"""
Rhythm-makers.
"""

from ._version import __version__
from .classes import Incise, Interpolation, Spelling, Talea
from .functions import (
    attach_beams_to_runs_by_leaf_list,
    attach_invisible_music_commands_to_leaves,
    attach_repeat_ties_to_pleaves,
    attach_span_beams_to_runs_across_leaf_lists,
    attach_ties_to_pleaves,
    detach_beams_from_leaves,
    detach_ties_from_leaves,
    extract_rest_filled_tuplets,
    extract_trivial_tuplets,
    override_beam_grow_direction,
    override_tuplet_number_text_duration_markup,
    reduce_tuplet_ratios,
    replace_leaves_with_notes,
    replace_leaves_with_rests,
    replace_ties_with_repeat_ties,
    respell_leaves_written_duration_and_dmp,
    respell_tuplets_without_dots,
    rewrite_meter,
    rewrite_rest_filled_tuplets,
    rewrite_sustained_tuplets,
    select_nongrace_leaves_by_tuplet,
    split_measures,
    swap_length_1_tuplets_for_containers,
    swap_skip_filled_tuplets_for_containers,
    swap_trivial_tuplets_for_containers,
    toggle_augmented_tuplets,
    toggle_diminished_tuplets,
    trivialize_tuplets,
    tweak_skip_filled_tuplets_stencil_false,
    tweak_trivial_tuplets_stencil_false,
    tweak_tuplet_number_text_calc_fraction_text,
    wrap_in_time_signature_staff,
)
from .makers import (
    make_accelerandi,
    make_even_division_tuplets,
    make_incised_tuplets,
    make_notes,
    make_notes_with_dmps,
    make_talea_tuplets,
    make_tuplets,
)

__all__ = [
    "__version__",
    "__version_info__",
    "Incise",
    "Interpolation",
    "Spelling",
    "Talea",
    "attach_beams_to_runs_by_leaf_list",
    "attach_invisible_music_commands_to_leaves",
    "attach_repeat_ties_to_pleaves",
    "attach_span_beams_to_runs_across_leaf_lists",
    "attach_ties_to_pleaves",
    "detach_beams_from_leaves",
    "detach_ties_from_leaves",
    "make_even_division_tuplets",
    "extract_rest_filled_tuplets",
    "extract_trivial_tuplets",
    "hide_trivial",
    "make_incised_tuplets",
    "make_accelerandi",
    "make_notes_with_dmps",
    "make_notes",
    "override_beam_grow_direction",
    "override_tuplet_number_text_duration_markup",
    "reduce_tuplet_ratios",
    "replace_leaves_with_notes",
    "replace_leaves_with_rests",
    "replace_ties_with_repeat_ties",
    "respell_leaves_written_duration_and_dmp",
    "respell_tuplets_without_dots",
    "rewrite_meter",
    "rewrite_rest_filled_tuplets",
    "rewrite_sustained_tuplets",
    "select_nongrace_leaves_by_tuplet",
    "split_measures",
    "swap_length_1_tuplets_for_containers",
    "swap_skip_filled_tuplets_for_containers",
    "swap_trivial_tuplets_for_containers",
    "make_talea_tuplets",
    "toggle_augmented_tuplets",
    "toggle_diminished_tuplets",
    "trivialize_tuplets",
    "make_tuplets",
    "tweak_skip_filled_tuplets_stencil_false",
    "tweak_trivial_tuplets_stencil_false",
    "tweak_tuplet_number_text_calc_fraction_text",
    "wrap_in_time_signature_staff",
]
