# tljh-repo2docker Changelog

## 2.0.0 - Highlights

Below are the major highlights in tljh-repo2docker 2.0.0

### tljh-repo2docker is now a JupyterHub service

`tljh-repo2docker` can be started as a standalone or hub-managed service.

### New UI to manage environments and user servers

`tljh-repo2docker` 2.0 features a new UI based on React to build docker images and start user servers. Optional names, memory, and CPU limits can also be set for the environment, instead of entering directly the CPU and Memory value, `tljh-repo2docker` can be configured with pre-defined machine profiles and users can only choose from the available options.

### New image build backend

In addition to the local docker engine, `tljh-repo2docker` can use binderhub service as the image build backend

### Backwards-incompatible changes.

- `jupyterhub` < 5 is no longer supported

## 1.0.0 - Highlights

The purpose of this release is to allow for better compatibility of the plugin with different versions of The Littlest JupyterHub.

This plugin was initially developed for a previous version of TLJH when it was not versioned yet. Now TLJH is making proper releases and might start introducing new changes that might potentially be breaking.

In short:

- Use `v1.0.0` if you are using a version of TLJH that includes JupyterHub 1.
- A future major version (`v2`) of the `tljh-repo2docker` plugin will target TLJH 1.0 and JupyterHub 4 as minimal requirements.

:information_source: Note the current `v1.0.0` version should already be compatible with JupyterHub 4.

You can find below the list of changes since the creation of the plugin.

### What's Changed

- Add installation instructions to the README by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/1
- Fix manifest by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/2
- Add optional name to the environment by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/7
- Show more information on the spawner options page by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/10
- Add minimal documentation to the README by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/11
- Update README instructions to install the plugin by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/12
- Expose list_images by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/13
- Show human readable value for mem and cpu limits by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/16
- Rename from PlasmaBio to Plasma by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/17
- Add a simple CI workflow by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/18
- Replace the service by extra hub handlers by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/19
- Add tests by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/21
- Show the build logs in a dialog by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/22
- Lowercase the autogenerated name from the repo by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/23
- Package the tests by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/25
- Async start method in the default spawner by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/28
- Hide 'Cancel' button from logs window by @pierrepo in https://github.com/plasmabio/tljh-repo2docker/pull/33
- Update instead of overwrite extra_host_config by @TimoRoth in https://github.com/plasmabio/tljh-repo2docker/pull/34
- Await rendered template if neccesary by @TimoRoth in https://github.com/plasmabio/tljh-repo2docker/pull/40
- Pin dependencies by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/41
- Add support for GIT_CREDENTIAL_ENV to build private repos by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/42
- Update repo2docker image by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/49
- Pin to `jupyterhub~=1.5` for development, update `dockerspawner`, default ref to `HEAD` by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/50
- Update Python versions on CI by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/51
- Use --label to set labels by @TimoRoth in https://github.com/plasmabio/tljh-repo2docker/pull/48
- Expose custom build-args as advanced option in the UI by @TimoRoth in https://github.com/plasmabio/tljh-repo2docker/pull/52
- Update test binder repo to the new URL by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/53
- Rename test repo to `tljh-repo2docker-test-binder` by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/54
- Pin `notebook<7` and `sqlalchemy<2` for now by @jtpio in https://github.com/plasmabio/tljh-repo2docker/pull/62
- Resolve 'Show Logs' issue by adding \_xsrf token by @yamaton in https://github.com/plasmabio/tljh-repo2docker/pull/61

### New Contributors

- @jtpio made their first contribution in https://github.com/plasmabio/tljh-repo2docker/pull/1
- @pierrepo made their first contribution in https://github.com/plasmabio/tljh-repo2docker/pull/33
- @TimoRoth made their first contribution in https://github.com/plasmabio/tljh-repo2docker/pull/34
- @yamaton made their first contribution in https://github.com/plasmabio/tljh-repo2docker/pull/61

**Full Changelog**: https://github.com/plasmabio/tljh-repo2docker/commits/v1

<!-- <START NEW CHANGELOG ENTRY> -->

## 3.0.0b4

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v3.0.0b3...fea11917bacc41ebfb2b2438ae9f9d89d22f9595))

### Merged PRs

- fix again [#120](https://github.com/plasmabio/tljh-repo2docker/pull/120) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-10-03&to=2025-10-03&type=c))

[@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-10-03..2025-10-03&type=Issues)

<!-- <END NEW CHANGELOG ENTRY> -->

## 3.0.0b3

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v3.0.0b2...27e67a3f821fbfede7db1730cefdd462c978dd31))

### Merged PRs

- again [#119](https://github.com/plasmabio/tljh-repo2docker/pull/119) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-10-03&to=2025-10-03&type=c))

[@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-10-03..2025-10-03&type=Issues)

## 3.0.0b2

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v3.0.0b1...fc8cd677acaf7611396c5bd242279f8b46f7c387))

### Bugs fixed

- fix server data [#118](https://github.com/plasmabio/tljh-repo2docker/pull/118) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-10-03&to=2025-10-03&type=c))

[@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-10-03..2025-10-03&type=Issues)

## 3.0.0b1

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v3.0.0b0...ec7d55f37b3cf963d1174b323e509b7670762f51))

### Enhancements made

- add url query to server endpoint [#117](https://github.com/plasmabio/tljh-repo2docker/pull/117) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-10-02&to=2025-10-03&type=c))

[@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-10-02..2025-10-03&type=Issues)

## 3.0.0b0

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v3.0.0a0...56f2b0c4e8e2165608765e93c985c040ab1593f8))

### Merged PRs

- hot fix [#116](https://github.com/plasmabio/tljh-repo2docker/pull/116) ([@trungleduc](https://github.com/trungleduc))
- Bump brace-expansion from 2.0.1 to 2.0.2 in /ui-tests [#110](https://github.com/plasmabio/tljh-repo2docker/pull/110) ([@dependabot](https://github.com/dependabot))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-06-11&to=2025-10-02&type=c))

[@dependabot](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Adependabot+updated%3A2025-06-11..2025-10-02&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-06-11..2025-10-02&type=Issues)

## 3.0.0a0

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v2.0.0...53522d32f83d39d783d7e149b0b58b84227c8e6b))

### Maintenance and upkeep improvements

- Update `dockerspawner` and `aiodocker`, TLJH 2.0 [#104](https://github.com/plasmabio/tljh-repo2docker/pull/104) ([@jtpio](https://github.com/jtpio))

### Other merged PRs

- Bump @babel/runtime from 7.24.0 to 7.27.6 [#108](https://github.com/plasmabio/tljh-repo2docker/pull/108) ([@dependabot](https://github.com/dependabot))
- Bump axios from 1.7.4 to 1.8.2 [#107](https://github.com/plasmabio/tljh-repo2docker/pull/107) ([@dependabot](https://github.com/dependabot))
- Add min Python version and trove classifiers [#105](https://github.com/plasmabio/tljh-repo2docker/pull/105) ([@jtpio](https://github.com/jtpio))
- Allow buildkit-built images to execute [#103](https://github.com/plasmabio/tljh-repo2docker/pull/103) ([@holzman](https://github.com/holzman))
- Make new node_selector Label optional [#102](https://github.com/plasmabio/tljh-repo2docker/pull/102) ([@TimoRoth](https://github.com/TimoRoth))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-03-05&to=2025-06-11&type=c))

[@dependabot](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Adependabot+updated%3A2025-03-05..2025-06-11&type=Issues) | [@holzman](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Aholzman+updated%3A2025-03-05..2025-06-11&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Ajtpio+updated%3A2025-03-05..2025-06-11&type=Issues) | [@TimoRoth](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3ATimoRoth+updated%3A2025-03-05..2025-06-11&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-03-05..2025-06-11&type=Issues)

## 2.0.0

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v2.0.0a5...a7a69f45f86bb907ac3936d830dc96ff84ba8870))

### Enhancements made

- Add node selector [#99](https://github.com/plasmabio/tljh-repo2docker/pull/99) ([@Meriem-BenIsmail](https://github.com/Meriem-BenIsmail))

### Documentation improvements

- Update changelog [#100](https://github.com/plasmabio/tljh-repo2docker/pull/100) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-02-17&to=2025-03-05&type=c))

[@Meriem-BenIsmail](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3AMeriem-BenIsmail+updated%3A2025-02-17..2025-03-05&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-02-17..2025-03-05&type=Issues)

## 2.0.0a5

No merged PRs

## 2.0.0a4

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v2.0.0a3...1bd36bae9484728e02036bbeb190745b4be395e5))

### Maintenance and upkeep improvements

- [skip ci] run build-image in release env [#98](https://github.com/plasmabio/tljh-repo2docker/pull/98) ([@trungleduc](https://github.com/trungleduc))

### Other merged PRs

- Bump webpack from 5.90.3 to 5.98.0 [#95](https://github.com/plasmabio/tljh-repo2docker/pull/95) ([@dependabot](https://github.com/dependabot))
- Bump axios from 1.6.7 to 1.7.4 [#94](https://github.com/plasmabio/tljh-repo2docker/pull/94) ([@dependabot](https://github.com/dependabot))
- Bump braces from 3.0.2 to 3.0.3 [#93](https://github.com/plasmabio/tljh-repo2docker/pull/93) ([@dependabot](https://github.com/dependabot))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-02-17&to=2025-02-17&type=c))

[@dependabot](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Adependabot+updated%3A2025-02-17..2025-02-17&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-02-17..2025-02-17&type=Issues)

## 2.0.0a3

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v2.0.0a2...f955d7a18f5e7e8a4c590370a1181d22aed39fd4))

### Enhancements made

- Restore self.log logger in BaseHandler [#96](https://github.com/plasmabio/tljh-repo2docker/pull/96) ([@TimoRoth](https://github.com/TimoRoth))

### Maintenance and upkeep improvements

- [skip ci] Add token for gh [#97](https://github.com/plasmabio/tljh-repo2docker/pull/97) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2025-02-17&to=2025-02-17&type=c))

[@TimoRoth](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3ATimoRoth+updated%3A2025-02-17..2025-02-17&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2025-02-17..2025-02-17&type=Issues)

## 2.0.0a2

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v2.0.0a1...36d6fbb0231498997c79dc254209554952d40025))

### Documentation improvements

- Add deployment example [#87](https://github.com/plasmabio/tljh-repo2docker/pull/87) ([@trungleduc](https://github.com/trungleduc))

### Other merged PRs

- Style adjusting with JupyterHub 5 [#91](https://github.com/plasmabio/tljh-repo2docker/pull/91) ([@Meriem-BenIsmail](https://github.com/Meriem-BenIsmail))
- Build and push image [#90](https://github.com/plasmabio/tljh-repo2docker/pull/90) ([@trungleduc](https://github.com/trungleduc))
- Make tljh_extra_hub_pip_packages hook match pyproject.toml [#88](https://github.com/plasmabio/tljh-repo2docker/pull/88) ([@TimoRoth](https://github.com/TimoRoth))
- Bump follow-redirects from 1.15.5 to 1.15.6 [#79](https://github.com/plasmabio/tljh-repo2docker/pull/79) ([@dependabot](https://github.com/dependabot))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2024-05-15&to=2025-02-17&type=c))

[@dependabot](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Adependabot+updated%3A2024-05-15..2025-02-17&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Ajtpio+updated%3A2024-05-15..2025-02-17&type=Issues) | [@Meriem-BenIsmail](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3AMeriem-BenIsmail+updated%3A2024-05-15..2025-02-17&type=Issues) | [@TimoRoth](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3ATimoRoth+updated%3A2024-05-15..2025-02-17&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2024-05-15..2025-02-17&type=Issues)

## 2.0.0a1

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v2.0.0a0...78fe0248148f114c72e4260f42ea1088ab285153))

### Enhancements made

- Adopt `binderhub` [#83](https://github.com/plasmabio/tljh-repo2docker/pull/83) ([@trungleduc](https://github.com/trungleduc))

### Maintenance and upkeep improvements

- Make npm package private [#86](https://github.com/plasmabio/tljh-repo2docker/pull/86) ([@trungleduc](https://github.com/trungleduc))

### Other merged PRs

- Update snapshot [#85](https://github.com/plasmabio/tljh-repo2docker/pull/85) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2024-04-04&to=2024-05-15&type=c))

[@jtpio](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Ajtpio+updated%3A2024-04-04..2024-05-15&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2024-04-04..2024-05-15&type=Issues)

## 2.0.0a0

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v1.0.1...094e4635ca9329ccab20e06eb1c0fefa4b8aa664))

### Enhancements made

- Start single server from backend [#81](https://github.com/plasmabio/tljh-repo2docker/pull/81) ([@trungleduc](https://github.com/trungleduc))
- Switch to JupyterHub service [#75](https://github.com/plasmabio/tljh-repo2docker/pull/75) ([@trungleduc](https://github.com/trungleduc))
- Add react-based frontend [#69](https://github.com/plasmabio/tljh-repo2docker/pull/69) ([@trungleduc](https://github.com/trungleduc))

### Maintenance and upkeep improvements

- Update to JupyterHub 4 and TLJH 1.0, use `pytest-jupyterhub` [#65](https://github.com/plasmabio/tljh-repo2docker/pull/65) ([@jtpio](https://github.com/jtpio))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2024-03-11&to=2024-04-03&type=c))

[@jtpio](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Ajtpio+updated%3A2024-03-11..2024-04-03&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2024-03-11..2024-04-03&type=Issues)

## 1.0.1

([Full Changelog](https://github.com/plasmabio/tljh-repo2docker/compare/v1.0.0...98eaec34e3617c1e9bb83b2b4b09b2e4866fe8a0))

### Bugs fixed

- Resolve 'Show Logs' issue by adding \_xsrf token [#61](https://github.com/plasmabio/tljh-repo2docker/pull/61) ([@yamaton](https://github.com/yamaton))

### Maintenance and upkeep improvements

- Use environment in CI [#77](https://github.com/plasmabio/tljh-repo2docker/pull/77) ([@trungleduc](https://github.com/trungleduc))
- Add 1.0.0 highlights to the change log. [#76](https://github.com/plasmabio/tljh-repo2docker/pull/76) ([@trungleduc](https://github.com/trungleduc))
- Add releaser workflow [#74](https://github.com/plasmabio/tljh-repo2docker/pull/74) ([@trungleduc](https://github.com/trungleduc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/plasmabio/tljh-repo2docker/graphs/contributors?from=2023-11-17&to=2024-03-11&type=c))

[@jtpio](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Ajtpio+updated%3A2023-11-17..2024-03-11&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Atrungleduc+updated%3A2023-11-17..2024-03-11&type=Issues) | [@yamaton](https://github.com/search?q=repo%3Aplasmabio%2Ftljh-repo2docker+involves%3Ayamaton+updated%3A2023-11-17..2024-03-11&type=Issues)
