# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('kafka')


class _ExportableConfig(types.ModuleType):
    @property
    def bootstrap_servers(self) -> Optional[str]:
        """
        A list of kafka brokers
        """
        return __config__.get('bootstrapServers')

    @property
    def ca_cert(self) -> Optional[str]:
        """
        CA certificate file to validate the server's certificate.
        """
        return __config__.get('caCert')

    @property
    def ca_cert_file(self) -> Optional[str]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return __config__.get('caCertFile')

    @property
    def client_cert(self) -> Optional[str]:
        """
        The client certificate.
        """
        return __config__.get('clientCert')

    @property
    def client_cert_file(self) -> Optional[str]:
        """
        Path to a file containing the client certificate.
        """
        return __config__.get('clientCertFile')

    @property
    def client_key(self) -> Optional[str]:
        """
        The private key that the certificate was issued for.
        """
        return __config__.get('clientKey')

    @property
    def client_key_file(self) -> Optional[str]:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return __config__.get('clientKeyFile')

    @property
    def client_key_passphrase(self) -> Optional[str]:
        """
        The passphrase for the private key that the certificate was issued for.
        """
        return __config__.get('clientKeyPassphrase')

    @property
    def kafka_version(self) -> Optional[str]:
        """
        The version of Kafka protocol to use in `$MAJOR.$MINOR.$PATCH` format. Some features may not be available on older
        versions. Default is 2.7.0.
        """
        return __config__.get('kafkaVersion')

    @property
    def sasl_aws_access_key(self) -> Optional[str]:
        """
        The AWS access key.
        """
        return __config__.get('saslAwsAccessKey')

    @property
    def sasl_aws_container_authorization_token_file(self) -> Optional[str]:
        """
        Path to a file containing the AWS pod identity authorization token
        """
        return __config__.get('saslAwsContainerAuthorizationTokenFile')

    @property
    def sasl_aws_container_credentials_full_uri(self) -> Optional[str]:
        """
        URI to retrieve AWS credentials from
        """
        return __config__.get('saslAwsContainerCredentialsFullUri')

    @property
    def sasl_aws_creds_debug(self) -> Optional[bool]:
        """
        Set this to true to turn AWS credentials debug.
        """
        return __config__.get_bool('saslAwsCredsDebug')

    @property
    def sasl_aws_external_id(self) -> Optional[str]:
        """
        External ID of the AWS IAM role to assume
        """
        return __config__.get('saslAwsExternalId')

    @property
    def sasl_aws_profile(self) -> Optional[str]:
        """
        AWS profile name to use
        """
        return __config__.get('saslAwsProfile')

    @property
    def sasl_aws_region(self) -> Optional[str]:
        """
        AWS region where MSK is deployed.
        """
        return __config__.get('saslAwsRegion')

    @property
    def sasl_aws_role_arn(self) -> Optional[str]:
        """
        Arn of an AWS IAM role to assume
        """
        return __config__.get('saslAwsRoleArn')

    @property
    def sasl_aws_secret_key(self) -> Optional[str]:
        """
        The AWS secret key.
        """
        return __config__.get('saslAwsSecretKey')

    @property
    def sasl_aws_shared_config_files(self) -> Optional[str]:
        """
        List of paths to AWS shared config files.
        """
        return __config__.get('saslAwsSharedConfigFiles')

    @property
    def sasl_aws_token(self) -> Optional[str]:
        """
        The AWS session token. Only required if you are using temporary security credentials.
        """
        return __config__.get('saslAwsToken')

    @property
    def sasl_mechanism(self) -> str:
        """
        SASL mechanism, can be plain, scram-sha512, scram-sha256, aws-iam
        """
        return __config__.get('saslMechanism') or (_utilities.get_env('KAFKA_SASL_MECHANISM') or 'plain')

    @property
    def sasl_password(self) -> Optional[str]:
        """
        Password for SASL authentication.
        """
        return __config__.get('saslPassword')

    @property
    def sasl_token_url(self) -> Optional[str]:
        """
        The url to retrieve oauth2 tokens from, when using sasl mechanism oauthbearer
        """
        return __config__.get('saslTokenUrl')

    @property
    def sasl_username(self) -> Optional[str]:
        """
        Username for SASL authentication.
        """
        return __config__.get('saslUsername')

    @property
    def skip_tls_verify(self) -> bool:
        """
        Set this to true only if the target Kafka server is an insecure development instance.
        """
        return __config__.get_bool('skipTlsVerify') or (_utilities.get_env_bool('KAFKA_SKIP_VERIFY') or False)

    @property
    def timeout(self) -> Optional[int]:
        """
        Timeout in seconds
        """
        return __config__.get_int('timeout')

    @property
    def tls_enabled(self) -> bool:
        """
        Enable communication with the Kafka Cluster over TLS.
        """
        return __config__.get_bool('tlsEnabled') or (_utilities.get_env_bool('KAFKA_ENABLE_TLS') or True)

