# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 bootstrap_servers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 ca_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[builtins.str]] = None,
                 client_cert_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_key: Optional[pulumi.Input[builtins.str]] = None,
                 client_key_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_key_passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 kafka_version: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_container_authorization_token_file: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_container_credentials_full_uri: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_creds_debug: Optional[pulumi.Input[builtins.bool]] = None,
                 sasl_aws_external_id: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_profile: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_shared_config_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sasl_aws_token: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_mechanism: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_username: Optional[pulumi.Input[builtins.str]] = None,
                 skip_tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] bootstrap_servers: A list of kafka brokers
        :param pulumi.Input[builtins.str] ca_cert: CA certificate file to validate the server's certificate.
        :param pulumi.Input[builtins.str] ca_cert_file: Path to a CA certificate file to validate the server's certificate.
        :param pulumi.Input[builtins.str] client_cert: The client certificate.
        :param pulumi.Input[builtins.str] client_cert_file: Path to a file containing the client certificate.
        :param pulumi.Input[builtins.str] client_key: The private key that the certificate was issued for.
        :param pulumi.Input[builtins.str] client_key_file: Path to a file containing the private key that the certificate was issued for.
        :param pulumi.Input[builtins.str] client_key_passphrase: The passphrase for the private key that the certificate was issued for.
        :param pulumi.Input[builtins.str] kafka_version: The version of Kafka protocol to use in `$MAJOR.$MINOR.$PATCH` format. Some features may not be available on older
               versions. Default is 2.7.0.
        :param pulumi.Input[builtins.str] sasl_aws_access_key: The AWS access key.
        :param pulumi.Input[builtins.str] sasl_aws_container_authorization_token_file: Path to a file containing the AWS pod identity authorization token
        :param pulumi.Input[builtins.str] sasl_aws_container_credentials_full_uri: URI to retrieve AWS credentials from
        :param pulumi.Input[builtins.bool] sasl_aws_creds_debug: Set this to true to turn AWS credentials debug.
        :param pulumi.Input[builtins.str] sasl_aws_external_id: External ID of the AWS IAM role to assume
        :param pulumi.Input[builtins.str] sasl_aws_profile: AWS profile name to use
        :param pulumi.Input[builtins.str] sasl_aws_region: AWS region where MSK is deployed.
        :param pulumi.Input[builtins.str] sasl_aws_role_arn: Arn of an AWS IAM role to assume
        :param pulumi.Input[builtins.str] sasl_aws_secret_key: The AWS secret key.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sasl_aws_shared_config_files: List of paths to AWS shared config files.
        :param pulumi.Input[builtins.str] sasl_aws_token: The AWS session token. Only required if you are using temporary security credentials.
        :param pulumi.Input[builtins.str] sasl_mechanism: SASL mechanism, can be plain, scram-sha512, scram-sha256, aws-iam
        :param pulumi.Input[builtins.str] sasl_password: Password for SASL authentication.
        :param pulumi.Input[builtins.str] sasl_token_url: The url to retrieve oauth2 tokens from, when using sasl mechanism oauthbearer
        :param pulumi.Input[builtins.str] sasl_username: Username for SASL authentication.
        :param pulumi.Input[builtins.bool] skip_tls_verify: Set this to true only if the target Kafka server is an insecure development instance.
        :param pulumi.Input[builtins.int] timeout: Timeout in seconds
        :param pulumi.Input[builtins.bool] tls_enabled: Enable communication with the Kafka Cluster over TLS.
        """
        pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if ca_cert_file is not None:
            warnings.warn("""This parameter is now deprecated and will be removed in a later release, please use `ca_cert` instead.""", DeprecationWarning)
            pulumi.log.warn("""ca_cert_file is deprecated: This parameter is now deprecated and will be removed in a later release, please use `ca_cert` instead.""")
        if ca_cert_file is not None:
            pulumi.set(__self__, "ca_cert_file", ca_cert_file)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_cert_file is not None:
            warnings.warn("""This parameter is now deprecated and will be removed in a later release, please use `client_cert` instead.""", DeprecationWarning)
            pulumi.log.warn("""client_cert_file is deprecated: This parameter is now deprecated and will be removed in a later release, please use `client_cert` instead.""")
        if client_cert_file is not None:
            pulumi.set(__self__, "client_cert_file", client_cert_file)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if client_key_file is not None:
            warnings.warn("""This parameter is now deprecated and will be removed in a later release, please use `client_key` instead.""", DeprecationWarning)
            pulumi.log.warn("""client_key_file is deprecated: This parameter is now deprecated and will be removed in a later release, please use `client_key` instead.""")
        if client_key_file is not None:
            pulumi.set(__self__, "client_key_file", client_key_file)
        if client_key_passphrase is not None:
            pulumi.set(__self__, "client_key_passphrase", client_key_passphrase)
        if kafka_version is not None:
            pulumi.set(__self__, "kafka_version", kafka_version)
        if sasl_aws_access_key is not None:
            pulumi.set(__self__, "sasl_aws_access_key", sasl_aws_access_key)
        if sasl_aws_container_authorization_token_file is not None:
            pulumi.set(__self__, "sasl_aws_container_authorization_token_file", sasl_aws_container_authorization_token_file)
        if sasl_aws_container_credentials_full_uri is not None:
            pulumi.set(__self__, "sasl_aws_container_credentials_full_uri", sasl_aws_container_credentials_full_uri)
        if sasl_aws_creds_debug is not None:
            pulumi.set(__self__, "sasl_aws_creds_debug", sasl_aws_creds_debug)
        if sasl_aws_external_id is not None:
            pulumi.set(__self__, "sasl_aws_external_id", sasl_aws_external_id)
        if sasl_aws_profile is not None:
            pulumi.set(__self__, "sasl_aws_profile", sasl_aws_profile)
        if sasl_aws_region is not None:
            pulumi.set(__self__, "sasl_aws_region", sasl_aws_region)
        if sasl_aws_role_arn is not None:
            pulumi.set(__self__, "sasl_aws_role_arn", sasl_aws_role_arn)
        if sasl_aws_secret_key is not None:
            pulumi.set(__self__, "sasl_aws_secret_key", sasl_aws_secret_key)
        if sasl_aws_shared_config_files is not None:
            pulumi.set(__self__, "sasl_aws_shared_config_files", sasl_aws_shared_config_files)
        if sasl_aws_token is not None:
            pulumi.set(__self__, "sasl_aws_token", sasl_aws_token)
        if sasl_mechanism is None:
            sasl_mechanism = (_utilities.get_env('KAFKA_SASL_MECHANISM') or 'plain')
        if sasl_mechanism is not None:
            pulumi.set(__self__, "sasl_mechanism", sasl_mechanism)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_token_url is not None:
            pulumi.set(__self__, "sasl_token_url", sasl_token_url)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if skip_tls_verify is None:
            skip_tls_verify = (_utilities.get_env_bool('KAFKA_SKIP_VERIFY') or False)
        if skip_tls_verify is not None:
            pulumi.set(__self__, "skip_tls_verify", skip_tls_verify)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tls_enabled is None:
            tls_enabled = (_utilities.get_env_bool('KAFKA_ENABLE_TLS') or True)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of kafka brokers
        """
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @property
    @pulumi.getter(name="caCertFile")
    @_utilities.deprecated("""This parameter is now deprecated and will be removed in a later release, please use `ca_cert` instead.""")
    def ca_cert_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_file")

    @ca_cert_file.setter
    def ca_cert_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_cert_file", value)

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client certificate.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @property
    @pulumi.getter(name="clientCertFile")
    @_utilities.deprecated("""This parameter is now deprecated and will be removed in a later release, please use `client_cert` instead.""")
    def client_cert_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to a file containing the client certificate.
        """
        return pulumi.get(self, "client_cert_file")

    @client_cert_file.setter
    def client_cert_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_cert_file", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private key that the certificate was issued for.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clientKeyFile")
    @_utilities.deprecated("""This parameter is now deprecated and will be removed in a later release, please use `client_key` instead.""")
    def client_key_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return pulumi.get(self, "client_key_file")

    @client_key_file.setter
    def client_key_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_key_file", value)

    @property
    @pulumi.getter(name="clientKeyPassphrase")
    def client_key_passphrase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The passphrase for the private key that the certificate was issued for.
        """
        return pulumi.get(self, "client_key_passphrase")

    @client_key_passphrase.setter
    def client_key_passphrase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_key_passphrase", value)

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of Kafka protocol to use in `$MAJOR.$MINOR.$PATCH` format. Some features may not be available on older
        versions. Default is 2.7.0.
        """
        return pulumi.get(self, "kafka_version")

    @kafka_version.setter
    def kafka_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kafka_version", value)

    @property
    @pulumi.getter(name="saslAwsAccessKey")
    def sasl_aws_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS access key.
        """
        return pulumi.get(self, "sasl_aws_access_key")

    @sasl_aws_access_key.setter
    def sasl_aws_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_access_key", value)

    @property
    @pulumi.getter(name="saslAwsContainerAuthorizationTokenFile")
    def sasl_aws_container_authorization_token_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to a file containing the AWS pod identity authorization token
        """
        return pulumi.get(self, "sasl_aws_container_authorization_token_file")

    @sasl_aws_container_authorization_token_file.setter
    def sasl_aws_container_authorization_token_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_container_authorization_token_file", value)

    @property
    @pulumi.getter(name="saslAwsContainerCredentialsFullUri")
    def sasl_aws_container_credentials_full_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI to retrieve AWS credentials from
        """
        return pulumi.get(self, "sasl_aws_container_credentials_full_uri")

    @sasl_aws_container_credentials_full_uri.setter
    def sasl_aws_container_credentials_full_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_container_credentials_full_uri", value)

    @property
    @pulumi.getter(name="saslAwsCredsDebug")
    def sasl_aws_creds_debug(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set this to true to turn AWS credentials debug.
        """
        return pulumi.get(self, "sasl_aws_creds_debug")

    @sasl_aws_creds_debug.setter
    def sasl_aws_creds_debug(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sasl_aws_creds_debug", value)

    @property
    @pulumi.getter(name="saslAwsExternalId")
    def sasl_aws_external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        External ID of the AWS IAM role to assume
        """
        return pulumi.get(self, "sasl_aws_external_id")

    @sasl_aws_external_id.setter
    def sasl_aws_external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_external_id", value)

    @property
    @pulumi.getter(name="saslAwsProfile")
    def sasl_aws_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS profile name to use
        """
        return pulumi.get(self, "sasl_aws_profile")

    @sasl_aws_profile.setter
    def sasl_aws_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_profile", value)

    @property
    @pulumi.getter(name="saslAwsRegion")
    def sasl_aws_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS region where MSK is deployed.
        """
        return pulumi.get(self, "sasl_aws_region")

    @sasl_aws_region.setter
    def sasl_aws_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_region", value)

    @property
    @pulumi.getter(name="saslAwsRoleArn")
    def sasl_aws_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Arn of an AWS IAM role to assume
        """
        return pulumi.get(self, "sasl_aws_role_arn")

    @sasl_aws_role_arn.setter
    def sasl_aws_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_role_arn", value)

    @property
    @pulumi.getter(name="saslAwsSecretKey")
    def sasl_aws_secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS secret key.
        """
        return pulumi.get(self, "sasl_aws_secret_key")

    @sasl_aws_secret_key.setter
    def sasl_aws_secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_secret_key", value)

    @property
    @pulumi.getter(name="saslAwsSharedConfigFiles")
    def sasl_aws_shared_config_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of paths to AWS shared config files.
        """
        return pulumi.get(self, "sasl_aws_shared_config_files")

    @sasl_aws_shared_config_files.setter
    def sasl_aws_shared_config_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sasl_aws_shared_config_files", value)

    @property
    @pulumi.getter(name="saslAwsToken")
    def sasl_aws_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS session token. Only required if you are using temporary security credentials.
        """
        return pulumi.get(self, "sasl_aws_token")

    @sasl_aws_token.setter
    def sasl_aws_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_aws_token", value)

    @property
    @pulumi.getter(name="saslMechanism")
    def sasl_mechanism(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SASL mechanism, can be plain, scram-sha512, scram-sha256, aws-iam
        """
        return pulumi.get(self, "sasl_mechanism")

    @sasl_mechanism.setter
    def sasl_mechanism(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_mechanism", value)

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password for SASL authentication.
        """
        return pulumi.get(self, "sasl_password")

    @sasl_password.setter
    def sasl_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_password", value)

    @property
    @pulumi.getter(name="saslTokenUrl")
    def sasl_token_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The url to retrieve oauth2 tokens from, when using sasl mechanism oauthbearer
        """
        return pulumi.get(self, "sasl_token_url")

    @sasl_token_url.setter
    def sasl_token_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_token_url", value)

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username for SASL authentication.
        """
        return pulumi.get(self, "sasl_username")

    @sasl_username.setter
    def sasl_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sasl_username", value)

    @property
    @pulumi.getter(name="skipTlsVerify")
    def skip_tls_verify(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set this to true only if the target Kafka server is an insecure development instance.
        """
        return pulumi.get(self, "skip_tls_verify")

    @skip_tls_verify.setter
    def skip_tls_verify(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_tls_verify", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Timeout in seconds
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable communication with the Kafka Cluster over TLS.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)


@pulumi.type_token("pulumi:providers:kafka")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[builtins.str]] = None,
                 client_cert_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_key: Optional[pulumi.Input[builtins.str]] = None,
                 client_key_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_key_passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 kafka_version: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_container_authorization_token_file: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_container_credentials_full_uri: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_creds_debug: Optional[pulumi.Input[builtins.bool]] = None,
                 sasl_aws_external_id: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_profile: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_shared_config_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sasl_aws_token: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_mechanism: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_username: Optional[pulumi.Input[builtins.str]] = None,
                 skip_tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the kafka package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] bootstrap_servers: A list of kafka brokers
        :param pulumi.Input[builtins.str] ca_cert: CA certificate file to validate the server's certificate.
        :param pulumi.Input[builtins.str] ca_cert_file: Path to a CA certificate file to validate the server's certificate.
        :param pulumi.Input[builtins.str] client_cert: The client certificate.
        :param pulumi.Input[builtins.str] client_cert_file: Path to a file containing the client certificate.
        :param pulumi.Input[builtins.str] client_key: The private key that the certificate was issued for.
        :param pulumi.Input[builtins.str] client_key_file: Path to a file containing the private key that the certificate was issued for.
        :param pulumi.Input[builtins.str] client_key_passphrase: The passphrase for the private key that the certificate was issued for.
        :param pulumi.Input[builtins.str] kafka_version: The version of Kafka protocol to use in `$MAJOR.$MINOR.$PATCH` format. Some features may not be available on older
               versions. Default is 2.7.0.
        :param pulumi.Input[builtins.str] sasl_aws_access_key: The AWS access key.
        :param pulumi.Input[builtins.str] sasl_aws_container_authorization_token_file: Path to a file containing the AWS pod identity authorization token
        :param pulumi.Input[builtins.str] sasl_aws_container_credentials_full_uri: URI to retrieve AWS credentials from
        :param pulumi.Input[builtins.bool] sasl_aws_creds_debug: Set this to true to turn AWS credentials debug.
        :param pulumi.Input[builtins.str] sasl_aws_external_id: External ID of the AWS IAM role to assume
        :param pulumi.Input[builtins.str] sasl_aws_profile: AWS profile name to use
        :param pulumi.Input[builtins.str] sasl_aws_region: AWS region where MSK is deployed.
        :param pulumi.Input[builtins.str] sasl_aws_role_arn: Arn of an AWS IAM role to assume
        :param pulumi.Input[builtins.str] sasl_aws_secret_key: The AWS secret key.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sasl_aws_shared_config_files: List of paths to AWS shared config files.
        :param pulumi.Input[builtins.str] sasl_aws_token: The AWS session token. Only required if you are using temporary security credentials.
        :param pulumi.Input[builtins.str] sasl_mechanism: SASL mechanism, can be plain, scram-sha512, scram-sha256, aws-iam
        :param pulumi.Input[builtins.str] sasl_password: Password for SASL authentication.
        :param pulumi.Input[builtins.str] sasl_token_url: The url to retrieve oauth2 tokens from, when using sasl mechanism oauthbearer
        :param pulumi.Input[builtins.str] sasl_username: Username for SASL authentication.
        :param pulumi.Input[builtins.bool] skip_tls_verify: Set this to true only if the target Kafka server is an insecure development instance.
        :param pulumi.Input[builtins.int] timeout: Timeout in seconds
        :param pulumi.Input[builtins.bool] tls_enabled: Enable communication with the Kafka Cluster over TLS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the kafka package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ca_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ca_cert_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[builtins.str]] = None,
                 client_cert_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_key: Optional[pulumi.Input[builtins.str]] = None,
                 client_key_file: Optional[pulumi.Input[builtins.str]] = None,
                 client_key_passphrase: Optional[pulumi.Input[builtins.str]] = None,
                 kafka_version: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_container_authorization_token_file: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_container_credentials_full_uri: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_creds_debug: Optional[pulumi.Input[builtins.bool]] = None,
                 sasl_aws_external_id: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_profile: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_secret_key: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_aws_shared_config_files: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sasl_aws_token: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_mechanism: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_password: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_token_url: Optional[pulumi.Input[builtins.str]] = None,
                 sasl_username: Optional[pulumi.Input[builtins.str]] = None,
                 skip_tls_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tls_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if bootstrap_servers is None and not opts.urn:
                raise TypeError("Missing required property 'bootstrap_servers'")
            __props__.__dict__["bootstrap_servers"] = pulumi.Output.from_input(bootstrap_servers).apply(pulumi.runtime.to_json) if bootstrap_servers is not None else None
            __props__.__dict__["ca_cert"] = ca_cert
            __props__.__dict__["ca_cert_file"] = ca_cert_file
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_cert_file"] = client_cert_file
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["client_key_file"] = client_key_file
            __props__.__dict__["client_key_passphrase"] = client_key_passphrase
            __props__.__dict__["kafka_version"] = kafka_version
            __props__.__dict__["sasl_aws_access_key"] = sasl_aws_access_key
            __props__.__dict__["sasl_aws_container_authorization_token_file"] = sasl_aws_container_authorization_token_file
            __props__.__dict__["sasl_aws_container_credentials_full_uri"] = sasl_aws_container_credentials_full_uri
            __props__.__dict__["sasl_aws_creds_debug"] = pulumi.Output.from_input(sasl_aws_creds_debug).apply(pulumi.runtime.to_json) if sasl_aws_creds_debug is not None else None
            __props__.__dict__["sasl_aws_external_id"] = sasl_aws_external_id
            __props__.__dict__["sasl_aws_profile"] = sasl_aws_profile
            __props__.__dict__["sasl_aws_region"] = sasl_aws_region
            __props__.__dict__["sasl_aws_role_arn"] = sasl_aws_role_arn
            __props__.__dict__["sasl_aws_secret_key"] = sasl_aws_secret_key
            __props__.__dict__["sasl_aws_shared_config_files"] = pulumi.Output.from_input(sasl_aws_shared_config_files).apply(pulumi.runtime.to_json) if sasl_aws_shared_config_files is not None else None
            __props__.__dict__["sasl_aws_token"] = sasl_aws_token
            if sasl_mechanism is None:
                sasl_mechanism = (_utilities.get_env('KAFKA_SASL_MECHANISM') or 'plain')
            __props__.__dict__["sasl_mechanism"] = sasl_mechanism
            __props__.__dict__["sasl_password"] = sasl_password
            __props__.__dict__["sasl_token_url"] = sasl_token_url
            __props__.__dict__["sasl_username"] = sasl_username
            if skip_tls_verify is None:
                skip_tls_verify = (_utilities.get_env_bool('KAFKA_SKIP_VERIFY') or False)
            __props__.__dict__["skip_tls_verify"] = pulumi.Output.from_input(skip_tls_verify).apply(pulumi.runtime.to_json) if skip_tls_verify is not None else None
            __props__.__dict__["timeout"] = pulumi.Output.from_input(timeout).apply(pulumi.runtime.to_json) if timeout is not None else None
            if tls_enabled is None:
                tls_enabled = (_utilities.get_env_bool('KAFKA_ENABLE_TLS') or True)
            __props__.__dict__["tls_enabled"] = pulumi.Output.from_input(tls_enabled).apply(pulumi.runtime.to_json) if tls_enabled is not None else None
        super(Provider, __self__).__init__(
            'kafka',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="caCertFile")
    @_utilities.deprecated("""This parameter is now deprecated and will be removed in a later release, please use `ca_cert` instead.""")
    def ca_cert_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to a CA certificate file to validate the server's certificate.
        """
        return pulumi.get(self, "ca_cert_file")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The client certificate.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientCertFile")
    @_utilities.deprecated("""This parameter is now deprecated and will be removed in a later release, please use `client_cert` instead.""")
    def client_cert_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to a file containing the client certificate.
        """
        return pulumi.get(self, "client_cert_file")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The private key that the certificate was issued for.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clientKeyFile")
    @_utilities.deprecated("""This parameter is now deprecated and will be removed in a later release, please use `client_key` instead.""")
    def client_key_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to a file containing the private key that the certificate was issued for.
        """
        return pulumi.get(self, "client_key_file")

    @property
    @pulumi.getter(name="clientKeyPassphrase")
    def client_key_passphrase(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The passphrase for the private key that the certificate was issued for.
        """
        return pulumi.get(self, "client_key_passphrase")

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of Kafka protocol to use in `$MAJOR.$MINOR.$PATCH` format. Some features may not be available on older
        versions. Default is 2.7.0.
        """
        return pulumi.get(self, "kafka_version")

    @property
    @pulumi.getter(name="saslAwsAccessKey")
    def sasl_aws_access_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS access key.
        """
        return pulumi.get(self, "sasl_aws_access_key")

    @property
    @pulumi.getter(name="saslAwsContainerAuthorizationTokenFile")
    def sasl_aws_container_authorization_token_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to a file containing the AWS pod identity authorization token
        """
        return pulumi.get(self, "sasl_aws_container_authorization_token_file")

    @property
    @pulumi.getter(name="saslAwsContainerCredentialsFullUri")
    def sasl_aws_container_credentials_full_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URI to retrieve AWS credentials from
        """
        return pulumi.get(self, "sasl_aws_container_credentials_full_uri")

    @property
    @pulumi.getter(name="saslAwsExternalId")
    def sasl_aws_external_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        External ID of the AWS IAM role to assume
        """
        return pulumi.get(self, "sasl_aws_external_id")

    @property
    @pulumi.getter(name="saslAwsProfile")
    def sasl_aws_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS profile name to use
        """
        return pulumi.get(self, "sasl_aws_profile")

    @property
    @pulumi.getter(name="saslAwsRegion")
    def sasl_aws_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS region where MSK is deployed.
        """
        return pulumi.get(self, "sasl_aws_region")

    @property
    @pulumi.getter(name="saslAwsRoleArn")
    def sasl_aws_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Arn of an AWS IAM role to assume
        """
        return pulumi.get(self, "sasl_aws_role_arn")

    @property
    @pulumi.getter(name="saslAwsSecretKey")
    def sasl_aws_secret_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS secret key.
        """
        return pulumi.get(self, "sasl_aws_secret_key")

    @property
    @pulumi.getter(name="saslAwsToken")
    def sasl_aws_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS session token. Only required if you are using temporary security credentials.
        """
        return pulumi.get(self, "sasl_aws_token")

    @property
    @pulumi.getter(name="saslMechanism")
    def sasl_mechanism(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SASL mechanism, can be plain, scram-sha512, scram-sha256, aws-iam
        """
        return pulumi.get(self, "sasl_mechanism")

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password for SASL authentication.
        """
        return pulumi.get(self, "sasl_password")

    @property
    @pulumi.getter(name="saslTokenUrl")
    def sasl_token_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The url to retrieve oauth2 tokens from, when using sasl mechanism oauthbearer
        """
        return pulumi.get(self, "sasl_token_url")

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Username for SASL authentication.
        """
        return pulumi.get(self, "sasl_username")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:kafka/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

