/*
# JamC-QA

This benchmark evaluates knowledge specific to Japan through multiple-choice questions.
It covers eight categories: culture, custom, regional_identity, geography, history, government, law, and healthcare.
Achieving high performance requires broad and detailed understanding of Japan across these categories.

References:

* [Hugging Face Dataset](https://huggingface.co/datasets/sbintuitions/JamC-QA)
*/

local dataset_base_args = {
  class_path: 'HFGenerationDataset',
  init_args: {
    path: 'sbintuitions/JamC-QA',
    subset: 'v1.0',
    split: 'test',
    reference_template: '{% set choices = [choice0, choice1, choice2, choice3] %}{{ choices[answer_index] }}',
  },
};

local template_blank = |||
  質問:: {{ question }}, 選択肢::
   {{ choice0 }}
   {{ choice1 }}
   {{ choice2 }}
||| + ' {{ choice3 }}, 回答::';

local template_culture = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 秋の季語でないものを選択肢の中から選べ, 選択肢::
   月見
   紅葉
   麗か
   山粧う, 回答:: 麗か
  質問:: 七段飾りの雛人形を飾る際、5段目に並べるものはどれ?, 選択肢::
   随身
   御駕篭
   箪笥
   仕丁, 回答:: 仕丁
  質問:: 萬歳楽・新年・東遊・越天楽のうち、催馬楽に当たるものはどれ, 選択肢::
   萬歳楽
   新年
   越天楽
   東遊, 回答:: 新年
  質問:: 餅つきで杵を振る人はつき手と呼ぶが、もち米をひっくり返す人は何と呼ぶか選択肢から選べ, 選択肢::
   返し手
   押し手
   こね手
   もみ手, 回答:: 返し手
||| + template_blank;

local template_custom = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 地鎮祭を実施するのに良いとされている日はどれ, 選択肢::
   先負
   友引
   仏滅
   赤口, 回答:: 友引
  質問:: 仏教のお葬式や法事のお焼香で用いられる細かい香木はどれ?, 選択肢::
   抹香
   線香
   香炉
   数珠, 回答:: 抹香
  質問:: お悔やみの言葉で口頭で使うにはふさわしくないものを選べ, 選択肢::
   残念でなりません
   お悔やみ申し上げます
   ご愁傷様です
   ご冥福をお祈りします, 回答:: ご冥福をお祈りします
  質問:: のし袋の渡し方として、正しくない説明を選べ, 選択肢::
   ふくさに包んで持参する
   両手で持って渡す
   玄関先で真っ先に渡す
   表書きが相手に見えるようにして渡す, 回答:: 玄関先で真っ先に渡す
||| + template_blank;

local template_regional_identity = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 日本で初めて小学校ができたのはどこか選べ, 選択肢::
   大阪
   横浜
   京都
   東京, 回答:: 京都
  質問:: 吉水神社の名勝として知られる桜の風景の別名はどれ?, 選択肢::
   一目十行
   一目十年
   一目千本
   一目八景, 回答:: 一目十年
  質問:: 宇都宮が「餃子のまち」と呼ばれるようになった理由について、誤っているものを選べ, 選択肢::
   気候の差が激しい宇都宮周辺は、小麦と白菜を作るのに適していた
   夏が暑い宇都宮で、スタミナを付けるために人気が高まった
   戦時中、兵隊が中国で食べていた餃子を、戦後になって宇都宮で作り始めた
   昔からキャベツや玉ねぎの生産や養豚が盛んだった, 回答:: 昔からキャベツや玉ねぎの生産や養豚が盛んだった
  質問:: 四国八十八か所の一番札所はどれ?, 選択肢::
   霊山寺
   極楽寺
   大日寺
   金泉寺, 回答:: 霊山寺
||| + template_blank;

local template_geography = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 日本の人工島空港で2番目に古い空港はどれ, 選択肢::
   関西国際空港
   中部国際空港
   神戸空港
   羽田空港, 回答:: 中部国際空港
  質問:: 2024年現在、日本で二番目に大きい古墳はどれ?, 選択肢::
   応神天皇陵古墳
   造山古墳
   仁徳天皇陵古墳
   箸墓古墳, 回答:: 応神天皇陵古墳
  質問:: 東京23区のうち、2024年1月時点で2番目に人口が多い区を選択肢から選べ, 選択肢::
   世田谷区
   大田区
   足立区
   練馬区, 回答:: 練馬区
  質問:: 2024年現在、最も標高が低い山はどれ, 選択肢::
   信夫山
   富山
   久能山
   二上山, 回答:: 久能山
||| + template_blank;

local template_history = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 日本橋にある、日本の国道の起点を示した「日本国道路元標」の文字を書いたのは誰か選べ, 選択肢::
   徳川慶喜
   伊藤博文
   田中角栄
   佐藤栄作, 回答:: 佐藤栄作
  質問:: 江戸時代に職業として存在しなかったものはどれ?, 選択肢::
   調律師
   小便仲間
   屁負比丘尼
   けだもの屋, 回答:: 調律師
  質問:: 平安時代、浄土教を信仰した藤原頼道によって建てられた世界遺産はどれ?, 選択肢::
   中尊寺
   平等院
   唐招提寺
   金剛寺, 回答:: 平等院
  質問:: 初めての日本郵便切手に使われた通貨単位はどれ?, 選択肢::
   円
   両
   文
   銭, 回答:: 文
||| + template_blank;

local template_government = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 2024年12月現在、マイナンバーカードを作成後、自主的に返納し、再度作成する場合(電子証明書の発行含む)にかかる手数料はいくらか選択肢の中から選べ, 選択肢::
   500円
   800円
   1000円
   2000円, 回答:: 1000円
  質問:: 2024年12月現在に存在する、8月1日から翌年7月31日の医療保険と介護保険の自己負担額が高額な場合、自己負担を軽減できる制度はどれ?, 選択肢::
   高額介護合算療養費制度
   高額療養費制度
   高額介護サービス費制度
   高額医療費制度, 回答:: 高額介護合算療養費制度
  質問:: 2025年2月現在、国民生活センターの問い合わせ先の電話番号はどれ?, 選択肢::
   03-5662-7637
   03-3446-0999
   188
   03-3406-7644, 回答:: 03-3446-0999
  質問:: 2024年12月現在、自動車を解体処分した際に必要な手続きを選べ, 選択肢::
   解体証明書
   リサイクル法
   一時抹消登録
   永久抹消登録, 回答:: 永久抹消登録
||| + template_blank;

local template_law = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 2024年現在、速度指定されていない高速道路での最低法定速度はどれ, 選択肢::
   時速50キロメートル
   時速30キロメートル
   時速40キロメートル
   時速60キロメートル, 回答:: 時速50キロメートル
  質問:: 2024年現在、ドローン視点のカメラ映像が使用できるFPVドローン(5.8GHz)の操作が出来ない資格はどれ, 選択肢::
   第2級陸上特殊無線技士
   第3級アマチュア無線技士
   第2級アマチュア無線技士
   第1級海上特殊無線技士, 回答:: 第1級海上特殊無線技士
  質問:: 道路上に描かれているひし形のマークの名称はどれ?, 選択肢::
   横断歩道注意マーク
   ダイヤマーク
   自転車横断帯マーク
   一時停止マーク, 回答:: ダイヤマーク
  質問:: 陣中見舞いで禁止されているものはどれ, 選択肢::
   金銭の寄付
   お菓子・果物
   弁当・酒・ジュース
   有価証券の寄付, 回答:: 弁当・酒・ジュース
||| + template_blank;

local template_healthcare = |||
  以下はタスクを説明する指示と、追加の背景情報を提供する入力の組み合わせです。要求を適切に満たす回答を書いてください。
  指示:: 質問と回答の選択肢を入力として受け取り、選択肢から回答を選択してください。回答の他には何も含めないことを厳守してください。
  
  質問:: 2024年現在、特定疾患療養管理料の算定対象外となる疾患はどれ?, 選択肢::
   胃潰瘍
   高血圧症
   結核
   喘息, 回答:: 高血圧症
  質問:: 2024年現在、マイナ保険証を利用した場合初診料はいくらか選べ, 選択肢::
   18円
   9円
   3円
   6円, 回答:: 6円
  質問:: 2024年現在、処方箋の使用期間は、交付の日を含めて何日以内か選べ, 選択肢::
   4日以内
   3日以内
   当日以内
   1週間以内, 回答:: 4日以内
  質問:: 訪日外国人旅行者の医療費は、一般的にどのような扱いになるか選べ, 選択肢::
   生活保護による診療
   無料診療
   自費診療
   公的医療保険診療, 回答:: 自費診療
||| + template_blank;

{
  class_path: 'Generation',
  init_args: {
    eval_dataset: dataset_base_args,
    prompt_template: {
      class_path: 'Jinja2PromptTemplate',
      init_args: {
        template: '{% if category == "culture" %}'+ template_culture + '{% elif category == "custom" %}'+ template_custom + '{% elif category == "regional_identity" %}'+ template_regional_identity + '{% elif category == "geography" %}'+ template_geography + '{% elif category == "history" %}'+ template_history + '{% elif category == "government" %}'+ template_government + '{% elif category == "law" %}'+ template_law + '{% elif category == "healthcare" %}' + template_healthcare + '{% endif %}',
      },
    },
    metrics: [
      { class_path: 'ExactMatch',
        init_args: {
          lm_output_processor: [ 
            { class_path: 'NFKCNormalizer'},
            { class_path: 'StringStrip', },
          ],
          reference_processor: [ 
            { class_path: 'NFKCNormalizer'},
            { class_path: 'StringStrip', },
          ],
        },
      },
    ],
    gen_kwargs: { max_new_tokens: 128, stop_sequences: ['\n'], },
    batch_size: 1,
  },
}
