# `google_container_cluster`

Refer to the Terraform Registory for docs: [`google_container_cluster`](https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster).

# `googleContainerCluster` Submodule <a name="`googleContainerCluster` Submodule" id="@cdktf/provider-google-beta.googleContainerCluster"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### GoogleContainerCluster <a name="GoogleContainerCluster" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster"></a>

Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster google_container_cluster}.

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerCluster(
  scope: Construct,
  id: str,
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[typing.Union[int, float], TerraformCount] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  name: str,
  addons_config: GoogleContainerClusterAddonsConfig = None,
  authenticator_groups_config: GoogleContainerClusterAuthenticatorGroupsConfig = None,
  binary_authorization: GoogleContainerClusterBinaryAuthorization = None,
  cluster_autoscaling: GoogleContainerClusterClusterAutoscaling = None,
  cluster_ipv4_cidr: str = None,
  cluster_telemetry: GoogleContainerClusterClusterTelemetry = None,
  confidential_nodes: GoogleContainerClusterConfidentialNodes = None,
  cost_management_config: GoogleContainerClusterCostManagementConfig = None,
  database_encryption: GoogleContainerClusterDatabaseEncryption = None,
  datapath_provider: str = None,
  default_max_pods_per_node: typing.Union[int, float] = None,
  default_snat_status: GoogleContainerClusterDefaultSnatStatus = None,
  description: str = None,
  dns_config: GoogleContainerClusterDnsConfig = None,
  enable_autopilot: typing.Union[bool, IResolvable] = None,
  enable_binary_authorization: typing.Union[bool, IResolvable] = None,
  enable_intranode_visibility: typing.Union[bool, IResolvable] = None,
  enable_kubernetes_alpha: typing.Union[bool, IResolvable] = None,
  enable_l4_ilb_subsetting: typing.Union[bool, IResolvable] = None,
  enable_legacy_abac: typing.Union[bool, IResolvable] = None,
  enable_shielded_nodes: typing.Union[bool, IResolvable] = None,
  enable_tpu: typing.Union[bool, IResolvable] = None,
  gateway_api_config: GoogleContainerClusterGatewayApiConfig = None,
  id: str = None,
  identity_service_config: GoogleContainerClusterIdentityServiceConfig = None,
  initial_node_count: typing.Union[int, float] = None,
  ip_allocation_policy: GoogleContainerClusterIpAllocationPolicy = None,
  location: str = None,
  logging_config: GoogleContainerClusterLoggingConfig = None,
  logging_service: str = None,
  maintenance_policy: GoogleContainerClusterMaintenancePolicy = None,
  master_auth: GoogleContainerClusterMasterAuth = None,
  master_authorized_networks_config: GoogleContainerClusterMasterAuthorizedNetworksConfig = None,
  mesh_certificates: GoogleContainerClusterMeshCertificates = None,
  min_master_version: str = None,
  monitoring_config: GoogleContainerClusterMonitoringConfig = None,
  monitoring_service: str = None,
  network: str = None,
  networking_mode: str = None,
  network_policy: GoogleContainerClusterNetworkPolicy = None,
  node_config: GoogleContainerClusterNodeConfig = None,
  node_locations: typing.List[str] = None,
  node_pool: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePool]] = None,
  node_pool_auto_config: GoogleContainerClusterNodePoolAutoConfig = None,
  node_pool_defaults: GoogleContainerClusterNodePoolDefaults = None,
  node_version: str = None,
  notification_config: GoogleContainerClusterNotificationConfig = None,
  pod_security_policy_config: GoogleContainerClusterPodSecurityPolicyConfig = None,
  private_cluster_config: GoogleContainerClusterPrivateClusterConfig = None,
  private_ipv6_google_access: str = None,
  project: str = None,
  protect_config: GoogleContainerClusterProtectConfig = None,
  release_channel: GoogleContainerClusterReleaseChannel = None,
  remove_default_node_pool: typing.Union[bool, IResolvable] = None,
  resource_labels: typing.Mapping[str] = None,
  resource_usage_export_config: GoogleContainerClusterResourceUsageExportConfig = None,
  service_external_ips_config: GoogleContainerClusterServiceExternalIpsConfig = None,
  subnetwork: str = None,
  timeouts: GoogleContainerClusterTimeouts = None,
  tpu_config: GoogleContainerClusterTpuConfig = None,
  vertical_pod_autoscaling: GoogleContainerClusterVerticalPodAutoscaling = None,
  workload_identity_config: GoogleContainerClusterWorkloadIdentityConfig = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.id">id</a></code> | <code>str</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.name">name</a></code> | <code>str</code> | The name of the cluster, unique within the project and location. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.addonsConfig">addons_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a></code> | addons_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.authenticatorGroupsConfig">authenticator_groups_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a></code> | authenticator_groups_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.binaryAuthorization">binary_authorization</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a></code> | binary_authorization block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.clusterAutoscaling">cluster_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling">GoogleContainerClusterClusterAutoscaling</a></code> | cluster_autoscaling block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.clusterIpv4Cidr">cluster_ipv4_cidr</a></code> | <code>str</code> | The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.clusterTelemetry">cluster_telemetry</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry">GoogleContainerClusterClusterTelemetry</a></code> | cluster_telemetry block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.confidentialNodes">confidential_nodes</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes">GoogleContainerClusterConfidentialNodes</a></code> | confidential_nodes block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.costManagementConfig">cost_management_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig">GoogleContainerClusterCostManagementConfig</a></code> | cost_management_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.databaseEncryption">database_encryption</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption">GoogleContainerClusterDatabaseEncryption</a></code> | database_encryption block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.datapathProvider">datapath_provider</a></code> | <code>str</code> | The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.defaultMaxPodsPerNode">default_max_pods_per_node</a></code> | <code>typing.Union[int, float]</code> | The default maximum number of pods per node in this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.defaultSnatStatus">default_snat_status</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus">GoogleContainerClusterDefaultSnatStatus</a></code> | default_snat_status block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.description">description</a></code> | <code>str</code> | Description of the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.dnsConfig">dns_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig">GoogleContainerClusterDnsConfig</a></code> | dns_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableAutopilot">enable_autopilot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Autopilot for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableBinaryAuthorization">enable_binary_authorization</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableIntranodeVisibility">enable_intranode_visibility</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether Intra-node visibility is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableKubernetesAlpha">enable_kubernetes_alpha</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable Kubernetes Alpha features for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableL4IlbSubsetting">enable_l4_ilb_subsetting</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether L4ILB Subsetting is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableLegacyAbac">enable_legacy_abac</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the ABAC authorizer is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableShieldedNodes">enable_shielded_nodes</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Shielded Nodes features on all nodes in this cluster. Defaults to true. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableTpu">enable_tpu</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable Cloud TPU resources in this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.gatewayApiConfig">gateway_api_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig">GoogleContainerClusterGatewayApiConfig</a></code> | gateway_api_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#id GoogleContainerCluster#id}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.identityServiceConfig">identity_service_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig">GoogleContainerClusterIdentityServiceConfig</a></code> | identity_service_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.initialNodeCount">initial_node_count</a></code> | <code>typing.Union[int, float]</code> | The number of nodes to create in this cluster's default node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.ipAllocationPolicy">ip_allocation_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy">GoogleContainerClusterIpAllocationPolicy</a></code> | ip_allocation_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.location">location</a></code> | <code>str</code> | The location (region or zone) in which the cluster master will be created, as well as the default node location. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.loggingConfig">logging_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig">GoogleContainerClusterLoggingConfig</a></code> | logging_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.loggingService">logging_service</a></code> | <code>str</code> | The logging service that the cluster should write logs to. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.maintenancePolicy">maintenance_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy">GoogleContainerClusterMaintenancePolicy</a></code> | maintenance_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.masterAuth">master_auth</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth">GoogleContainerClusterMasterAuth</a></code> | master_auth block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.masterAuthorizedNetworksConfig">master_authorized_networks_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig">GoogleContainerClusterMasterAuthorizedNetworksConfig</a></code> | master_authorized_networks_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.meshCertificates">mesh_certificates</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates">GoogleContainerClusterMeshCertificates</a></code> | mesh_certificates block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.minMasterVersion">min_master_version</a></code> | <code>str</code> | The minimum version of the master. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.monitoringConfig">monitoring_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig">GoogleContainerClusterMonitoringConfig</a></code> | monitoring_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.monitoringService">monitoring_service</a></code> | <code>str</code> | The monitoring service that the cluster should write metrics to. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.network">network</a></code> | <code>str</code> | The name or self_link of the Google Compute Engine network to which the cluster is connected. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.networkingMode">networking_mode</a></code> | <code>str</code> | Determines whether alias IPs or routes will be used for pod IPs in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.networkPolicy">network_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy">GoogleContainerClusterNetworkPolicy</a></code> | network_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodeConfig">node_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig">GoogleContainerClusterNodeConfig</a></code> | node_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodeLocations">node_locations</a></code> | <code>typing.List[str]</code> | The list of zones in which the cluster's nodes are located. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodePool">node_pool</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]</code> | node_pool block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodePoolAutoConfig">node_pool_auto_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig">GoogleContainerClusterNodePoolAutoConfig</a></code> | node_pool_auto_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodePoolDefaults">node_pool_defaults</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults">GoogleContainerClusterNodePoolDefaults</a></code> | node_pool_defaults block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodeVersion">node_version</a></code> | <code>str</code> | The Kubernetes version on the nodes. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.notificationConfig">notification_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig">GoogleContainerClusterNotificationConfig</a></code> | notification_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.podSecurityPolicyConfig">pod_security_policy_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig">GoogleContainerClusterPodSecurityPolicyConfig</a></code> | pod_security_policy_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.privateClusterConfig">private_cluster_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig">GoogleContainerClusterPrivateClusterConfig</a></code> | private_cluster_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.privateIpv6GoogleAccess">private_ipv6_google_access</a></code> | <code>str</code> | The desired state of IPv6 connectivity to Google Services. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.project">project</a></code> | <code>str</code> | The ID of the project in which the resource belongs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.protectConfig">protect_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig">GoogleContainerClusterProtectConfig</a></code> | protect_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.releaseChannel">release_channel</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel">GoogleContainerClusterReleaseChannel</a></code> | release_channel block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.removeDefaultNodePool">remove_default_node_pool</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | If true, deletes the default node pool upon cluster creation. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.resourceLabels">resource_labels</a></code> | <code>typing.Mapping[str]</code> | The GCE resource labels (a map of key/value pairs) to be applied to the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.resourceUsageExportConfig">resource_usage_export_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig">GoogleContainerClusterResourceUsageExportConfig</a></code> | resource_usage_export_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.serviceExternalIpsConfig">service_external_ips_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig">GoogleContainerClusterServiceExternalIpsConfig</a></code> | service_external_ips_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.subnetwork">subnetwork</a></code> | <code>str</code> | The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts">GoogleContainerClusterTimeouts</a></code> | timeouts block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.tpuConfig">tpu_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig">GoogleContainerClusterTpuConfig</a></code> | tpu_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.verticalPodAutoscaling">vertical_pod_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling">GoogleContainerClusterVerticalPodAutoscaling</a></code> | vertical_pod_autoscaling block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.workloadIdentityConfig">workload_identity_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig">GoogleContainerClusterWorkloadIdentityConfig</a></code> | workload_identity_config block. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.id"></a>

- *Type:* str

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.connection"></a>

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.count"></a>

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.dependsOn"></a>

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.forEach"></a>

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.lifecycle"></a>

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.provider"></a>

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.provisioners"></a>

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.name"></a>

- *Type:* str

The name of the cluster, unique within the project and location.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#name GoogleContainerCluster#name}

---

##### `addons_config`<sup>Optional</sup> <a name="addons_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.addonsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a>

addons_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#addons_config GoogleContainerCluster#addons_config}

---

##### `authenticator_groups_config`<sup>Optional</sup> <a name="authenticator_groups_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.authenticatorGroupsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a>

authenticator_groups_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#authenticator_groups_config GoogleContainerCluster#authenticator_groups_config}

---

##### `binary_authorization`<sup>Optional</sup> <a name="binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.binaryAuthorization"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a>

binary_authorization block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#binary_authorization GoogleContainerCluster#binary_authorization}

---

##### `cluster_autoscaling`<sup>Optional</sup> <a name="cluster_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.clusterAutoscaling"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling">GoogleContainerClusterClusterAutoscaling</a>

cluster_autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_autoscaling GoogleContainerCluster#cluster_autoscaling}

---

##### `cluster_ipv4_cidr`<sup>Optional</sup> <a name="cluster_ipv4_cidr" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.clusterIpv4Cidr"></a>

- *Type:* str

The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_ipv4_cidr GoogleContainerCluster#cluster_ipv4_cidr}

---

##### `cluster_telemetry`<sup>Optional</sup> <a name="cluster_telemetry" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.clusterTelemetry"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry">GoogleContainerClusterClusterTelemetry</a>

cluster_telemetry block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_telemetry GoogleContainerCluster#cluster_telemetry}

---

##### `confidential_nodes`<sup>Optional</sup> <a name="confidential_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.confidentialNodes"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes">GoogleContainerClusterConfidentialNodes</a>

confidential_nodes block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#confidential_nodes GoogleContainerCluster#confidential_nodes}

---

##### `cost_management_config`<sup>Optional</sup> <a name="cost_management_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.costManagementConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig">GoogleContainerClusterCostManagementConfig</a>

cost_management_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cost_management_config GoogleContainerCluster#cost_management_config}

---

##### `database_encryption`<sup>Optional</sup> <a name="database_encryption" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.databaseEncryption"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption">GoogleContainerClusterDatabaseEncryption</a>

database_encryption block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#database_encryption GoogleContainerCluster#database_encryption}

---

##### `datapath_provider`<sup>Optional</sup> <a name="datapath_provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.datapathProvider"></a>

- *Type:* str

The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#datapath_provider GoogleContainerCluster#datapath_provider}

---

##### `default_max_pods_per_node`<sup>Optional</sup> <a name="default_max_pods_per_node" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.defaultMaxPodsPerNode"></a>

- *Type:* typing.Union[int, float]

The default maximum number of pods per node in this cluster.

This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#default_max_pods_per_node GoogleContainerCluster#default_max_pods_per_node}

---

##### `default_snat_status`<sup>Optional</sup> <a name="default_snat_status" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.defaultSnatStatus"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus">GoogleContainerClusterDefaultSnatStatus</a>

default_snat_status block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#default_snat_status GoogleContainerCluster#default_snat_status}

---

##### `description`<sup>Optional</sup> <a name="description" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.description"></a>

- *Type:* str

Description of the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#description GoogleContainerCluster#description}

---

##### `dns_config`<sup>Optional</sup> <a name="dns_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.dnsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig">GoogleContainerClusterDnsConfig</a>

dns_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#dns_config GoogleContainerCluster#dns_config}

---

##### `enable_autopilot`<sup>Optional</sup> <a name="enable_autopilot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableAutopilot"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Autopilot for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_autopilot GoogleContainerCluster#enable_autopilot}

---

##### `enable_binary_authorization`<sup>Optional</sup> <a name="enable_binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableBinaryAuthorization"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_binary_authorization GoogleContainerCluster#enable_binary_authorization}

---

##### `enable_intranode_visibility`<sup>Optional</sup> <a name="enable_intranode_visibility" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableIntranodeVisibility"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether Intra-node visibility is enabled for this cluster.

This makes same node pod to pod traffic visible for VPC network.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_intranode_visibility GoogleContainerCluster#enable_intranode_visibility}

---

##### `enable_kubernetes_alpha`<sup>Optional</sup> <a name="enable_kubernetes_alpha" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableKubernetesAlpha"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable Kubernetes Alpha features for this cluster.

Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_kubernetes_alpha GoogleContainerCluster#enable_kubernetes_alpha}

---

##### `enable_l4_ilb_subsetting`<sup>Optional</sup> <a name="enable_l4_ilb_subsetting" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableL4IlbSubsetting"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether L4ILB Subsetting is enabled for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_l4_ilb_subsetting GoogleContainerCluster#enable_l4_ilb_subsetting}

---

##### `enable_legacy_abac`<sup>Optional</sup> <a name="enable_legacy_abac" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableLegacyAbac"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the ABAC authorizer is enabled for this cluster.

When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_legacy_abac GoogleContainerCluster#enable_legacy_abac}

---

##### `enable_shielded_nodes`<sup>Optional</sup> <a name="enable_shielded_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableShieldedNodes"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_shielded_nodes GoogleContainerCluster#enable_shielded_nodes}

---

##### `enable_tpu`<sup>Optional</sup> <a name="enable_tpu" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.enableTpu"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable Cloud TPU resources in this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_tpu GoogleContainerCluster#enable_tpu}

---

##### `gateway_api_config`<sup>Optional</sup> <a name="gateway_api_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.gatewayApiConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig">GoogleContainerClusterGatewayApiConfig</a>

gateway_api_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gateway_api_config GoogleContainerCluster#gateway_api_config}

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.id"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#id GoogleContainerCluster#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `identity_service_config`<sup>Optional</sup> <a name="identity_service_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.identityServiceConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig">GoogleContainerClusterIdentityServiceConfig</a>

identity_service_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#identity_service_config GoogleContainerCluster#identity_service_config}

---

##### `initial_node_count`<sup>Optional</sup> <a name="initial_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.initialNodeCount"></a>

- *Type:* typing.Union[int, float]

The number of nodes to create in this cluster's default node pool.

In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}

---

##### `ip_allocation_policy`<sup>Optional</sup> <a name="ip_allocation_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.ipAllocationPolicy"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy">GoogleContainerClusterIpAllocationPolicy</a>

ip_allocation_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ip_allocation_policy GoogleContainerCluster#ip_allocation_policy}

---

##### `location`<sup>Optional</sup> <a name="location" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.location"></a>

- *Type:* str

The location (region or zone) in which the cluster master will be created, as well as the default node location.

If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#location GoogleContainerCluster#location}

---

##### `logging_config`<sup>Optional</sup> <a name="logging_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.loggingConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig">GoogleContainerClusterLoggingConfig</a>

logging_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_config GoogleContainerCluster#logging_config}

---

##### `logging_service`<sup>Optional</sup> <a name="logging_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.loggingService"></a>

- *Type:* str

The logging service that the cluster should write logs to.

Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_service GoogleContainerCluster#logging_service}

---

##### `maintenance_policy`<sup>Optional</sup> <a name="maintenance_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.maintenancePolicy"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy">GoogleContainerClusterMaintenancePolicy</a>

maintenance_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#maintenance_policy GoogleContainerCluster#maintenance_policy}

---

##### `master_auth`<sup>Optional</sup> <a name="master_auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.masterAuth"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth">GoogleContainerClusterMasterAuth</a>

master_auth block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_auth GoogleContainerCluster#master_auth}

---

##### `master_authorized_networks_config`<sup>Optional</sup> <a name="master_authorized_networks_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.masterAuthorizedNetworksConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig">GoogleContainerClusterMasterAuthorizedNetworksConfig</a>

master_authorized_networks_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_authorized_networks_config GoogleContainerCluster#master_authorized_networks_config}

---

##### `mesh_certificates`<sup>Optional</sup> <a name="mesh_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.meshCertificates"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates">GoogleContainerClusterMeshCertificates</a>

mesh_certificates block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#mesh_certificates GoogleContainerCluster#mesh_certificates}

---

##### `min_master_version`<sup>Optional</sup> <a name="min_master_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.minMasterVersion"></a>

- *Type:* str

The minimum version of the master.

GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_master_version GoogleContainerCluster#min_master_version}

---

##### `monitoring_config`<sup>Optional</sup> <a name="monitoring_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.monitoringConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig">GoogleContainerClusterMonitoringConfig</a>

monitoring_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#monitoring_config GoogleContainerCluster#monitoring_config}

---

##### `monitoring_service`<sup>Optional</sup> <a name="monitoring_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.monitoringService"></a>

- *Type:* str

The monitoring service that the cluster should write metrics to.

Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#monitoring_service GoogleContainerCluster#monitoring_service}

---

##### `network`<sup>Optional</sup> <a name="network" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.network"></a>

- *Type:* str

The name or self_link of the Google Compute Engine network to which the cluster is connected.

For Shared VPC, set this to the self link of the shared network.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network GoogleContainerCluster#network}

---

##### `networking_mode`<sup>Optional</sup> <a name="networking_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.networkingMode"></a>

- *Type:* str

Determines whether alias IPs or routes will be used for pod IPs in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#networking_mode GoogleContainerCluster#networking_mode}

---

##### `network_policy`<sup>Optional</sup> <a name="network_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.networkPolicy"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy">GoogleContainerClusterNetworkPolicy</a>

network_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_policy GoogleContainerCluster#network_policy}

---

##### `node_config`<sup>Optional</sup> <a name="node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodeConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig">GoogleContainerClusterNodeConfig</a>

node_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_config GoogleContainerCluster#node_config}

---

##### `node_locations`<sup>Optional</sup> <a name="node_locations" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodeLocations"></a>

- *Type:* typing.List[str]

The list of zones in which the cluster's nodes are located.

Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_locations GoogleContainerCluster#node_locations}

---

##### `node_pool`<sup>Optional</sup> <a name="node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodePool"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]

node_pool block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool GoogleContainerCluster#node_pool}

---

##### `node_pool_auto_config`<sup>Optional</sup> <a name="node_pool_auto_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodePoolAutoConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig">GoogleContainerClusterNodePoolAutoConfig</a>

node_pool_auto_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool_auto_config GoogleContainerCluster#node_pool_auto_config}

---

##### `node_pool_defaults`<sup>Optional</sup> <a name="node_pool_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodePoolDefaults"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults">GoogleContainerClusterNodePoolDefaults</a>

node_pool_defaults block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool_defaults GoogleContainerCluster#node_pool_defaults}

---

##### `node_version`<sup>Optional</sup> <a name="node_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.nodeVersion"></a>

- *Type:* str

The Kubernetes version on the nodes.

Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_version GoogleContainerCluster#node_version}

---

##### `notification_config`<sup>Optional</sup> <a name="notification_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.notificationConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig">GoogleContainerClusterNotificationConfig</a>

notification_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#notification_config GoogleContainerCluster#notification_config}

---

##### `pod_security_policy_config`<sup>Optional</sup> <a name="pod_security_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.podSecurityPolicyConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig">GoogleContainerClusterPodSecurityPolicyConfig</a>

pod_security_policy_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_security_policy_config GoogleContainerCluster#pod_security_policy_config}

---

##### `private_cluster_config`<sup>Optional</sup> <a name="private_cluster_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.privateClusterConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig">GoogleContainerClusterPrivateClusterConfig</a>

private_cluster_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#private_cluster_config GoogleContainerCluster#private_cluster_config}

---

##### `private_ipv6_google_access`<sup>Optional</sup> <a name="private_ipv6_google_access" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.privateIpv6GoogleAccess"></a>

- *Type:* str

The desired state of IPv6 connectivity to Google Services.

By default, no private IPv6 access to or from Google Services (all access will be via IPv4).

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#private_ipv6_google_access GoogleContainerCluster#private_ipv6_google_access}

---

##### `project`<sup>Optional</sup> <a name="project" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.project"></a>

- *Type:* str

The ID of the project in which the resource belongs.

If it is not provided, the provider project is used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#project GoogleContainerCluster#project}

---

##### `protect_config`<sup>Optional</sup> <a name="protect_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.protectConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig">GoogleContainerClusterProtectConfig</a>

protect_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#protect_config GoogleContainerCluster#protect_config}

---

##### `release_channel`<sup>Optional</sup> <a name="release_channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.releaseChannel"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel">GoogleContainerClusterReleaseChannel</a>

release_channel block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#release_channel GoogleContainerCluster#release_channel}

---

##### `remove_default_node_pool`<sup>Optional</sup> <a name="remove_default_node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.removeDefaultNodePool"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

If true, deletes the default node pool upon cluster creation.

If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#remove_default_node_pool GoogleContainerCluster#remove_default_node_pool}

---

##### `resource_labels`<sup>Optional</sup> <a name="resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.resourceLabels"></a>

- *Type:* typing.Mapping[str]

The GCE resource labels (a map of key/value pairs) to be applied to the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}

---

##### `resource_usage_export_config`<sup>Optional</sup> <a name="resource_usage_export_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.resourceUsageExportConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig">GoogleContainerClusterResourceUsageExportConfig</a>

resource_usage_export_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_usage_export_config GoogleContainerCluster#resource_usage_export_config}

---

##### `service_external_ips_config`<sup>Optional</sup> <a name="service_external_ips_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.serviceExternalIpsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig">GoogleContainerClusterServiceExternalIpsConfig</a>

service_external_ips_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#service_external_ips_config GoogleContainerCluster#service_external_ips_config}

---

##### `subnetwork`<sup>Optional</sup> <a name="subnetwork" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.subnetwork"></a>

- *Type:* str

The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#subnetwork GoogleContainerCluster#subnetwork}

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.timeouts"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts">GoogleContainerClusterTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#timeouts GoogleContainerCluster#timeouts}

---

##### `tpu_config`<sup>Optional</sup> <a name="tpu_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.tpuConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig">GoogleContainerClusterTpuConfig</a>

tpu_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#tpu_config GoogleContainerCluster#tpu_config}

---

##### `vertical_pod_autoscaling`<sup>Optional</sup> <a name="vertical_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.verticalPodAutoscaling"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling">GoogleContainerClusterVerticalPodAutoscaling</a>

vertical_pod_autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#vertical_pod_autoscaling GoogleContainerCluster#vertical_pod_autoscaling}

---

##### `workload_identity_config`<sup>Optional</sup> <a name="workload_identity_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.Initializer.parameter.workloadIdentityConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig">GoogleContainerClusterWorkloadIdentityConfig</a>

workload_identity_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_identity_config GoogleContainerCluster#workload_identity_config}

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.addOverride">add_override</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.overrideLogicalId">override_logical_id</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetOverrideLogicalId">reset_override_logical_id</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.toMetadata">to_metadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.toTerraform">to_terraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig">put_addons_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAuthenticatorGroupsConfig">put_authenticator_groups_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putBinaryAuthorization">put_binary_authorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterAutoscaling">put_cluster_autoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterTelemetry">put_cluster_telemetry</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putConfidentialNodes">put_confidential_nodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putCostManagementConfig">put_cost_management_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDatabaseEncryption">put_database_encryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDefaultSnatStatus">put_default_snat_status</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDnsConfig">put_dns_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putGatewayApiConfig">put_gateway_api_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIdentityServiceConfig">put_identity_service_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy">put_ip_allocation_policy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putLoggingConfig">put_logging_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMaintenancePolicy">put_maintenance_policy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuth">put_master_auth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuthorizedNetworksConfig">put_master_authorized_networks_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMeshCertificates">put_mesh_certificates</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMonitoringConfig">put_monitoring_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNetworkPolicy">put_network_policy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig">put_node_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePool">put_node_pool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePoolAutoConfig">put_node_pool_auto_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePoolDefaults">put_node_pool_defaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNotificationConfig">put_notification_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPodSecurityPolicyConfig">put_pod_security_policy_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig">put_private_cluster_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putProtectConfig">put_protect_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putReleaseChannel">put_release_channel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putResourceUsageExportConfig">put_resource_usage_export_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putServiceExternalIpsConfig">put_service_external_ips_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTimeouts">put_timeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTpuConfig">put_tpu_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putVerticalPodAutoscaling">put_vertical_pod_autoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putWorkloadIdentityConfig">put_workload_identity_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetAddonsConfig">reset_addons_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetAuthenticatorGroupsConfig">reset_authenticator_groups_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetBinaryAuthorization">reset_binary_authorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetClusterAutoscaling">reset_cluster_autoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetClusterIpv4Cidr">reset_cluster_ipv4_cidr</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetClusterTelemetry">reset_cluster_telemetry</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetConfidentialNodes">reset_confidential_nodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetCostManagementConfig">reset_cost_management_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDatabaseEncryption">reset_database_encryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDatapathProvider">reset_datapath_provider</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDefaultMaxPodsPerNode">reset_default_max_pods_per_node</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDefaultSnatStatus">reset_default_snat_status</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDescription">reset_description</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDnsConfig">reset_dns_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableAutopilot">reset_enable_autopilot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableBinaryAuthorization">reset_enable_binary_authorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableIntranodeVisibility">reset_enable_intranode_visibility</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableKubernetesAlpha">reset_enable_kubernetes_alpha</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableL4IlbSubsetting">reset_enable_l4_ilb_subsetting</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableLegacyAbac">reset_enable_legacy_abac</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableShieldedNodes">reset_enable_shielded_nodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableTpu">reset_enable_tpu</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetGatewayApiConfig">reset_gateway_api_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetId">reset_id</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetIdentityServiceConfig">reset_identity_service_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetInitialNodeCount">reset_initial_node_count</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetIpAllocationPolicy">reset_ip_allocation_policy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetLocation">reset_location</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetLoggingConfig">reset_logging_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetLoggingService">reset_logging_service</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMaintenancePolicy">reset_maintenance_policy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMasterAuth">reset_master_auth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMasterAuthorizedNetworksConfig">reset_master_authorized_networks_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMeshCertificates">reset_mesh_certificates</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMinMasterVersion">reset_min_master_version</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMonitoringConfig">reset_monitoring_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMonitoringService">reset_monitoring_service</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNetwork">reset_network</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNetworkingMode">reset_networking_mode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNetworkPolicy">reset_network_policy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodeConfig">reset_node_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodeLocations">reset_node_locations</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodePool">reset_node_pool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodePoolAutoConfig">reset_node_pool_auto_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodePoolDefaults">reset_node_pool_defaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodeVersion">reset_node_version</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNotificationConfig">reset_notification_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetPodSecurityPolicyConfig">reset_pod_security_policy_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetPrivateClusterConfig">reset_private_cluster_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetPrivateIpv6GoogleAccess">reset_private_ipv6_google_access</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetProject">reset_project</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetProtectConfig">reset_protect_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetReleaseChannel">reset_release_channel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetRemoveDefaultNodePool">reset_remove_default_node_pool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetResourceLabels">reset_resource_labels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetResourceUsageExportConfig">reset_resource_usage_export_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetServiceExternalIpsConfig">reset_service_external_ips_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetSubnetwork">reset_subnetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetTimeouts">reset_timeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetTpuConfig">reset_tpu_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetVerticalPodAutoscaling">reset_vertical_pod_autoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetWorkloadIdentityConfig">reset_workload_identity_config</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_override` <a name="add_override" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.addOverride"></a>

```python
def add_override(
  path: str,
  value: typing.Any
) -> None
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.addOverride.parameter.path"></a>

- *Type:* str

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.addOverride.parameter.value"></a>

- *Type:* typing.Any

---

##### `override_logical_id` <a name="override_logical_id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.overrideLogicalId"></a>

```python
def override_logical_id(
  new_logical_id: str
) -> None
```

Overrides the auto-generated logical ID with a specific ID.

###### `new_logical_id`<sup>Required</sup> <a name="new_logical_id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* str

The new logical ID to use for this stack element.

---

##### `reset_override_logical_id` <a name="reset_override_logical_id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetOverrideLogicalId"></a>

```python
def reset_override_logical_id() -> None
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `to_metadata` <a name="to_metadata" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.toMetadata"></a>

```python
def to_metadata() -> typing.Any
```

##### `to_terraform` <a name="to_terraform" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.toTerraform"></a>

```python
def to_terraform() -> typing.Any
```

Adds this resource to the terraform JSON output.

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `put_addons_config` <a name="put_addons_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig"></a>

```python
def put_addons_config(
  cloudrun_config: GoogleContainerClusterAddonsConfigCloudrunConfig = None,
  config_connector_config: GoogleContainerClusterAddonsConfigConfigConnectorConfig = None,
  dns_cache_config: GoogleContainerClusterAddonsConfigDnsCacheConfig = None,
  gce_persistent_disk_csi_driver_config: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig = None,
  gcp_filestore_csi_driver_config: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig = None,
  gke_backup_agent_config: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig = None,
  horizontal_pod_autoscaling: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling = None,
  http_load_balancing: GoogleContainerClusterAddonsConfigHttpLoadBalancing = None,
  istio_config: GoogleContainerClusterAddonsConfigIstioConfig = None,
  kalm_config: GoogleContainerClusterAddonsConfigKalmConfig = None,
  network_policy_config: GoogleContainerClusterAddonsConfigNetworkPolicyConfig = None
) -> None
```

###### `cloudrun_config`<sup>Optional</sup> <a name="cloudrun_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.cloudrunConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a>

cloudrun_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cloudrun_config GoogleContainerCluster#cloudrun_config}

---

###### `config_connector_config`<sup>Optional</sup> <a name="config_connector_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.configConnectorConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a>

config_connector_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#config_connector_config GoogleContainerCluster#config_connector_config}

---

###### `dns_cache_config`<sup>Optional</sup> <a name="dns_cache_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.dnsCacheConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a>

dns_cache_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#dns_cache_config GoogleContainerCluster#dns_cache_config}

---

###### `gce_persistent_disk_csi_driver_config`<sup>Optional</sup> <a name="gce_persistent_disk_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.gcePersistentDiskCsiDriverConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

gce_persistent_disk_csi_driver_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gce_persistent_disk_csi_driver_config GoogleContainerCluster#gce_persistent_disk_csi_driver_config}

---

###### `gcp_filestore_csi_driver_config`<sup>Optional</sup> <a name="gcp_filestore_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.gcpFilestoreCsiDriverConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

gcp_filestore_csi_driver_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcp_filestore_csi_driver_config GoogleContainerCluster#gcp_filestore_csi_driver_config}

---

###### `gke_backup_agent_config`<sup>Optional</sup> <a name="gke_backup_agent_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.gkeBackupAgentConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a>

gke_backup_agent_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gke_backup_agent_config GoogleContainerCluster#gke_backup_agent_config}

---

###### `horizontal_pod_autoscaling`<sup>Optional</sup> <a name="horizontal_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.horizontalPodAutoscaling"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

horizontal_pod_autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#horizontal_pod_autoscaling GoogleContainerCluster#horizontal_pod_autoscaling}

---

###### `http_load_balancing`<sup>Optional</sup> <a name="http_load_balancing" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.httpLoadBalancing"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a>

http_load_balancing block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#http_load_balancing GoogleContainerCluster#http_load_balancing}

---

###### `istio_config`<sup>Optional</sup> <a name="istio_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.istioConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a>

istio_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#istio_config GoogleContainerCluster#istio_config}

---

###### `kalm_config`<sup>Optional</sup> <a name="kalm_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.kalmConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a>

kalm_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#kalm_config GoogleContainerCluster#kalm_config}

---

###### `network_policy_config`<sup>Optional</sup> <a name="network_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAddonsConfig.parameter.networkPolicyConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a>

network_policy_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_policy_config GoogleContainerCluster#network_policy_config}

---

##### `put_authenticator_groups_config` <a name="put_authenticator_groups_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAuthenticatorGroupsConfig"></a>

```python
def put_authenticator_groups_config(
  security_group: str
) -> None
```

###### `security_group`<sup>Required</sup> <a name="security_group" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putAuthenticatorGroupsConfig.parameter.securityGroup"></a>

- *Type:* str

The name of the RBAC security group for use with Google security groups in Kubernetes RBAC.

Group name must be in format gke-security-groups@yourdomain.com.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#security_group GoogleContainerCluster#security_group}

---

##### `put_binary_authorization` <a name="put_binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putBinaryAuthorization"></a>

```python
def put_binary_authorization(
  enabled: typing.Union[bool, IResolvable] = None,
  evaluation_mode: str = None
) -> None
```

###### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putBinaryAuthorization.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Binary Authorization for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

###### `evaluation_mode`<sup>Optional</sup> <a name="evaluation_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putBinaryAuthorization.parameter.evaluationMode"></a>

- *Type:* str

Mode of operation for Binary Authorization policy evaluation.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#evaluation_mode GoogleContainerCluster#evaluation_mode}

---

##### `put_cluster_autoscaling` <a name="put_cluster_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterAutoscaling"></a>

```python
def put_cluster_autoscaling(
  auto_provisioning_defaults: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults = None,
  autoscaling_profile: str = None,
  enabled: typing.Union[bool, IResolvable] = None,
  resource_limits: typing.Union[IResolvable, typing.List[GoogleContainerClusterClusterAutoscalingResourceLimits]] = None
) -> None
```

###### `auto_provisioning_defaults`<sup>Optional</sup> <a name="auto_provisioning_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterAutoscaling.parameter.autoProvisioningDefaults"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults</a>

auto_provisioning_defaults block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auto_provisioning_defaults GoogleContainerCluster#auto_provisioning_defaults}

---

###### `autoscaling_profile`<sup>Optional</sup> <a name="autoscaling_profile" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterAutoscaling.parameter.autoscalingProfile"></a>

- *Type:* str

Configuration options for the Autoscaling profile feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability when deciding to remove nodes from a cluster.

Can be BALANCED or OPTIMIZE_UTILIZATION. Defaults to BALANCED.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#autoscaling_profile GoogleContainerCluster#autoscaling_profile}

---

###### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterAutoscaling.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

###### `resource_limits`<sup>Optional</sup> <a name="resource_limits" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterAutoscaling.parameter.resourceLimits"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits">GoogleContainerClusterClusterAutoscalingResourceLimits</a>]]

resource_limits block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_limits GoogleContainerCluster#resource_limits}

---

##### `put_cluster_telemetry` <a name="put_cluster_telemetry" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterTelemetry"></a>

```python
def put_cluster_telemetry(
  type: str
) -> None
```

###### `type`<sup>Required</sup> <a name="type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putClusterTelemetry.parameter.type"></a>

- *Type:* str

Type of the integration.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}

---

##### `put_confidential_nodes` <a name="put_confidential_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putConfidentialNodes"></a>

```python
def put_confidential_nodes(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putConfidentialNodes.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether Confidential Nodes feature is enabled for all nodes in this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `put_cost_management_config` <a name="put_cost_management_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putCostManagementConfig"></a>

```python
def put_cost_management_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putCostManagementConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable GKE cost allocation.

When you enable GKE cost allocation, the cluster name and namespace of your GKE workloads appear in the labels field of the billing export to BigQuery. Defaults to false.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `put_database_encryption` <a name="put_database_encryption" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDatabaseEncryption"></a>

```python
def put_database_encryption(
  state: str,
  key_name: str = None
) -> None
```

###### `state`<sup>Required</sup> <a name="state" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDatabaseEncryption.parameter.state"></a>

- *Type:* str

ENCRYPTED or DECRYPTED.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#state GoogleContainerCluster#state}

---

###### `key_name`<sup>Optional</sup> <a name="key_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDatabaseEncryption.parameter.keyName"></a>

- *Type:* str

The key to use to encrypt/decrypt secrets.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key_name GoogleContainerCluster#key_name}

---

##### `put_default_snat_status` <a name="put_default_snat_status" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDefaultSnatStatus"></a>

```python
def put_default_snat_status(
  disabled: typing.Union[bool, IResolvable]
) -> None
```

###### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDefaultSnatStatus.parameter.disabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}

---

##### `put_dns_config` <a name="put_dns_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDnsConfig"></a>

```python
def put_dns_config(
  cluster_dns: str = None,
  cluster_dns_domain: str = None,
  cluster_dns_scope: str = None
) -> None
```

###### `cluster_dns`<sup>Optional</sup> <a name="cluster_dns" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDnsConfig.parameter.clusterDns"></a>

- *Type:* str

Which in-cluster DNS provider should be used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_dns GoogleContainerCluster#cluster_dns}

---

###### `cluster_dns_domain`<sup>Optional</sup> <a name="cluster_dns_domain" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDnsConfig.parameter.clusterDnsDomain"></a>

- *Type:* str

The suffix used for all cluster service records.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_dns_domain GoogleContainerCluster#cluster_dns_domain}

---

###### `cluster_dns_scope`<sup>Optional</sup> <a name="cluster_dns_scope" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putDnsConfig.parameter.clusterDnsScope"></a>

- *Type:* str

The scope of access to cluster DNS records.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_dns_scope GoogleContainerCluster#cluster_dns_scope}

---

##### `put_gateway_api_config` <a name="put_gateway_api_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putGatewayApiConfig"></a>

```python
def put_gateway_api_config(
  channel: str
) -> None
```

###### `channel`<sup>Required</sup> <a name="channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putGatewayApiConfig.parameter.channel"></a>

- *Type:* str

The Gateway API release channel to use for Gateway API.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#channel GoogleContainerCluster#channel}

---

##### `put_identity_service_config` <a name="put_identity_service_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIdentityServiceConfig"></a>

```python
def put_identity_service_config(
  enabled: typing.Union[bool, IResolvable] = None
) -> None
```

###### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIdentityServiceConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable the Identity Service component.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `put_ip_allocation_policy` <a name="put_ip_allocation_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy"></a>

```python
def put_ip_allocation_policy(
  cluster_ipv4_cidr_block: str = None,
  cluster_secondary_range_name: str = None,
  pod_cidr_overprovision_config: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig = None,
  services_ipv4_cidr_block: str = None,
  services_secondary_range_name: str = None,
  stack_type: str = None
) -> None
```

###### `cluster_ipv4_cidr_block`<sup>Optional</sup> <a name="cluster_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy.parameter.clusterIpv4CidrBlock"></a>

- *Type:* str

The IP address range for the cluster pod IPs.

Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_ipv4_cidr_block GoogleContainerCluster#cluster_ipv4_cidr_block}

---

###### `cluster_secondary_range_name`<sup>Optional</sup> <a name="cluster_secondary_range_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy.parameter.clusterSecondaryRangeName"></a>

- *Type:* str

The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses.

Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_secondary_range_name GoogleContainerCluster#cluster_secondary_range_name}

---

###### `pod_cidr_overprovision_config`<sup>Optional</sup> <a name="pod_cidr_overprovision_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy.parameter.podCidrOverprovisionConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig">GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig</a>

pod_cidr_overprovision_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_cidr_overprovision_config GoogleContainerCluster#pod_cidr_overprovision_config}

---

###### `services_ipv4_cidr_block`<sup>Optional</sup> <a name="services_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy.parameter.servicesIpv4CidrBlock"></a>

- *Type:* str

The IP address range of the services IPs in this cluster.

Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#services_ipv4_cidr_block GoogleContainerCluster#services_ipv4_cidr_block}

---

###### `services_secondary_range_name`<sup>Optional</sup> <a name="services_secondary_range_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy.parameter.servicesSecondaryRangeName"></a>

- *Type:* str

The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs.

Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#services_secondary_range_name GoogleContainerCluster#services_secondary_range_name}

---

###### `stack_type`<sup>Optional</sup> <a name="stack_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putIpAllocationPolicy.parameter.stackType"></a>

- *Type:* str

The IP Stack type of the cluster.

Choose between IPV4 and IPV4_IPV6. Default type is IPV4 Only if not set

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#stack_type GoogleContainerCluster#stack_type}

---

##### `put_logging_config` <a name="put_logging_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putLoggingConfig"></a>

```python
def put_logging_config(
  enable_components: typing.List[str]
) -> None
```

###### `enable_components`<sup>Required</sup> <a name="enable_components" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putLoggingConfig.parameter.enableComponents"></a>

- *Type:* typing.List[str]

GKE components exposing logs. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_components GoogleContainerCluster#enable_components}

---

##### `put_maintenance_policy` <a name="put_maintenance_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMaintenancePolicy"></a>

```python
def put_maintenance_policy(
  daily_maintenance_window: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow = None,
  maintenance_exclusion: typing.Union[IResolvable, typing.List[GoogleContainerClusterMaintenancePolicyMaintenanceExclusion]] = None,
  recurring_window: GoogleContainerClusterMaintenancePolicyRecurringWindow = None
) -> None
```

###### `daily_maintenance_window`<sup>Optional</sup> <a name="daily_maintenance_window" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMaintenancePolicy.parameter.dailyMaintenanceWindow"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow">GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow</a>

daily_maintenance_window block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#daily_maintenance_window GoogleContainerCluster#daily_maintenance_window}

---

###### `maintenance_exclusion`<sup>Optional</sup> <a name="maintenance_exclusion" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMaintenancePolicy.parameter.maintenanceExclusion"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion">GoogleContainerClusterMaintenancePolicyMaintenanceExclusion</a>]]

maintenance_exclusion block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#maintenance_exclusion GoogleContainerCluster#maintenance_exclusion}

---

###### `recurring_window`<sup>Optional</sup> <a name="recurring_window" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMaintenancePolicy.parameter.recurringWindow"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow">GoogleContainerClusterMaintenancePolicyRecurringWindow</a>

recurring_window block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#recurring_window GoogleContainerCluster#recurring_window}

---

##### `put_master_auth` <a name="put_master_auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuth"></a>

```python
def put_master_auth(
  client_certificate_config: GoogleContainerClusterMasterAuthClientCertificateConfig
) -> None
```

###### `client_certificate_config`<sup>Required</sup> <a name="client_certificate_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuth.parameter.clientCertificateConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig">GoogleContainerClusterMasterAuthClientCertificateConfig</a>

client_certificate_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#client_certificate_config GoogleContainerCluster#client_certificate_config}

---

##### `put_master_authorized_networks_config` <a name="put_master_authorized_networks_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuthorizedNetworksConfig"></a>

```python
def put_master_authorized_networks_config(
  cidr_blocks: typing.Union[IResolvable, typing.List[GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks]] = None,
  gcp_public_cidrs_access_enabled: typing.Union[bool, IResolvable] = None
) -> None
```

###### `cidr_blocks`<sup>Optional</sup> <a name="cidr_blocks" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuthorizedNetworksConfig.parameter.cidrBlocks"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks">GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks</a>]]

cidr_blocks block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cidr_blocks GoogleContainerCluster#cidr_blocks}

---

###### `gcp_public_cidrs_access_enabled`<sup>Optional</sup> <a name="gcp_public_cidrs_access_enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMasterAuthorizedNetworksConfig.parameter.gcpPublicCidrsAccessEnabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether master is accessbile via Google Compute Engine Public IP addresses.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcp_public_cidrs_access_enabled GoogleContainerCluster#gcp_public_cidrs_access_enabled}

---

##### `put_mesh_certificates` <a name="put_mesh_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMeshCertificates"></a>

```python
def put_mesh_certificates(
  enable_certificates: typing.Union[bool, IResolvable]
) -> None
```

###### `enable_certificates`<sup>Required</sup> <a name="enable_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMeshCertificates.parameter.enableCertificates"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_certificates GoogleContainerCluster#enable_certificates}

---

##### `put_monitoring_config` <a name="put_monitoring_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMonitoringConfig"></a>

```python
def put_monitoring_config(
  enable_components: typing.List[str] = None,
  managed_prometheus: GoogleContainerClusterMonitoringConfigManagedPrometheus = None
) -> None
```

###### `enable_components`<sup>Optional</sup> <a name="enable_components" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMonitoringConfig.parameter.enableComponents"></a>

- *Type:* typing.List[str]

GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_components GoogleContainerCluster#enable_components}

---

###### `managed_prometheus`<sup>Optional</sup> <a name="managed_prometheus" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putMonitoringConfig.parameter.managedPrometheus"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus">GoogleContainerClusterMonitoringConfigManagedPrometheus</a>

managed_prometheus block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#managed_prometheus GoogleContainerCluster#managed_prometheus}

---

##### `put_network_policy` <a name="put_network_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNetworkPolicy"></a>

```python
def put_network_policy(
  enabled: typing.Union[bool, IResolvable],
  provider: str = None
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNetworkPolicy.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether network policy is enabled on the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

###### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNetworkPolicy.parameter.provider"></a>

- *Type:* str

The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#provider GoogleContainerCluster#provider}

---

##### `put_node_config` <a name="put_node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig"></a>

```python
def put_node_config(
  advanced_machine_features: GoogleContainerClusterNodeConfigAdvancedMachineFeatures = None,
  boot_disk_kms_key: str = None,
  disk_size_gb: typing.Union[int, float] = None,
  disk_type: str = None,
  ephemeral_storage_config: GoogleContainerClusterNodeConfigEphemeralStorageConfig = None,
  ephemeral_storage_local_ssd_config: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig = None,
  gcfs_config: GoogleContainerClusterNodeConfigGcfsConfig = None,
  guest_accelerator: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigGuestAccelerator]] = None,
  gvnic: GoogleContainerClusterNodeConfigGvnic = None,
  image_type: str = None,
  kubelet_config: GoogleContainerClusterNodeConfigKubeletConfig = None,
  labels: typing.Mapping[str] = None,
  linux_node_config: GoogleContainerClusterNodeConfigLinuxNodeConfig = None,
  local_nvme_ssd_block_config: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig = None,
  local_ssd_count: typing.Union[int, float] = None,
  logging_variant: str = None,
  machine_type: str = None,
  metadata: typing.Mapping[str] = None,
  min_cpu_platform: str = None,
  node_group: str = None,
  oauth_scopes: typing.List[str] = None,
  preemptible: typing.Union[bool, IResolvable] = None,
  reservation_affinity: GoogleContainerClusterNodeConfigReservationAffinity = None,
  resource_labels: typing.Mapping[str] = None,
  sandbox_config: GoogleContainerClusterNodeConfigSandboxConfig = None,
  service_account: str = None,
  shielded_instance_config: GoogleContainerClusterNodeConfigShieldedInstanceConfig = None,
  spot: typing.Union[bool, IResolvable] = None,
  tags: typing.List[str] = None,
  taint: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigTaint]] = None,
  workload_metadata_config: GoogleContainerClusterNodeConfigWorkloadMetadataConfig = None
) -> None
```

###### `advanced_machine_features`<sup>Optional</sup> <a name="advanced_machine_features" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.advancedMachineFeatures"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures">GoogleContainerClusterNodeConfigAdvancedMachineFeatures</a>

advanced_machine_features block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#advanced_machine_features GoogleContainerCluster#advanced_machine_features}

---

###### `boot_disk_kms_key`<sup>Optional</sup> <a name="boot_disk_kms_key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.bootDiskKmsKey"></a>

- *Type:* str

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}

---

###### `disk_size_gb`<sup>Optional</sup> <a name="disk_size_gb" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.diskSizeGb"></a>

- *Type:* typing.Union[int, float]

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}

---

###### `disk_type`<sup>Optional</sup> <a name="disk_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.diskType"></a>

- *Type:* str

Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}

---

###### `ephemeral_storage_config`<sup>Optional</sup> <a name="ephemeral_storage_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.ephemeralStorageConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig">GoogleContainerClusterNodeConfigEphemeralStorageConfig</a>

ephemeral_storage_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}

---

###### `ephemeral_storage_local_ssd_config`<sup>Optional</sup> <a name="ephemeral_storage_local_ssd_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.ephemeralStorageLocalSsdConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig">GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig</a>

ephemeral_storage_local_ssd_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ephemeral_storage_local_ssd_config GoogleContainerCluster#ephemeral_storage_local_ssd_config}

---

###### `gcfs_config`<sup>Optional</sup> <a name="gcfs_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.gcfsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig">GoogleContainerClusterNodeConfigGcfsConfig</a>

gcfs_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}

---

###### `guest_accelerator`<sup>Optional</sup> <a name="guest_accelerator" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.guestAccelerator"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator">GoogleContainerClusterNodeConfigGuestAccelerator</a>]]

List of the type and count of accelerator cards attached to the instance.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}

---

###### `gvnic`<sup>Optional</sup> <a name="gvnic" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.gvnic"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic">GoogleContainerClusterNodeConfigGvnic</a>

gvnic block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gvnic GoogleContainerCluster#gvnic}

---

###### `image_type`<sup>Optional</sup> <a name="image_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.imageType"></a>

- *Type:* str

The image type to use for this node.

Note that for a given image type, the latest version of it will be used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}

---

###### `kubelet_config`<sup>Optional</sup> <a name="kubelet_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.kubeletConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig">GoogleContainerClusterNodeConfigKubeletConfig</a>

kubelet_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}

---

###### `labels`<sup>Optional</sup> <a name="labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.labels"></a>

- *Type:* typing.Mapping[str]

The map of Kubernetes labels (key/value pairs) to be applied to each node.

These will added in addition to any default label(s) that Kubernetes may apply to the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#labels GoogleContainerCluster#labels}

---

###### `linux_node_config`<sup>Optional</sup> <a name="linux_node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.linuxNodeConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig">GoogleContainerClusterNodeConfigLinuxNodeConfig</a>

linux_node_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}

---

###### `local_nvme_ssd_block_config`<sup>Optional</sup> <a name="local_nvme_ssd_block_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.localNvmeSsdBlockConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig">GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig</a>

local_nvme_ssd_block_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_nvme_ssd_block_config GoogleContainerCluster#local_nvme_ssd_block_config}

---

###### `local_ssd_count`<sup>Optional</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.localSsdCount"></a>

- *Type:* typing.Union[int, float]

The number of local SSD disks to be attached to the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

###### `logging_variant`<sup>Optional</sup> <a name="logging_variant" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.loggingVariant"></a>

- *Type:* str

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}

---

###### `machine_type`<sup>Optional</sup> <a name="machine_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.machineType"></a>

- *Type:* str

The name of a Google Compute Engine machine type.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#machine_type GoogleContainerCluster#machine_type}

---

###### `metadata`<sup>Optional</sup> <a name="metadata" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.metadata"></a>

- *Type:* typing.Mapping[str]

The metadata key/value pairs assigned to instances in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#metadata GoogleContainerCluster#metadata}

---

###### `min_cpu_platform`<sup>Optional</sup> <a name="min_cpu_platform" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.minCpuPlatform"></a>

- *Type:* str

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}

---

###### `node_group`<sup>Optional</sup> <a name="node_group" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.nodeGroup"></a>

- *Type:* str

Setting this field will assign instances of this pool to run on the specified node group.

This is useful for running workloads on sole tenant nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_group GoogleContainerCluster#node_group}

---

###### `oauth_scopes`<sup>Optional</sup> <a name="oauth_scopes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.oauthScopes"></a>

- *Type:* typing.List[str]

The set of Google API scopes to be made available on all of the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}

---

###### `preemptible`<sup>Optional</sup> <a name="preemptible" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.preemptible"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes are created as preemptible VM instances.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#preemptible GoogleContainerCluster#preemptible}

---

###### `reservation_affinity`<sup>Optional</sup> <a name="reservation_affinity" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.reservationAffinity"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity">GoogleContainerClusterNodeConfigReservationAffinity</a>

reservation_affinity block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}

---

###### `resource_labels`<sup>Optional</sup> <a name="resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.resourceLabels"></a>

- *Type:* typing.Mapping[str]

The GCE resource labels (a map of key/value pairs) to be applied to the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}

---

###### `sandbox_config`<sup>Optional</sup> <a name="sandbox_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.sandboxConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig">GoogleContainerClusterNodeConfigSandboxConfig</a>

sandbox_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}

---

###### `service_account`<sup>Optional</sup> <a name="service_account" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.serviceAccount"></a>

- *Type:* str

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}

---

###### `shielded_instance_config`<sup>Optional</sup> <a name="shielded_instance_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.shieldedInstanceConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig">GoogleContainerClusterNodeConfigShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}

---

###### `spot`<sup>Optional</sup> <a name="spot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.spot"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes are created as spot VM instances.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#spot GoogleContainerCluster#spot}

---

###### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.tags"></a>

- *Type:* typing.List[str]

The list of instance tags applied to all nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}

---

###### `taint`<sup>Optional</sup> <a name="taint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.taint"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint">GoogleContainerClusterNodeConfigTaint</a>]]

List of Kubernetes taints to be applied to each node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#taint GoogleContainerCluster#taint}

---

###### `workload_metadata_config`<sup>Optional</sup> <a name="workload_metadata_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodeConfig.parameter.workloadMetadataConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig">GoogleContainerClusterNodeConfigWorkloadMetadataConfig</a>

workload_metadata_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}

---

##### `put_node_pool` <a name="put_node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePool"></a>

```python
def put_node_pool(
  value: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePool]]
) -> None
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePool.parameter.value"></a>

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]

---

##### `put_node_pool_auto_config` <a name="put_node_pool_auto_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePoolAutoConfig"></a>

```python
def put_node_pool_auto_config(
  network_tags: GoogleContainerClusterNodePoolAutoConfigNetworkTags = None
) -> None
```

###### `network_tags`<sup>Optional</sup> <a name="network_tags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePoolAutoConfig.parameter.networkTags"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags">GoogleContainerClusterNodePoolAutoConfigNetworkTags</a>

network_tags block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_tags GoogleContainerCluster#network_tags}

---

##### `put_node_pool_defaults` <a name="put_node_pool_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePoolDefaults"></a>

```python
def put_node_pool_defaults(
  node_config_defaults: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults = None
) -> None
```

###### `node_config_defaults`<sup>Optional</sup> <a name="node_config_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNodePoolDefaults.parameter.nodeConfigDefaults"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults">GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults</a>

node_config_defaults block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_config_defaults GoogleContainerCluster#node_config_defaults}

---

##### `put_notification_config` <a name="put_notification_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNotificationConfig"></a>

```python
def put_notification_config(
  pubsub: GoogleContainerClusterNotificationConfigPubsub
) -> None
```

###### `pubsub`<sup>Required</sup> <a name="pubsub" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putNotificationConfig.parameter.pubsub"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub">GoogleContainerClusterNotificationConfigPubsub</a>

pubsub block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pubsub GoogleContainerCluster#pubsub}

---

##### `put_pod_security_policy_config` <a name="put_pod_security_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPodSecurityPolicyConfig"></a>

```python
def put_pod_security_policy_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPodSecurityPolicyConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `put_private_cluster_config` <a name="put_private_cluster_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig"></a>

```python
def put_private_cluster_config(
  enable_private_endpoint: typing.Union[bool, IResolvable] = None,
  enable_private_nodes: typing.Union[bool, IResolvable] = None,
  master_global_access_config: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig = None,
  master_ipv4_cidr_block: str = None,
  private_endpoint_subnetwork: str = None
) -> None
```

###### `enable_private_endpoint`<sup>Optional</sup> <a name="enable_private_endpoint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig.parameter.enablePrivateEndpoint"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled.

When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_private_endpoint GoogleContainerCluster#enable_private_endpoint}

---

###### `enable_private_nodes`<sup>Optional</sup> <a name="enable_private_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig.parameter.enablePrivateNodes"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enables the private cluster feature, creating a private endpoint on the cluster.

In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_private_nodes GoogleContainerCluster#enable_private_nodes}

---

###### `master_global_access_config`<sup>Optional</sup> <a name="master_global_access_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig.parameter.masterGlobalAccessConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig">GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig</a>

master_global_access_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_global_access_config GoogleContainerCluster#master_global_access_config}

---

###### `master_ipv4_cidr_block`<sup>Optional</sup> <a name="master_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig.parameter.masterIpv4CidrBlock"></a>

- *Type:* str

The IP range in CIDR notation to use for the hosted master network.

This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_ipv4_cidr_block GoogleContainerCluster#master_ipv4_cidr_block}

---

###### `private_endpoint_subnetwork`<sup>Optional</sup> <a name="private_endpoint_subnetwork" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putPrivateClusterConfig.parameter.privateEndpointSubnetwork"></a>

- *Type:* str

Subnetwork in cluster's network where master's endpoint will be provisioned.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#private_endpoint_subnetwork GoogleContainerCluster#private_endpoint_subnetwork}

---

##### `put_protect_config` <a name="put_protect_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putProtectConfig"></a>

```python
def put_protect_config(
  workload_config: GoogleContainerClusterProtectConfigWorkloadConfig = None,
  workload_vulnerability_mode: str = None
) -> None
```

###### `workload_config`<sup>Optional</sup> <a name="workload_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putProtectConfig.parameter.workloadConfig"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig">GoogleContainerClusterProtectConfigWorkloadConfig</a>

workload_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_config GoogleContainerCluster#workload_config}

---

###### `workload_vulnerability_mode`<sup>Optional</sup> <a name="workload_vulnerability_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putProtectConfig.parameter.workloadVulnerabilityMode"></a>

- *Type:* str

Sets which mode to use for Protect workload vulnerability scanning feature. Accepted values are DISABLED, BASIC.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_vulnerability_mode GoogleContainerCluster#workload_vulnerability_mode}

---

##### `put_release_channel` <a name="put_release_channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putReleaseChannel"></a>

```python
def put_release_channel(
  channel: str
) -> None
```

###### `channel`<sup>Required</sup> <a name="channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putReleaseChannel.parameter.channel"></a>

- *Type:* str

The selected release channel.

Accepted values are:
UNSPECIFIED: Not set.
RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#channel GoogleContainerCluster#channel}

---

##### `put_resource_usage_export_config` <a name="put_resource_usage_export_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putResourceUsageExportConfig"></a>

```python
def put_resource_usage_export_config(
  bigquery_destination: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination,
  enable_network_egress_metering: typing.Union[bool, IResolvable] = None,
  enable_resource_consumption_metering: typing.Union[bool, IResolvable] = None
) -> None
```

###### `bigquery_destination`<sup>Required</sup> <a name="bigquery_destination" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putResourceUsageExportConfig.parameter.bigqueryDestination"></a>

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination">GoogleContainerClusterResourceUsageExportConfigBigqueryDestination</a>

bigquery_destination block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#bigquery_destination GoogleContainerCluster#bigquery_destination}

---

###### `enable_network_egress_metering`<sup>Optional</sup> <a name="enable_network_egress_metering" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putResourceUsageExportConfig.parameter.enableNetworkEgressMetering"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable network egress metering for this cluster.

If enabled, a daemonset will be created in the cluster to meter network egress traffic.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_network_egress_metering GoogleContainerCluster#enable_network_egress_metering}

---

###### `enable_resource_consumption_metering`<sup>Optional</sup> <a name="enable_resource_consumption_metering" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putResourceUsageExportConfig.parameter.enableResourceConsumptionMetering"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable resource consumption metering on this cluster.

When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_resource_consumption_metering GoogleContainerCluster#enable_resource_consumption_metering}

---

##### `put_service_external_ips_config` <a name="put_service_external_ips_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putServiceExternalIpsConfig"></a>

```python
def put_service_external_ips_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putServiceExternalIpsConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

When enabled, services with exterenal ips specified will be allowed.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `put_timeouts` <a name="put_timeouts" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTimeouts"></a>

```python
def put_timeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
) -> None
```

###### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTimeouts.parameter.create"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#create GoogleContainerCluster#create}.

---

###### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTimeouts.parameter.delete"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#delete GoogleContainerCluster#delete}.

---

###### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTimeouts.parameter.read"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#read GoogleContainerCluster#read}.

---

###### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTimeouts.parameter.update"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#update GoogleContainerCluster#update}.

---

##### `put_tpu_config` <a name="put_tpu_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTpuConfig"></a>

```python
def put_tpu_config(
  enabled: typing.Union[bool, IResolvable],
  use_service_networking: typing.Union[bool, IResolvable] = None
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTpuConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether Cloud TPU integration is enabled or not.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

###### `use_service_networking`<sup>Optional</sup> <a name="use_service_networking" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putTpuConfig.parameter.useServiceNetworking"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to use service networking for Cloud TPU or not.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#use_service_networking GoogleContainerCluster#use_service_networking}

---

##### `put_vertical_pod_autoscaling` <a name="put_vertical_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putVerticalPodAutoscaling"></a>

```python
def put_vertical_pod_autoscaling(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putVerticalPodAutoscaling.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enables vertical pod autoscaling.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `put_workload_identity_config` <a name="put_workload_identity_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putWorkloadIdentityConfig"></a>

```python
def put_workload_identity_config(
  workload_pool: str = None
) -> None
```

###### `workload_pool`<sup>Optional</sup> <a name="workload_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.putWorkloadIdentityConfig.parameter.workloadPool"></a>

- *Type:* str

The workload pool to attach all Kubernetes service accounts to.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_pool GoogleContainerCluster#workload_pool}

---

##### `reset_addons_config` <a name="reset_addons_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetAddonsConfig"></a>

```python
def reset_addons_config() -> None
```

##### `reset_authenticator_groups_config` <a name="reset_authenticator_groups_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetAuthenticatorGroupsConfig"></a>

```python
def reset_authenticator_groups_config() -> None
```

##### `reset_binary_authorization` <a name="reset_binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetBinaryAuthorization"></a>

```python
def reset_binary_authorization() -> None
```

##### `reset_cluster_autoscaling` <a name="reset_cluster_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetClusterAutoscaling"></a>

```python
def reset_cluster_autoscaling() -> None
```

##### `reset_cluster_ipv4_cidr` <a name="reset_cluster_ipv4_cidr" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetClusterIpv4Cidr"></a>

```python
def reset_cluster_ipv4_cidr() -> None
```

##### `reset_cluster_telemetry` <a name="reset_cluster_telemetry" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetClusterTelemetry"></a>

```python
def reset_cluster_telemetry() -> None
```

##### `reset_confidential_nodes` <a name="reset_confidential_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetConfidentialNodes"></a>

```python
def reset_confidential_nodes() -> None
```

##### `reset_cost_management_config` <a name="reset_cost_management_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetCostManagementConfig"></a>

```python
def reset_cost_management_config() -> None
```

##### `reset_database_encryption` <a name="reset_database_encryption" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDatabaseEncryption"></a>

```python
def reset_database_encryption() -> None
```

##### `reset_datapath_provider` <a name="reset_datapath_provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDatapathProvider"></a>

```python
def reset_datapath_provider() -> None
```

##### `reset_default_max_pods_per_node` <a name="reset_default_max_pods_per_node" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDefaultMaxPodsPerNode"></a>

```python
def reset_default_max_pods_per_node() -> None
```

##### `reset_default_snat_status` <a name="reset_default_snat_status" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDefaultSnatStatus"></a>

```python
def reset_default_snat_status() -> None
```

##### `reset_description` <a name="reset_description" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDescription"></a>

```python
def reset_description() -> None
```

##### `reset_dns_config` <a name="reset_dns_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetDnsConfig"></a>

```python
def reset_dns_config() -> None
```

##### `reset_enable_autopilot` <a name="reset_enable_autopilot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableAutopilot"></a>

```python
def reset_enable_autopilot() -> None
```

##### `reset_enable_binary_authorization` <a name="reset_enable_binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableBinaryAuthorization"></a>

```python
def reset_enable_binary_authorization() -> None
```

##### `reset_enable_intranode_visibility` <a name="reset_enable_intranode_visibility" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableIntranodeVisibility"></a>

```python
def reset_enable_intranode_visibility() -> None
```

##### `reset_enable_kubernetes_alpha` <a name="reset_enable_kubernetes_alpha" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableKubernetesAlpha"></a>

```python
def reset_enable_kubernetes_alpha() -> None
```

##### `reset_enable_l4_ilb_subsetting` <a name="reset_enable_l4_ilb_subsetting" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableL4IlbSubsetting"></a>

```python
def reset_enable_l4_ilb_subsetting() -> None
```

##### `reset_enable_legacy_abac` <a name="reset_enable_legacy_abac" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableLegacyAbac"></a>

```python
def reset_enable_legacy_abac() -> None
```

##### `reset_enable_shielded_nodes` <a name="reset_enable_shielded_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableShieldedNodes"></a>

```python
def reset_enable_shielded_nodes() -> None
```

##### `reset_enable_tpu` <a name="reset_enable_tpu" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetEnableTpu"></a>

```python
def reset_enable_tpu() -> None
```

##### `reset_gateway_api_config` <a name="reset_gateway_api_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetGatewayApiConfig"></a>

```python
def reset_gateway_api_config() -> None
```

##### `reset_id` <a name="reset_id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetId"></a>

```python
def reset_id() -> None
```

##### `reset_identity_service_config` <a name="reset_identity_service_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetIdentityServiceConfig"></a>

```python
def reset_identity_service_config() -> None
```

##### `reset_initial_node_count` <a name="reset_initial_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetInitialNodeCount"></a>

```python
def reset_initial_node_count() -> None
```

##### `reset_ip_allocation_policy` <a name="reset_ip_allocation_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetIpAllocationPolicy"></a>

```python
def reset_ip_allocation_policy() -> None
```

##### `reset_location` <a name="reset_location" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetLocation"></a>

```python
def reset_location() -> None
```

##### `reset_logging_config` <a name="reset_logging_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetLoggingConfig"></a>

```python
def reset_logging_config() -> None
```

##### `reset_logging_service` <a name="reset_logging_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetLoggingService"></a>

```python
def reset_logging_service() -> None
```

##### `reset_maintenance_policy` <a name="reset_maintenance_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMaintenancePolicy"></a>

```python
def reset_maintenance_policy() -> None
```

##### `reset_master_auth` <a name="reset_master_auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMasterAuth"></a>

```python
def reset_master_auth() -> None
```

##### `reset_master_authorized_networks_config` <a name="reset_master_authorized_networks_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMasterAuthorizedNetworksConfig"></a>

```python
def reset_master_authorized_networks_config() -> None
```

##### `reset_mesh_certificates` <a name="reset_mesh_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMeshCertificates"></a>

```python
def reset_mesh_certificates() -> None
```

##### `reset_min_master_version` <a name="reset_min_master_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMinMasterVersion"></a>

```python
def reset_min_master_version() -> None
```

##### `reset_monitoring_config` <a name="reset_monitoring_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMonitoringConfig"></a>

```python
def reset_monitoring_config() -> None
```

##### `reset_monitoring_service` <a name="reset_monitoring_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetMonitoringService"></a>

```python
def reset_monitoring_service() -> None
```

##### `reset_network` <a name="reset_network" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNetwork"></a>

```python
def reset_network() -> None
```

##### `reset_networking_mode` <a name="reset_networking_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNetworkingMode"></a>

```python
def reset_networking_mode() -> None
```

##### `reset_network_policy` <a name="reset_network_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNetworkPolicy"></a>

```python
def reset_network_policy() -> None
```

##### `reset_node_config` <a name="reset_node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodeConfig"></a>

```python
def reset_node_config() -> None
```

##### `reset_node_locations` <a name="reset_node_locations" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodeLocations"></a>

```python
def reset_node_locations() -> None
```

##### `reset_node_pool` <a name="reset_node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodePool"></a>

```python
def reset_node_pool() -> None
```

##### `reset_node_pool_auto_config` <a name="reset_node_pool_auto_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodePoolAutoConfig"></a>

```python
def reset_node_pool_auto_config() -> None
```

##### `reset_node_pool_defaults` <a name="reset_node_pool_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodePoolDefaults"></a>

```python
def reset_node_pool_defaults() -> None
```

##### `reset_node_version` <a name="reset_node_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNodeVersion"></a>

```python
def reset_node_version() -> None
```

##### `reset_notification_config` <a name="reset_notification_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetNotificationConfig"></a>

```python
def reset_notification_config() -> None
```

##### `reset_pod_security_policy_config` <a name="reset_pod_security_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetPodSecurityPolicyConfig"></a>

```python
def reset_pod_security_policy_config() -> None
```

##### `reset_private_cluster_config` <a name="reset_private_cluster_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetPrivateClusterConfig"></a>

```python
def reset_private_cluster_config() -> None
```

##### `reset_private_ipv6_google_access` <a name="reset_private_ipv6_google_access" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetPrivateIpv6GoogleAccess"></a>

```python
def reset_private_ipv6_google_access() -> None
```

##### `reset_project` <a name="reset_project" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetProject"></a>

```python
def reset_project() -> None
```

##### `reset_protect_config` <a name="reset_protect_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetProtectConfig"></a>

```python
def reset_protect_config() -> None
```

##### `reset_release_channel` <a name="reset_release_channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetReleaseChannel"></a>

```python
def reset_release_channel() -> None
```

##### `reset_remove_default_node_pool` <a name="reset_remove_default_node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetRemoveDefaultNodePool"></a>

```python
def reset_remove_default_node_pool() -> None
```

##### `reset_resource_labels` <a name="reset_resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetResourceLabels"></a>

```python
def reset_resource_labels() -> None
```

##### `reset_resource_usage_export_config` <a name="reset_resource_usage_export_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetResourceUsageExportConfig"></a>

```python
def reset_resource_usage_export_config() -> None
```

##### `reset_service_external_ips_config` <a name="reset_service_external_ips_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetServiceExternalIpsConfig"></a>

```python
def reset_service_external_ips_config() -> None
```

##### `reset_subnetwork` <a name="reset_subnetwork" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetSubnetwork"></a>

```python
def reset_subnetwork() -> None
```

##### `reset_timeouts` <a name="reset_timeouts" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetTimeouts"></a>

```python
def reset_timeouts() -> None
```

##### `reset_tpu_config` <a name="reset_tpu_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetTpuConfig"></a>

```python
def reset_tpu_config() -> None
```

##### `reset_vertical_pod_autoscaling` <a name="reset_vertical_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetVerticalPodAutoscaling"></a>

```python
def reset_vertical_pod_autoscaling() -> None
```

##### `reset_workload_identity_config` <a name="reset_workload_identity_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.resetWorkloadIdentityConfig"></a>

```python
def reset_workload_identity_config() -> None
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isTerraformElement">is_terraform_element</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isTerraformResource">is_terraform_resource</a></code> | *No description.* |

---

##### `is_construct` <a name="is_construct" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isConstruct"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerCluster.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_terraform_element` <a name="is_terraform_element" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isTerraformElement"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerCluster.is_terraform_element(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isTerraformElement.parameter.x"></a>

- *Type:* typing.Any

---

##### `is_terraform_resource` <a name="is_terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isTerraformResource"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerCluster.is_terraform_resource(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.isTerraformResource.parameter.x"></a>

- *Type:* typing.Any

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.cdktfStack">cdktf_stack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.friendlyUniqueId">friendly_unique_id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.terraformMetaArguments">terraform_meta_arguments</a></code> | <code>typing.Mapping[typing.Any]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.terraformResourceType">terraform_resource_type</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.terraformGeneratorMetadata">terraform_generator_metadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.dependsOn">depends_on</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.addonsConfig">addons_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference">GoogleContainerClusterAddonsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.authenticatorGroupsConfig">authenticator_groups_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference">GoogleContainerClusterAuthenticatorGroupsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.binaryAuthorization">binary_authorization</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference">GoogleContainerClusterBinaryAuthorizationOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterAutoscaling">cluster_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingOutputReference">GoogleContainerClusterClusterAutoscalingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterTelemetry">cluster_telemetry</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetryOutputReference">GoogleContainerClusterClusterTelemetryOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.confidentialNodes">confidential_nodes</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodesOutputReference">GoogleContainerClusterConfidentialNodesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.costManagementConfig">cost_management_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfigOutputReference">GoogleContainerClusterCostManagementConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.databaseEncryption">database_encryption</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryptionOutputReference">GoogleContainerClusterDatabaseEncryptionOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultSnatStatus">default_snat_status</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatusOutputReference">GoogleContainerClusterDefaultSnatStatusOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.dnsConfig">dns_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfigOutputReference">GoogleContainerClusterDnsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.endpoint">endpoint</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.gatewayApiConfig">gateway_api_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfigOutputReference">GoogleContainerClusterGatewayApiConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.identityServiceConfig">identity_service_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfigOutputReference">GoogleContainerClusterIdentityServiceConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.ipAllocationPolicy">ip_allocation_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyOutputReference">GoogleContainerClusterIpAllocationPolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.labelFingerprint">label_fingerprint</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingConfig">logging_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfigOutputReference">GoogleContainerClusterLoggingConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.maintenancePolicy">maintenance_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyOutputReference">GoogleContainerClusterMaintenancePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuth">master_auth</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthOutputReference">GoogleContainerClusterMasterAuthOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuthorizedNetworksConfig">master_authorized_networks_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference">GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterVersion">master_version</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.meshCertificates">mesh_certificates</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificatesOutputReference">GoogleContainerClusterMeshCertificatesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringConfig">monitoring_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigOutputReference">GoogleContainerClusterMonitoringConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkPolicy">network_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicyOutputReference">GoogleContainerClusterNetworkPolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeConfig">node_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigOutputReference">GoogleContainerClusterNodeConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePool">node_pool</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolList">GoogleContainerClusterNodePoolList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolAutoConfig">node_pool_auto_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigOutputReference">GoogleContainerClusterNodePoolAutoConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolDefaults">node_pool_defaults</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsOutputReference">GoogleContainerClusterNodePoolDefaultsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.notificationConfig">notification_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigOutputReference">GoogleContainerClusterNotificationConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.operation">operation</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.podSecurityPolicyConfig">pod_security_policy_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfigOutputReference">GoogleContainerClusterPodSecurityPolicyConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateClusterConfig">private_cluster_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigOutputReference">GoogleContainerClusterPrivateClusterConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.protectConfig">protect_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigOutputReference">GoogleContainerClusterProtectConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.releaseChannel">release_channel</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannelOutputReference">GoogleContainerClusterReleaseChannelOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceUsageExportConfig">resource_usage_export_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigOutputReference">GoogleContainerClusterResourceUsageExportConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.selfLink">self_link</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.serviceExternalIpsConfig">service_external_ips_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfigOutputReference">GoogleContainerClusterServiceExternalIpsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.servicesIpv4Cidr">services_ipv4_cidr</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeoutsOutputReference">GoogleContainerClusterTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tpuConfig">tpu_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfigOutputReference">GoogleContainerClusterTpuConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tpuIpv4CidrBlock">tpu_ipv4_cidr_block</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.verticalPodAutoscaling">vertical_pod_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscalingOutputReference">GoogleContainerClusterVerticalPodAutoscalingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.workloadIdentityConfig">workload_identity_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfigOutputReference">GoogleContainerClusterWorkloadIdentityConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.addonsConfigInput">addons_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.authenticatorGroupsConfigInput">authenticator_groups_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.binaryAuthorizationInput">binary_authorization_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterAutoscalingInput">cluster_autoscaling_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling">GoogleContainerClusterClusterAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterIpv4CidrInput">cluster_ipv4_cidr_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterTelemetryInput">cluster_telemetry_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry">GoogleContainerClusterClusterTelemetry</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.confidentialNodesInput">confidential_nodes_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes">GoogleContainerClusterConfidentialNodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.costManagementConfigInput">cost_management_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig">GoogleContainerClusterCostManagementConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.databaseEncryptionInput">database_encryption_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption">GoogleContainerClusterDatabaseEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.datapathProviderInput">datapath_provider_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultMaxPodsPerNodeInput">default_max_pods_per_node_input</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultSnatStatusInput">default_snat_status_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus">GoogleContainerClusterDefaultSnatStatus</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.descriptionInput">description_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.dnsConfigInput">dns_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig">GoogleContainerClusterDnsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableAutopilotInput">enable_autopilot_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableBinaryAuthorizationInput">enable_binary_authorization_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableIntranodeVisibilityInput">enable_intranode_visibility_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableKubernetesAlphaInput">enable_kubernetes_alpha_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableL4IlbSubsettingInput">enable_l4_ilb_subsetting_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableLegacyAbacInput">enable_legacy_abac_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableShieldedNodesInput">enable_shielded_nodes_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableTpuInput">enable_tpu_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.gatewayApiConfigInput">gateway_api_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig">GoogleContainerClusterGatewayApiConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.identityServiceConfigInput">identity_service_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig">GoogleContainerClusterIdentityServiceConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.idInput">id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.initialNodeCountInput">initial_node_count_input</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.ipAllocationPolicyInput">ip_allocation_policy_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy">GoogleContainerClusterIpAllocationPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.locationInput">location_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingConfigInput">logging_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig">GoogleContainerClusterLoggingConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingServiceInput">logging_service_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.maintenancePolicyInput">maintenance_policy_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy">GoogleContainerClusterMaintenancePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuthInput">master_auth_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth">GoogleContainerClusterMasterAuth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuthorizedNetworksConfigInput">master_authorized_networks_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig">GoogleContainerClusterMasterAuthorizedNetworksConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.meshCertificatesInput">mesh_certificates_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates">GoogleContainerClusterMeshCertificates</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.minMasterVersionInput">min_master_version_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringConfigInput">monitoring_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig">GoogleContainerClusterMonitoringConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringServiceInput">monitoring_service_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nameInput">name_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkingModeInput">networking_mode_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkInput">network_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkPolicyInput">network_policy_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy">GoogleContainerClusterNetworkPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeConfigInput">node_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig">GoogleContainerClusterNodeConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeLocationsInput">node_locations_input</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolAutoConfigInput">node_pool_auto_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig">GoogleContainerClusterNodePoolAutoConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolDefaultsInput">node_pool_defaults_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults">GoogleContainerClusterNodePoolDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolInput">node_pool_input</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeVersionInput">node_version_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.notificationConfigInput">notification_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig">GoogleContainerClusterNotificationConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.podSecurityPolicyConfigInput">pod_security_policy_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig">GoogleContainerClusterPodSecurityPolicyConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateClusterConfigInput">private_cluster_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig">GoogleContainerClusterPrivateClusterConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateIpv6GoogleAccessInput">private_ipv6_google_access_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.projectInput">project_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.protectConfigInput">protect_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig">GoogleContainerClusterProtectConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.releaseChannelInput">release_channel_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel">GoogleContainerClusterReleaseChannel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.removeDefaultNodePoolInput">remove_default_node_pool_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceLabelsInput">resource_labels_input</a></code> | <code>typing.Mapping[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceUsageExportConfigInput">resource_usage_export_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig">GoogleContainerClusterResourceUsageExportConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.serviceExternalIpsConfigInput">service_external_ips_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig">GoogleContainerClusterServiceExternalIpsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.subnetworkInput">subnetwork_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.timeoutsInput">timeouts_input</a></code> | <code>typing.Union[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts">GoogleContainerClusterTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tpuConfigInput">tpu_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig">GoogleContainerClusterTpuConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.verticalPodAutoscalingInput">vertical_pod_autoscaling_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling">GoogleContainerClusterVerticalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.workloadIdentityConfigInput">workload_identity_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig">GoogleContainerClusterWorkloadIdentityConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterIpv4Cidr">cluster_ipv4_cidr</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.datapathProvider">datapath_provider</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultMaxPodsPerNode">default_max_pods_per_node</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.description">description</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableAutopilot">enable_autopilot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableBinaryAuthorization">enable_binary_authorization</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableIntranodeVisibility">enable_intranode_visibility</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableKubernetesAlpha">enable_kubernetes_alpha</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableL4IlbSubsetting">enable_l4_ilb_subsetting</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableLegacyAbac">enable_legacy_abac</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableShieldedNodes">enable_shielded_nodes</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableTpu">enable_tpu</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.initialNodeCount">initial_node_count</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.location">location</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingService">logging_service</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.minMasterVersion">min_master_version</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringService">monitoring_service</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.name">name</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.network">network</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkingMode">networking_mode</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeLocations">node_locations</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeVersion">node_version</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateIpv6GoogleAccess">private_ipv6_google_access</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.project">project</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.removeDefaultNodePool">remove_default_node_pool</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceLabels">resource_labels</a></code> | <code>typing.Mapping[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.subnetwork">subnetwork</a></code> | <code>str</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktf_stack`<sup>Required</sup> <a name="cdktf_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.cdktfStack"></a>

```python
cdktf_stack: TerraformStack
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `friendly_unique_id`<sup>Required</sup> <a name="friendly_unique_id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.friendlyUniqueId"></a>

```python
friendly_unique_id: str
```

- *Type:* str

---

##### `terraform_meta_arguments`<sup>Required</sup> <a name="terraform_meta_arguments" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.terraformMetaArguments"></a>

```python
terraform_meta_arguments: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

---

##### `terraform_resource_type`<sup>Required</sup> <a name="terraform_resource_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.terraformResourceType"></a>

```python
terraform_resource_type: str
```

- *Type:* str

---

##### `terraform_generator_metadata`<sup>Optional</sup> <a name="terraform_generator_metadata" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.terraformGeneratorMetadata"></a>

```python
terraform_generator_metadata: TerraformProviderGeneratorMetadata
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.count"></a>

```python
count: typing.Union[typing.Union[int, float], TerraformCount]
```

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.dependsOn"></a>

```python
depends_on: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `addons_config`<sup>Required</sup> <a name="addons_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.addonsConfig"></a>

```python
addons_config: GoogleContainerClusterAddonsConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference">GoogleContainerClusterAddonsConfigOutputReference</a>

---

##### `authenticator_groups_config`<sup>Required</sup> <a name="authenticator_groups_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.authenticatorGroupsConfig"></a>

```python
authenticator_groups_config: GoogleContainerClusterAuthenticatorGroupsConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference">GoogleContainerClusterAuthenticatorGroupsConfigOutputReference</a>

---

##### `binary_authorization`<sup>Required</sup> <a name="binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.binaryAuthorization"></a>

```python
binary_authorization: GoogleContainerClusterBinaryAuthorizationOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference">GoogleContainerClusterBinaryAuthorizationOutputReference</a>

---

##### `cluster_autoscaling`<sup>Required</sup> <a name="cluster_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterAutoscaling"></a>

```python
cluster_autoscaling: GoogleContainerClusterClusterAutoscalingOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingOutputReference">GoogleContainerClusterClusterAutoscalingOutputReference</a>

---

##### `cluster_telemetry`<sup>Required</sup> <a name="cluster_telemetry" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterTelemetry"></a>

```python
cluster_telemetry: GoogleContainerClusterClusterTelemetryOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetryOutputReference">GoogleContainerClusterClusterTelemetryOutputReference</a>

---

##### `confidential_nodes`<sup>Required</sup> <a name="confidential_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.confidentialNodes"></a>

```python
confidential_nodes: GoogleContainerClusterConfidentialNodesOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodesOutputReference">GoogleContainerClusterConfidentialNodesOutputReference</a>

---

##### `cost_management_config`<sup>Required</sup> <a name="cost_management_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.costManagementConfig"></a>

```python
cost_management_config: GoogleContainerClusterCostManagementConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfigOutputReference">GoogleContainerClusterCostManagementConfigOutputReference</a>

---

##### `database_encryption`<sup>Required</sup> <a name="database_encryption" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.databaseEncryption"></a>

```python
database_encryption: GoogleContainerClusterDatabaseEncryptionOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryptionOutputReference">GoogleContainerClusterDatabaseEncryptionOutputReference</a>

---

##### `default_snat_status`<sup>Required</sup> <a name="default_snat_status" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultSnatStatus"></a>

```python
default_snat_status: GoogleContainerClusterDefaultSnatStatusOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatusOutputReference">GoogleContainerClusterDefaultSnatStatusOutputReference</a>

---

##### `dns_config`<sup>Required</sup> <a name="dns_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.dnsConfig"></a>

```python
dns_config: GoogleContainerClusterDnsConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfigOutputReference">GoogleContainerClusterDnsConfigOutputReference</a>

---

##### `endpoint`<sup>Required</sup> <a name="endpoint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.endpoint"></a>

```python
endpoint: str
```

- *Type:* str

---

##### `gateway_api_config`<sup>Required</sup> <a name="gateway_api_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.gatewayApiConfig"></a>

```python
gateway_api_config: GoogleContainerClusterGatewayApiConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfigOutputReference">GoogleContainerClusterGatewayApiConfigOutputReference</a>

---

##### `identity_service_config`<sup>Required</sup> <a name="identity_service_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.identityServiceConfig"></a>

```python
identity_service_config: GoogleContainerClusterIdentityServiceConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfigOutputReference">GoogleContainerClusterIdentityServiceConfigOutputReference</a>

---

##### `ip_allocation_policy`<sup>Required</sup> <a name="ip_allocation_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.ipAllocationPolicy"></a>

```python
ip_allocation_policy: GoogleContainerClusterIpAllocationPolicyOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyOutputReference">GoogleContainerClusterIpAllocationPolicyOutputReference</a>

---

##### `label_fingerprint`<sup>Required</sup> <a name="label_fingerprint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.labelFingerprint"></a>

```python
label_fingerprint: str
```

- *Type:* str

---

##### `logging_config`<sup>Required</sup> <a name="logging_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingConfig"></a>

```python
logging_config: GoogleContainerClusterLoggingConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfigOutputReference">GoogleContainerClusterLoggingConfigOutputReference</a>

---

##### `maintenance_policy`<sup>Required</sup> <a name="maintenance_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.maintenancePolicy"></a>

```python
maintenance_policy: GoogleContainerClusterMaintenancePolicyOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyOutputReference">GoogleContainerClusterMaintenancePolicyOutputReference</a>

---

##### `master_auth`<sup>Required</sup> <a name="master_auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuth"></a>

```python
master_auth: GoogleContainerClusterMasterAuthOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthOutputReference">GoogleContainerClusterMasterAuthOutputReference</a>

---

##### `master_authorized_networks_config`<sup>Required</sup> <a name="master_authorized_networks_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuthorizedNetworksConfig"></a>

```python
master_authorized_networks_config: GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference">GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference</a>

---

##### `master_version`<sup>Required</sup> <a name="master_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterVersion"></a>

```python
master_version: str
```

- *Type:* str

---

##### `mesh_certificates`<sup>Required</sup> <a name="mesh_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.meshCertificates"></a>

```python
mesh_certificates: GoogleContainerClusterMeshCertificatesOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificatesOutputReference">GoogleContainerClusterMeshCertificatesOutputReference</a>

---

##### `monitoring_config`<sup>Required</sup> <a name="monitoring_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringConfig"></a>

```python
monitoring_config: GoogleContainerClusterMonitoringConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigOutputReference">GoogleContainerClusterMonitoringConfigOutputReference</a>

---

##### `network_policy`<sup>Required</sup> <a name="network_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkPolicy"></a>

```python
network_policy: GoogleContainerClusterNetworkPolicyOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicyOutputReference">GoogleContainerClusterNetworkPolicyOutputReference</a>

---

##### `node_config`<sup>Required</sup> <a name="node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeConfig"></a>

```python
node_config: GoogleContainerClusterNodeConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigOutputReference">GoogleContainerClusterNodeConfigOutputReference</a>

---

##### `node_pool`<sup>Required</sup> <a name="node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePool"></a>

```python
node_pool: GoogleContainerClusterNodePoolList
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolList">GoogleContainerClusterNodePoolList</a>

---

##### `node_pool_auto_config`<sup>Required</sup> <a name="node_pool_auto_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolAutoConfig"></a>

```python
node_pool_auto_config: GoogleContainerClusterNodePoolAutoConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigOutputReference">GoogleContainerClusterNodePoolAutoConfigOutputReference</a>

---

##### `node_pool_defaults`<sup>Required</sup> <a name="node_pool_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolDefaults"></a>

```python
node_pool_defaults: GoogleContainerClusterNodePoolDefaultsOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsOutputReference">GoogleContainerClusterNodePoolDefaultsOutputReference</a>

---

##### `notification_config`<sup>Required</sup> <a name="notification_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.notificationConfig"></a>

```python
notification_config: GoogleContainerClusterNotificationConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigOutputReference">GoogleContainerClusterNotificationConfigOutputReference</a>

---

##### `operation`<sup>Required</sup> <a name="operation" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.operation"></a>

```python
operation: str
```

- *Type:* str

---

##### `pod_security_policy_config`<sup>Required</sup> <a name="pod_security_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.podSecurityPolicyConfig"></a>

```python
pod_security_policy_config: GoogleContainerClusterPodSecurityPolicyConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfigOutputReference">GoogleContainerClusterPodSecurityPolicyConfigOutputReference</a>

---

##### `private_cluster_config`<sup>Required</sup> <a name="private_cluster_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateClusterConfig"></a>

```python
private_cluster_config: GoogleContainerClusterPrivateClusterConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigOutputReference">GoogleContainerClusterPrivateClusterConfigOutputReference</a>

---

##### `protect_config`<sup>Required</sup> <a name="protect_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.protectConfig"></a>

```python
protect_config: GoogleContainerClusterProtectConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigOutputReference">GoogleContainerClusterProtectConfigOutputReference</a>

---

##### `release_channel`<sup>Required</sup> <a name="release_channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.releaseChannel"></a>

```python
release_channel: GoogleContainerClusterReleaseChannelOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannelOutputReference">GoogleContainerClusterReleaseChannelOutputReference</a>

---

##### `resource_usage_export_config`<sup>Required</sup> <a name="resource_usage_export_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceUsageExportConfig"></a>

```python
resource_usage_export_config: GoogleContainerClusterResourceUsageExportConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigOutputReference">GoogleContainerClusterResourceUsageExportConfigOutputReference</a>

---

##### `self_link`<sup>Required</sup> <a name="self_link" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.selfLink"></a>

```python
self_link: str
```

- *Type:* str

---

##### `service_external_ips_config`<sup>Required</sup> <a name="service_external_ips_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.serviceExternalIpsConfig"></a>

```python
service_external_ips_config: GoogleContainerClusterServiceExternalIpsConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfigOutputReference">GoogleContainerClusterServiceExternalIpsConfigOutputReference</a>

---

##### `services_ipv4_cidr`<sup>Required</sup> <a name="services_ipv4_cidr" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.servicesIpv4Cidr"></a>

```python
services_ipv4_cidr: str
```

- *Type:* str

---

##### `timeouts`<sup>Required</sup> <a name="timeouts" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.timeouts"></a>

```python
timeouts: GoogleContainerClusterTimeoutsOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeoutsOutputReference">GoogleContainerClusterTimeoutsOutputReference</a>

---

##### `tpu_config`<sup>Required</sup> <a name="tpu_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tpuConfig"></a>

```python
tpu_config: GoogleContainerClusterTpuConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfigOutputReference">GoogleContainerClusterTpuConfigOutputReference</a>

---

##### `tpu_ipv4_cidr_block`<sup>Required</sup> <a name="tpu_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tpuIpv4CidrBlock"></a>

```python
tpu_ipv4_cidr_block: str
```

- *Type:* str

---

##### `vertical_pod_autoscaling`<sup>Required</sup> <a name="vertical_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.verticalPodAutoscaling"></a>

```python
vertical_pod_autoscaling: GoogleContainerClusterVerticalPodAutoscalingOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscalingOutputReference">GoogleContainerClusterVerticalPodAutoscalingOutputReference</a>

---

##### `workload_identity_config`<sup>Required</sup> <a name="workload_identity_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.workloadIdentityConfig"></a>

```python
workload_identity_config: GoogleContainerClusterWorkloadIdentityConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfigOutputReference">GoogleContainerClusterWorkloadIdentityConfigOutputReference</a>

---

##### `addons_config_input`<sup>Optional</sup> <a name="addons_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.addonsConfigInput"></a>

```python
addons_config_input: GoogleContainerClusterAddonsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a>

---

##### `authenticator_groups_config_input`<sup>Optional</sup> <a name="authenticator_groups_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.authenticatorGroupsConfigInput"></a>

```python
authenticator_groups_config_input: GoogleContainerClusterAuthenticatorGroupsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a>

---

##### `binary_authorization_input`<sup>Optional</sup> <a name="binary_authorization_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.binaryAuthorizationInput"></a>

```python
binary_authorization_input: GoogleContainerClusterBinaryAuthorization
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a>

---

##### `cluster_autoscaling_input`<sup>Optional</sup> <a name="cluster_autoscaling_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterAutoscalingInput"></a>

```python
cluster_autoscaling_input: GoogleContainerClusterClusterAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling">GoogleContainerClusterClusterAutoscaling</a>

---

##### `cluster_ipv4_cidr_input`<sup>Optional</sup> <a name="cluster_ipv4_cidr_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterIpv4CidrInput"></a>

```python
cluster_ipv4_cidr_input: str
```

- *Type:* str

---

##### `cluster_telemetry_input`<sup>Optional</sup> <a name="cluster_telemetry_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterTelemetryInput"></a>

```python
cluster_telemetry_input: GoogleContainerClusterClusterTelemetry
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry">GoogleContainerClusterClusterTelemetry</a>

---

##### `confidential_nodes_input`<sup>Optional</sup> <a name="confidential_nodes_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.confidentialNodesInput"></a>

```python
confidential_nodes_input: GoogleContainerClusterConfidentialNodes
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes">GoogleContainerClusterConfidentialNodes</a>

---

##### `cost_management_config_input`<sup>Optional</sup> <a name="cost_management_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.costManagementConfigInput"></a>

```python
cost_management_config_input: GoogleContainerClusterCostManagementConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig">GoogleContainerClusterCostManagementConfig</a>

---

##### `database_encryption_input`<sup>Optional</sup> <a name="database_encryption_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.databaseEncryptionInput"></a>

```python
database_encryption_input: GoogleContainerClusterDatabaseEncryption
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption">GoogleContainerClusterDatabaseEncryption</a>

---

##### `datapath_provider_input`<sup>Optional</sup> <a name="datapath_provider_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.datapathProviderInput"></a>

```python
datapath_provider_input: str
```

- *Type:* str

---

##### `default_max_pods_per_node_input`<sup>Optional</sup> <a name="default_max_pods_per_node_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultMaxPodsPerNodeInput"></a>

```python
default_max_pods_per_node_input: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `default_snat_status_input`<sup>Optional</sup> <a name="default_snat_status_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultSnatStatusInput"></a>

```python
default_snat_status_input: GoogleContainerClusterDefaultSnatStatus
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus">GoogleContainerClusterDefaultSnatStatus</a>

---

##### `description_input`<sup>Optional</sup> <a name="description_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.descriptionInput"></a>

```python
description_input: str
```

- *Type:* str

---

##### `dns_config_input`<sup>Optional</sup> <a name="dns_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.dnsConfigInput"></a>

```python
dns_config_input: GoogleContainerClusterDnsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig">GoogleContainerClusterDnsConfig</a>

---

##### `enable_autopilot_input`<sup>Optional</sup> <a name="enable_autopilot_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableAutopilotInput"></a>

```python
enable_autopilot_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_binary_authorization_input`<sup>Optional</sup> <a name="enable_binary_authorization_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableBinaryAuthorizationInput"></a>

```python
enable_binary_authorization_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_intranode_visibility_input`<sup>Optional</sup> <a name="enable_intranode_visibility_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableIntranodeVisibilityInput"></a>

```python
enable_intranode_visibility_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_kubernetes_alpha_input`<sup>Optional</sup> <a name="enable_kubernetes_alpha_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableKubernetesAlphaInput"></a>

```python
enable_kubernetes_alpha_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_l4_ilb_subsetting_input`<sup>Optional</sup> <a name="enable_l4_ilb_subsetting_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableL4IlbSubsettingInput"></a>

```python
enable_l4_ilb_subsetting_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_legacy_abac_input`<sup>Optional</sup> <a name="enable_legacy_abac_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableLegacyAbacInput"></a>

```python
enable_legacy_abac_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_shielded_nodes_input`<sup>Optional</sup> <a name="enable_shielded_nodes_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableShieldedNodesInput"></a>

```python
enable_shielded_nodes_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_tpu_input`<sup>Optional</sup> <a name="enable_tpu_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableTpuInput"></a>

```python
enable_tpu_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `gateway_api_config_input`<sup>Optional</sup> <a name="gateway_api_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.gatewayApiConfigInput"></a>

```python
gateway_api_config_input: GoogleContainerClusterGatewayApiConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig">GoogleContainerClusterGatewayApiConfig</a>

---

##### `identity_service_config_input`<sup>Optional</sup> <a name="identity_service_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.identityServiceConfigInput"></a>

```python
identity_service_config_input: GoogleContainerClusterIdentityServiceConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig">GoogleContainerClusterIdentityServiceConfig</a>

---

##### `id_input`<sup>Optional</sup> <a name="id_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.idInput"></a>

```python
id_input: str
```

- *Type:* str

---

##### `initial_node_count_input`<sup>Optional</sup> <a name="initial_node_count_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.initialNodeCountInput"></a>

```python
initial_node_count_input: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `ip_allocation_policy_input`<sup>Optional</sup> <a name="ip_allocation_policy_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.ipAllocationPolicyInput"></a>

```python
ip_allocation_policy_input: GoogleContainerClusterIpAllocationPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy">GoogleContainerClusterIpAllocationPolicy</a>

---

##### `location_input`<sup>Optional</sup> <a name="location_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.locationInput"></a>

```python
location_input: str
```

- *Type:* str

---

##### `logging_config_input`<sup>Optional</sup> <a name="logging_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingConfigInput"></a>

```python
logging_config_input: GoogleContainerClusterLoggingConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig">GoogleContainerClusterLoggingConfig</a>

---

##### `logging_service_input`<sup>Optional</sup> <a name="logging_service_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingServiceInput"></a>

```python
logging_service_input: str
```

- *Type:* str

---

##### `maintenance_policy_input`<sup>Optional</sup> <a name="maintenance_policy_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.maintenancePolicyInput"></a>

```python
maintenance_policy_input: GoogleContainerClusterMaintenancePolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy">GoogleContainerClusterMaintenancePolicy</a>

---

##### `master_auth_input`<sup>Optional</sup> <a name="master_auth_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuthInput"></a>

```python
master_auth_input: GoogleContainerClusterMasterAuth
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth">GoogleContainerClusterMasterAuth</a>

---

##### `master_authorized_networks_config_input`<sup>Optional</sup> <a name="master_authorized_networks_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.masterAuthorizedNetworksConfigInput"></a>

```python
master_authorized_networks_config_input: GoogleContainerClusterMasterAuthorizedNetworksConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig">GoogleContainerClusterMasterAuthorizedNetworksConfig</a>

---

##### `mesh_certificates_input`<sup>Optional</sup> <a name="mesh_certificates_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.meshCertificatesInput"></a>

```python
mesh_certificates_input: GoogleContainerClusterMeshCertificates
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates">GoogleContainerClusterMeshCertificates</a>

---

##### `min_master_version_input`<sup>Optional</sup> <a name="min_master_version_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.minMasterVersionInput"></a>

```python
min_master_version_input: str
```

- *Type:* str

---

##### `monitoring_config_input`<sup>Optional</sup> <a name="monitoring_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringConfigInput"></a>

```python
monitoring_config_input: GoogleContainerClusterMonitoringConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig">GoogleContainerClusterMonitoringConfig</a>

---

##### `monitoring_service_input`<sup>Optional</sup> <a name="monitoring_service_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringServiceInput"></a>

```python
monitoring_service_input: str
```

- *Type:* str

---

##### `name_input`<sup>Optional</sup> <a name="name_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nameInput"></a>

```python
name_input: str
```

- *Type:* str

---

##### `networking_mode_input`<sup>Optional</sup> <a name="networking_mode_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkingModeInput"></a>

```python
networking_mode_input: str
```

- *Type:* str

---

##### `network_input`<sup>Optional</sup> <a name="network_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkInput"></a>

```python
network_input: str
```

- *Type:* str

---

##### `network_policy_input`<sup>Optional</sup> <a name="network_policy_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkPolicyInput"></a>

```python
network_policy_input: GoogleContainerClusterNetworkPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy">GoogleContainerClusterNetworkPolicy</a>

---

##### `node_config_input`<sup>Optional</sup> <a name="node_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeConfigInput"></a>

```python
node_config_input: GoogleContainerClusterNodeConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig">GoogleContainerClusterNodeConfig</a>

---

##### `node_locations_input`<sup>Optional</sup> <a name="node_locations_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeLocationsInput"></a>

```python
node_locations_input: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `node_pool_auto_config_input`<sup>Optional</sup> <a name="node_pool_auto_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolAutoConfigInput"></a>

```python
node_pool_auto_config_input: GoogleContainerClusterNodePoolAutoConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig">GoogleContainerClusterNodePoolAutoConfig</a>

---

##### `node_pool_defaults_input`<sup>Optional</sup> <a name="node_pool_defaults_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolDefaultsInput"></a>

```python
node_pool_defaults_input: GoogleContainerClusterNodePoolDefaults
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults">GoogleContainerClusterNodePoolDefaults</a>

---

##### `node_pool_input`<sup>Optional</sup> <a name="node_pool_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodePoolInput"></a>

```python
node_pool_input: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePool]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]

---

##### `node_version_input`<sup>Optional</sup> <a name="node_version_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeVersionInput"></a>

```python
node_version_input: str
```

- *Type:* str

---

##### `notification_config_input`<sup>Optional</sup> <a name="notification_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.notificationConfigInput"></a>

```python
notification_config_input: GoogleContainerClusterNotificationConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig">GoogleContainerClusterNotificationConfig</a>

---

##### `pod_security_policy_config_input`<sup>Optional</sup> <a name="pod_security_policy_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.podSecurityPolicyConfigInput"></a>

```python
pod_security_policy_config_input: GoogleContainerClusterPodSecurityPolicyConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig">GoogleContainerClusterPodSecurityPolicyConfig</a>

---

##### `private_cluster_config_input`<sup>Optional</sup> <a name="private_cluster_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateClusterConfigInput"></a>

```python
private_cluster_config_input: GoogleContainerClusterPrivateClusterConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig">GoogleContainerClusterPrivateClusterConfig</a>

---

##### `private_ipv6_google_access_input`<sup>Optional</sup> <a name="private_ipv6_google_access_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateIpv6GoogleAccessInput"></a>

```python
private_ipv6_google_access_input: str
```

- *Type:* str

---

##### `project_input`<sup>Optional</sup> <a name="project_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.projectInput"></a>

```python
project_input: str
```

- *Type:* str

---

##### `protect_config_input`<sup>Optional</sup> <a name="protect_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.protectConfigInput"></a>

```python
protect_config_input: GoogleContainerClusterProtectConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig">GoogleContainerClusterProtectConfig</a>

---

##### `release_channel_input`<sup>Optional</sup> <a name="release_channel_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.releaseChannelInput"></a>

```python
release_channel_input: GoogleContainerClusterReleaseChannel
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel">GoogleContainerClusterReleaseChannel</a>

---

##### `remove_default_node_pool_input`<sup>Optional</sup> <a name="remove_default_node_pool_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.removeDefaultNodePoolInput"></a>

```python
remove_default_node_pool_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `resource_labels_input`<sup>Optional</sup> <a name="resource_labels_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceLabelsInput"></a>

```python
resource_labels_input: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

---

##### `resource_usage_export_config_input`<sup>Optional</sup> <a name="resource_usage_export_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceUsageExportConfigInput"></a>

```python
resource_usage_export_config_input: GoogleContainerClusterResourceUsageExportConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig">GoogleContainerClusterResourceUsageExportConfig</a>

---

##### `service_external_ips_config_input`<sup>Optional</sup> <a name="service_external_ips_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.serviceExternalIpsConfigInput"></a>

```python
service_external_ips_config_input: GoogleContainerClusterServiceExternalIpsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig">GoogleContainerClusterServiceExternalIpsConfig</a>

---

##### `subnetwork_input`<sup>Optional</sup> <a name="subnetwork_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.subnetworkInput"></a>

```python
subnetwork_input: str
```

- *Type:* str

---

##### `timeouts_input`<sup>Optional</sup> <a name="timeouts_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.timeoutsInput"></a>

```python
timeouts_input: typing.Union[GoogleContainerClusterTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts">GoogleContainerClusterTimeouts</a>, cdktf.IResolvable]

---

##### `tpu_config_input`<sup>Optional</sup> <a name="tpu_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tpuConfigInput"></a>

```python
tpu_config_input: GoogleContainerClusterTpuConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig">GoogleContainerClusterTpuConfig</a>

---

##### `vertical_pod_autoscaling_input`<sup>Optional</sup> <a name="vertical_pod_autoscaling_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.verticalPodAutoscalingInput"></a>

```python
vertical_pod_autoscaling_input: GoogleContainerClusterVerticalPodAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling">GoogleContainerClusterVerticalPodAutoscaling</a>

---

##### `workload_identity_config_input`<sup>Optional</sup> <a name="workload_identity_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.workloadIdentityConfigInput"></a>

```python
workload_identity_config_input: GoogleContainerClusterWorkloadIdentityConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig">GoogleContainerClusterWorkloadIdentityConfig</a>

---

##### `cluster_ipv4_cidr`<sup>Required</sup> <a name="cluster_ipv4_cidr" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.clusterIpv4Cidr"></a>

```python
cluster_ipv4_cidr: str
```

- *Type:* str

---

##### `datapath_provider`<sup>Required</sup> <a name="datapath_provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.datapathProvider"></a>

```python
datapath_provider: str
```

- *Type:* str

---

##### `default_max_pods_per_node`<sup>Required</sup> <a name="default_max_pods_per_node" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.defaultMaxPodsPerNode"></a>

```python
default_max_pods_per_node: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.description"></a>

```python
description: str
```

- *Type:* str

---

##### `enable_autopilot`<sup>Required</sup> <a name="enable_autopilot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableAutopilot"></a>

```python
enable_autopilot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_binary_authorization`<sup>Required</sup> <a name="enable_binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableBinaryAuthorization"></a>

```python
enable_binary_authorization: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_intranode_visibility`<sup>Required</sup> <a name="enable_intranode_visibility" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableIntranodeVisibility"></a>

```python
enable_intranode_visibility: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_kubernetes_alpha`<sup>Required</sup> <a name="enable_kubernetes_alpha" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableKubernetesAlpha"></a>

```python
enable_kubernetes_alpha: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_l4_ilb_subsetting`<sup>Required</sup> <a name="enable_l4_ilb_subsetting" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableL4IlbSubsetting"></a>

```python
enable_l4_ilb_subsetting: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_legacy_abac`<sup>Required</sup> <a name="enable_legacy_abac" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableLegacyAbac"></a>

```python
enable_legacy_abac: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_shielded_nodes`<sup>Required</sup> <a name="enable_shielded_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableShieldedNodes"></a>

```python
enable_shielded_nodes: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enable_tpu`<sup>Required</sup> <a name="enable_tpu" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.enableTpu"></a>

```python
enable_tpu: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `initial_node_count`<sup>Required</sup> <a name="initial_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.initialNodeCount"></a>

```python
initial_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `location`<sup>Required</sup> <a name="location" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.location"></a>

```python
location: str
```

- *Type:* str

---

##### `logging_service`<sup>Required</sup> <a name="logging_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.loggingService"></a>

```python
logging_service: str
```

- *Type:* str

---

##### `min_master_version`<sup>Required</sup> <a name="min_master_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.minMasterVersion"></a>

```python
min_master_version: str
```

- *Type:* str

---

##### `monitoring_service`<sup>Required</sup> <a name="monitoring_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.monitoringService"></a>

```python
monitoring_service: str
```

- *Type:* str

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.name"></a>

```python
name: str
```

- *Type:* str

---

##### `network`<sup>Required</sup> <a name="network" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.network"></a>

```python
network: str
```

- *Type:* str

---

##### `networking_mode`<sup>Required</sup> <a name="networking_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.networkingMode"></a>

```python
networking_mode: str
```

- *Type:* str

---

##### `node_locations`<sup>Required</sup> <a name="node_locations" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeLocations"></a>

```python
node_locations: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `node_version`<sup>Required</sup> <a name="node_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.nodeVersion"></a>

```python
node_version: str
```

- *Type:* str

---

##### `private_ipv6_google_access`<sup>Required</sup> <a name="private_ipv6_google_access" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.privateIpv6GoogleAccess"></a>

```python
private_ipv6_google_access: str
```

- *Type:* str

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.project"></a>

```python
project: str
```

- *Type:* str

---

##### `remove_default_node_pool`<sup>Required</sup> <a name="remove_default_node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.removeDefaultNodePool"></a>

```python
remove_default_node_pool: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `resource_labels`<sup>Required</sup> <a name="resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.resourceLabels"></a>

```python
resource_labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

---

##### `subnetwork`<sup>Required</sup> <a name="subnetwork" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.subnetwork"></a>

```python
subnetwork: str
```

- *Type:* str

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tfResourceType">tfResourceType</a></code> | <code>str</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster.property.tfResourceType"></a>

```python
tfResourceType: str
```

- *Type:* str

---

## Structs <a name="Structs" id="Structs"></a>

### GoogleContainerClusterAddonsConfig <a name="GoogleContainerClusterAddonsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfig(
  cloudrun_config: GoogleContainerClusterAddonsConfigCloudrunConfig = None,
  config_connector_config: GoogleContainerClusterAddonsConfigConfigConnectorConfig = None,
  dns_cache_config: GoogleContainerClusterAddonsConfigDnsCacheConfig = None,
  gce_persistent_disk_csi_driver_config: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig = None,
  gcp_filestore_csi_driver_config: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig = None,
  gke_backup_agent_config: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig = None,
  horizontal_pod_autoscaling: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling = None,
  http_load_balancing: GoogleContainerClusterAddonsConfigHttpLoadBalancing = None,
  istio_config: GoogleContainerClusterAddonsConfigIstioConfig = None,
  kalm_config: GoogleContainerClusterAddonsConfigKalmConfig = None,
  network_policy_config: GoogleContainerClusterAddonsConfigNetworkPolicyConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.cloudrunConfig">cloudrun_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a></code> | cloudrun_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.configConnectorConfig">config_connector_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a></code> | config_connector_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.dnsCacheConfig">dns_cache_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a></code> | dns_cache_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.gcePersistentDiskCsiDriverConfig">gce_persistent_disk_csi_driver_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a></code> | gce_persistent_disk_csi_driver_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.gcpFilestoreCsiDriverConfig">gcp_filestore_csi_driver_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a></code> | gcp_filestore_csi_driver_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.gkeBackupAgentConfig">gke_backup_agent_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a></code> | gke_backup_agent_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.horizontalPodAutoscaling">horizontal_pod_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a></code> | horizontal_pod_autoscaling block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.httpLoadBalancing">http_load_balancing</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a></code> | http_load_balancing block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.istioConfig">istio_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a></code> | istio_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.kalmConfig">kalm_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a></code> | kalm_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.networkPolicyConfig">network_policy_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a></code> | network_policy_config block. |

---

##### `cloudrun_config`<sup>Optional</sup> <a name="cloudrun_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.cloudrunConfig"></a>

```python
cloudrun_config: GoogleContainerClusterAddonsConfigCloudrunConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a>

cloudrun_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cloudrun_config GoogleContainerCluster#cloudrun_config}

---

##### `config_connector_config`<sup>Optional</sup> <a name="config_connector_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.configConnectorConfig"></a>

```python
config_connector_config: GoogleContainerClusterAddonsConfigConfigConnectorConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a>

config_connector_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#config_connector_config GoogleContainerCluster#config_connector_config}

---

##### `dns_cache_config`<sup>Optional</sup> <a name="dns_cache_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.dnsCacheConfig"></a>

```python
dns_cache_config: GoogleContainerClusterAddonsConfigDnsCacheConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a>

dns_cache_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#dns_cache_config GoogleContainerCluster#dns_cache_config}

---

##### `gce_persistent_disk_csi_driver_config`<sup>Optional</sup> <a name="gce_persistent_disk_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.gcePersistentDiskCsiDriverConfig"></a>

```python
gce_persistent_disk_csi_driver_config: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

gce_persistent_disk_csi_driver_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gce_persistent_disk_csi_driver_config GoogleContainerCluster#gce_persistent_disk_csi_driver_config}

---

##### `gcp_filestore_csi_driver_config`<sup>Optional</sup> <a name="gcp_filestore_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.gcpFilestoreCsiDriverConfig"></a>

```python
gcp_filestore_csi_driver_config: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

gcp_filestore_csi_driver_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcp_filestore_csi_driver_config GoogleContainerCluster#gcp_filestore_csi_driver_config}

---

##### `gke_backup_agent_config`<sup>Optional</sup> <a name="gke_backup_agent_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.gkeBackupAgentConfig"></a>

```python
gke_backup_agent_config: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a>

gke_backup_agent_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gke_backup_agent_config GoogleContainerCluster#gke_backup_agent_config}

---

##### `horizontal_pod_autoscaling`<sup>Optional</sup> <a name="horizontal_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.horizontalPodAutoscaling"></a>

```python
horizontal_pod_autoscaling: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

horizontal_pod_autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#horizontal_pod_autoscaling GoogleContainerCluster#horizontal_pod_autoscaling}

---

##### `http_load_balancing`<sup>Optional</sup> <a name="http_load_balancing" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.httpLoadBalancing"></a>

```python
http_load_balancing: GoogleContainerClusterAddonsConfigHttpLoadBalancing
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a>

http_load_balancing block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#http_load_balancing GoogleContainerCluster#http_load_balancing}

---

##### `istio_config`<sup>Optional</sup> <a name="istio_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.istioConfig"></a>

```python
istio_config: GoogleContainerClusterAddonsConfigIstioConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a>

istio_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#istio_config GoogleContainerCluster#istio_config}

---

##### `kalm_config`<sup>Optional</sup> <a name="kalm_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.kalmConfig"></a>

```python
kalm_config: GoogleContainerClusterAddonsConfigKalmConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a>

kalm_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#kalm_config GoogleContainerCluster#kalm_config}

---

##### `network_policy_config`<sup>Optional</sup> <a name="network_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig.property.networkPolicyConfig"></a>

```python
network_policy_config: GoogleContainerClusterAddonsConfigNetworkPolicyConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a>

network_policy_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_policy_config GoogleContainerCluster#network_policy_config}

---

### GoogleContainerClusterAddonsConfigCloudrunConfig <a name="GoogleContainerClusterAddonsConfigCloudrunConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig(
  disabled: typing.Union[bool, IResolvable],
  load_balancer_type: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig.property.loadBalancerType">load_balancer_type</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#load_balancer_type GoogleContainerCluster#load_balancer_type}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

##### `load_balancer_type`<sup>Optional</sup> <a name="load_balancer_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig.property.loadBalancerType"></a>

```python
load_balancer_type: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#load_balancer_type GoogleContainerCluster#load_balancer_type}.

---

### GoogleContainerClusterAddonsConfigConfigConnectorConfig <a name="GoogleContainerClusterAddonsConfigConfigConnectorConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

### GoogleContainerClusterAddonsConfigDnsCacheConfig <a name="GoogleContainerClusterAddonsConfigDnsCacheConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

### GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig <a name="GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

### GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig <a name="GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

### GoogleContainerClusterAddonsConfigGkeBackupAgentConfig <a name="GoogleContainerClusterAddonsConfigGkeBackupAgentConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

### GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling <a name="GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling(
  disabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

### GoogleContainerClusterAddonsConfigHttpLoadBalancing <a name="GoogleContainerClusterAddonsConfigHttpLoadBalancing" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing(
  disabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

### GoogleContainerClusterAddonsConfigIstioConfig <a name="GoogleContainerClusterAddonsConfigIstioConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig(
  disabled: typing.Union[bool, IResolvable],
  auth: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | The status of the Istio addon, which makes it easy to set up Istio for services in a cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig.property.auth">auth</a></code> | <code>str</code> | The authentication type between services in Istio. Available options include AUTH_MUTUAL_TLS. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

The status of the Istio addon, which makes it easy to set up Istio for services in a cluster.

It is disabled by default. Set disabled = false to enable.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}

---

##### `auth`<sup>Optional</sup> <a name="auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig.property.auth"></a>

```python
auth: str
```

- *Type:* str

The authentication type between services in Istio. Available options include AUTH_MUTUAL_TLS.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auth GoogleContainerCluster#auth}

---

### GoogleContainerClusterAddonsConfigKalmConfig <a name="GoogleContainerClusterAddonsConfigKalmConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

### GoogleContainerClusterAddonsConfigNetworkPolicyConfig <a name="GoogleContainerClusterAddonsConfigNetworkPolicyConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig(
  disabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

### GoogleContainerClusterAuthenticatorGroupsConfig <a name="GoogleContainerClusterAuthenticatorGroupsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig(
  security_group: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig.property.securityGroup">security_group</a></code> | <code>str</code> | The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. |

---

##### `security_group`<sup>Required</sup> <a name="security_group" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig.property.securityGroup"></a>

```python
security_group: str
```

- *Type:* str

The name of the RBAC security group for use with Google security groups in Kubernetes RBAC.

Group name must be in format gke-security-groups@yourdomain.com.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#security_group GoogleContainerCluster#security_group}

---

### GoogleContainerClusterBinaryAuthorization <a name="GoogleContainerClusterBinaryAuthorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterBinaryAuthorization(
  enabled: typing.Union[bool, IResolvable] = None,
  evaluation_mode: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Binary Authorization for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization.property.evaluationMode">evaluation_mode</a></code> | <code>str</code> | Mode of operation for Binary Authorization policy evaluation. |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Binary Authorization for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `evaluation_mode`<sup>Optional</sup> <a name="evaluation_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization.property.evaluationMode"></a>

```python
evaluation_mode: str
```

- *Type:* str

Mode of operation for Binary Authorization policy evaluation.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#evaluation_mode GoogleContainerCluster#evaluation_mode}

---

### GoogleContainerClusterClusterAutoscaling <a name="GoogleContainerClusterClusterAutoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscaling(
  auto_provisioning_defaults: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults = None,
  autoscaling_profile: str = None,
  enabled: typing.Union[bool, IResolvable] = None,
  resource_limits: typing.Union[IResolvable, typing.List[GoogleContainerClusterClusterAutoscalingResourceLimits]] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.autoProvisioningDefaults">auto_provisioning_defaults</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults</a></code> | auto_provisioning_defaults block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.autoscalingProfile">autoscaling_profile</a></code> | <code>str</code> | Configuration options for the Autoscaling profile feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability when deciding to remove nodes from a cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.resourceLimits">resource_limits</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits">GoogleContainerClusterClusterAutoscalingResourceLimits</a>]]</code> | resource_limits block. |

---

##### `auto_provisioning_defaults`<sup>Optional</sup> <a name="auto_provisioning_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.autoProvisioningDefaults"></a>

```python
auto_provisioning_defaults: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults</a>

auto_provisioning_defaults block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auto_provisioning_defaults GoogleContainerCluster#auto_provisioning_defaults}

---

##### `autoscaling_profile`<sup>Optional</sup> <a name="autoscaling_profile" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.autoscalingProfile"></a>

```python
autoscaling_profile: str
```

- *Type:* str

Configuration options for the Autoscaling profile feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability when deciding to remove nodes from a cluster.

Can be BALANCED or OPTIMIZE_UTILIZATION. Defaults to BALANCED.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#autoscaling_profile GoogleContainerCluster#autoscaling_profile}

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `resource_limits`<sup>Optional</sup> <a name="resource_limits" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling.property.resourceLimits"></a>

```python
resource_limits: typing.Union[IResolvable, typing.List[GoogleContainerClusterClusterAutoscalingResourceLimits]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits">GoogleContainerClusterClusterAutoscalingResourceLimits</a>]]

resource_limits block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_limits GoogleContainerCluster#resource_limits}

---

### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults(
  boot_disk_kms_key: str = None,
  disk_size: typing.Union[int, float] = None,
  disk_type: str = None,
  image_type: str = None,
  management: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement = None,
  min_cpu_platform: str = None,
  oauth_scopes: typing.List[str] = None,
  service_account: str = None,
  shielded_instance_config: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig = None,
  upgrade_settings: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.bootDiskKmsKey">boot_disk_kms_key</a></code> | <code>str</code> | The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskSize">disk_size</a></code> | <code>typing.Union[int, float]</code> | Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskType">disk_type</a></code> | <code>str</code> | Type of the disk attached to each node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.imageType">image_type</a></code> | <code>str</code> | The default image type used by NAP once a new node pool is being created. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.management">management</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a></code> | management block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.minCpuPlatform">min_cpu_platform</a></code> | <code>str</code> | Minimum CPU platform to be used by this instance. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.oauthScopes">oauth_scopes</a></code> | <code>typing.List[str]</code> | Scopes that are used by NAP when creating node pools. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.serviceAccount">service_account</a></code> | <code>str</code> | The Google Cloud Platform Service Account to be used by the node VMs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.shieldedInstanceConfig">shielded_instance_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a></code> | shielded_instance_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.upgradeSettings">upgrade_settings</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a></code> | upgrade_settings block. |

---

##### `boot_disk_kms_key`<sup>Optional</sup> <a name="boot_disk_kms_key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.bootDiskKmsKey"></a>

```python
boot_disk_kms_key: str
```

- *Type:* str

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}

---

##### `disk_size`<sup>Optional</sup> <a name="disk_size" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskSize"></a>

```python
disk_size: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_size GoogleContainerCluster#disk_size}

---

##### `disk_type`<sup>Optional</sup> <a name="disk_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskType"></a>

```python
disk_type: str
```

- *Type:* str

Type of the disk attached to each node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}

---

##### `image_type`<sup>Optional</sup> <a name="image_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.imageType"></a>

```python
image_type: str
```

- *Type:* str

The default image type used by NAP once a new node pool is being created.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}

---

##### `management`<sup>Optional</sup> <a name="management" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.management"></a>

```python
management: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a>

management block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#management GoogleContainerCluster#management}

---

##### `min_cpu_platform`<sup>Optional</sup> <a name="min_cpu_platform" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.minCpuPlatform"></a>

```python
min_cpu_platform: str
```

- *Type:* str

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as Intel Haswell.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}

---

##### `oauth_scopes`<sup>Optional</sup> <a name="oauth_scopes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.oauthScopes"></a>

```python
oauth_scopes: typing.List[str]
```

- *Type:* typing.List[str]

Scopes that are used by NAP when creating node pools.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}

---

##### `service_account`<sup>Optional</sup> <a name="service_account" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.serviceAccount"></a>

```python
service_account: str
```

- *Type:* str

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}

---

##### `shielded_instance_config`<sup>Optional</sup> <a name="shielded_instance_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.shieldedInstanceConfig"></a>

```python
shielded_instance_config: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}

---

##### `upgrade_settings`<sup>Optional</sup> <a name="upgrade_settings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.upgradeSettings"></a>

```python
upgrade_settings: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a>

upgrade_settings block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#upgrade_settings GoogleContainerCluster#upgrade_settings}

---

### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement(
  auto_repair: typing.Union[bool, IResolvable] = None,
  auto_upgrade: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoRepair">auto_repair</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Specifies whether the node auto-repair is enabled for the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoUpgrade">auto_upgrade</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Specifies whether node auto-upgrade is enabled for the node pool. |

---

##### `auto_repair`<sup>Optional</sup> <a name="auto_repair" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoRepair"></a>

```python
auto_repair: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Specifies whether the node auto-repair is enabled for the node pool.

If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auto_repair GoogleContainerCluster#auto_repair}

---

##### `auto_upgrade`<sup>Optional</sup> <a name="auto_upgrade" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoUpgrade"></a>

```python
auto_upgrade: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Specifies whether node auto-upgrade is enabled for the node pool.

If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auto_upgrade GoogleContainerCluster#auto_upgrade}

---

### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions()
```


### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig(
  enable_integrity_monitoring: typing.Union[bool, IResolvable] = None,
  enable_secure_boot: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableIntegrityMonitoring">enable_integrity_monitoring</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Defines whether the instance has integrity monitoring enabled. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableSecureBoot">enable_secure_boot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Defines whether the instance has Secure Boot enabled. |

---

##### `enable_integrity_monitoring`<sup>Optional</sup> <a name="enable_integrity_monitoring" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableIntegrityMonitoring"></a>

```python
enable_integrity_monitoring: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Defines whether the instance has integrity monitoring enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}

---

##### `enable_secure_boot`<sup>Optional</sup> <a name="enable_secure_boot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableSecureBoot"></a>

```python
enable_secure_boot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Defines whether the instance has Secure Boot enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}

---

### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings(
  blue_green_settings: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings = None,
  max_surge: typing.Union[int, float] = None,
  max_unavailable: typing.Union[int, float] = None,
  strategy: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.blueGreenSettings">blue_green_settings</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a></code> | blue_green_settings block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxSurge">max_surge</a></code> | <code>typing.Union[int, float]</code> | The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxUnavailable">max_unavailable</a></code> | <code>typing.Union[int, float]</code> | The maximum number of nodes that can be simultaneously unavailable during the upgrade process. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.strategy">strategy</a></code> | <code>str</code> | Update strategy of the node pool. |

---

##### `blue_green_settings`<sup>Optional</sup> <a name="blue_green_settings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.blueGreenSettings"></a>

```python
blue_green_settings: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a>

blue_green_settings block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#blue_green_settings GoogleContainerCluster#blue_green_settings}

---

##### `max_surge`<sup>Optional</sup> <a name="max_surge" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxSurge"></a>

```python
max_surge: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_surge GoogleContainerCluster#max_surge}

---

##### `max_unavailable`<sup>Optional</sup> <a name="max_unavailable" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxUnavailable"></a>

```python
max_unavailable: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The maximum number of nodes that can be simultaneously unavailable during the upgrade process.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_unavailable GoogleContainerCluster#max_unavailable}

---

##### `strategy`<sup>Optional</sup> <a name="strategy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.strategy"></a>

```python
strategy: str
```

- *Type:* str

Update strategy of the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#strategy GoogleContainerCluster#strategy}

---

### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings(
  node_pool_soak_duration: str = None,
  standard_rollout_policy: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration">node_pool_soak_duration</a></code> | <code>str</code> | Time needed after draining entire blue pool. After this period, blue pool will be cleaned up. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy">standard_rollout_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a></code> | standard_rollout_policy block. |

---

##### `node_pool_soak_duration`<sup>Optional</sup> <a name="node_pool_soak_duration" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration"></a>

```python
node_pool_soak_duration: str
```

- *Type:* str

Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.

A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool_soak_duration GoogleContainerCluster#node_pool_soak_duration}

---

##### `standard_rollout_policy`<sup>Optional</sup> <a name="standard_rollout_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy"></a>

```python
standard_rollout_policy: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

standard_rollout_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#standard_rollout_policy GoogleContainerCluster#standard_rollout_policy}

---

### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy(
  batch_node_count: typing.Union[int, float] = None,
  batch_percentage: typing.Union[int, float] = None,
  batch_soak_duration: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount">batch_node_count</a></code> | <code>typing.Union[int, float]</code> | Number of blue nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage">batch_percentage</a></code> | <code>typing.Union[int, float]</code> | Percentage of the bool pool nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration">batch_soak_duration</a></code> | <code>str</code> | Soak time after each batch gets drained. |

---

##### `batch_node_count`<sup>Optional</sup> <a name="batch_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount"></a>

```python
batch_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of blue nodes to drain in a batch.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#batch_node_count GoogleContainerCluster#batch_node_count}

---

##### `batch_percentage`<sup>Optional</sup> <a name="batch_percentage" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage"></a>

```python
batch_percentage: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Percentage of the bool pool nodes to drain in a batch.

The range of this field should be (0.0, 1.0].

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#batch_percentage GoogleContainerCluster#batch_percentage}

---

##### `batch_soak_duration`<sup>Optional</sup> <a name="batch_soak_duration" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration"></a>

```python
batch_soak_duration: str
```

- *Type:* str

Soak time after each batch gets drained.

A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#batch_soak_duration GoogleContainerCluster#batch_soak_duration}

---

### GoogleContainerClusterClusterAutoscalingResourceLimits <a name="GoogleContainerClusterClusterAutoscalingResourceLimits" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits(
  resource_type: str,
  maximum: typing.Union[int, float] = None,
  minimum: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.property.resourceType">resource_type</a></code> | <code>str</code> | The type of the resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.property.maximum">maximum</a></code> | <code>typing.Union[int, float]</code> | Maximum amount of the resource in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.property.minimum">minimum</a></code> | <code>typing.Union[int, float]</code> | Minimum amount of the resource in the cluster. |

---

##### `resource_type`<sup>Required</sup> <a name="resource_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.property.resourceType"></a>

```python
resource_type: str
```

- *Type:* str

The type of the resource.

For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_type GoogleContainerCluster#resource_type}

---

##### `maximum`<sup>Optional</sup> <a name="maximum" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.property.maximum"></a>

```python
maximum: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Maximum amount of the resource in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#maximum GoogleContainerCluster#maximum}

---

##### `minimum`<sup>Optional</sup> <a name="minimum" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingResourceLimits.property.minimum"></a>

```python
minimum: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Minimum amount of the resource in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#minimum GoogleContainerCluster#minimum}

---

### GoogleContainerClusterClusterTelemetry <a name="GoogleContainerClusterClusterTelemetry" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterTelemetry(
  type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry.property.type">type</a></code> | <code>str</code> | Type of the integration. |

---

##### `type`<sup>Required</sup> <a name="type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry.property.type"></a>

```python
type: str
```

- *Type:* str

Type of the integration.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}

---

### GoogleContainerClusterConfidentialNodes <a name="GoogleContainerClusterConfidentialNodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterConfidentialNodes(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether Confidential Nodes feature is enabled for all nodes in this cluster. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether Confidential Nodes feature is enabled for all nodes in this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterConfig <a name="GoogleContainerClusterConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterConfig(
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[typing.Union[int, float], TerraformCount] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  name: str,
  addons_config: GoogleContainerClusterAddonsConfig = None,
  authenticator_groups_config: GoogleContainerClusterAuthenticatorGroupsConfig = None,
  binary_authorization: GoogleContainerClusterBinaryAuthorization = None,
  cluster_autoscaling: GoogleContainerClusterClusterAutoscaling = None,
  cluster_ipv4_cidr: str = None,
  cluster_telemetry: GoogleContainerClusterClusterTelemetry = None,
  confidential_nodes: GoogleContainerClusterConfidentialNodes = None,
  cost_management_config: GoogleContainerClusterCostManagementConfig = None,
  database_encryption: GoogleContainerClusterDatabaseEncryption = None,
  datapath_provider: str = None,
  default_max_pods_per_node: typing.Union[int, float] = None,
  default_snat_status: GoogleContainerClusterDefaultSnatStatus = None,
  description: str = None,
  dns_config: GoogleContainerClusterDnsConfig = None,
  enable_autopilot: typing.Union[bool, IResolvable] = None,
  enable_binary_authorization: typing.Union[bool, IResolvable] = None,
  enable_intranode_visibility: typing.Union[bool, IResolvable] = None,
  enable_kubernetes_alpha: typing.Union[bool, IResolvable] = None,
  enable_l4_ilb_subsetting: typing.Union[bool, IResolvable] = None,
  enable_legacy_abac: typing.Union[bool, IResolvable] = None,
  enable_shielded_nodes: typing.Union[bool, IResolvable] = None,
  enable_tpu: typing.Union[bool, IResolvable] = None,
  gateway_api_config: GoogleContainerClusterGatewayApiConfig = None,
  id: str = None,
  identity_service_config: GoogleContainerClusterIdentityServiceConfig = None,
  initial_node_count: typing.Union[int, float] = None,
  ip_allocation_policy: GoogleContainerClusterIpAllocationPolicy = None,
  location: str = None,
  logging_config: GoogleContainerClusterLoggingConfig = None,
  logging_service: str = None,
  maintenance_policy: GoogleContainerClusterMaintenancePolicy = None,
  master_auth: GoogleContainerClusterMasterAuth = None,
  master_authorized_networks_config: GoogleContainerClusterMasterAuthorizedNetworksConfig = None,
  mesh_certificates: GoogleContainerClusterMeshCertificates = None,
  min_master_version: str = None,
  monitoring_config: GoogleContainerClusterMonitoringConfig = None,
  monitoring_service: str = None,
  network: str = None,
  networking_mode: str = None,
  network_policy: GoogleContainerClusterNetworkPolicy = None,
  node_config: GoogleContainerClusterNodeConfig = None,
  node_locations: typing.List[str] = None,
  node_pool: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePool]] = None,
  node_pool_auto_config: GoogleContainerClusterNodePoolAutoConfig = None,
  node_pool_defaults: GoogleContainerClusterNodePoolDefaults = None,
  node_version: str = None,
  notification_config: GoogleContainerClusterNotificationConfig = None,
  pod_security_policy_config: GoogleContainerClusterPodSecurityPolicyConfig = None,
  private_cluster_config: GoogleContainerClusterPrivateClusterConfig = None,
  private_ipv6_google_access: str = None,
  project: str = None,
  protect_config: GoogleContainerClusterProtectConfig = None,
  release_channel: GoogleContainerClusterReleaseChannel = None,
  remove_default_node_pool: typing.Union[bool, IResolvable] = None,
  resource_labels: typing.Mapping[str] = None,
  resource_usage_export_config: GoogleContainerClusterResourceUsageExportConfig = None,
  service_external_ips_config: GoogleContainerClusterServiceExternalIpsConfig = None,
  subnetwork: str = None,
  timeouts: GoogleContainerClusterTimeouts = None,
  tpu_config: GoogleContainerClusterTpuConfig = None,
  vertical_pod_autoscaling: GoogleContainerClusterVerticalPodAutoscaling = None,
  workload_identity_config: GoogleContainerClusterWorkloadIdentityConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.name">name</a></code> | <code>str</code> | The name of the cluster, unique within the project and location. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.addonsConfig">addons_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a></code> | addons_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.authenticatorGroupsConfig">authenticator_groups_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a></code> | authenticator_groups_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.binaryAuthorization">binary_authorization</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a></code> | binary_authorization block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.clusterAutoscaling">cluster_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling">GoogleContainerClusterClusterAutoscaling</a></code> | cluster_autoscaling block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.clusterIpv4Cidr">cluster_ipv4_cidr</a></code> | <code>str</code> | The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.clusterTelemetry">cluster_telemetry</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry">GoogleContainerClusterClusterTelemetry</a></code> | cluster_telemetry block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.confidentialNodes">confidential_nodes</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes">GoogleContainerClusterConfidentialNodes</a></code> | confidential_nodes block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.costManagementConfig">cost_management_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig">GoogleContainerClusterCostManagementConfig</a></code> | cost_management_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.databaseEncryption">database_encryption</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption">GoogleContainerClusterDatabaseEncryption</a></code> | database_encryption block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.datapathProvider">datapath_provider</a></code> | <code>str</code> | The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.defaultMaxPodsPerNode">default_max_pods_per_node</a></code> | <code>typing.Union[int, float]</code> | The default maximum number of pods per node in this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.defaultSnatStatus">default_snat_status</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus">GoogleContainerClusterDefaultSnatStatus</a></code> | default_snat_status block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.description">description</a></code> | <code>str</code> | Description of the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.dnsConfig">dns_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig">GoogleContainerClusterDnsConfig</a></code> | dns_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableAutopilot">enable_autopilot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Autopilot for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableBinaryAuthorization">enable_binary_authorization</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableIntranodeVisibility">enable_intranode_visibility</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether Intra-node visibility is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableKubernetesAlpha">enable_kubernetes_alpha</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable Kubernetes Alpha features for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableL4IlbSubsetting">enable_l4_ilb_subsetting</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether L4ILB Subsetting is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableLegacyAbac">enable_legacy_abac</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the ABAC authorizer is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableShieldedNodes">enable_shielded_nodes</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable Shielded Nodes features on all nodes in this cluster. Defaults to true. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableTpu">enable_tpu</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable Cloud TPU resources in this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.gatewayApiConfig">gateway_api_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig">GoogleContainerClusterGatewayApiConfig</a></code> | gateway_api_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#id GoogleContainerCluster#id}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.identityServiceConfig">identity_service_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig">GoogleContainerClusterIdentityServiceConfig</a></code> | identity_service_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.initialNodeCount">initial_node_count</a></code> | <code>typing.Union[int, float]</code> | The number of nodes to create in this cluster's default node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.ipAllocationPolicy">ip_allocation_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy">GoogleContainerClusterIpAllocationPolicy</a></code> | ip_allocation_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.location">location</a></code> | <code>str</code> | The location (region or zone) in which the cluster master will be created, as well as the default node location. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.loggingConfig">logging_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig">GoogleContainerClusterLoggingConfig</a></code> | logging_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.loggingService">logging_service</a></code> | <code>str</code> | The logging service that the cluster should write logs to. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.maintenancePolicy">maintenance_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy">GoogleContainerClusterMaintenancePolicy</a></code> | maintenance_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.masterAuth">master_auth</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth">GoogleContainerClusterMasterAuth</a></code> | master_auth block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.masterAuthorizedNetworksConfig">master_authorized_networks_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig">GoogleContainerClusterMasterAuthorizedNetworksConfig</a></code> | master_authorized_networks_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.meshCertificates">mesh_certificates</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates">GoogleContainerClusterMeshCertificates</a></code> | mesh_certificates block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.minMasterVersion">min_master_version</a></code> | <code>str</code> | The minimum version of the master. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.monitoringConfig">monitoring_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig">GoogleContainerClusterMonitoringConfig</a></code> | monitoring_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.monitoringService">monitoring_service</a></code> | <code>str</code> | The monitoring service that the cluster should write metrics to. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.network">network</a></code> | <code>str</code> | The name or self_link of the Google Compute Engine network to which the cluster is connected. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.networkingMode">networking_mode</a></code> | <code>str</code> | Determines whether alias IPs or routes will be used for pod IPs in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.networkPolicy">network_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy">GoogleContainerClusterNetworkPolicy</a></code> | network_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodeConfig">node_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig">GoogleContainerClusterNodeConfig</a></code> | node_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodeLocations">node_locations</a></code> | <code>typing.List[str]</code> | The list of zones in which the cluster's nodes are located. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodePool">node_pool</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]</code> | node_pool block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodePoolAutoConfig">node_pool_auto_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig">GoogleContainerClusterNodePoolAutoConfig</a></code> | node_pool_auto_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodePoolDefaults">node_pool_defaults</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults">GoogleContainerClusterNodePoolDefaults</a></code> | node_pool_defaults block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodeVersion">node_version</a></code> | <code>str</code> | The Kubernetes version on the nodes. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.notificationConfig">notification_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig">GoogleContainerClusterNotificationConfig</a></code> | notification_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.podSecurityPolicyConfig">pod_security_policy_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig">GoogleContainerClusterPodSecurityPolicyConfig</a></code> | pod_security_policy_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.privateClusterConfig">private_cluster_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig">GoogleContainerClusterPrivateClusterConfig</a></code> | private_cluster_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.privateIpv6GoogleAccess">private_ipv6_google_access</a></code> | <code>str</code> | The desired state of IPv6 connectivity to Google Services. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.project">project</a></code> | <code>str</code> | The ID of the project in which the resource belongs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.protectConfig">protect_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig">GoogleContainerClusterProtectConfig</a></code> | protect_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.releaseChannel">release_channel</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel">GoogleContainerClusterReleaseChannel</a></code> | release_channel block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.removeDefaultNodePool">remove_default_node_pool</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | If true, deletes the default node pool upon cluster creation. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.resourceLabels">resource_labels</a></code> | <code>typing.Mapping[str]</code> | The GCE resource labels (a map of key/value pairs) to be applied to the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.resourceUsageExportConfig">resource_usage_export_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig">GoogleContainerClusterResourceUsageExportConfig</a></code> | resource_usage_export_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.serviceExternalIpsConfig">service_external_ips_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig">GoogleContainerClusterServiceExternalIpsConfig</a></code> | service_external_ips_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.subnetwork">subnetwork</a></code> | <code>str</code> | The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts">GoogleContainerClusterTimeouts</a></code> | timeouts block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.tpuConfig">tpu_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig">GoogleContainerClusterTpuConfig</a></code> | tpu_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.verticalPodAutoscaling">vertical_pod_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling">GoogleContainerClusterVerticalPodAutoscaling</a></code> | vertical_pod_autoscaling block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.workloadIdentityConfig">workload_identity_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig">GoogleContainerClusterWorkloadIdentityConfig</a></code> | workload_identity_config block. |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.count"></a>

```python
count: typing.Union[typing.Union[int, float], TerraformCount]
```

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.dependsOn"></a>

```python
depends_on: typing.List[ITerraformDependable]
```

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.name"></a>

```python
name: str
```

- *Type:* str

The name of the cluster, unique within the project and location.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#name GoogleContainerCluster#name}

---

##### `addons_config`<sup>Optional</sup> <a name="addons_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.addonsConfig"></a>

```python
addons_config: GoogleContainerClusterAddonsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a>

addons_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#addons_config GoogleContainerCluster#addons_config}

---

##### `authenticator_groups_config`<sup>Optional</sup> <a name="authenticator_groups_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.authenticatorGroupsConfig"></a>

```python
authenticator_groups_config: GoogleContainerClusterAuthenticatorGroupsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a>

authenticator_groups_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#authenticator_groups_config GoogleContainerCluster#authenticator_groups_config}

---

##### `binary_authorization`<sup>Optional</sup> <a name="binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.binaryAuthorization"></a>

```python
binary_authorization: GoogleContainerClusterBinaryAuthorization
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a>

binary_authorization block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#binary_authorization GoogleContainerCluster#binary_authorization}

---

##### `cluster_autoscaling`<sup>Optional</sup> <a name="cluster_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.clusterAutoscaling"></a>

```python
cluster_autoscaling: GoogleContainerClusterClusterAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscaling">GoogleContainerClusterClusterAutoscaling</a>

cluster_autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_autoscaling GoogleContainerCluster#cluster_autoscaling}

---

##### `cluster_ipv4_cidr`<sup>Optional</sup> <a name="cluster_ipv4_cidr" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.clusterIpv4Cidr"></a>

```python
cluster_ipv4_cidr: str
```

- *Type:* str

The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_ipv4_cidr GoogleContainerCluster#cluster_ipv4_cidr}

---

##### `cluster_telemetry`<sup>Optional</sup> <a name="cluster_telemetry" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.clusterTelemetry"></a>

```python
cluster_telemetry: GoogleContainerClusterClusterTelemetry
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterTelemetry">GoogleContainerClusterClusterTelemetry</a>

cluster_telemetry block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_telemetry GoogleContainerCluster#cluster_telemetry}

---

##### `confidential_nodes`<sup>Optional</sup> <a name="confidential_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.confidentialNodes"></a>

```python
confidential_nodes: GoogleContainerClusterConfidentialNodes
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfidentialNodes">GoogleContainerClusterConfidentialNodes</a>

confidential_nodes block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#confidential_nodes GoogleContainerCluster#confidential_nodes}

---

##### `cost_management_config`<sup>Optional</sup> <a name="cost_management_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.costManagementConfig"></a>

```python
cost_management_config: GoogleContainerClusterCostManagementConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig">GoogleContainerClusterCostManagementConfig</a>

cost_management_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cost_management_config GoogleContainerCluster#cost_management_config}

---

##### `database_encryption`<sup>Optional</sup> <a name="database_encryption" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.databaseEncryption"></a>

```python
database_encryption: GoogleContainerClusterDatabaseEncryption
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption">GoogleContainerClusterDatabaseEncryption</a>

database_encryption block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#database_encryption GoogleContainerCluster#database_encryption}

---

##### `datapath_provider`<sup>Optional</sup> <a name="datapath_provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.datapathProvider"></a>

```python
datapath_provider: str
```

- *Type:* str

The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#datapath_provider GoogleContainerCluster#datapath_provider}

---

##### `default_max_pods_per_node`<sup>Optional</sup> <a name="default_max_pods_per_node" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.defaultMaxPodsPerNode"></a>

```python
default_max_pods_per_node: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The default maximum number of pods per node in this cluster.

This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#default_max_pods_per_node GoogleContainerCluster#default_max_pods_per_node}

---

##### `default_snat_status`<sup>Optional</sup> <a name="default_snat_status" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.defaultSnatStatus"></a>

```python
default_snat_status: GoogleContainerClusterDefaultSnatStatus
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus">GoogleContainerClusterDefaultSnatStatus</a>

default_snat_status block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#default_snat_status GoogleContainerCluster#default_snat_status}

---

##### `description`<sup>Optional</sup> <a name="description" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.description"></a>

```python
description: str
```

- *Type:* str

Description of the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#description GoogleContainerCluster#description}

---

##### `dns_config`<sup>Optional</sup> <a name="dns_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.dnsConfig"></a>

```python
dns_config: GoogleContainerClusterDnsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig">GoogleContainerClusterDnsConfig</a>

dns_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#dns_config GoogleContainerCluster#dns_config}

---

##### `enable_autopilot`<sup>Optional</sup> <a name="enable_autopilot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableAutopilot"></a>

```python
enable_autopilot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Autopilot for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_autopilot GoogleContainerCluster#enable_autopilot}

---

##### `enable_binary_authorization`<sup>Optional</sup> <a name="enable_binary_authorization" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableBinaryAuthorization"></a>

```python
enable_binary_authorization: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_binary_authorization GoogleContainerCluster#enable_binary_authorization}

---

##### `enable_intranode_visibility`<sup>Optional</sup> <a name="enable_intranode_visibility" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableIntranodeVisibility"></a>

```python
enable_intranode_visibility: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether Intra-node visibility is enabled for this cluster.

This makes same node pod to pod traffic visible for VPC network.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_intranode_visibility GoogleContainerCluster#enable_intranode_visibility}

---

##### `enable_kubernetes_alpha`<sup>Optional</sup> <a name="enable_kubernetes_alpha" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableKubernetesAlpha"></a>

```python
enable_kubernetes_alpha: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable Kubernetes Alpha features for this cluster.

Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_kubernetes_alpha GoogleContainerCluster#enable_kubernetes_alpha}

---

##### `enable_l4_ilb_subsetting`<sup>Optional</sup> <a name="enable_l4_ilb_subsetting" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableL4IlbSubsetting"></a>

```python
enable_l4_ilb_subsetting: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether L4ILB Subsetting is enabled for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_l4_ilb_subsetting GoogleContainerCluster#enable_l4_ilb_subsetting}

---

##### `enable_legacy_abac`<sup>Optional</sup> <a name="enable_legacy_abac" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableLegacyAbac"></a>

```python
enable_legacy_abac: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the ABAC authorizer is enabled for this cluster.

When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_legacy_abac GoogleContainerCluster#enable_legacy_abac}

---

##### `enable_shielded_nodes`<sup>Optional</sup> <a name="enable_shielded_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableShieldedNodes"></a>

```python
enable_shielded_nodes: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_shielded_nodes GoogleContainerCluster#enable_shielded_nodes}

---

##### `enable_tpu`<sup>Optional</sup> <a name="enable_tpu" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.enableTpu"></a>

```python
enable_tpu: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable Cloud TPU resources in this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_tpu GoogleContainerCluster#enable_tpu}

---

##### `gateway_api_config`<sup>Optional</sup> <a name="gateway_api_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.gatewayApiConfig"></a>

```python
gateway_api_config: GoogleContainerClusterGatewayApiConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig">GoogleContainerClusterGatewayApiConfig</a>

gateway_api_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gateway_api_config GoogleContainerCluster#gateway_api_config}

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#id GoogleContainerCluster#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `identity_service_config`<sup>Optional</sup> <a name="identity_service_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.identityServiceConfig"></a>

```python
identity_service_config: GoogleContainerClusterIdentityServiceConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig">GoogleContainerClusterIdentityServiceConfig</a>

identity_service_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#identity_service_config GoogleContainerCluster#identity_service_config}

---

##### `initial_node_count`<sup>Optional</sup> <a name="initial_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.initialNodeCount"></a>

```python
initial_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of nodes to create in this cluster's default node pool.

In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}

---

##### `ip_allocation_policy`<sup>Optional</sup> <a name="ip_allocation_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.ipAllocationPolicy"></a>

```python
ip_allocation_policy: GoogleContainerClusterIpAllocationPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy">GoogleContainerClusterIpAllocationPolicy</a>

ip_allocation_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ip_allocation_policy GoogleContainerCluster#ip_allocation_policy}

---

##### `location`<sup>Optional</sup> <a name="location" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.location"></a>

```python
location: str
```

- *Type:* str

The location (region or zone) in which the cluster master will be created, as well as the default node location.

If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#location GoogleContainerCluster#location}

---

##### `logging_config`<sup>Optional</sup> <a name="logging_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.loggingConfig"></a>

```python
logging_config: GoogleContainerClusterLoggingConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig">GoogleContainerClusterLoggingConfig</a>

logging_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_config GoogleContainerCluster#logging_config}

---

##### `logging_service`<sup>Optional</sup> <a name="logging_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.loggingService"></a>

```python
logging_service: str
```

- *Type:* str

The logging service that the cluster should write logs to.

Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_service GoogleContainerCluster#logging_service}

---

##### `maintenance_policy`<sup>Optional</sup> <a name="maintenance_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.maintenancePolicy"></a>

```python
maintenance_policy: GoogleContainerClusterMaintenancePolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy">GoogleContainerClusterMaintenancePolicy</a>

maintenance_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#maintenance_policy GoogleContainerCluster#maintenance_policy}

---

##### `master_auth`<sup>Optional</sup> <a name="master_auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.masterAuth"></a>

```python
master_auth: GoogleContainerClusterMasterAuth
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth">GoogleContainerClusterMasterAuth</a>

master_auth block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_auth GoogleContainerCluster#master_auth}

---

##### `master_authorized_networks_config`<sup>Optional</sup> <a name="master_authorized_networks_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.masterAuthorizedNetworksConfig"></a>

```python
master_authorized_networks_config: GoogleContainerClusterMasterAuthorizedNetworksConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig">GoogleContainerClusterMasterAuthorizedNetworksConfig</a>

master_authorized_networks_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_authorized_networks_config GoogleContainerCluster#master_authorized_networks_config}

---

##### `mesh_certificates`<sup>Optional</sup> <a name="mesh_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.meshCertificates"></a>

```python
mesh_certificates: GoogleContainerClusterMeshCertificates
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates">GoogleContainerClusterMeshCertificates</a>

mesh_certificates block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#mesh_certificates GoogleContainerCluster#mesh_certificates}

---

##### `min_master_version`<sup>Optional</sup> <a name="min_master_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.minMasterVersion"></a>

```python
min_master_version: str
```

- *Type:* str

The minimum version of the master.

GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_master_version GoogleContainerCluster#min_master_version}

---

##### `monitoring_config`<sup>Optional</sup> <a name="monitoring_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.monitoringConfig"></a>

```python
monitoring_config: GoogleContainerClusterMonitoringConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig">GoogleContainerClusterMonitoringConfig</a>

monitoring_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#monitoring_config GoogleContainerCluster#monitoring_config}

---

##### `monitoring_service`<sup>Optional</sup> <a name="monitoring_service" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.monitoringService"></a>

```python
monitoring_service: str
```

- *Type:* str

The monitoring service that the cluster should write metrics to.

Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#monitoring_service GoogleContainerCluster#monitoring_service}

---

##### `network`<sup>Optional</sup> <a name="network" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.network"></a>

```python
network: str
```

- *Type:* str

The name or self_link of the Google Compute Engine network to which the cluster is connected.

For Shared VPC, set this to the self link of the shared network.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network GoogleContainerCluster#network}

---

##### `networking_mode`<sup>Optional</sup> <a name="networking_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.networkingMode"></a>

```python
networking_mode: str
```

- *Type:* str

Determines whether alias IPs or routes will be used for pod IPs in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#networking_mode GoogleContainerCluster#networking_mode}

---

##### `network_policy`<sup>Optional</sup> <a name="network_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.networkPolicy"></a>

```python
network_policy: GoogleContainerClusterNetworkPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy">GoogleContainerClusterNetworkPolicy</a>

network_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_policy GoogleContainerCluster#network_policy}

---

##### `node_config`<sup>Optional</sup> <a name="node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodeConfig"></a>

```python
node_config: GoogleContainerClusterNodeConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig">GoogleContainerClusterNodeConfig</a>

node_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_config GoogleContainerCluster#node_config}

---

##### `node_locations`<sup>Optional</sup> <a name="node_locations" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodeLocations"></a>

```python
node_locations: typing.List[str]
```

- *Type:* typing.List[str]

The list of zones in which the cluster's nodes are located.

Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_locations GoogleContainerCluster#node_locations}

---

##### `node_pool`<sup>Optional</sup> <a name="node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodePool"></a>

```python
node_pool: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePool]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool">GoogleContainerClusterNodePool</a>]]

node_pool block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool GoogleContainerCluster#node_pool}

---

##### `node_pool_auto_config`<sup>Optional</sup> <a name="node_pool_auto_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodePoolAutoConfig"></a>

```python
node_pool_auto_config: GoogleContainerClusterNodePoolAutoConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig">GoogleContainerClusterNodePoolAutoConfig</a>

node_pool_auto_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool_auto_config GoogleContainerCluster#node_pool_auto_config}

---

##### `node_pool_defaults`<sup>Optional</sup> <a name="node_pool_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodePoolDefaults"></a>

```python
node_pool_defaults: GoogleContainerClusterNodePoolDefaults
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults">GoogleContainerClusterNodePoolDefaults</a>

node_pool_defaults block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool_defaults GoogleContainerCluster#node_pool_defaults}

---

##### `node_version`<sup>Optional</sup> <a name="node_version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.nodeVersion"></a>

```python
node_version: str
```

- *Type:* str

The Kubernetes version on the nodes.

Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_version GoogleContainerCluster#node_version}

---

##### `notification_config`<sup>Optional</sup> <a name="notification_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.notificationConfig"></a>

```python
notification_config: GoogleContainerClusterNotificationConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig">GoogleContainerClusterNotificationConfig</a>

notification_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#notification_config GoogleContainerCluster#notification_config}

---

##### `pod_security_policy_config`<sup>Optional</sup> <a name="pod_security_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.podSecurityPolicyConfig"></a>

```python
pod_security_policy_config: GoogleContainerClusterPodSecurityPolicyConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig">GoogleContainerClusterPodSecurityPolicyConfig</a>

pod_security_policy_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_security_policy_config GoogleContainerCluster#pod_security_policy_config}

---

##### `private_cluster_config`<sup>Optional</sup> <a name="private_cluster_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.privateClusterConfig"></a>

```python
private_cluster_config: GoogleContainerClusterPrivateClusterConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig">GoogleContainerClusterPrivateClusterConfig</a>

private_cluster_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#private_cluster_config GoogleContainerCluster#private_cluster_config}

---

##### `private_ipv6_google_access`<sup>Optional</sup> <a name="private_ipv6_google_access" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.privateIpv6GoogleAccess"></a>

```python
private_ipv6_google_access: str
```

- *Type:* str

The desired state of IPv6 connectivity to Google Services.

By default, no private IPv6 access to or from Google Services (all access will be via IPv4).

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#private_ipv6_google_access GoogleContainerCluster#private_ipv6_google_access}

---

##### `project`<sup>Optional</sup> <a name="project" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.project"></a>

```python
project: str
```

- *Type:* str

The ID of the project in which the resource belongs.

If it is not provided, the provider project is used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#project GoogleContainerCluster#project}

---

##### `protect_config`<sup>Optional</sup> <a name="protect_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.protectConfig"></a>

```python
protect_config: GoogleContainerClusterProtectConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig">GoogleContainerClusterProtectConfig</a>

protect_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#protect_config GoogleContainerCluster#protect_config}

---

##### `release_channel`<sup>Optional</sup> <a name="release_channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.releaseChannel"></a>

```python
release_channel: GoogleContainerClusterReleaseChannel
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel">GoogleContainerClusterReleaseChannel</a>

release_channel block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#release_channel GoogleContainerCluster#release_channel}

---

##### `remove_default_node_pool`<sup>Optional</sup> <a name="remove_default_node_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.removeDefaultNodePool"></a>

```python
remove_default_node_pool: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

If true, deletes the default node pool upon cluster creation.

If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#remove_default_node_pool GoogleContainerCluster#remove_default_node_pool}

---

##### `resource_labels`<sup>Optional</sup> <a name="resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.resourceLabels"></a>

```python
resource_labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The GCE resource labels (a map of key/value pairs) to be applied to the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}

---

##### `resource_usage_export_config`<sup>Optional</sup> <a name="resource_usage_export_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.resourceUsageExportConfig"></a>

```python
resource_usage_export_config: GoogleContainerClusterResourceUsageExportConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig">GoogleContainerClusterResourceUsageExportConfig</a>

resource_usage_export_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_usage_export_config GoogleContainerCluster#resource_usage_export_config}

---

##### `service_external_ips_config`<sup>Optional</sup> <a name="service_external_ips_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.serviceExternalIpsConfig"></a>

```python
service_external_ips_config: GoogleContainerClusterServiceExternalIpsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig">GoogleContainerClusterServiceExternalIpsConfig</a>

service_external_ips_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#service_external_ips_config GoogleContainerCluster#service_external_ips_config}

---

##### `subnetwork`<sup>Optional</sup> <a name="subnetwork" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.subnetwork"></a>

```python
subnetwork: str
```

- *Type:* str

The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#subnetwork GoogleContainerCluster#subnetwork}

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.timeouts"></a>

```python
timeouts: GoogleContainerClusterTimeouts
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts">GoogleContainerClusterTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#timeouts GoogleContainerCluster#timeouts}

---

##### `tpu_config`<sup>Optional</sup> <a name="tpu_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.tpuConfig"></a>

```python
tpu_config: GoogleContainerClusterTpuConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig">GoogleContainerClusterTpuConfig</a>

tpu_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#tpu_config GoogleContainerCluster#tpu_config}

---

##### `vertical_pod_autoscaling`<sup>Optional</sup> <a name="vertical_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.verticalPodAutoscaling"></a>

```python
vertical_pod_autoscaling: GoogleContainerClusterVerticalPodAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling">GoogleContainerClusterVerticalPodAutoscaling</a>

vertical_pod_autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#vertical_pod_autoscaling GoogleContainerCluster#vertical_pod_autoscaling}

---

##### `workload_identity_config`<sup>Optional</sup> <a name="workload_identity_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterConfig.property.workloadIdentityConfig"></a>

```python
workload_identity_config: GoogleContainerClusterWorkloadIdentityConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig">GoogleContainerClusterWorkloadIdentityConfig</a>

workload_identity_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_identity_config GoogleContainerCluster#workload_identity_config}

---

### GoogleContainerClusterCostManagementConfig <a name="GoogleContainerClusterCostManagementConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterCostManagementConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable GKE cost allocation. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterCostManagementConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable GKE cost allocation.

When you enable GKE cost allocation, the cluster name and namespace of your GKE workloads appear in the labels field of the billing export to BigQuery. Defaults to false.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterDatabaseEncryption <a name="GoogleContainerClusterDatabaseEncryption" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterDatabaseEncryption(
  state: str,
  key_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption.property.state">state</a></code> | <code>str</code> | ENCRYPTED or DECRYPTED. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption.property.keyName">key_name</a></code> | <code>str</code> | The key to use to encrypt/decrypt secrets. |

---

##### `state`<sup>Required</sup> <a name="state" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption.property.state"></a>

```python
state: str
```

- *Type:* str

ENCRYPTED or DECRYPTED.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#state GoogleContainerCluster#state}

---

##### `key_name`<sup>Optional</sup> <a name="key_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDatabaseEncryption.property.keyName"></a>

```python
key_name: str
```

- *Type:* str

The key to use to encrypt/decrypt secrets.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key_name GoogleContainerCluster#key_name}

---

### GoogleContainerClusterDefaultSnatStatus <a name="GoogleContainerClusterDefaultSnatStatus" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterDefaultSnatStatus(
  disabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDefaultSnatStatus.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}

---

### GoogleContainerClusterDnsConfig <a name="GoogleContainerClusterDnsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterDnsConfig(
  cluster_dns: str = None,
  cluster_dns_domain: str = None,
  cluster_dns_scope: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.property.clusterDns">cluster_dns</a></code> | <code>str</code> | Which in-cluster DNS provider should be used. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.property.clusterDnsDomain">cluster_dns_domain</a></code> | <code>str</code> | The suffix used for all cluster service records. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.property.clusterDnsScope">cluster_dns_scope</a></code> | <code>str</code> | The scope of access to cluster DNS records. |

---

##### `cluster_dns`<sup>Optional</sup> <a name="cluster_dns" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.property.clusterDns"></a>

```python
cluster_dns: str
```

- *Type:* str

Which in-cluster DNS provider should be used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_dns GoogleContainerCluster#cluster_dns}

---

##### `cluster_dns_domain`<sup>Optional</sup> <a name="cluster_dns_domain" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.property.clusterDnsDomain"></a>

```python
cluster_dns_domain: str
```

- *Type:* str

The suffix used for all cluster service records.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_dns_domain GoogleContainerCluster#cluster_dns_domain}

---

##### `cluster_dns_scope`<sup>Optional</sup> <a name="cluster_dns_scope" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterDnsConfig.property.clusterDnsScope"></a>

```python
cluster_dns_scope: str
```

- *Type:* str

The scope of access to cluster DNS records.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_dns_scope GoogleContainerCluster#cluster_dns_scope}

---

### GoogleContainerClusterGatewayApiConfig <a name="GoogleContainerClusterGatewayApiConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterGatewayApiConfig(
  channel: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig.property.channel">channel</a></code> | <code>str</code> | The Gateway API release channel to use for Gateway API. |

---

##### `channel`<sup>Required</sup> <a name="channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterGatewayApiConfig.property.channel"></a>

```python
channel: str
```

- *Type:* str

The Gateway API release channel to use for Gateway API.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#channel GoogleContainerCluster#channel}

---

### GoogleContainerClusterIdentityServiceConfig <a name="GoogleContainerClusterIdentityServiceConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterIdentityServiceConfig(
  enabled: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable the Identity Service component. |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIdentityServiceConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable the Identity Service component.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterIpAllocationPolicy <a name="GoogleContainerClusterIpAllocationPolicy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterIpAllocationPolicy(
  cluster_ipv4_cidr_block: str = None,
  cluster_secondary_range_name: str = None,
  pod_cidr_overprovision_config: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig = None,
  services_ipv4_cidr_block: str = None,
  services_secondary_range_name: str = None,
  stack_type: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.clusterIpv4CidrBlock">cluster_ipv4_cidr_block</a></code> | <code>str</code> | The IP address range for the cluster pod IPs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.clusterSecondaryRangeName">cluster_secondary_range_name</a></code> | <code>str</code> | The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.podCidrOverprovisionConfig">pod_cidr_overprovision_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig">GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig</a></code> | pod_cidr_overprovision_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.servicesIpv4CidrBlock">services_ipv4_cidr_block</a></code> | <code>str</code> | The IP address range of the services IPs in this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.servicesSecondaryRangeName">services_secondary_range_name</a></code> | <code>str</code> | The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.stackType">stack_type</a></code> | <code>str</code> | The IP Stack type of the cluster. |

---

##### `cluster_ipv4_cidr_block`<sup>Optional</sup> <a name="cluster_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.clusterIpv4CidrBlock"></a>

```python
cluster_ipv4_cidr_block: str
```

- *Type:* str

The IP address range for the cluster pod IPs.

Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_ipv4_cidr_block GoogleContainerCluster#cluster_ipv4_cidr_block}

---

##### `cluster_secondary_range_name`<sup>Optional</sup> <a name="cluster_secondary_range_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.clusterSecondaryRangeName"></a>

```python
cluster_secondary_range_name: str
```

- *Type:* str

The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses.

Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cluster_secondary_range_name GoogleContainerCluster#cluster_secondary_range_name}

---

##### `pod_cidr_overprovision_config`<sup>Optional</sup> <a name="pod_cidr_overprovision_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.podCidrOverprovisionConfig"></a>

```python
pod_cidr_overprovision_config: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig">GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig</a>

pod_cidr_overprovision_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_cidr_overprovision_config GoogleContainerCluster#pod_cidr_overprovision_config}

---

##### `services_ipv4_cidr_block`<sup>Optional</sup> <a name="services_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.servicesIpv4CidrBlock"></a>

```python
services_ipv4_cidr_block: str
```

- *Type:* str

The IP address range of the services IPs in this cluster.

Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#services_ipv4_cidr_block GoogleContainerCluster#services_ipv4_cidr_block}

---

##### `services_secondary_range_name`<sup>Optional</sup> <a name="services_secondary_range_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.servicesSecondaryRangeName"></a>

```python
services_secondary_range_name: str
```

- *Type:* str

The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs.

Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#services_secondary_range_name GoogleContainerCluster#services_secondary_range_name}

---

##### `stack_type`<sup>Optional</sup> <a name="stack_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicy.property.stackType"></a>

```python
stack_type: str
```

- *Type:* str

The IP Stack type of the cluster.

Choose between IPV4 and IPV4_IPV6. Default type is IPV4 Only if not set

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#stack_type GoogleContainerCluster#stack_type}

---

### GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig <a name="GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig(
  disabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

### GoogleContainerClusterLoggingConfig <a name="GoogleContainerClusterLoggingConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterLoggingConfig(
  enable_components: typing.List[str]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig.property.enableComponents">enable_components</a></code> | <code>typing.List[str]</code> | GKE components exposing logs. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS. |

---

##### `enable_components`<sup>Required</sup> <a name="enable_components" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterLoggingConfig.property.enableComponents"></a>

```python
enable_components: typing.List[str]
```

- *Type:* typing.List[str]

GKE components exposing logs. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_components GoogleContainerCluster#enable_components}

---

### GoogleContainerClusterMaintenancePolicy <a name="GoogleContainerClusterMaintenancePolicy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMaintenancePolicy(
  daily_maintenance_window: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow = None,
  maintenance_exclusion: typing.Union[IResolvable, typing.List[GoogleContainerClusterMaintenancePolicyMaintenanceExclusion]] = None,
  recurring_window: GoogleContainerClusterMaintenancePolicyRecurringWindow = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.property.dailyMaintenanceWindow">daily_maintenance_window</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow">GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow</a></code> | daily_maintenance_window block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.property.maintenanceExclusion">maintenance_exclusion</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion">GoogleContainerClusterMaintenancePolicyMaintenanceExclusion</a>]]</code> | maintenance_exclusion block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.property.recurringWindow">recurring_window</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow">GoogleContainerClusterMaintenancePolicyRecurringWindow</a></code> | recurring_window block. |

---

##### `daily_maintenance_window`<sup>Optional</sup> <a name="daily_maintenance_window" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.property.dailyMaintenanceWindow"></a>

```python
daily_maintenance_window: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow">GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow</a>

daily_maintenance_window block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#daily_maintenance_window GoogleContainerCluster#daily_maintenance_window}

---

##### `maintenance_exclusion`<sup>Optional</sup> <a name="maintenance_exclusion" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.property.maintenanceExclusion"></a>

```python
maintenance_exclusion: typing.Union[IResolvable, typing.List[GoogleContainerClusterMaintenancePolicyMaintenanceExclusion]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion">GoogleContainerClusterMaintenancePolicyMaintenanceExclusion</a>]]

maintenance_exclusion block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#maintenance_exclusion GoogleContainerCluster#maintenance_exclusion}

---

##### `recurring_window`<sup>Optional</sup> <a name="recurring_window" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicy.property.recurringWindow"></a>

```python
recurring_window: GoogleContainerClusterMaintenancePolicyRecurringWindow
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow">GoogleContainerClusterMaintenancePolicyRecurringWindow</a>

recurring_window block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#recurring_window GoogleContainerCluster#recurring_window}

---

### GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow <a name="GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow(
  start_time: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow.property.startTime">start_time</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}. |

---

##### `start_time`<sup>Required</sup> <a name="start_time" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow.property.startTime"></a>

```python
start_time: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}.

---

### GoogleContainerClusterMaintenancePolicyMaintenanceExclusion <a name="GoogleContainerClusterMaintenancePolicyMaintenanceExclusion" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion(
  end_time: str,
  exclusion_name: str,
  start_time: str,
  exclusion_options: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.endTime">end_time</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#end_time GoogleContainerCluster#end_time}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionName">exclusion_name</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#exclusion_name GoogleContainerCluster#exclusion_name}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.startTime">start_time</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionOptions">exclusion_options</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions">GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions</a></code> | exclusion_options block. |

---

##### `end_time`<sup>Required</sup> <a name="end_time" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.endTime"></a>

```python
end_time: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#end_time GoogleContainerCluster#end_time}.

---

##### `exclusion_name`<sup>Required</sup> <a name="exclusion_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionName"></a>

```python
exclusion_name: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#exclusion_name GoogleContainerCluster#exclusion_name}.

---

##### `start_time`<sup>Required</sup> <a name="start_time" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.startTime"></a>

```python
start_time: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}.

---

##### `exclusion_options`<sup>Optional</sup> <a name="exclusion_options" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionOptions"></a>

```python
exclusion_options: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions">GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions</a>

exclusion_options block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#exclusion_options GoogleContainerCluster#exclusion_options}

---

### GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions <a name="GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions(
  scope: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.property.scope">scope</a></code> | <code>str</code> | The scope of automatic upgrades to restrict in the exclusion window. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.property.scope"></a>

```python
scope: str
```

- *Type:* str

The scope of automatic upgrades to restrict in the exclusion window.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#scope GoogleContainerCluster#scope}

---

### GoogleContainerClusterMaintenancePolicyRecurringWindow <a name="GoogleContainerClusterMaintenancePolicyRecurringWindow" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow(
  end_time: str,
  recurrence: str,
  start_time: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.property.endTime">end_time</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#end_time GoogleContainerCluster#end_time}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.property.recurrence">recurrence</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#recurrence GoogleContainerCluster#recurrence}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.property.startTime">start_time</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}. |

---

##### `end_time`<sup>Required</sup> <a name="end_time" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.property.endTime"></a>

```python
end_time: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#end_time GoogleContainerCluster#end_time}.

---

##### `recurrence`<sup>Required</sup> <a name="recurrence" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.property.recurrence"></a>

```python
recurrence: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#recurrence GoogleContainerCluster#recurrence}.

---

##### `start_time`<sup>Required</sup> <a name="start_time" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMaintenancePolicyRecurringWindow.property.startTime"></a>

```python
start_time: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}.

---

### GoogleContainerClusterMasterAuth <a name="GoogleContainerClusterMasterAuth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMasterAuth(
  client_certificate_config: GoogleContainerClusterMasterAuthClientCertificateConfig
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth.property.clientCertificateConfig">client_certificate_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig">GoogleContainerClusterMasterAuthClientCertificateConfig</a></code> | client_certificate_config block. |

---

##### `client_certificate_config`<sup>Required</sup> <a name="client_certificate_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuth.property.clientCertificateConfig"></a>

```python
client_certificate_config: GoogleContainerClusterMasterAuthClientCertificateConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig">GoogleContainerClusterMasterAuthClientCertificateConfig</a>

client_certificate_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#client_certificate_config GoogleContainerCluster#client_certificate_config}

---

### GoogleContainerClusterMasterAuthClientCertificateConfig <a name="GoogleContainerClusterMasterAuthClientCertificateConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig(
  issue_client_certificate: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig.property.issueClientCertificate">issue_client_certificate</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether client certificate authorization is enabled for this cluster. |

---

##### `issue_client_certificate`<sup>Required</sup> <a name="issue_client_certificate" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthClientCertificateConfig.property.issueClientCertificate"></a>

```python
issue_client_certificate: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether client certificate authorization is enabled for this cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#issue_client_certificate GoogleContainerCluster#issue_client_certificate}

---

### GoogleContainerClusterMasterAuthorizedNetworksConfig <a name="GoogleContainerClusterMasterAuthorizedNetworksConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig(
  cidr_blocks: typing.Union[IResolvable, typing.List[GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks]] = None,
  gcp_public_cidrs_access_enabled: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig.property.cidrBlocks">cidr_blocks</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks">GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks</a>]]</code> | cidr_blocks block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig.property.gcpPublicCidrsAccessEnabled">gcp_public_cidrs_access_enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether master is accessbile via Google Compute Engine Public IP addresses. |

---

##### `cidr_blocks`<sup>Optional</sup> <a name="cidr_blocks" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig.property.cidrBlocks"></a>

```python
cidr_blocks: typing.Union[IResolvable, typing.List[GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks">GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks</a>]]

cidr_blocks block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cidr_blocks GoogleContainerCluster#cidr_blocks}

---

##### `gcp_public_cidrs_access_enabled`<sup>Optional</sup> <a name="gcp_public_cidrs_access_enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfig.property.gcpPublicCidrsAccessEnabled"></a>

```python
gcp_public_cidrs_access_enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether master is accessbile via Google Compute Engine Public IP addresses.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcp_public_cidrs_access_enabled GoogleContainerCluster#gcp_public_cidrs_access_enabled}

---

### GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks <a name="GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks(
  cidr_block: str,
  display_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.cidrBlock">cidr_block</a></code> | <code>str</code> | External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.displayName">display_name</a></code> | <code>str</code> | Field for users to identify CIDR blocks. |

---

##### `cidr_block`<sup>Required</sup> <a name="cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.cidrBlock"></a>

```python
cidr_block: str
```

- *Type:* str

External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cidr_block GoogleContainerCluster#cidr_block}

---

##### `display_name`<sup>Optional</sup> <a name="display_name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.displayName"></a>

```python
display_name: str
```

- *Type:* str

Field for users to identify CIDR blocks.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#display_name GoogleContainerCluster#display_name}

---

### GoogleContainerClusterMeshCertificates <a name="GoogleContainerClusterMeshCertificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMeshCertificates(
  enable_certificates: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates.property.enableCertificates">enable_certificates</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster. |

---

##### `enable_certificates`<sup>Required</sup> <a name="enable_certificates" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMeshCertificates.property.enableCertificates"></a>

```python
enable_certificates: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_certificates GoogleContainerCluster#enable_certificates}

---

### GoogleContainerClusterMonitoringConfig <a name="GoogleContainerClusterMonitoringConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMonitoringConfig(
  enable_components: typing.List[str] = None,
  managed_prometheus: GoogleContainerClusterMonitoringConfigManagedPrometheus = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig.property.enableComponents">enable_components</a></code> | <code>typing.List[str]</code> | GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig.property.managedPrometheus">managed_prometheus</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus">GoogleContainerClusterMonitoringConfigManagedPrometheus</a></code> | managed_prometheus block. |

---

##### `enable_components`<sup>Optional</sup> <a name="enable_components" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig.property.enableComponents"></a>

```python
enable_components: typing.List[str]
```

- *Type:* typing.List[str]

GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_components GoogleContainerCluster#enable_components}

---

##### `managed_prometheus`<sup>Optional</sup> <a name="managed_prometheus" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfig.property.managedPrometheus"></a>

```python
managed_prometheus: GoogleContainerClusterMonitoringConfigManagedPrometheus
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus">GoogleContainerClusterMonitoringConfigManagedPrometheus</a>

managed_prometheus block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#managed_prometheus GoogleContainerCluster#managed_prometheus}

---

### GoogleContainerClusterMonitoringConfigManagedPrometheus <a name="GoogleContainerClusterMonitoringConfigManagedPrometheus" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not the managed collection is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterMonitoringConfigManagedPrometheus.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not the managed collection is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterNetworkPolicy <a name="GoogleContainerClusterNetworkPolicy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNetworkPolicy(
  enabled: typing.Union[bool, IResolvable],
  provider: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether network policy is enabled on the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy.property.provider">provider</a></code> | <code>str</code> | The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether network policy is enabled on the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNetworkPolicy.property.provider"></a>

```python
provider: str
```

- *Type:* str

The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#provider GoogleContainerCluster#provider}

---

### GoogleContainerClusterNodeConfig <a name="GoogleContainerClusterNodeConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfig(
  advanced_machine_features: GoogleContainerClusterNodeConfigAdvancedMachineFeatures = None,
  boot_disk_kms_key: str = None,
  disk_size_gb: typing.Union[int, float] = None,
  disk_type: str = None,
  ephemeral_storage_config: GoogleContainerClusterNodeConfigEphemeralStorageConfig = None,
  ephemeral_storage_local_ssd_config: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig = None,
  gcfs_config: GoogleContainerClusterNodeConfigGcfsConfig = None,
  guest_accelerator: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigGuestAccelerator]] = None,
  gvnic: GoogleContainerClusterNodeConfigGvnic = None,
  image_type: str = None,
  kubelet_config: GoogleContainerClusterNodeConfigKubeletConfig = None,
  labels: typing.Mapping[str] = None,
  linux_node_config: GoogleContainerClusterNodeConfigLinuxNodeConfig = None,
  local_nvme_ssd_block_config: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig = None,
  local_ssd_count: typing.Union[int, float] = None,
  logging_variant: str = None,
  machine_type: str = None,
  metadata: typing.Mapping[str] = None,
  min_cpu_platform: str = None,
  node_group: str = None,
  oauth_scopes: typing.List[str] = None,
  preemptible: typing.Union[bool, IResolvable] = None,
  reservation_affinity: GoogleContainerClusterNodeConfigReservationAffinity = None,
  resource_labels: typing.Mapping[str] = None,
  sandbox_config: GoogleContainerClusterNodeConfigSandboxConfig = None,
  service_account: str = None,
  shielded_instance_config: GoogleContainerClusterNodeConfigShieldedInstanceConfig = None,
  spot: typing.Union[bool, IResolvable] = None,
  tags: typing.List[str] = None,
  taint: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigTaint]] = None,
  workload_metadata_config: GoogleContainerClusterNodeConfigWorkloadMetadataConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.advancedMachineFeatures">advanced_machine_features</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures">GoogleContainerClusterNodeConfigAdvancedMachineFeatures</a></code> | advanced_machine_features block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.bootDiskKmsKey">boot_disk_kms_key</a></code> | <code>str</code> | The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.diskSizeGb">disk_size_gb</a></code> | <code>typing.Union[int, float]</code> | Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.diskType">disk_type</a></code> | <code>str</code> | Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.ephemeralStorageConfig">ephemeral_storage_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig">GoogleContainerClusterNodeConfigEphemeralStorageConfig</a></code> | ephemeral_storage_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.ephemeralStorageLocalSsdConfig">ephemeral_storage_local_ssd_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig">GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig</a></code> | ephemeral_storage_local_ssd_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.gcfsConfig">gcfs_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig">GoogleContainerClusterNodeConfigGcfsConfig</a></code> | gcfs_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.guestAccelerator">guest_accelerator</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator">GoogleContainerClusterNodeConfigGuestAccelerator</a>]]</code> | List of the type and count of accelerator cards attached to the instance. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.gvnic">gvnic</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic">GoogleContainerClusterNodeConfigGvnic</a></code> | gvnic block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.imageType">image_type</a></code> | <code>str</code> | The image type to use for this node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.kubeletConfig">kubelet_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig">GoogleContainerClusterNodeConfigKubeletConfig</a></code> | kubelet_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.labels">labels</a></code> | <code>typing.Mapping[str]</code> | The map of Kubernetes labels (key/value pairs) to be applied to each node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.linuxNodeConfig">linux_node_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig">GoogleContainerClusterNodeConfigLinuxNodeConfig</a></code> | linux_node_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.localNvmeSsdBlockConfig">local_nvme_ssd_block_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig">GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig</a></code> | local_nvme_ssd_block_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | The number of local SSD disks to be attached to the node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.loggingVariant">logging_variant</a></code> | <code>str</code> | Type of logging agent that is used as the default value for node pools in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.machineType">machine_type</a></code> | <code>str</code> | The name of a Google Compute Engine machine type. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.metadata">metadata</a></code> | <code>typing.Mapping[str]</code> | The metadata key/value pairs assigned to instances in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.minCpuPlatform">min_cpu_platform</a></code> | <code>str</code> | Minimum CPU platform to be used by this instance. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.nodeGroup">node_group</a></code> | <code>str</code> | Setting this field will assign instances of this pool to run on the specified node group. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.oauthScopes">oauth_scopes</a></code> | <code>typing.List[str]</code> | The set of Google API scopes to be made available on all of the node VMs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.preemptible">preemptible</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the nodes are created as preemptible VM instances. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.reservationAffinity">reservation_affinity</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity">GoogleContainerClusterNodeConfigReservationAffinity</a></code> | reservation_affinity block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.resourceLabels">resource_labels</a></code> | <code>typing.Mapping[str]</code> | The GCE resource labels (a map of key/value pairs) to be applied to the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.sandboxConfig">sandbox_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig">GoogleContainerClusterNodeConfigSandboxConfig</a></code> | sandbox_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.serviceAccount">service_account</a></code> | <code>str</code> | The Google Cloud Platform Service Account to be used by the node VMs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.shieldedInstanceConfig">shielded_instance_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig">GoogleContainerClusterNodeConfigShieldedInstanceConfig</a></code> | shielded_instance_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.spot">spot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the nodes are created as spot VM instances. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.tags">tags</a></code> | <code>typing.List[str]</code> | The list of instance tags applied to all nodes. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.taint">taint</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint">GoogleContainerClusterNodeConfigTaint</a>]]</code> | List of Kubernetes taints to be applied to each node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.workloadMetadataConfig">workload_metadata_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig">GoogleContainerClusterNodeConfigWorkloadMetadataConfig</a></code> | workload_metadata_config block. |

---

##### `advanced_machine_features`<sup>Optional</sup> <a name="advanced_machine_features" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.advancedMachineFeatures"></a>

```python
advanced_machine_features: GoogleContainerClusterNodeConfigAdvancedMachineFeatures
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures">GoogleContainerClusterNodeConfigAdvancedMachineFeatures</a>

advanced_machine_features block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#advanced_machine_features GoogleContainerCluster#advanced_machine_features}

---

##### `boot_disk_kms_key`<sup>Optional</sup> <a name="boot_disk_kms_key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.bootDiskKmsKey"></a>

```python
boot_disk_kms_key: str
```

- *Type:* str

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}

---

##### `disk_size_gb`<sup>Optional</sup> <a name="disk_size_gb" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.diskSizeGb"></a>

```python
disk_size_gb: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}

---

##### `disk_type`<sup>Optional</sup> <a name="disk_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.diskType"></a>

```python
disk_type: str
```

- *Type:* str

Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}

---

##### `ephemeral_storage_config`<sup>Optional</sup> <a name="ephemeral_storage_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.ephemeralStorageConfig"></a>

```python
ephemeral_storage_config: GoogleContainerClusterNodeConfigEphemeralStorageConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig">GoogleContainerClusterNodeConfigEphemeralStorageConfig</a>

ephemeral_storage_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}

---

##### `ephemeral_storage_local_ssd_config`<sup>Optional</sup> <a name="ephemeral_storage_local_ssd_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.ephemeralStorageLocalSsdConfig"></a>

```python
ephemeral_storage_local_ssd_config: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig">GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig</a>

ephemeral_storage_local_ssd_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ephemeral_storage_local_ssd_config GoogleContainerCluster#ephemeral_storage_local_ssd_config}

---

##### `gcfs_config`<sup>Optional</sup> <a name="gcfs_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.gcfsConfig"></a>

```python
gcfs_config: GoogleContainerClusterNodeConfigGcfsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig">GoogleContainerClusterNodeConfigGcfsConfig</a>

gcfs_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}

---

##### `guest_accelerator`<sup>Optional</sup> <a name="guest_accelerator" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.guestAccelerator"></a>

```python
guest_accelerator: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigGuestAccelerator]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator">GoogleContainerClusterNodeConfigGuestAccelerator</a>]]

List of the type and count of accelerator cards attached to the instance.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}

---

##### `gvnic`<sup>Optional</sup> <a name="gvnic" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.gvnic"></a>

```python
gvnic: GoogleContainerClusterNodeConfigGvnic
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic">GoogleContainerClusterNodeConfigGvnic</a>

gvnic block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gvnic GoogleContainerCluster#gvnic}

---

##### `image_type`<sup>Optional</sup> <a name="image_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.imageType"></a>

```python
image_type: str
```

- *Type:* str

The image type to use for this node.

Note that for a given image type, the latest version of it will be used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}

---

##### `kubelet_config`<sup>Optional</sup> <a name="kubelet_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.kubeletConfig"></a>

```python
kubelet_config: GoogleContainerClusterNodeConfigKubeletConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig">GoogleContainerClusterNodeConfigKubeletConfig</a>

kubelet_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}

---

##### `labels`<sup>Optional</sup> <a name="labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.labels"></a>

```python
labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The map of Kubernetes labels (key/value pairs) to be applied to each node.

These will added in addition to any default label(s) that Kubernetes may apply to the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#labels GoogleContainerCluster#labels}

---

##### `linux_node_config`<sup>Optional</sup> <a name="linux_node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.linuxNodeConfig"></a>

```python
linux_node_config: GoogleContainerClusterNodeConfigLinuxNodeConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig">GoogleContainerClusterNodeConfigLinuxNodeConfig</a>

linux_node_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}

---

##### `local_nvme_ssd_block_config`<sup>Optional</sup> <a name="local_nvme_ssd_block_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.localNvmeSsdBlockConfig"></a>

```python
local_nvme_ssd_block_config: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig">GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig</a>

local_nvme_ssd_block_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_nvme_ssd_block_config GoogleContainerCluster#local_nvme_ssd_block_config}

---

##### `local_ssd_count`<sup>Optional</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of local SSD disks to be attached to the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

##### `logging_variant`<sup>Optional</sup> <a name="logging_variant" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.loggingVariant"></a>

```python
logging_variant: str
```

- *Type:* str

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}

---

##### `machine_type`<sup>Optional</sup> <a name="machine_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.machineType"></a>

```python
machine_type: str
```

- *Type:* str

The name of a Google Compute Engine machine type.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#machine_type GoogleContainerCluster#machine_type}

---

##### `metadata`<sup>Optional</sup> <a name="metadata" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.metadata"></a>

```python
metadata: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The metadata key/value pairs assigned to instances in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#metadata GoogleContainerCluster#metadata}

---

##### `min_cpu_platform`<sup>Optional</sup> <a name="min_cpu_platform" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.minCpuPlatform"></a>

```python
min_cpu_platform: str
```

- *Type:* str

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}

---

##### `node_group`<sup>Optional</sup> <a name="node_group" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.nodeGroup"></a>

```python
node_group: str
```

- *Type:* str

Setting this field will assign instances of this pool to run on the specified node group.

This is useful for running workloads on sole tenant nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_group GoogleContainerCluster#node_group}

---

##### `oauth_scopes`<sup>Optional</sup> <a name="oauth_scopes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.oauthScopes"></a>

```python
oauth_scopes: typing.List[str]
```

- *Type:* typing.List[str]

The set of Google API scopes to be made available on all of the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}

---

##### `preemptible`<sup>Optional</sup> <a name="preemptible" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.preemptible"></a>

```python
preemptible: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes are created as preemptible VM instances.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#preemptible GoogleContainerCluster#preemptible}

---

##### `reservation_affinity`<sup>Optional</sup> <a name="reservation_affinity" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.reservationAffinity"></a>

```python
reservation_affinity: GoogleContainerClusterNodeConfigReservationAffinity
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity">GoogleContainerClusterNodeConfigReservationAffinity</a>

reservation_affinity block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}

---

##### `resource_labels`<sup>Optional</sup> <a name="resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.resourceLabels"></a>

```python
resource_labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The GCE resource labels (a map of key/value pairs) to be applied to the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}

---

##### `sandbox_config`<sup>Optional</sup> <a name="sandbox_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.sandboxConfig"></a>

```python
sandbox_config: GoogleContainerClusterNodeConfigSandboxConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig">GoogleContainerClusterNodeConfigSandboxConfig</a>

sandbox_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}

---

##### `service_account`<sup>Optional</sup> <a name="service_account" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.serviceAccount"></a>

```python
service_account: str
```

- *Type:* str

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}

---

##### `shielded_instance_config`<sup>Optional</sup> <a name="shielded_instance_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.shieldedInstanceConfig"></a>

```python
shielded_instance_config: GoogleContainerClusterNodeConfigShieldedInstanceConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig">GoogleContainerClusterNodeConfigShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}

---

##### `spot`<sup>Optional</sup> <a name="spot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.spot"></a>

```python
spot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes are created as spot VM instances.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#spot GoogleContainerCluster#spot}

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.tags"></a>

```python
tags: typing.List[str]
```

- *Type:* typing.List[str]

The list of instance tags applied to all nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}

---

##### `taint`<sup>Optional</sup> <a name="taint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.taint"></a>

```python
taint: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigTaint]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint">GoogleContainerClusterNodeConfigTaint</a>]]

List of Kubernetes taints to be applied to each node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#taint GoogleContainerCluster#taint}

---

##### `workload_metadata_config`<sup>Optional</sup> <a name="workload_metadata_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfig.property.workloadMetadataConfig"></a>

```python
workload_metadata_config: GoogleContainerClusterNodeConfigWorkloadMetadataConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig">GoogleContainerClusterNodeConfigWorkloadMetadataConfig</a>

workload_metadata_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}

---

### GoogleContainerClusterNodeConfigAdvancedMachineFeatures <a name="GoogleContainerClusterNodeConfigAdvancedMachineFeatures" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures(
  threads_per_core: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures.property.threadsPerCore">threads_per_core</a></code> | <code>typing.Union[int, float]</code> | The number of threads per physical core. |

---

##### `threads_per_core`<sup>Required</sup> <a name="threads_per_core" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigAdvancedMachineFeatures.property.threadsPerCore"></a>

```python
threads_per_core: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of threads per physical core.

To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#threads_per_core GoogleContainerCluster#threads_per_core}

---

### GoogleContainerClusterNodeConfigEphemeralStorageConfig <a name="GoogleContainerClusterNodeConfigEphemeralStorageConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig(
  local_ssd_count: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | Number of local SSDs to use to back ephemeral storage. |

---

##### `local_ssd_count`<sup>Required</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of local SSDs to use to back ephemeral storage.

Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

### GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig <a name="GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig(
  local_ssd_count: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | Number of local SSDs to use to back ephemeral storage. |

---

##### `local_ssd_count`<sup>Required</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of local SSDs to use to back ephemeral storage.

Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

### GoogleContainerClusterNodeConfigGcfsConfig <a name="GoogleContainerClusterNodeConfigGcfsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not GCFS is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGcfsConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not GCFS is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterNodeConfigGuestAccelerator <a name="GoogleContainerClusterNodeConfigGuestAccelerator" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator(
  count: typing.Union[int, float] = None,
  gpu_partition_size: str = None,
  gpu_sharing_config: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig]] = None,
  type: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.count">count</a></code> | <code>typing.Union[int, float]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#count GoogleContainerCluster#count}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.gpuPartitionSize">gpu_partition_size</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.gpuSharingConfig">gpu_sharing_config</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig">GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig</a>]]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_config GoogleContainerCluster#gpu_sharing_config}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.type">type</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}. |

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.count"></a>

```python
count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#count GoogleContainerCluster#count}.

---

##### `gpu_partition_size`<sup>Optional</sup> <a name="gpu_partition_size" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.gpuPartitionSize"></a>

```python
gpu_partition_size: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}.

---

##### `gpu_sharing_config`<sup>Optional</sup> <a name="gpu_sharing_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.gpuSharingConfig"></a>

```python
gpu_sharing_config: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig">GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig</a>]]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_config GoogleContainerCluster#gpu_sharing_config}.

---

##### `type`<sup>Optional</sup> <a name="type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAccelerator.property.type"></a>

```python
type: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}.

---

### GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig <a name="GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig(
  gpu_sharing_strategy: str = None,
  max_shared_clients_per_gpu: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy">gpu_sharing_strategy</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_strategy GoogleContainerCluster#gpu_sharing_strategy}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu">max_shared_clients_per_gpu</a></code> | <code>typing.Union[int, float]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_shared_clients_per_gpu GoogleContainerCluster#max_shared_clients_per_gpu}. |

---

##### `gpu_sharing_strategy`<sup>Optional</sup> <a name="gpu_sharing_strategy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy"></a>

```python
gpu_sharing_strategy: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_strategy GoogleContainerCluster#gpu_sharing_strategy}.

---

##### `max_shared_clients_per_gpu`<sup>Optional</sup> <a name="max_shared_clients_per_gpu" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu"></a>

```python
max_shared_clients_per_gpu: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_shared_clients_per_gpu GoogleContainerCluster#max_shared_clients_per_gpu}.

---

### GoogleContainerClusterNodeConfigGvnic <a name="GoogleContainerClusterNodeConfigGvnic" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigGvnic(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not gvnic is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigGvnic.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not gvnic is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterNodeConfigKubeletConfig <a name="GoogleContainerClusterNodeConfigKubeletConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig(
  cpu_manager_policy: str,
  cpu_cfs_quota: typing.Union[bool, IResolvable] = None,
  cpu_cfs_quota_period: str = None,
  pod_pids_limit: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.cpuManagerPolicy">cpu_manager_policy</a></code> | <code>str</code> | Control the CPU management policy on the node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuota">cpu_cfs_quota</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable CPU CFS quota enforcement for containers that specify CPU limits. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod">cpu_cfs_quota_period</a></code> | <code>str</code> | Set the CPU CFS quota period value 'cpu.cfs_period_us'. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.podPidsLimit">pod_pids_limit</a></code> | <code>typing.Union[int, float]</code> | Controls the maximum number of processes allowed to run in a pod. |

---

##### `cpu_manager_policy`<sup>Required</sup> <a name="cpu_manager_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.cpuManagerPolicy"></a>

```python
cpu_manager_policy: str
```

- *Type:* str

Control the CPU management policy on the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cpu_manager_policy GoogleContainerCluster#cpu_manager_policy}

---

##### `cpu_cfs_quota`<sup>Optional</sup> <a name="cpu_cfs_quota" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuota"></a>

```python
cpu_cfs_quota: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable CPU CFS quota enforcement for containers that specify CPU limits.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cpu_cfs_quota GoogleContainerCluster#cpu_cfs_quota}

---

##### `cpu_cfs_quota_period`<sup>Optional</sup> <a name="cpu_cfs_quota_period" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod"></a>

```python
cpu_cfs_quota_period: str
```

- *Type:* str

Set the CPU CFS quota period value 'cpu.cfs_period_us'.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cpu_cfs_quota_period GoogleContainerCluster#cpu_cfs_quota_period}

---

##### `pod_pids_limit`<sup>Optional</sup> <a name="pod_pids_limit" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigKubeletConfig.property.podPidsLimit"></a>

```python
pod_pids_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Controls the maximum number of processes allowed to run in a pod.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_pids_limit GoogleContainerCluster#pod_pids_limit}

---

### GoogleContainerClusterNodeConfigLinuxNodeConfig <a name="GoogleContainerClusterNodeConfigLinuxNodeConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig(
  sysctls: typing.Mapping[str]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig.property.sysctls">sysctls</a></code> | <code>typing.Mapping[str]</code> | The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. |

---

##### `sysctls`<sup>Required</sup> <a name="sysctls" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLinuxNodeConfig.property.sysctls"></a>

```python
sysctls: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sysctls GoogleContainerCluster#sysctls}

---

### GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig <a name="GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig(
  local_ssd_count: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | Number of raw-block local NVMe SSD disks to be attached to the node. |

---

##### `local_ssd_count`<sup>Required</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of raw-block local NVMe SSD disks to be attached to the node.

Each local SSD is 375 GB in size.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

### GoogleContainerClusterNodeConfigReservationAffinity <a name="GoogleContainerClusterNodeConfigReservationAffinity" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity(
  consume_reservation_type: str,
  key: str = None,
  values: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.property.consumeReservationType">consume_reservation_type</a></code> | <code>str</code> | Corresponds to the type of reservation consumption. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.property.key">key</a></code> | <code>str</code> | The label key of a reservation resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.property.values">values</a></code> | <code>typing.List[str]</code> | The label values of the reservation resource. |

---

##### `consume_reservation_type`<sup>Required</sup> <a name="consume_reservation_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.property.consumeReservationType"></a>

```python
consume_reservation_type: str
```

- *Type:* str

Corresponds to the type of reservation consumption.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#consume_reservation_type GoogleContainerCluster#consume_reservation_type}

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.property.key"></a>

```python
key: str
```

- *Type:* str

The label key of a reservation resource.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}

---

##### `values`<sup>Optional</sup> <a name="values" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigReservationAffinity.property.values"></a>

```python
values: typing.List[str]
```

- *Type:* typing.List[str]

The label values of the reservation resource.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#values GoogleContainerCluster#values}

---

### GoogleContainerClusterNodeConfigSandboxConfig <a name="GoogleContainerClusterNodeConfigSandboxConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig(
  sandbox_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig.property.sandboxType">sandbox_type</a></code> | <code>str</code> | Type of the sandbox to use for the node (e.g. 'gvisor'). |

---

##### `sandbox_type`<sup>Required</sup> <a name="sandbox_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigSandboxConfig.property.sandboxType"></a>

```python
sandbox_type: str
```

- *Type:* str

Type of the sandbox to use for the node (e.g. 'gvisor').

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sandbox_type GoogleContainerCluster#sandbox_type}

---

### GoogleContainerClusterNodeConfigShieldedInstanceConfig <a name="GoogleContainerClusterNodeConfigShieldedInstanceConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig(
  enable_integrity_monitoring: typing.Union[bool, IResolvable] = None,
  enable_secure_boot: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring">enable_integrity_monitoring</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Defines whether the instance has integrity monitoring enabled. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig.property.enableSecureBoot">enable_secure_boot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Defines whether the instance has Secure Boot enabled. |

---

##### `enable_integrity_monitoring`<sup>Optional</sup> <a name="enable_integrity_monitoring" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring"></a>

```python
enable_integrity_monitoring: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Defines whether the instance has integrity monitoring enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}

---

##### `enable_secure_boot`<sup>Optional</sup> <a name="enable_secure_boot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigShieldedInstanceConfig.property.enableSecureBoot"></a>

```python
enable_secure_boot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Defines whether the instance has Secure Boot enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}

---

### GoogleContainerClusterNodeConfigTaint <a name="GoogleContainerClusterNodeConfigTaint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigTaint(
  effect: str = None,
  key: str = None,
  value: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.property.effect">effect</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#effect GoogleContainerCluster#effect}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.property.key">key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.property.value">value</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#value GoogleContainerCluster#value}. |

---

##### `effect`<sup>Optional</sup> <a name="effect" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.property.effect"></a>

```python
effect: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#effect GoogleContainerCluster#effect}.

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.property.key"></a>

```python
key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}.

---

##### `value`<sup>Optional</sup> <a name="value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigTaint.property.value"></a>

```python
value: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#value GoogleContainerCluster#value}.

---

### GoogleContainerClusterNodeConfigWorkloadMetadataConfig <a name="GoogleContainerClusterNodeConfigWorkloadMetadataConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig(
  mode: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig.property.mode">mode</a></code> | <code>str</code> | Mode is the configuration for how to expose metadata to workloads running on the node. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodeConfigWorkloadMetadataConfig.property.mode"></a>

```python
mode: str
```

- *Type:* str

Mode is the configuration for how to expose metadata to workloads running on the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#mode GoogleContainerCluster#mode}

---

### GoogleContainerClusterNodePool <a name="GoogleContainerClusterNodePool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePool(
  autoscaling: GoogleContainerClusterNodePoolAutoscaling = None,
  initial_node_count: typing.Union[int, float] = None,
  management: GoogleContainerClusterNodePoolManagement = None,
  max_pods_per_node: typing.Union[int, float] = None,
  name: str = None,
  name_prefix: str = None,
  network_config: GoogleContainerClusterNodePoolNetworkConfig = None,
  node_config: GoogleContainerClusterNodePoolNodeConfig = None,
  node_count: typing.Union[int, float] = None,
  node_locations: typing.List[str] = None,
  placement_policy: GoogleContainerClusterNodePoolPlacementPolicy = None,
  upgrade_settings: GoogleContainerClusterNodePoolUpgradeSettings = None,
  version: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.autoscaling">autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling">GoogleContainerClusterNodePoolAutoscaling</a></code> | autoscaling block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.initialNodeCount">initial_node_count</a></code> | <code>typing.Union[int, float]</code> | The initial number of nodes for the pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.management">management</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement">GoogleContainerClusterNodePoolManagement</a></code> | management block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.maxPodsPerNode">max_pods_per_node</a></code> | <code>typing.Union[int, float]</code> | The maximum number of pods per node in this node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.name">name</a></code> | <code>str</code> | The name of the node pool. If left blank, Terraform will auto-generate a unique name. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.namePrefix">name_prefix</a></code> | <code>str</code> | Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.networkConfig">network_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig">GoogleContainerClusterNodePoolNetworkConfig</a></code> | network_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.nodeConfig">node_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig">GoogleContainerClusterNodePoolNodeConfig</a></code> | node_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.nodeCount">node_count</a></code> | <code>typing.Union[int, float]</code> | The number of nodes per instance group. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.nodeLocations">node_locations</a></code> | <code>typing.List[str]</code> | The list of zones in which the node pool's nodes should be located. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.placementPolicy">placement_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy">GoogleContainerClusterNodePoolPlacementPolicy</a></code> | placement_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.upgradeSettings">upgrade_settings</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings">GoogleContainerClusterNodePoolUpgradeSettings</a></code> | upgrade_settings block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.version">version</a></code> | <code>str</code> | The Kubernetes version for the nodes in this pool. |

---

##### `autoscaling`<sup>Optional</sup> <a name="autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.autoscaling"></a>

```python
autoscaling: GoogleContainerClusterNodePoolAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling">GoogleContainerClusterNodePoolAutoscaling</a>

autoscaling block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#autoscaling GoogleContainerCluster#autoscaling}

---

##### `initial_node_count`<sup>Optional</sup> <a name="initial_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.initialNodeCount"></a>

```python
initial_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The initial number of nodes for the pool.

In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}

---

##### `management`<sup>Optional</sup> <a name="management" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.management"></a>

```python
management: GoogleContainerClusterNodePoolManagement
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement">GoogleContainerClusterNodePoolManagement</a>

management block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#management GoogleContainerCluster#management}

---

##### `max_pods_per_node`<sup>Optional</sup> <a name="max_pods_per_node" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.maxPodsPerNode"></a>

```python
max_pods_per_node: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The maximum number of pods per node in this node pool.

Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_pods_per_node GoogleContainerCluster#max_pods_per_node}

---

##### `name`<sup>Optional</sup> <a name="name" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.name"></a>

```python
name: str
```

- *Type:* str

The name of the node pool. If left blank, Terraform will auto-generate a unique name.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#name GoogleContainerCluster#name}

---

##### `name_prefix`<sup>Optional</sup> <a name="name_prefix" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.namePrefix"></a>

```python
name_prefix: str
```

- *Type:* str

Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#name_prefix GoogleContainerCluster#name_prefix}

---

##### `network_config`<sup>Optional</sup> <a name="network_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.networkConfig"></a>

```python
network_config: GoogleContainerClusterNodePoolNetworkConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig">GoogleContainerClusterNodePoolNetworkConfig</a>

network_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_config GoogleContainerCluster#network_config}

---

##### `node_config`<sup>Optional</sup> <a name="node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.nodeConfig"></a>

```python
node_config: GoogleContainerClusterNodePoolNodeConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig">GoogleContainerClusterNodePoolNodeConfig</a>

node_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_config GoogleContainerCluster#node_config}

---

##### `node_count`<sup>Optional</sup> <a name="node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.nodeCount"></a>

```python
node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of nodes per instance group.

This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_count GoogleContainerCluster#node_count}

---

##### `node_locations`<sup>Optional</sup> <a name="node_locations" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.nodeLocations"></a>

```python
node_locations: typing.List[str]
```

- *Type:* typing.List[str]

The list of zones in which the node pool's nodes should be located.

Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_locations GoogleContainerCluster#node_locations}

---

##### `placement_policy`<sup>Optional</sup> <a name="placement_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.placementPolicy"></a>

```python
placement_policy: GoogleContainerClusterNodePoolPlacementPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy">GoogleContainerClusterNodePoolPlacementPolicy</a>

placement_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#placement_policy GoogleContainerCluster#placement_policy}

---

##### `upgrade_settings`<sup>Optional</sup> <a name="upgrade_settings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.upgradeSettings"></a>

```python
upgrade_settings: GoogleContainerClusterNodePoolUpgradeSettings
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings">GoogleContainerClusterNodePoolUpgradeSettings</a>

upgrade_settings block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#upgrade_settings GoogleContainerCluster#upgrade_settings}

---

##### `version`<sup>Optional</sup> <a name="version" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePool.property.version"></a>

```python
version: str
```

- *Type:* str

The Kubernetes version for the nodes in this pool.

Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#version GoogleContainerCluster#version}

---

### GoogleContainerClusterNodePoolAutoConfig <a name="GoogleContainerClusterNodePoolAutoConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig(
  network_tags: GoogleContainerClusterNodePoolAutoConfigNetworkTags = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig.property.networkTags">network_tags</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags">GoogleContainerClusterNodePoolAutoConfigNetworkTags</a></code> | network_tags block. |

---

##### `network_tags`<sup>Optional</sup> <a name="network_tags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfig.property.networkTags"></a>

```python
network_tags: GoogleContainerClusterNodePoolAutoConfigNetworkTags
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags">GoogleContainerClusterNodePoolAutoConfigNetworkTags</a>

network_tags block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#network_tags GoogleContainerCluster#network_tags}

---

### GoogleContainerClusterNodePoolAutoConfigNetworkTags <a name="GoogleContainerClusterNodePoolAutoConfigNetworkTags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags(
  tags: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags.property.tags">tags</a></code> | <code>typing.List[str]</code> | List of network tags applied to auto-provisioned node pools. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoConfigNetworkTags.property.tags"></a>

```python
tags: typing.List[str]
```

- *Type:* typing.List[str]

List of network tags applied to auto-provisioned node pools.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}

---

### GoogleContainerClusterNodePoolAutoscaling <a name="GoogleContainerClusterNodePoolAutoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling(
  location_policy: str = None,
  max_node_count: typing.Union[int, float] = None,
  min_node_count: typing.Union[int, float] = None,
  total_max_node_count: typing.Union[int, float] = None,
  total_min_node_count: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.locationPolicy">location_policy</a></code> | <code>str</code> | Location policy specifies the algorithm used when scaling-up the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.maxNodeCount">max_node_count</a></code> | <code>typing.Union[int, float]</code> | Maximum number of nodes per zone in the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.minNodeCount">min_node_count</a></code> | <code>typing.Union[int, float]</code> | Minimum number of nodes per zone in the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.totalMaxNodeCount">total_max_node_count</a></code> | <code>typing.Union[int, float]</code> | Maximum number of all nodes in the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.totalMinNodeCount">total_min_node_count</a></code> | <code>typing.Union[int, float]</code> | Minimum number of all nodes in the node pool. |

---

##### `location_policy`<sup>Optional</sup> <a name="location_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.locationPolicy"></a>

```python
location_policy: str
```

- *Type:* str

Location policy specifies the algorithm used when scaling-up the node pool.

"BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#location_policy GoogleContainerCluster#location_policy}

---

##### `max_node_count`<sup>Optional</sup> <a name="max_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.maxNodeCount"></a>

```python
max_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Maximum number of nodes per zone in the node pool.

Must be >= min_node_count. Cannot be used with total limits.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_node_count GoogleContainerCluster#max_node_count}

---

##### `min_node_count`<sup>Optional</sup> <a name="min_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.minNodeCount"></a>

```python
min_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Minimum number of nodes per zone in the node pool.

Must be >=0 and <= max_node_count. Cannot be used with total limits.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_node_count GoogleContainerCluster#min_node_count}

---

##### `total_max_node_count`<sup>Optional</sup> <a name="total_max_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.totalMaxNodeCount"></a>

```python
total_max_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Maximum number of all nodes in the node pool.

Must be >= total_min_node_count. Cannot be used with per zone limits.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#total_max_node_count GoogleContainerCluster#total_max_node_count}

---

##### `total_min_node_count`<sup>Optional</sup> <a name="total_min_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolAutoscaling.property.totalMinNodeCount"></a>

```python
total_min_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Minimum number of all nodes in the node pool.

Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#total_min_node_count GoogleContainerCluster#total_min_node_count}

---

### GoogleContainerClusterNodePoolDefaults <a name="GoogleContainerClusterNodePoolDefaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolDefaults(
  node_config_defaults: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults.property.nodeConfigDefaults">node_config_defaults</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults">GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults</a></code> | node_config_defaults block. |

---

##### `node_config_defaults`<sup>Optional</sup> <a name="node_config_defaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaults.property.nodeConfigDefaults"></a>

```python
node_config_defaults: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults">GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults</a>

node_config_defaults block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_config_defaults GoogleContainerCluster#node_config_defaults}

---

### GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults <a name="GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults(
  gcfs_config: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig = None,
  logging_variant: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults.property.gcfsConfig">gcfs_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig">GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig</a></code> | gcfs_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults.property.loggingVariant">logging_variant</a></code> | <code>str</code> | Type of logging agent that is used as the default value for node pools in the cluster. |

---

##### `gcfs_config`<sup>Optional</sup> <a name="gcfs_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults.property.gcfsConfig"></a>

```python
gcfs_config: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig">GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig</a>

gcfs_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}

---

##### `logging_variant`<sup>Optional</sup> <a name="logging_variant" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults.property.loggingVariant"></a>

```python
logging_variant: str
```

- *Type:* str

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}

---

### GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig <a name="GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not GCFS is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not GCFS is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterNodePoolManagement <a name="GoogleContainerClusterNodePoolManagement" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolManagement(
  auto_repair: typing.Union[bool, IResolvable] = None,
  auto_upgrade: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement.property.autoRepair">auto_repair</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the nodes will be automatically repaired. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement.property.autoUpgrade">auto_upgrade</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the nodes will be automatically upgraded. |

---

##### `auto_repair`<sup>Optional</sup> <a name="auto_repair" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement.property.autoRepair"></a>

```python
auto_repair: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes will be automatically repaired.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auto_repair GoogleContainerCluster#auto_repair}

---

##### `auto_upgrade`<sup>Optional</sup> <a name="auto_upgrade" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolManagement.property.autoUpgrade"></a>

```python
auto_upgrade: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes will be automatically upgraded.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auto_upgrade GoogleContainerCluster#auto_upgrade}

---

### GoogleContainerClusterNodePoolNetworkConfig <a name="GoogleContainerClusterNodePoolNetworkConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig(
  create_pod_range: typing.Union[bool, IResolvable] = None,
  enable_private_nodes: typing.Union[bool, IResolvable] = None,
  pod_cidr_overprovision_config: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig = None,
  pod_ipv4_cidr_block: str = None,
  pod_range: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.createPodRange">create_pod_range</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to create a new range for pod IPs in this node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.enablePrivateNodes">enable_private_nodes</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether nodes have internal IP addresses only. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.podCidrOverprovisionConfig">pod_cidr_overprovision_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig">GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig</a></code> | pod_cidr_overprovision_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.podIpv4CidrBlock">pod_ipv4_cidr_block</a></code> | <code>str</code> | The IP address range for pod IPs in this node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.podRange">pod_range</a></code> | <code>str</code> | The ID of the secondary range for pod IPs. |

---

##### `create_pod_range`<sup>Optional</sup> <a name="create_pod_range" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.createPodRange"></a>

```python
create_pod_range: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to create a new range for pod IPs in this node pool.

Defaults are provided for pod_range and pod_ipv4_cidr_block if they are not specified.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#create_pod_range GoogleContainerCluster#create_pod_range}

---

##### `enable_private_nodes`<sup>Optional</sup> <a name="enable_private_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.enablePrivateNodes"></a>

```python
enable_private_nodes: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether nodes have internal IP addresses only.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_private_nodes GoogleContainerCluster#enable_private_nodes}

---

##### `pod_cidr_overprovision_config`<sup>Optional</sup> <a name="pod_cidr_overprovision_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.podCidrOverprovisionConfig"></a>

```python
pod_cidr_overprovision_config: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig">GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig</a>

pod_cidr_overprovision_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_cidr_overprovision_config GoogleContainerCluster#pod_cidr_overprovision_config}

---

##### `pod_ipv4_cidr_block`<sup>Optional</sup> <a name="pod_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.podIpv4CidrBlock"></a>

```python
pod_ipv4_cidr_block: str
```

- *Type:* str

The IP address range for pod IPs in this node pool.

Only applicable if create_pod_range is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) to pick a specific range to use.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_ipv4_cidr_block GoogleContainerCluster#pod_ipv4_cidr_block}

---

##### `pod_range`<sup>Optional</sup> <a name="pod_range" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfig.property.podRange"></a>

```python
pod_range: str
```

- *Type:* str

The ID of the secondary range for pod IPs.

If create_pod_range is true, this ID is used for the new range. If create_pod_range is false, uses an existing secondary range with this ID.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_range GoogleContainerCluster#pod_range}

---

### GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig <a name="GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig(
  disabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

### GoogleContainerClusterNodePoolNodeConfig <a name="GoogleContainerClusterNodePoolNodeConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig(
  advanced_machine_features: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures = None,
  boot_disk_kms_key: str = None,
  disk_size_gb: typing.Union[int, float] = None,
  disk_type: str = None,
  ephemeral_storage_config: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig = None,
  ephemeral_storage_local_ssd_config: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig = None,
  gcfs_config: GoogleContainerClusterNodePoolNodeConfigGcfsConfig = None,
  guest_accelerator: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePoolNodeConfigGuestAccelerator]] = None,
  gvnic: GoogleContainerClusterNodePoolNodeConfigGvnic = None,
  image_type: str = None,
  kubelet_config: GoogleContainerClusterNodePoolNodeConfigKubeletConfig = None,
  labels: typing.Mapping[str] = None,
  linux_node_config: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig = None,
  local_nvme_ssd_block_config: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig = None,
  local_ssd_count: typing.Union[int, float] = None,
  logging_variant: str = None,
  machine_type: str = None,
  metadata: typing.Mapping[str] = None,
  min_cpu_platform: str = None,
  node_group: str = None,
  oauth_scopes: typing.List[str] = None,
  preemptible: typing.Union[bool, IResolvable] = None,
  reservation_affinity: GoogleContainerClusterNodePoolNodeConfigReservationAffinity = None,
  resource_labels: typing.Mapping[str] = None,
  sandbox_config: GoogleContainerClusterNodePoolNodeConfigSandboxConfig = None,
  service_account: str = None,
  shielded_instance_config: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig = None,
  spot: typing.Union[bool, IResolvable] = None,
  tags: typing.List[str] = None,
  taint: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePoolNodeConfigTaint]] = None,
  workload_metadata_config: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.advancedMachineFeatures">advanced_machine_features</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures">GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures</a></code> | advanced_machine_features block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.bootDiskKmsKey">boot_disk_kms_key</a></code> | <code>str</code> | The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.diskSizeGb">disk_size_gb</a></code> | <code>typing.Union[int, float]</code> | Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.diskType">disk_type</a></code> | <code>str</code> | Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.ephemeralStorageConfig">ephemeral_storage_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig">GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig</a></code> | ephemeral_storage_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.ephemeralStorageLocalSsdConfig">ephemeral_storage_local_ssd_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig">GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig</a></code> | ephemeral_storage_local_ssd_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.gcfsConfig">gcfs_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig">GoogleContainerClusterNodePoolNodeConfigGcfsConfig</a></code> | gcfs_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.guestAccelerator">guest_accelerator</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator">GoogleContainerClusterNodePoolNodeConfigGuestAccelerator</a>]]</code> | List of the type and count of accelerator cards attached to the instance. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.gvnic">gvnic</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic">GoogleContainerClusterNodePoolNodeConfigGvnic</a></code> | gvnic block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.imageType">image_type</a></code> | <code>str</code> | The image type to use for this node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.kubeletConfig">kubelet_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig">GoogleContainerClusterNodePoolNodeConfigKubeletConfig</a></code> | kubelet_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.labels">labels</a></code> | <code>typing.Mapping[str]</code> | The map of Kubernetes labels (key/value pairs) to be applied to each node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.linuxNodeConfig">linux_node_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig">GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig</a></code> | linux_node_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.localNvmeSsdBlockConfig">local_nvme_ssd_block_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig">GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig</a></code> | local_nvme_ssd_block_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | The number of local SSD disks to be attached to the node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.loggingVariant">logging_variant</a></code> | <code>str</code> | Type of logging agent that is used as the default value for node pools in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.machineType">machine_type</a></code> | <code>str</code> | The name of a Google Compute Engine machine type. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.metadata">metadata</a></code> | <code>typing.Mapping[str]</code> | The metadata key/value pairs assigned to instances in the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.minCpuPlatform">min_cpu_platform</a></code> | <code>str</code> | Minimum CPU platform to be used by this instance. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.nodeGroup">node_group</a></code> | <code>str</code> | Setting this field will assign instances of this pool to run on the specified node group. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.oauthScopes">oauth_scopes</a></code> | <code>typing.List[str]</code> | The set of Google API scopes to be made available on all of the node VMs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.preemptible">preemptible</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the nodes are created as preemptible VM instances. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.reservationAffinity">reservation_affinity</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity">GoogleContainerClusterNodePoolNodeConfigReservationAffinity</a></code> | reservation_affinity block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.resourceLabels">resource_labels</a></code> | <code>typing.Mapping[str]</code> | The GCE resource labels (a map of key/value pairs) to be applied to the node pool. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.sandboxConfig">sandbox_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig">GoogleContainerClusterNodePoolNodeConfigSandboxConfig</a></code> | sandbox_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.serviceAccount">service_account</a></code> | <code>str</code> | The Google Cloud Platform Service Account to be used by the node VMs. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.shieldedInstanceConfig">shielded_instance_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig">GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig</a></code> | shielded_instance_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.spot">spot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the nodes are created as spot VM instances. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.tags">tags</a></code> | <code>typing.List[str]</code> | The list of instance tags applied to all nodes. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.taint">taint</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint">GoogleContainerClusterNodePoolNodeConfigTaint</a>]]</code> | List of Kubernetes taints to be applied to each node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.workloadMetadataConfig">workload_metadata_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig">GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig</a></code> | workload_metadata_config block. |

---

##### `advanced_machine_features`<sup>Optional</sup> <a name="advanced_machine_features" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.advancedMachineFeatures"></a>

```python
advanced_machine_features: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures">GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures</a>

advanced_machine_features block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#advanced_machine_features GoogleContainerCluster#advanced_machine_features}

---

##### `boot_disk_kms_key`<sup>Optional</sup> <a name="boot_disk_kms_key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.bootDiskKmsKey"></a>

```python
boot_disk_kms_key: str
```

- *Type:* str

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}

---

##### `disk_size_gb`<sup>Optional</sup> <a name="disk_size_gb" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.diskSizeGb"></a>

```python
disk_size_gb: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}

---

##### `disk_type`<sup>Optional</sup> <a name="disk_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.diskType"></a>

```python
disk_type: str
```

- *Type:* str

Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}

---

##### `ephemeral_storage_config`<sup>Optional</sup> <a name="ephemeral_storage_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.ephemeralStorageConfig"></a>

```python
ephemeral_storage_config: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig">GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig</a>

ephemeral_storage_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}

---

##### `ephemeral_storage_local_ssd_config`<sup>Optional</sup> <a name="ephemeral_storage_local_ssd_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.ephemeralStorageLocalSsdConfig"></a>

```python
ephemeral_storage_local_ssd_config: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig">GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig</a>

ephemeral_storage_local_ssd_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#ephemeral_storage_local_ssd_config GoogleContainerCluster#ephemeral_storage_local_ssd_config}

---

##### `gcfs_config`<sup>Optional</sup> <a name="gcfs_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.gcfsConfig"></a>

```python
gcfs_config: GoogleContainerClusterNodePoolNodeConfigGcfsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig">GoogleContainerClusterNodePoolNodeConfigGcfsConfig</a>

gcfs_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}

---

##### `guest_accelerator`<sup>Optional</sup> <a name="guest_accelerator" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.guestAccelerator"></a>

```python
guest_accelerator: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePoolNodeConfigGuestAccelerator]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator">GoogleContainerClusterNodePoolNodeConfigGuestAccelerator</a>]]

List of the type and count of accelerator cards attached to the instance.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}

---

##### `gvnic`<sup>Optional</sup> <a name="gvnic" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.gvnic"></a>

```python
gvnic: GoogleContainerClusterNodePoolNodeConfigGvnic
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic">GoogleContainerClusterNodePoolNodeConfigGvnic</a>

gvnic block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gvnic GoogleContainerCluster#gvnic}

---

##### `image_type`<sup>Optional</sup> <a name="image_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.imageType"></a>

```python
image_type: str
```

- *Type:* str

The image type to use for this node.

Note that for a given image type, the latest version of it will be used.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}

---

##### `kubelet_config`<sup>Optional</sup> <a name="kubelet_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.kubeletConfig"></a>

```python
kubelet_config: GoogleContainerClusterNodePoolNodeConfigKubeletConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig">GoogleContainerClusterNodePoolNodeConfigKubeletConfig</a>

kubelet_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}

---

##### `labels`<sup>Optional</sup> <a name="labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.labels"></a>

```python
labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The map of Kubernetes labels (key/value pairs) to be applied to each node.

These will added in addition to any default label(s) that Kubernetes may apply to the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#labels GoogleContainerCluster#labels}

---

##### `linux_node_config`<sup>Optional</sup> <a name="linux_node_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.linuxNodeConfig"></a>

```python
linux_node_config: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig">GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig</a>

linux_node_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}

---

##### `local_nvme_ssd_block_config`<sup>Optional</sup> <a name="local_nvme_ssd_block_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.localNvmeSsdBlockConfig"></a>

```python
local_nvme_ssd_block_config: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig">GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig</a>

local_nvme_ssd_block_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_nvme_ssd_block_config GoogleContainerCluster#local_nvme_ssd_block_config}

---

##### `local_ssd_count`<sup>Optional</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of local SSD disks to be attached to the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

##### `logging_variant`<sup>Optional</sup> <a name="logging_variant" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.loggingVariant"></a>

```python
logging_variant: str
```

- *Type:* str

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}

---

##### `machine_type`<sup>Optional</sup> <a name="machine_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.machineType"></a>

```python
machine_type: str
```

- *Type:* str

The name of a Google Compute Engine machine type.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#machine_type GoogleContainerCluster#machine_type}

---

##### `metadata`<sup>Optional</sup> <a name="metadata" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.metadata"></a>

```python
metadata: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The metadata key/value pairs assigned to instances in the cluster.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#metadata GoogleContainerCluster#metadata}

---

##### `min_cpu_platform`<sup>Optional</sup> <a name="min_cpu_platform" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.minCpuPlatform"></a>

```python
min_cpu_platform: str
```

- *Type:* str

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}

---

##### `node_group`<sup>Optional</sup> <a name="node_group" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.nodeGroup"></a>

```python
node_group: str
```

- *Type:* str

Setting this field will assign instances of this pool to run on the specified node group.

This is useful for running workloads on sole tenant nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_group GoogleContainerCluster#node_group}

---

##### `oauth_scopes`<sup>Optional</sup> <a name="oauth_scopes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.oauthScopes"></a>

```python
oauth_scopes: typing.List[str]
```

- *Type:* typing.List[str]

The set of Google API scopes to be made available on all of the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}

---

##### `preemptible`<sup>Optional</sup> <a name="preemptible" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.preemptible"></a>

```python
preemptible: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes are created as preemptible VM instances.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#preemptible GoogleContainerCluster#preemptible}

---

##### `reservation_affinity`<sup>Optional</sup> <a name="reservation_affinity" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.reservationAffinity"></a>

```python
reservation_affinity: GoogleContainerClusterNodePoolNodeConfigReservationAffinity
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity">GoogleContainerClusterNodePoolNodeConfigReservationAffinity</a>

reservation_affinity block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}

---

##### `resource_labels`<sup>Optional</sup> <a name="resource_labels" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.resourceLabels"></a>

```python
resource_labels: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The GCE resource labels (a map of key/value pairs) to be applied to the node pool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}

---

##### `sandbox_config`<sup>Optional</sup> <a name="sandbox_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.sandboxConfig"></a>

```python
sandbox_config: GoogleContainerClusterNodePoolNodeConfigSandboxConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig">GoogleContainerClusterNodePoolNodeConfigSandboxConfig</a>

sandbox_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}

---

##### `service_account`<sup>Optional</sup> <a name="service_account" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.serviceAccount"></a>

```python
service_account: str
```

- *Type:* str

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}

---

##### `shielded_instance_config`<sup>Optional</sup> <a name="shielded_instance_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.shieldedInstanceConfig"></a>

```python
shielded_instance_config: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig">GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}

---

##### `spot`<sup>Optional</sup> <a name="spot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.spot"></a>

```python
spot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the nodes are created as spot VM instances.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#spot GoogleContainerCluster#spot}

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.tags"></a>

```python
tags: typing.List[str]
```

- *Type:* typing.List[str]

The list of instance tags applied to all nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}

---

##### `taint`<sup>Optional</sup> <a name="taint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.taint"></a>

```python
taint: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePoolNodeConfigTaint]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint">GoogleContainerClusterNodePoolNodeConfigTaint</a>]]

List of Kubernetes taints to be applied to each node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#taint GoogleContainerCluster#taint}

---

##### `workload_metadata_config`<sup>Optional</sup> <a name="workload_metadata_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfig.property.workloadMetadataConfig"></a>

```python
workload_metadata_config: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig">GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig</a>

workload_metadata_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}

---

### GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures <a name="GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures(
  threads_per_core: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.property.threadsPerCore">threads_per_core</a></code> | <code>typing.Union[int, float]</code> | The number of threads per physical core. |

---

##### `threads_per_core`<sup>Required</sup> <a name="threads_per_core" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.property.threadsPerCore"></a>

```python
threads_per_core: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of threads per physical core.

To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#threads_per_core GoogleContainerCluster#threads_per_core}

---

### GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig <a name="GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig(
  local_ssd_count: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | Number of local SSDs to use to back ephemeral storage. |

---

##### `local_ssd_count`<sup>Required</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of local SSDs to use to back ephemeral storage.

Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

### GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig <a name="GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig(
  local_ssd_count: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | Number of local SSDs to use to back ephemeral storage. |

---

##### `local_ssd_count`<sup>Required</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of local SSDs to use to back ephemeral storage.

Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

### GoogleContainerClusterNodePoolNodeConfigGcfsConfig <a name="GoogleContainerClusterNodePoolNodeConfigGcfsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not GCFS is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGcfsConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not GCFS is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterNodePoolNodeConfigGuestAccelerator <a name="GoogleContainerClusterNodePoolNodeConfigGuestAccelerator" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator(
  count: typing.Union[int, float] = None,
  gpu_partition_size: str = None,
  gpu_sharing_config: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig]] = None,
  type: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.count">count</a></code> | <code>typing.Union[int, float]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#count GoogleContainerCluster#count}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuPartitionSize">gpu_partition_size</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuSharingConfig">gpu_sharing_config</a></code> | <code>typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig">GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig</a>]]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_config GoogleContainerCluster#gpu_sharing_config}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.type">type</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}. |

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.count"></a>

```python
count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#count GoogleContainerCluster#count}.

---

##### `gpu_partition_size`<sup>Optional</sup> <a name="gpu_partition_size" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuPartitionSize"></a>

```python
gpu_partition_size: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}.

---

##### `gpu_sharing_config`<sup>Optional</sup> <a name="gpu_sharing_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuSharingConfig"></a>

```python
gpu_sharing_config: typing.Union[IResolvable, typing.List[GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig]]
```

- *Type:* typing.Union[cdktf.IResolvable, typing.List[<a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig">GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig</a>]]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_config GoogleContainerCluster#gpu_sharing_config}.

---

##### `type`<sup>Optional</sup> <a name="type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAccelerator.property.type"></a>

```python
type: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}.

---

### GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig <a name="GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig(
  gpu_sharing_strategy: str = None,
  max_shared_clients_per_gpu: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy">gpu_sharing_strategy</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_strategy GoogleContainerCluster#gpu_sharing_strategy}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu">max_shared_clients_per_gpu</a></code> | <code>typing.Union[int, float]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_shared_clients_per_gpu GoogleContainerCluster#max_shared_clients_per_gpu}. |

---

##### `gpu_sharing_strategy`<sup>Optional</sup> <a name="gpu_sharing_strategy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy"></a>

```python
gpu_sharing_strategy: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#gpu_sharing_strategy GoogleContainerCluster#gpu_sharing_strategy}.

---

##### `max_shared_clients_per_gpu`<sup>Optional</sup> <a name="max_shared_clients_per_gpu" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu"></a>

```python
max_shared_clients_per_gpu: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_shared_clients_per_gpu GoogleContainerCluster#max_shared_clients_per_gpu}.

---

### GoogleContainerClusterNodePoolNodeConfigGvnic <a name="GoogleContainerClusterNodePoolNodeConfigGvnic" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not gvnic is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigGvnic.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not gvnic is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterNodePoolNodeConfigKubeletConfig <a name="GoogleContainerClusterNodePoolNodeConfigKubeletConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig(
  cpu_manager_policy: str,
  cpu_cfs_quota: typing.Union[bool, IResolvable] = None,
  cpu_cfs_quota_period: str = None,
  pod_pids_limit: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuManagerPolicy">cpu_manager_policy</a></code> | <code>str</code> | Control the CPU management policy on the node. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuota">cpu_cfs_quota</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable CPU CFS quota enforcement for containers that specify CPU limits. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod">cpu_cfs_quota_period</a></code> | <code>str</code> | Set the CPU CFS quota period value 'cpu.cfs_period_us'. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.podPidsLimit">pod_pids_limit</a></code> | <code>typing.Union[int, float]</code> | Controls the maximum number of processes allowed to run in a pod. |

---

##### `cpu_manager_policy`<sup>Required</sup> <a name="cpu_manager_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuManagerPolicy"></a>

```python
cpu_manager_policy: str
```

- *Type:* str

Control the CPU management policy on the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cpu_manager_policy GoogleContainerCluster#cpu_manager_policy}

---

##### `cpu_cfs_quota`<sup>Optional</sup> <a name="cpu_cfs_quota" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuota"></a>

```python
cpu_cfs_quota: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable CPU CFS quota enforcement for containers that specify CPU limits.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cpu_cfs_quota GoogleContainerCluster#cpu_cfs_quota}

---

##### `cpu_cfs_quota_period`<sup>Optional</sup> <a name="cpu_cfs_quota_period" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod"></a>

```python
cpu_cfs_quota_period: str
```

- *Type:* str

Set the CPU CFS quota period value 'cpu.cfs_period_us'.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#cpu_cfs_quota_period GoogleContainerCluster#cpu_cfs_quota_period}

---

##### `pod_pids_limit`<sup>Optional</sup> <a name="pod_pids_limit" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigKubeletConfig.property.podPidsLimit"></a>

```python
pod_pids_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Controls the maximum number of processes allowed to run in a pod.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pod_pids_limit GoogleContainerCluster#pod_pids_limit}

---

### GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig <a name="GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig(
  sysctls: typing.Mapping[str]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig.property.sysctls">sysctls</a></code> | <code>typing.Mapping[str]</code> | The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. |

---

##### `sysctls`<sup>Required</sup> <a name="sysctls" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig.property.sysctls"></a>

```python
sysctls: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sysctls GoogleContainerCluster#sysctls}

---

### GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig <a name="GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig(
  local_ssd_count: typing.Union[int, float]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount">local_ssd_count</a></code> | <code>typing.Union[int, float]</code> | Number of raw-block local NVMe SSD disks to be attached to the node. |

---

##### `local_ssd_count`<sup>Required</sup> <a name="local_ssd_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount"></a>

```python
local_ssd_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of raw-block local NVMe SSD disks to be attached to the node.

Each local SSD is 375 GB in size.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}

---

### GoogleContainerClusterNodePoolNodeConfigReservationAffinity <a name="GoogleContainerClusterNodePoolNodeConfigReservationAffinity" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity(
  consume_reservation_type: str,
  key: str = None,
  values: typing.List[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.property.consumeReservationType">consume_reservation_type</a></code> | <code>str</code> | Corresponds to the type of reservation consumption. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.property.key">key</a></code> | <code>str</code> | The label key of a reservation resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.property.values">values</a></code> | <code>typing.List[str]</code> | The label values of the reservation resource. |

---

##### `consume_reservation_type`<sup>Required</sup> <a name="consume_reservation_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.property.consumeReservationType"></a>

```python
consume_reservation_type: str
```

- *Type:* str

Corresponds to the type of reservation consumption.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#consume_reservation_type GoogleContainerCluster#consume_reservation_type}

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.property.key"></a>

```python
key: str
```

- *Type:* str

The label key of a reservation resource.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}

---

##### `values`<sup>Optional</sup> <a name="values" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigReservationAffinity.property.values"></a>

```python
values: typing.List[str]
```

- *Type:* typing.List[str]

The label values of the reservation resource.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#values GoogleContainerCluster#values}

---

### GoogleContainerClusterNodePoolNodeConfigSandboxConfig <a name="GoogleContainerClusterNodePoolNodeConfigSandboxConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig(
  sandbox_type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig.property.sandboxType">sandbox_type</a></code> | <code>str</code> | Type of the sandbox to use for the node (e.g. 'gvisor'). |

---

##### `sandbox_type`<sup>Required</sup> <a name="sandbox_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigSandboxConfig.property.sandboxType"></a>

```python
sandbox_type: str
```

- *Type:* str

Type of the sandbox to use for the node (e.g. 'gvisor').

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#sandbox_type GoogleContainerCluster#sandbox_type}

---

### GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig <a name="GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig(
  enable_integrity_monitoring: typing.Union[bool, IResolvable] = None,
  enable_secure_boot: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring">enable_integrity_monitoring</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Defines whether the instance has integrity monitoring enabled. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableSecureBoot">enable_secure_boot</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Defines whether the instance has Secure Boot enabled. |

---

##### `enable_integrity_monitoring`<sup>Optional</sup> <a name="enable_integrity_monitoring" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring"></a>

```python
enable_integrity_monitoring: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Defines whether the instance has integrity monitoring enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}

---

##### `enable_secure_boot`<sup>Optional</sup> <a name="enable_secure_boot" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableSecureBoot"></a>

```python
enable_secure_boot: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Defines whether the instance has Secure Boot enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}

---

### GoogleContainerClusterNodePoolNodeConfigTaint <a name="GoogleContainerClusterNodePoolNodeConfigTaint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint(
  effect: str = None,
  key: str = None,
  value: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.property.effect">effect</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#effect GoogleContainerCluster#effect}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.property.key">key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.property.value">value</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#value GoogleContainerCluster#value}. |

---

##### `effect`<sup>Optional</sup> <a name="effect" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.property.effect"></a>

```python
effect: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#effect GoogleContainerCluster#effect}.

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.property.key"></a>

```python
key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}.

---

##### `value`<sup>Optional</sup> <a name="value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigTaint.property.value"></a>

```python
value: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#value GoogleContainerCluster#value}.

---

### GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig <a name="GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig(
  mode: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.property.mode">mode</a></code> | <code>str</code> | Mode is the configuration for how to expose metadata to workloads running on the node. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.property.mode"></a>

```python
mode: str
```

- *Type:* str

Mode is the configuration for how to expose metadata to workloads running on the node.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#mode GoogleContainerCluster#mode}

---

### GoogleContainerClusterNodePoolPlacementPolicy <a name="GoogleContainerClusterNodePoolPlacementPolicy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy(
  type: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy.property.type">type</a></code> | <code>str</code> | Type defines the type of placement policy. |

---

##### `type`<sup>Required</sup> <a name="type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolPlacementPolicy.property.type"></a>

```python
type: str
```

- *Type:* str

Type defines the type of placement policy.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}

---

### GoogleContainerClusterNodePoolUpgradeSettings <a name="GoogleContainerClusterNodePoolUpgradeSettings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings(
  blue_green_settings: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings = None,
  max_surge: typing.Union[int, float] = None,
  max_unavailable: typing.Union[int, float] = None,
  strategy: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.blueGreenSettings">blue_green_settings</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings">GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings</a></code> | blue_green_settings block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.maxSurge">max_surge</a></code> | <code>typing.Union[int, float]</code> | The number of additional nodes that can be added to the node pool during an upgrade. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.maxUnavailable">max_unavailable</a></code> | <code>typing.Union[int, float]</code> | The number of nodes that can be simultaneously unavailable during an upgrade. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.strategy">strategy</a></code> | <code>str</code> | Update strategy for the given nodepool. |

---

##### `blue_green_settings`<sup>Optional</sup> <a name="blue_green_settings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.blueGreenSettings"></a>

```python
blue_green_settings: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings">GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings</a>

blue_green_settings block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#blue_green_settings GoogleContainerCluster#blue_green_settings}

---

##### `max_surge`<sup>Optional</sup> <a name="max_surge" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.maxSurge"></a>

```python
max_surge: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of additional nodes that can be added to the node pool during an upgrade.

Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_surge GoogleContainerCluster#max_surge}

---

##### `max_unavailable`<sup>Optional</sup> <a name="max_unavailable" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.maxUnavailable"></a>

```python
max_unavailable: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of nodes that can be simultaneously unavailable during an upgrade.

Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#max_unavailable GoogleContainerCluster#max_unavailable}

---

##### `strategy`<sup>Optional</sup> <a name="strategy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettings.property.strategy"></a>

```python
strategy: str
```

- *Type:* str

Update strategy for the given nodepool.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#strategy GoogleContainerCluster#strategy}

---

### GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings <a name="GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings(
  standard_rollout_policy: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy,
  node_pool_soak_duration: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy">standard_rollout_policy</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a></code> | standard_rollout_policy block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration">node_pool_soak_duration</a></code> | <code>str</code> | Time needed after draining entire blue pool. After this period, blue pool will be cleaned up. |

---

##### `standard_rollout_policy`<sup>Required</sup> <a name="standard_rollout_policy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy"></a>

```python
standard_rollout_policy: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

standard_rollout_policy block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#standard_rollout_policy GoogleContainerCluster#standard_rollout_policy}

---

##### `node_pool_soak_duration`<sup>Optional</sup> <a name="node_pool_soak_duration" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration"></a>

```python
node_pool_soak_duration: str
```

- *Type:* str

Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#node_pool_soak_duration GoogleContainerCluster#node_pool_soak_duration}

---

### GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy <a name="GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy(
  batch_node_count: typing.Union[int, float] = None,
  batch_percentage: typing.Union[int, float] = None,
  batch_soak_duration: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount">batch_node_count</a></code> | <code>typing.Union[int, float]</code> | Number of blue nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage">batch_percentage</a></code> | <code>typing.Union[int, float]</code> | Percentage of the blue pool nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration">batch_soak_duration</a></code> | <code>str</code> | Soak time after each batch gets drained. |

---

##### `batch_node_count`<sup>Optional</sup> <a name="batch_node_count" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount"></a>

```python
batch_node_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Number of blue nodes to drain in a batch.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#batch_node_count GoogleContainerCluster#batch_node_count}

---

##### `batch_percentage`<sup>Optional</sup> <a name="batch_percentage" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage"></a>

```python
batch_percentage: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Percentage of the blue pool nodes to drain in a batch.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#batch_percentage GoogleContainerCluster#batch_percentage}

---

##### `batch_soak_duration`<sup>Optional</sup> <a name="batch_soak_duration" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration"></a>

```python
batch_soak_duration: str
```

- *Type:* str

Soak time after each batch gets drained.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#batch_soak_duration GoogleContainerCluster#batch_soak_duration}

---

### GoogleContainerClusterNotificationConfig <a name="GoogleContainerClusterNotificationConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNotificationConfig(
  pubsub: GoogleContainerClusterNotificationConfigPubsub
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig.property.pubsub">pubsub</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub">GoogleContainerClusterNotificationConfigPubsub</a></code> | pubsub block. |

---

##### `pubsub`<sup>Required</sup> <a name="pubsub" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfig.property.pubsub"></a>

```python
pubsub: GoogleContainerClusterNotificationConfigPubsub
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub">GoogleContainerClusterNotificationConfigPubsub</a>

pubsub block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#pubsub GoogleContainerCluster#pubsub}

---

### GoogleContainerClusterNotificationConfigPubsub <a name="GoogleContainerClusterNotificationConfigPubsub" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub(
  enabled: typing.Union[bool, IResolvable],
  filter: GoogleContainerClusterNotificationConfigPubsubFilter = None,
  topic: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether or not the notification config is enabled. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.property.filter">filter</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter">GoogleContainerClusterNotificationConfigPubsubFilter</a></code> | filter block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.property.topic">topic</a></code> | <code>str</code> | The pubsub topic to push upgrade notifications to. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether or not the notification config is enabled.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `filter`<sup>Optional</sup> <a name="filter" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.property.filter"></a>

```python
filter: GoogleContainerClusterNotificationConfigPubsubFilter
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter">GoogleContainerClusterNotificationConfigPubsubFilter</a>

filter block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#filter GoogleContainerCluster#filter}

---

##### `topic`<sup>Optional</sup> <a name="topic" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsub.property.topic"></a>

```python
topic: str
```

- *Type:* str

The pubsub topic to push upgrade notifications to.

Must be in the same project as the cluster. Must be in the format: projects/{project}/topics/{topic}.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#topic GoogleContainerCluster#topic}

---

### GoogleContainerClusterNotificationConfigPubsubFilter <a name="GoogleContainerClusterNotificationConfigPubsubFilter" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter(
  event_type: typing.List[str]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter.property.eventType">event_type</a></code> | <code>typing.List[str]</code> | Can be used to filter what notifications are sent. Valid values include include UPGRADE_AVAILABLE_EVENT, UPGRADE_EVENT and SECURITY_BULLETIN_EVENT. |

---

##### `event_type`<sup>Required</sup> <a name="event_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterNotificationConfigPubsubFilter.property.eventType"></a>

```python
event_type: typing.List[str]
```

- *Type:* typing.List[str]

Can be used to filter what notifications are sent. Valid values include include UPGRADE_AVAILABLE_EVENT, UPGRADE_EVENT and SECURITY_BULLETIN_EVENT.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#event_type GoogleContainerCluster#event_type}

---

### GoogleContainerClusterPodSecurityPolicyConfig <a name="GoogleContainerClusterPodSecurityPolicyConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPodSecurityPolicyConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterPrivateClusterConfig <a name="GoogleContainerClusterPrivateClusterConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterPrivateClusterConfig(
  enable_private_endpoint: typing.Union[bool, IResolvable] = None,
  enable_private_nodes: typing.Union[bool, IResolvable] = None,
  master_global_access_config: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig = None,
  master_ipv4_cidr_block: str = None,
  private_endpoint_subnetwork: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.enablePrivateEndpoint">enable_private_endpoint</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.enablePrivateNodes">enable_private_nodes</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enables the private cluster feature, creating a private endpoint on the cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.masterGlobalAccessConfig">master_global_access_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig">GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig</a></code> | master_global_access_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.masterIpv4CidrBlock">master_ipv4_cidr_block</a></code> | <code>str</code> | The IP range in CIDR notation to use for the hosted master network. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.privateEndpointSubnetwork">private_endpoint_subnetwork</a></code> | <code>str</code> | Subnetwork in cluster's network where master's endpoint will be provisioned. |

---

##### `enable_private_endpoint`<sup>Optional</sup> <a name="enable_private_endpoint" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.enablePrivateEndpoint"></a>

```python
enable_private_endpoint: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled.

When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_private_endpoint GoogleContainerCluster#enable_private_endpoint}

---

##### `enable_private_nodes`<sup>Optional</sup> <a name="enable_private_nodes" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.enablePrivateNodes"></a>

```python
enable_private_nodes: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enables the private cluster feature, creating a private endpoint on the cluster.

In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_private_nodes GoogleContainerCluster#enable_private_nodes}

---

##### `master_global_access_config`<sup>Optional</sup> <a name="master_global_access_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.masterGlobalAccessConfig"></a>

```python
master_global_access_config: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig">GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig</a>

master_global_access_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_global_access_config GoogleContainerCluster#master_global_access_config}

---

##### `master_ipv4_cidr_block`<sup>Optional</sup> <a name="master_ipv4_cidr_block" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.masterIpv4CidrBlock"></a>

```python
master_ipv4_cidr_block: str
```

- *Type:* str

The IP range in CIDR notation to use for the hosted master network.

This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#master_ipv4_cidr_block GoogleContainerCluster#master_ipv4_cidr_block}

---

##### `private_endpoint_subnetwork`<sup>Optional</sup> <a name="private_endpoint_subnetwork" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfig.property.privateEndpointSubnetwork"></a>

```python
private_endpoint_subnetwork: str
```

- *Type:* str

Subnetwork in cluster's network where master's endpoint will be provisioned.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#private_endpoint_subnetwork GoogleContainerCluster#private_endpoint_subnetwork}

---

### GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig <a name="GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether the cluster master is accessible globally or not. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether the cluster master is accessible globally or not.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterProtectConfig <a name="GoogleContainerClusterProtectConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterProtectConfig(
  workload_config: GoogleContainerClusterProtectConfigWorkloadConfig = None,
  workload_vulnerability_mode: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig.property.workloadConfig">workload_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig">GoogleContainerClusterProtectConfigWorkloadConfig</a></code> | workload_config block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig.property.workloadVulnerabilityMode">workload_vulnerability_mode</a></code> | <code>str</code> | Sets which mode to use for Protect workload vulnerability scanning feature. Accepted values are DISABLED, BASIC. |

---

##### `workload_config`<sup>Optional</sup> <a name="workload_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig.property.workloadConfig"></a>

```python
workload_config: GoogleContainerClusterProtectConfigWorkloadConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig">GoogleContainerClusterProtectConfigWorkloadConfig</a>

workload_config block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_config GoogleContainerCluster#workload_config}

---

##### `workload_vulnerability_mode`<sup>Optional</sup> <a name="workload_vulnerability_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfig.property.workloadVulnerabilityMode"></a>

```python
workload_vulnerability_mode: str
```

- *Type:* str

Sets which mode to use for Protect workload vulnerability scanning feature. Accepted values are DISABLED, BASIC.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_vulnerability_mode GoogleContainerCluster#workload_vulnerability_mode}

---

### GoogleContainerClusterProtectConfigWorkloadConfig <a name="GoogleContainerClusterProtectConfigWorkloadConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig(
  audit_mode: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig.property.auditMode">audit_mode</a></code> | <code>str</code> | Sets which mode of auditing should be used for the cluster's workloads. Accepted values are DISABLED, BASIC. |

---

##### `audit_mode`<sup>Required</sup> <a name="audit_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterProtectConfigWorkloadConfig.property.auditMode"></a>

```python
audit_mode: str
```

- *Type:* str

Sets which mode of auditing should be used for the cluster's workloads. Accepted values are DISABLED, BASIC.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#audit_mode GoogleContainerCluster#audit_mode}

---

### GoogleContainerClusterReleaseChannel <a name="GoogleContainerClusterReleaseChannel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterReleaseChannel(
  channel: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel.property.channel">channel</a></code> | <code>str</code> | The selected release channel. |

---

##### `channel`<sup>Required</sup> <a name="channel" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterReleaseChannel.property.channel"></a>

```python
channel: str
```

- *Type:* str

The selected release channel.

Accepted values are:
UNSPECIFIED: Not set.
RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#channel GoogleContainerCluster#channel}

---

### GoogleContainerClusterResourceUsageExportConfig <a name="GoogleContainerClusterResourceUsageExportConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig(
  bigquery_destination: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination,
  enable_network_egress_metering: typing.Union[bool, IResolvable] = None,
  enable_resource_consumption_metering: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.property.bigqueryDestination">bigquery_destination</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination">GoogleContainerClusterResourceUsageExportConfigBigqueryDestination</a></code> | bigquery_destination block. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.property.enableNetworkEgressMetering">enable_network_egress_metering</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable network egress metering for this cluster. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.property.enableResourceConsumptionMetering">enable_resource_consumption_metering</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to enable resource consumption metering on this cluster. |

---

##### `bigquery_destination`<sup>Required</sup> <a name="bigquery_destination" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.property.bigqueryDestination"></a>

```python
bigquery_destination: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination">GoogleContainerClusterResourceUsageExportConfigBigqueryDestination</a>

bigquery_destination block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#bigquery_destination GoogleContainerCluster#bigquery_destination}

---

##### `enable_network_egress_metering`<sup>Optional</sup> <a name="enable_network_egress_metering" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.property.enableNetworkEgressMetering"></a>

```python
enable_network_egress_metering: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable network egress metering for this cluster.

If enabled, a daemonset will be created in the cluster to meter network egress traffic.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_network_egress_metering GoogleContainerCluster#enable_network_egress_metering}

---

##### `enable_resource_consumption_metering`<sup>Optional</sup> <a name="enable_resource_consumption_metering" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfig.property.enableResourceConsumptionMetering"></a>

```python
enable_resource_consumption_metering: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to enable resource consumption metering on this cluster.

When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enable_resource_consumption_metering GoogleContainerCluster#enable_resource_consumption_metering}

---

### GoogleContainerClusterResourceUsageExportConfigBigqueryDestination <a name="GoogleContainerClusterResourceUsageExportConfigBigqueryDestination" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination(
  dataset_id: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination.property.datasetId">dataset_id</a></code> | <code>str</code> | The ID of a BigQuery Dataset. |

---

##### `dataset_id`<sup>Required</sup> <a name="dataset_id" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterResourceUsageExportConfigBigqueryDestination.property.datasetId"></a>

```python
dataset_id: str
```

- *Type:* str

The ID of a BigQuery Dataset.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#dataset_id GoogleContainerCluster#dataset_id}

---

### GoogleContainerClusterServiceExternalIpsConfig <a name="GoogleContainerClusterServiceExternalIpsConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | When enabled, services with exterenal ips specified will be allowed. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterServiceExternalIpsConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

When enabled, services with exterenal ips specified will be allowed.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterTimeouts <a name="GoogleContainerClusterTimeouts" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterTimeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.create">create</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#create GoogleContainerCluster#create}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.delete">delete</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#delete GoogleContainerCluster#delete}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.read">read</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#read GoogleContainerCluster#read}. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.update">update</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#update GoogleContainerCluster#update}. |

---

##### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.create"></a>

```python
create: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#create GoogleContainerCluster#create}.

---

##### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.delete"></a>

```python
delete: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#delete GoogleContainerCluster#delete}.

---

##### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.read"></a>

```python
read: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#read GoogleContainerCluster#read}.

---

##### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTimeouts.property.update"></a>

```python
update: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#update GoogleContainerCluster#update}.

---

### GoogleContainerClusterTpuConfig <a name="GoogleContainerClusterTpuConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterTpuConfig(
  enabled: typing.Union[bool, IResolvable],
  use_service_networking: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether Cloud TPU integration is enabled or not. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig.property.useServiceNetworking">use_service_networking</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Whether to use service networking for Cloud TPU or not. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether Cloud TPU integration is enabled or not.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

##### `use_service_networking`<sup>Optional</sup> <a name="use_service_networking" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterTpuConfig.property.useServiceNetworking"></a>

```python
use_service_networking: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Whether to use service networking for Cloud TPU or not.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#use_service_networking GoogleContainerCluster#use_service_networking}

---

### GoogleContainerClusterVerticalPodAutoscaling <a name="GoogleContainerClusterVerticalPodAutoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling(
  enabled: typing.Union[bool, IResolvable]
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Enables vertical pod autoscaling. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterVerticalPodAutoscaling.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Enables vertical pod autoscaling.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}

---

### GoogleContainerClusterWorkloadIdentityConfig <a name="GoogleContainerClusterWorkloadIdentityConfig" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig(
  workload_pool: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig.property.workloadPool">workload_pool</a></code> | <code>str</code> | The workload pool to attach all Kubernetes service accounts to. |

---

##### `workload_pool`<sup>Optional</sup> <a name="workload_pool" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterWorkloadIdentityConfig.property.workloadPool"></a>

```python
workload_pool: str
```

- *Type:* str

The workload pool to attach all Kubernetes service accounts to.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#workload_pool GoogleContainerCluster#workload_pool}

---

## Classes <a name="Classes" id="Classes"></a>

### GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference <a name="GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.resetLoadBalancerType">reset_load_balancer_type</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_load_balancer_type` <a name="reset_load_balancer_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.resetLoadBalancerType"></a>

```python
def reset_load_balancer_type() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabledInput">disabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerTypeInput">load_balancer_type_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerType">load_balancer_type</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `disabled_input`<sup>Optional</sup> <a name="disabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabledInput"></a>

```python
disabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `load_balancer_type_input`<sup>Optional</sup> <a name="load_balancer_type_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerTypeInput"></a>

```python
load_balancer_type_input: str
```

- *Type:* str

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `load_balancer_type`<sup>Required</sup> <a name="load_balancer_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerType"></a>

```python
load_balancer_type: str
```

- *Type:* str

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigCloudrunConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a>

---


### GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference <a name="GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigConfigConnectorConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a>

---


### GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference <a name="GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigDnsCacheConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a>

---


### GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference <a name="GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

---


### GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference <a name="GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

---


### GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference <a name="GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a>

---


### GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference <a name="GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabledInput">disabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `disabled_input`<sup>Optional</sup> <a name="disabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabledInput"></a>

```python
disabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

---


### GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference <a name="GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabledInput">disabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `disabled_input`<sup>Optional</sup> <a name="disabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabledInput"></a>

```python
disabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigHttpLoadBalancing
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a>

---


### GoogleContainerClusterAddonsConfigIstioConfigOutputReference <a name="GoogleContainerClusterAddonsConfigIstioConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.resetAuth">reset_auth</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_auth` <a name="reset_auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.resetAuth"></a>

```python
def reset_auth() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.authInput">auth_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.disabledInput">disabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.auth">auth</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `auth_input`<sup>Optional</sup> <a name="auth_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.authInput"></a>

```python
auth_input: str
```

- *Type:* str

---

##### `disabled_input`<sup>Optional</sup> <a name="disabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.disabledInput"></a>

```python
disabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `auth`<sup>Required</sup> <a name="auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.auth"></a>

```python
auth: str
```

- *Type:* str

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigIstioConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a>

---


### GoogleContainerClusterAddonsConfigKalmConfigOutputReference <a name="GoogleContainerClusterAddonsConfigKalmConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigKalmConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a>

---


### GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference <a name="GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabledInput">disabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabled">disabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `disabled_input`<sup>Optional</sup> <a name="disabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabledInput"></a>

```python
disabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabled"></a>

```python
disabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfigNetworkPolicyConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a>

---


### GoogleContainerClusterAddonsConfigOutputReference <a name="GoogleContainerClusterAddonsConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putCloudrunConfig">put_cloudrun_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putConfigConnectorConfig">put_config_connector_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putDnsCacheConfig">put_dns_cache_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGcePersistentDiskCsiDriverConfig">put_gce_persistent_disk_csi_driver_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGcpFilestoreCsiDriverConfig">put_gcp_filestore_csi_driver_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGkeBackupAgentConfig">put_gke_backup_agent_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putHorizontalPodAutoscaling">put_horizontal_pod_autoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putHttpLoadBalancing">put_http_load_balancing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putIstioConfig">put_istio_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putKalmConfig">put_kalm_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putNetworkPolicyConfig">put_network_policy_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetCloudrunConfig">reset_cloudrun_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetConfigConnectorConfig">reset_config_connector_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetDnsCacheConfig">reset_dns_cache_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetGcePersistentDiskCsiDriverConfig">reset_gce_persistent_disk_csi_driver_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetGcpFilestoreCsiDriverConfig">reset_gcp_filestore_csi_driver_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetGkeBackupAgentConfig">reset_gke_backup_agent_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetHorizontalPodAutoscaling">reset_horizontal_pod_autoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetHttpLoadBalancing">reset_http_load_balancing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetIstioConfig">reset_istio_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetKalmConfig">reset_kalm_config</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetNetworkPolicyConfig">reset_network_policy_config</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `put_cloudrun_config` <a name="put_cloudrun_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putCloudrunConfig"></a>

```python
def put_cloudrun_config(
  disabled: typing.Union[bool, IResolvable],
  load_balancer_type: str = None
) -> None
```

###### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putCloudrunConfig.parameter.disabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

###### `load_balancer_type`<sup>Optional</sup> <a name="load_balancer_type" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putCloudrunConfig.parameter.loadBalancerType"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#load_balancer_type GoogleContainerCluster#load_balancer_type}.

---

##### `put_config_connector_config` <a name="put_config_connector_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putConfigConnectorConfig"></a>

```python
def put_config_connector_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putConfigConnectorConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

##### `put_dns_cache_config` <a name="put_dns_cache_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putDnsCacheConfig"></a>

```python
def put_dns_cache_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putDnsCacheConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

##### `put_gce_persistent_disk_csi_driver_config` <a name="put_gce_persistent_disk_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGcePersistentDiskCsiDriverConfig"></a>

```python
def put_gce_persistent_disk_csi_driver_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGcePersistentDiskCsiDriverConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

##### `put_gcp_filestore_csi_driver_config` <a name="put_gcp_filestore_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGcpFilestoreCsiDriverConfig"></a>

```python
def put_gcp_filestore_csi_driver_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGcpFilestoreCsiDriverConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

##### `put_gke_backup_agent_config` <a name="put_gke_backup_agent_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGkeBackupAgentConfig"></a>

```python
def put_gke_backup_agent_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putGkeBackupAgentConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

##### `put_horizontal_pod_autoscaling` <a name="put_horizontal_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putHorizontalPodAutoscaling"></a>

```python
def put_horizontal_pod_autoscaling(
  disabled: typing.Union[bool, IResolvable]
) -> None
```

###### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putHorizontalPodAutoscaling.parameter.disabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

##### `put_http_load_balancing` <a name="put_http_load_balancing" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putHttpLoadBalancing"></a>

```python
def put_http_load_balancing(
  disabled: typing.Union[bool, IResolvable]
) -> None
```

###### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putHttpLoadBalancing.parameter.disabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

##### `put_istio_config` <a name="put_istio_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putIstioConfig"></a>

```python
def put_istio_config(
  disabled: typing.Union[bool, IResolvable],
  auth: str = None
) -> None
```

###### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putIstioConfig.parameter.disabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

The status of the Istio addon, which makes it easy to set up Istio for services in a cluster.

It is disabled by default. Set disabled = false to enable.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}

---

###### `auth`<sup>Optional</sup> <a name="auth" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putIstioConfig.parameter.auth"></a>

- *Type:* str

The authentication type between services in Istio. Available options include AUTH_MUTUAL_TLS.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#auth GoogleContainerCluster#auth}

---

##### `put_kalm_config` <a name="put_kalm_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putKalmConfig"></a>

```python
def put_kalm_config(
  enabled: typing.Union[bool, IResolvable]
) -> None
```

###### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putKalmConfig.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}.

---

##### `put_network_policy_config` <a name="put_network_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putNetworkPolicyConfig"></a>

```python
def put_network_policy_config(
  disabled: typing.Union[bool, IResolvable]
) -> None
```

###### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.putNetworkPolicyConfig.parameter.disabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}.

---

##### `reset_cloudrun_config` <a name="reset_cloudrun_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetCloudrunConfig"></a>

```python
def reset_cloudrun_config() -> None
```

##### `reset_config_connector_config` <a name="reset_config_connector_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetConfigConnectorConfig"></a>

```python
def reset_config_connector_config() -> None
```

##### `reset_dns_cache_config` <a name="reset_dns_cache_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetDnsCacheConfig"></a>

```python
def reset_dns_cache_config() -> None
```

##### `reset_gce_persistent_disk_csi_driver_config` <a name="reset_gce_persistent_disk_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetGcePersistentDiskCsiDriverConfig"></a>

```python
def reset_gce_persistent_disk_csi_driver_config() -> None
```

##### `reset_gcp_filestore_csi_driver_config` <a name="reset_gcp_filestore_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetGcpFilestoreCsiDriverConfig"></a>

```python
def reset_gcp_filestore_csi_driver_config() -> None
```

##### `reset_gke_backup_agent_config` <a name="reset_gke_backup_agent_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetGkeBackupAgentConfig"></a>

```python
def reset_gke_backup_agent_config() -> None
```

##### `reset_horizontal_pod_autoscaling` <a name="reset_horizontal_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetHorizontalPodAutoscaling"></a>

```python
def reset_horizontal_pod_autoscaling() -> None
```

##### `reset_http_load_balancing` <a name="reset_http_load_balancing" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetHttpLoadBalancing"></a>

```python
def reset_http_load_balancing() -> None
```

##### `reset_istio_config` <a name="reset_istio_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetIstioConfig"></a>

```python
def reset_istio_config() -> None
```

##### `reset_kalm_config` <a name="reset_kalm_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetKalmConfig"></a>

```python
def reset_kalm_config() -> None
```

##### `reset_network_policy_config` <a name="reset_network_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.resetNetworkPolicyConfig"></a>

```python
def reset_network_policy_config() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.cloudrunConfig">cloudrun_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference">GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.configConnectorConfig">config_connector_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference">GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.dnsCacheConfig">dns_cache_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference">GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfig">gce_persistent_disk_csi_driver_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfig">gcp_filestore_csi_driver_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfig">gke_backup_agent_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference">GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscaling">horizontal_pod_autoscaling</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference">GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.httpLoadBalancing">http_load_balancing</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference">GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.istioConfig">istio_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference">GoogleContainerClusterAddonsConfigIstioConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.kalmConfig">kalm_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference">GoogleContainerClusterAddonsConfigKalmConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.networkPolicyConfig">network_policy_config</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference">GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.cloudrunConfigInput">cloudrun_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.configConnectorConfigInput">config_connector_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.dnsCacheConfigInput">dns_cache_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfigInput">gce_persistent_disk_csi_driver_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfigInput">gcp_filestore_csi_driver_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfigInput">gke_backup_agent_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscalingInput">horizontal_pod_autoscaling_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.httpLoadBalancingInput">http_load_balancing_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.istioConfigInput">istio_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.kalmConfigInput">kalm_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.networkPolicyConfigInput">network_policy_config_input</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `cloudrun_config`<sup>Required</sup> <a name="cloudrun_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.cloudrunConfig"></a>

```python
cloudrun_config: GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference">GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference</a>

---

##### `config_connector_config`<sup>Required</sup> <a name="config_connector_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.configConnectorConfig"></a>

```python
config_connector_config: GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference">GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference</a>

---

##### `dns_cache_config`<sup>Required</sup> <a name="dns_cache_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.dnsCacheConfig"></a>

```python
dns_cache_config: GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference">GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference</a>

---

##### `gce_persistent_disk_csi_driver_config`<sup>Required</sup> <a name="gce_persistent_disk_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfig"></a>

```python
gce_persistent_disk_csi_driver_config: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference</a>

---

##### `gcp_filestore_csi_driver_config`<sup>Required</sup> <a name="gcp_filestore_csi_driver_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfig"></a>

```python
gcp_filestore_csi_driver_config: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference</a>

---

##### `gke_backup_agent_config`<sup>Required</sup> <a name="gke_backup_agent_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfig"></a>

```python
gke_backup_agent_config: GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference">GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference</a>

---

##### `horizontal_pod_autoscaling`<sup>Required</sup> <a name="horizontal_pod_autoscaling" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscaling"></a>

```python
horizontal_pod_autoscaling: GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference">GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference</a>

---

##### `http_load_balancing`<sup>Required</sup> <a name="http_load_balancing" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.httpLoadBalancing"></a>

```python
http_load_balancing: GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference">GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference</a>

---

##### `istio_config`<sup>Required</sup> <a name="istio_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.istioConfig"></a>

```python
istio_config: GoogleContainerClusterAddonsConfigIstioConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfigOutputReference">GoogleContainerClusterAddonsConfigIstioConfigOutputReference</a>

---

##### `kalm_config`<sup>Required</sup> <a name="kalm_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.kalmConfig"></a>

```python
kalm_config: GoogleContainerClusterAddonsConfigKalmConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfigOutputReference">GoogleContainerClusterAddonsConfigKalmConfigOutputReference</a>

---

##### `network_policy_config`<sup>Required</sup> <a name="network_policy_config" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.networkPolicyConfig"></a>

```python
network_policy_config: GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference">GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference</a>

---

##### `cloudrun_config_input`<sup>Optional</sup> <a name="cloudrun_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.cloudrunConfigInput"></a>

```python
cloudrun_config_input: GoogleContainerClusterAddonsConfigCloudrunConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigCloudrunConfig">GoogleContainerClusterAddonsConfigCloudrunConfig</a>

---

##### `config_connector_config_input`<sup>Optional</sup> <a name="config_connector_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.configConnectorConfigInput"></a>

```python
config_connector_config_input: GoogleContainerClusterAddonsConfigConfigConnectorConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigConfigConnectorConfig">GoogleContainerClusterAddonsConfigConfigConnectorConfig</a>

---

##### `dns_cache_config_input`<sup>Optional</sup> <a name="dns_cache_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.dnsCacheConfigInput"></a>

```python
dns_cache_config_input: GoogleContainerClusterAddonsConfigDnsCacheConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigDnsCacheConfig">GoogleContainerClusterAddonsConfigDnsCacheConfig</a>

---

##### `gce_persistent_disk_csi_driver_config_input`<sup>Optional</sup> <a name="gce_persistent_disk_csi_driver_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfigInput"></a>

```python
gce_persistent_disk_csi_driver_config_input: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

---

##### `gcp_filestore_csi_driver_config_input`<sup>Optional</sup> <a name="gcp_filestore_csi_driver_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfigInput"></a>

```python
gcp_filestore_csi_driver_config_input: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

---

##### `gke_backup_agent_config_input`<sup>Optional</sup> <a name="gke_backup_agent_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfigInput"></a>

```python
gke_backup_agent_config_input: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigGkeBackupAgentConfig">GoogleContainerClusterAddonsConfigGkeBackupAgentConfig</a>

---

##### `horizontal_pod_autoscaling_input`<sup>Optional</sup> <a name="horizontal_pod_autoscaling_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscalingInput"></a>

```python
horizontal_pod_autoscaling_input: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling">GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

---

##### `http_load_balancing_input`<sup>Optional</sup> <a name="http_load_balancing_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.httpLoadBalancingInput"></a>

```python
http_load_balancing_input: GoogleContainerClusterAddonsConfigHttpLoadBalancing
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigHttpLoadBalancing">GoogleContainerClusterAddonsConfigHttpLoadBalancing</a>

---

##### `istio_config_input`<sup>Optional</sup> <a name="istio_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.istioConfigInput"></a>

```python
istio_config_input: GoogleContainerClusterAddonsConfigIstioConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigIstioConfig">GoogleContainerClusterAddonsConfigIstioConfig</a>

---

##### `kalm_config_input`<sup>Optional</sup> <a name="kalm_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.kalmConfigInput"></a>

```python
kalm_config_input: GoogleContainerClusterAddonsConfigKalmConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigKalmConfig">GoogleContainerClusterAddonsConfigKalmConfig</a>

---

##### `network_policy_config_input`<sup>Optional</sup> <a name="network_policy_config_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.networkPolicyConfigInput"></a>

```python
network_policy_config_input: GoogleContainerClusterAddonsConfigNetworkPolicyConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigNetworkPolicyConfig">GoogleContainerClusterAddonsConfigNetworkPolicyConfig</a>

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAddonsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAddonsConfig">GoogleContainerClusterAddonsConfig</a>

---


### GoogleContainerClusterAuthenticatorGroupsConfigOutputReference <a name="GoogleContainerClusterAuthenticatorGroupsConfigOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroupInput">security_group_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroup">security_group</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `security_group_input`<sup>Optional</sup> <a name="security_group_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroupInput"></a>

```python
security_group_input: str
```

- *Type:* str

---

##### `security_group`<sup>Required</sup> <a name="security_group" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroup"></a>

```python
security_group: str
```

- *Type:* str

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterAuthenticatorGroupsConfig
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterAuthenticatorGroupsConfig">GoogleContainerClusterAuthenticatorGroupsConfig</a>

---


### GoogleContainerClusterBinaryAuthorizationOutputReference <a name="GoogleContainerClusterBinaryAuthorizationOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resetEnabled">reset_enabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resetEvaluationMode">reset_evaluation_mode</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_enabled` <a name="reset_enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resetEnabled"></a>

```python
def reset_enabled() -> None
```

##### `reset_evaluation_mode` <a name="reset_evaluation_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.resetEvaluationMode"></a>

```python
def reset_evaluation_mode() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.evaluationModeInput">evaluation_mode_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.evaluationMode">evaluation_mode</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `evaluation_mode_input`<sup>Optional</sup> <a name="evaluation_mode_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.evaluationModeInput"></a>

```python
evaluation_mode_input: str
```

- *Type:* str

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `evaluation_mode`<sup>Required</sup> <a name="evaluation_mode" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.evaluationMode"></a>

```python
evaluation_mode: str
```

- *Type:* str

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorizationOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterBinaryAuthorization
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterBinaryAuthorization">GoogleContainerClusterBinaryAuthorization</a>

---


### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoRepair">reset_auto_repair</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoUpgrade">reset_auto_upgrade</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_auto_repair` <a name="reset_auto_repair" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoRepair"></a>

```python
def reset_auto_repair() -> None
```

##### `reset_auto_upgrade` <a name="reset_auto_upgrade" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoUpgrade"></a>

```python
def reset_auto_upgrade() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.upgradeOptions">upgrade_options</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepairInput">auto_repair_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgradeInput">auto_upgrade_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepair">auto_repair</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgrade">auto_upgrade</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `upgrade_options`<sup>Required</sup> <a name="upgrade_options" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.upgradeOptions"></a>

```python
upgrade_options: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList</a>

---

##### `auto_repair_input`<sup>Optional</sup> <a name="auto_repair_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepairInput"></a>

```python
auto_repair_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `auto_upgrade_input`<sup>Optional</sup> <a name="auto_upgrade_input" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgradeInput"></a>

```python
auto_upgrade_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `auto_repair`<sup>Required</sup> <a name="auto_repair" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepair"></a>

```python
auto_repair: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `auto_upgrade`<sup>Required</sup> <a name="auto_upgrade" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgrade"></a>

```python
auto_upgrade: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.internalValue"></a>

```python
internal_value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement
```

- *Type:* <a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a>

---


### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str,
  wraps_set: bool
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.wrapsSet">wraps_set</a></code> | <code>bool</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

##### `wraps_set`<sup>Required</sup> <a name="wraps_set" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.wrapsSet"></a>

- *Type:* bool

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.get">get</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `resolve` <a name="resolve" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.get"></a>

```python
def get(
  index: typing.Union[int, float]
) -> GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.get.parameter.index"></a>

- *Type:* typing.Union[int, float]

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---


### GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference <a name="GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_google_beta import google_container_cluster

googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str,
  complex_object_index: typing.Union[int, float],
  complex_object_is_from_set: bool
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIndex">complex_object_index</a></code> | <code>typing.Union[int, float]</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIsFromSet">complex_object_is_from_set</a></code> | <code>bool</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

##### `complex_object_index`<sup>Required</sup> <a name="complex_object_index" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* typing.Union[int, float]

the index of this item in the list.

---

##### `complex_object_is_from_set`<sup>Required</sup> <a name="complex_object_is_from_set" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* bool

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsM