import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBeyondcorpAppGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_beyondcorp_app_gateway#id DataGoogleBeyondcorpAppGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the AppGateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_beyondcorp_app_gateway#name DataGoogleBeyondcorpAppGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_beyondcorp_app_gateway#project DataGoogleBeyondcorpAppGateway#project}
    */
    readonly project?: string;
    /**
    * The region of the AppGateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_beyondcorp_app_gateway#region DataGoogleBeyondcorpAppGateway#region}
    */
    readonly region?: string;
}
export interface DataGoogleBeyondcorpAppGatewayAllocatedConnections {
}
export declare function dataGoogleBeyondcorpAppGatewayAllocatedConnectionsToTerraform(struct?: DataGoogleBeyondcorpAppGatewayAllocatedConnections): any;
export declare class DataGoogleBeyondcorpAppGatewayAllocatedConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBeyondcorpAppGatewayAllocatedConnections | undefined;
    set internalValue(value: DataGoogleBeyondcorpAppGatewayAllocatedConnections | undefined);
    get ingressPort(): number;
    get pscUri(): string;
}
export declare class DataGoogleBeyondcorpAppGatewayAllocatedConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBeyondcorpAppGatewayAllocatedConnectionsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_beyondcorp_app_gateway google_beyondcorp_app_gateway}
*/
export declare class DataGoogleBeyondcorpAppGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_beyondcorp_app_gateway";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_beyondcorp_app_gateway google_beyondcorp_app_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBeyondcorpAppGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleBeyondcorpAppGatewayConfig);
    private _allocatedConnections;
    get allocatedConnections(): DataGoogleBeyondcorpAppGatewayAllocatedConnectionsList;
    get displayName(): string;
    get hostType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get state(): string;
    get type(): string;
    get uri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
