import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudAssetResourcesSearchAllConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_asset_resources_search_all#asset_types DataGoogleCloudAssetResourcesSearchAll#asset_types}
    */
    readonly assetTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_asset_resources_search_all#id DataGoogleCloudAssetResourcesSearchAll#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_asset_resources_search_all#query DataGoogleCloudAssetResourcesSearchAll#query}
    */
    readonly query?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_asset_resources_search_all#scope DataGoogleCloudAssetResourcesSearchAll#scope}
    */
    readonly scope: string;
}
export interface DataGoogleCloudAssetResourcesSearchAllResults {
}
export declare function dataGoogleCloudAssetResourcesSearchAllResultsToTerraform(struct?: DataGoogleCloudAssetResourcesSearchAllResults): any;
export declare class DataGoogleCloudAssetResourcesSearchAllResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudAssetResourcesSearchAllResults | undefined;
    set internalValue(value: DataGoogleCloudAssetResourcesSearchAllResults | undefined);
    get additionalAttributes(): string[];
    get assetType(): string;
    get description(): string;
    get displayName(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get location(): string;
    get name(): string;
    get networkTags(): string[];
    get project(): string;
}
export declare class DataGoogleCloudAssetResourcesSearchAllResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudAssetResourcesSearchAllResultsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_asset_resources_search_all google_cloud_asset_resources_search_all}
*/
export declare class DataGoogleCloudAssetResourcesSearchAll extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_asset_resources_search_all";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_asset_resources_search_all google_cloud_asset_resources_search_all} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudAssetResourcesSearchAllConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudAssetResourcesSearchAllConfig);
    private _assetTypes?;
    get assetTypes(): string[];
    set assetTypes(value: string[]);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    resetQuery(): void;
    get queryInput(): string | undefined;
    private _results;
    get results(): DataGoogleCloudAssetResourcesSearchAllResultsList;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
