import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudIdentityGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_identity_groups#id DataGoogleCloudIdentityGroups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the entity under which this Group resides in the
  Cloud Identity resource hierarchy.
  
  Must be of the form identitysources/{identity_source_id} for external-identity-mapped
  groups or customers/{customer_id} for Google Groups.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_identity_groups#parent DataGoogleCloudIdentityGroups#parent}
    */
    readonly parent: string;
}
export interface DataGoogleCloudIdentityGroupsGroupsGroupKey {
}
export declare function dataGoogleCloudIdentityGroupsGroupsGroupKeyToTerraform(struct?: DataGoogleCloudIdentityGroupsGroupsGroupKey): any;
export declare class DataGoogleCloudIdentityGroupsGroupsGroupKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupsGroupsGroupKey | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupsGroupsGroupKey | undefined);
    get id(): string;
    get namespace(): string;
}
export declare class DataGoogleCloudIdentityGroupsGroupsGroupKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupsGroupsGroupKeyOutputReference;
}
export interface DataGoogleCloudIdentityGroupsGroups {
}
export declare function dataGoogleCloudIdentityGroupsGroupsToTerraform(struct?: DataGoogleCloudIdentityGroupsGroups): any;
export declare class DataGoogleCloudIdentityGroupsGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupsGroups | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupsGroups | undefined);
    get createTime(): string;
    get description(): string;
    get displayName(): string;
    private _groupKey;
    get groupKey(): DataGoogleCloudIdentityGroupsGroupsGroupKeyList;
    get initialGroupConfig(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get parent(): string;
    get updateTime(): string;
}
export declare class DataGoogleCloudIdentityGroupsGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupsGroupsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_identity_groups google_cloud_identity_groups}
*/
export declare class DataGoogleCloudIdentityGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_identity_groups";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloud_identity_groups google_cloud_identity_groups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudIdentityGroupsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupsConfig);
    private _groups;
    get groups(): DataGoogleCloudIdentityGroupsGroupsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
