import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions_function#id DataGoogleCloudfunctionsFunction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A user-defined name of the function. Function names must be unique globally.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions_function#name DataGoogleCloudfunctionsFunction#name}
    */
    readonly name: string;
    /**
    * Project of the function. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions_function#project DataGoogleCloudfunctionsFunction#project}
    */
    readonly project?: string;
    /**
    * Region of function. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions_function#region DataGoogleCloudfunctionsFunction#region}
    */
    readonly region?: string;
}
export interface DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy {
}
export declare function dataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct?: DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy): any;
export declare class DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicy | undefined);
    get retry(): cdktf.IResolvable;
}
export declare class DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionEventTrigger {
}
export declare function dataGoogleCloudfunctionsFunctionEventTriggerToTerraform(struct?: DataGoogleCloudfunctionsFunctionEventTrigger): any;
export declare class DataGoogleCloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionEventTrigger | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionEventTrigger | undefined);
    get eventType(): string;
    private _failurePolicy;
    get failurePolicy(): DataGoogleCloudfunctionsFunctionEventTriggerFailurePolicyList;
    get resource(): string;
}
export declare class DataGoogleCloudfunctionsFunctionEventTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionEventTriggerOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionSecretEnvironmentVariables {
}
export declare function dataGoogleCloudfunctionsFunctionSecretEnvironmentVariablesToTerraform(struct?: DataGoogleCloudfunctionsFunctionSecretEnvironmentVariables): any;
export declare class DataGoogleCloudfunctionsFunctionSecretEnvironmentVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionSecretEnvironmentVariables | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionSecretEnvironmentVariables | undefined);
    get key(): string;
    get projectId(): string;
    get secret(): string;
    get version(): string;
}
export declare class DataGoogleCloudfunctionsFunctionSecretEnvironmentVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionSecretEnvironmentVariablesOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionSecretVolumesVersions {
}
export declare function dataGoogleCloudfunctionsFunctionSecretVolumesVersionsToTerraform(struct?: DataGoogleCloudfunctionsFunctionSecretVolumesVersions): any;
export declare class DataGoogleCloudfunctionsFunctionSecretVolumesVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionSecretVolumesVersions | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionSecretVolumesVersions | undefined);
    get path(): string;
    get version(): string;
}
export declare class DataGoogleCloudfunctionsFunctionSecretVolumesVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionSecretVolumesVersionsOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionSecretVolumes {
}
export declare function dataGoogleCloudfunctionsFunctionSecretVolumesToTerraform(struct?: DataGoogleCloudfunctionsFunctionSecretVolumes): any;
export declare class DataGoogleCloudfunctionsFunctionSecretVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionSecretVolumes | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionSecretVolumes | undefined);
    get mountPath(): string;
    get projectId(): string;
    get secret(): string;
    private _versions;
    get versions(): DataGoogleCloudfunctionsFunctionSecretVolumesVersionsList;
}
export declare class DataGoogleCloudfunctionsFunctionSecretVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionSecretVolumesOutputReference;
}
export interface DataGoogleCloudfunctionsFunctionSourceRepository {
}
export declare function dataGoogleCloudfunctionsFunctionSourceRepositoryToTerraform(struct?: DataGoogleCloudfunctionsFunctionSourceRepository): any;
export declare class DataGoogleCloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctionsFunctionSourceRepository | undefined;
    set internalValue(value: DataGoogleCloudfunctionsFunctionSourceRepository | undefined);
    get deployedUrl(): string;
    get url(): string;
}
export declare class DataGoogleCloudfunctionsFunctionSourceRepositoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctionsFunctionSourceRepositoryOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions_function google_cloudfunctions_function}
*/
export declare class DataGoogleCloudfunctionsFunction extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloudfunctions_function";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions_function google_cloudfunctions_function} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudfunctionsFunctionConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudfunctionsFunctionConfig);
    get availableMemoryMb(): number;
    private _buildEnvironmentVariables;
    get buildEnvironmentVariables(): cdktf.StringMap;
    get buildWorkerPool(): string;
    get description(): string;
    get dockerRegistry(): string;
    get dockerRepository(): string;
    get entryPoint(): string;
    private _environmentVariables;
    get environmentVariables(): cdktf.StringMap;
    private _eventTrigger;
    get eventTrigger(): DataGoogleCloudfunctionsFunctionEventTriggerList;
    get httpsTriggerSecurityLevel(): string;
    get httpsTriggerUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ingressSettings(): string;
    get kmsKeyName(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get maxInstances(): number;
    get minInstances(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get runtime(): string;
    private _secretEnvironmentVariables;
    get secretEnvironmentVariables(): DataGoogleCloudfunctionsFunctionSecretEnvironmentVariablesList;
    private _secretVolumes;
    get secretVolumes(): DataGoogleCloudfunctionsFunctionSecretVolumesList;
    get serviceAccountEmail(): string;
    get sourceArchiveBucket(): string;
    get sourceArchiveObject(): string;
    private _sourceRepository;
    get sourceRepository(): DataGoogleCloudfunctionsFunctionSourceRepositoryList;
    get timeout(): number;
    get triggerHttp(): cdktf.IResolvable;
    get vpcConnector(): string;
    get vpcConnectorEgressSettings(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
