import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudfunctions2FunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions2_function#id DataGoogleCloudfunctions2Function#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of this cloud function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions2_function#location DataGoogleCloudfunctions2Function#location}
    */
    readonly location: string;
    /**
    * A user-defined name of the function. Function names must
  be unique globally and match pattern 'projects/*\/locations/*\/functions/*'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions2_function#name DataGoogleCloudfunctions2Function#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions2_function#project DataGoogleCloudfunctions2Function#project}
    */
    readonly project?: string;
}
export interface DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSource {
}
export declare function dataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSourceToTerraform(struct?: DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSource): any;
export declare class DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSource | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSource | undefined);
    get branchName(): string;
    get commitSha(): string;
    get dir(): string;
    get invertRegex(): cdktf.IResolvable;
    get projectId(): string;
    get repoName(): string;
    get tagName(): string;
}
export declare class DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSourceOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSource {
}
export declare function dataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSourceToTerraform(struct?: DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSource): any;
export declare class DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSource | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSource | undefined);
    get bucket(): string;
    get generation(): number;
    get object(): string;
}
export declare class DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSourceOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionBuildConfigSource {
}
export declare function dataGoogleCloudfunctions2FunctionBuildConfigSourceToTerraform(struct?: DataGoogleCloudfunctions2FunctionBuildConfigSource): any;
export declare class DataGoogleCloudfunctions2FunctionBuildConfigSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionBuildConfigSource | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionBuildConfigSource | undefined);
    private _repoSource;
    get repoSource(): DataGoogleCloudfunctions2FunctionBuildConfigSourceRepoSourceList;
    private _storageSource;
    get storageSource(): DataGoogleCloudfunctions2FunctionBuildConfigSourceStorageSourceList;
}
export declare class DataGoogleCloudfunctions2FunctionBuildConfigSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionBuildConfigSourceOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionBuildConfig {
}
export declare function dataGoogleCloudfunctions2FunctionBuildConfigToTerraform(struct?: DataGoogleCloudfunctions2FunctionBuildConfig): any;
export declare class DataGoogleCloudfunctions2FunctionBuildConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionBuildConfig | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionBuildConfig | undefined);
    get buildAttribute(): string;
    get dockerRepository(): string;
    get entryPoint(): string;
    private _environmentVariables;
    get environmentVariables(): cdktf.StringMap;
    get runtime(): string;
    private _source;
    get source(): DataGoogleCloudfunctions2FunctionBuildConfigSourceList;
    get workerPool(): string;
}
export declare class DataGoogleCloudfunctions2FunctionBuildConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionBuildConfigOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionEventTriggerEventFilters {
}
export declare function dataGoogleCloudfunctions2FunctionEventTriggerEventFiltersToTerraform(struct?: DataGoogleCloudfunctions2FunctionEventTriggerEventFilters): any;
export declare class DataGoogleCloudfunctions2FunctionEventTriggerEventFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionEventTriggerEventFilters | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionEventTriggerEventFilters | undefined);
    get attribute(): string;
    get operator(): string;
    get value(): string;
}
export declare class DataGoogleCloudfunctions2FunctionEventTriggerEventFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionEventTriggerEventFiltersOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionEventTrigger {
}
export declare function dataGoogleCloudfunctions2FunctionEventTriggerToTerraform(struct?: DataGoogleCloudfunctions2FunctionEventTrigger): any;
export declare class DataGoogleCloudfunctions2FunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionEventTrigger | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionEventTrigger | undefined);
    private _eventFilters;
    get eventFilters(): DataGoogleCloudfunctions2FunctionEventTriggerEventFiltersList;
    get eventType(): string;
    get pubsubTopic(): string;
    get retryPolicy(): string;
    get serviceAccountEmail(): string;
    get trigger(): string;
    get triggerRegion(): string;
}
export declare class DataGoogleCloudfunctions2FunctionEventTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionEventTriggerOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariables {
}
export declare function dataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariablesToTerraform(struct?: DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariables): any;
export declare class DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariables | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariables | undefined);
    get key(): string;
    get projectId(): string;
    get secret(): string;
    get version(): string;
}
export declare class DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariablesOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersions {
}
export declare function dataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersionsToTerraform(struct?: DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersions): any;
export declare class DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersions | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersions | undefined);
    get path(): string;
    get version(): string;
}
export declare class DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersionsOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumes {
}
export declare function dataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesToTerraform(struct?: DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumes): any;
export declare class DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumes | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumes | undefined);
    get mountPath(): string;
    get projectId(): string;
    get secret(): string;
    private _versions;
    get versions(): DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesVersionsList;
}
export declare class DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesOutputReference;
}
export interface DataGoogleCloudfunctions2FunctionServiceConfig {
}
export declare function dataGoogleCloudfunctions2FunctionServiceConfigToTerraform(struct?: DataGoogleCloudfunctions2FunctionServiceConfig): any;
export declare class DataGoogleCloudfunctions2FunctionServiceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudfunctions2FunctionServiceConfig | undefined;
    set internalValue(value: DataGoogleCloudfunctions2FunctionServiceConfig | undefined);
    get allTrafficOnLatestRevision(): cdktf.IResolvable;
    get availableCpu(): string;
    get availableMemory(): string;
    private _environmentVariables;
    get environmentVariables(): cdktf.StringMap;
    get gcfUri(): string;
    get ingressSettings(): string;
    get maxInstanceCount(): number;
    get maxInstanceRequestConcurrency(): number;
    get minInstanceCount(): number;
    private _secretEnvironmentVariables;
    get secretEnvironmentVariables(): DataGoogleCloudfunctions2FunctionServiceConfigSecretEnvironmentVariablesList;
    private _secretVolumes;
    get secretVolumes(): DataGoogleCloudfunctions2FunctionServiceConfigSecretVolumesList;
    get service(): string;
    get serviceAccountEmail(): string;
    get timeoutSeconds(): number;
    get uri(): string;
    get vpcConnector(): string;
    get vpcConnectorEgressSettings(): string;
}
export declare class DataGoogleCloudfunctions2FunctionServiceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudfunctions2FunctionServiceConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions2_function google_cloudfunctions2_function}
*/
export declare class DataGoogleCloudfunctions2Function extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloudfunctions2_function";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_cloudfunctions2_function google_cloudfunctions2_function} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudfunctions2FunctionConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudfunctions2FunctionConfig);
    private _buildConfig;
    get buildConfig(): DataGoogleCloudfunctions2FunctionBuildConfigList;
    get description(): string;
    get environment(): string;
    private _eventTrigger;
    get eventTrigger(): DataGoogleCloudfunctions2FunctionEventTriggerList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceConfig;
    get serviceConfig(): DataGoogleCloudfunctions2FunctionServiceConfigList;
    get state(): string;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
