import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeAddressesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Filter sets the optional parameter "filter": A filter expression that
  filters resources listed in the response. The expression must specify
  the field name, an operator, and the value that you want to use for
  filtering. The value must be a string, a number, or a boolean. The
  operator must be either "=", "!=", ">", "<", "<=", ">=" or ":". For
  example, if you are filtering Compute Engine instances, you can
  exclude instances named "example-instance" by specifying "name !=
  example-instance". The ":" operator can be used with string fields to
  match substrings. For non-string fields it is equivalent to the "="
  operator. The ":*" comparison can be used to test whether a key has
  been defined. For example, to find all objects with "owner" label
  use: """ labels.owner:* """ You can also filter nested fields. For
  example, you could specify "scheduling.automaticRestart = false" to
  include instances only if they are not scheduled for automatic
  restarts. You can use filtering on nested fields to filter based on
  resource labels. To filter on multiple expressions, provide each
  separate expression within parentheses. For example: """
  (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
  """ By default, each expression is an "AND" expression. However, you
  can include "AND" and "OR" expressions explicitly. For example: """
  (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell")
  AND (scheduling.automaticRestart = true) """
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_addresses#filter DataGoogleComputeAddresses#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_addresses#id DataGoogleComputeAddresses#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The google project in which addresses are listed. Defaults to provider's configuration if missing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_addresses#project DataGoogleComputeAddresses#project}
    */
    readonly project?: string;
    /**
    * Region that should be considered to search addresses. All regions are considered if missing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_addresses#region DataGoogleComputeAddresses#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeAddressesAddresses {
}
export declare function dataGoogleComputeAddressesAddressesToTerraform(struct?: DataGoogleComputeAddressesAddresses): any;
export declare class DataGoogleComputeAddressesAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeAddressesAddresses | undefined;
    set internalValue(value: DataGoogleComputeAddressesAddresses | undefined);
    get address(): string;
    get addressType(): string;
    get description(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get region(): string;
    get selfLink(): string;
    get status(): string;
}
export declare class DataGoogleComputeAddressesAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeAddressesAddressesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_addresses google_compute_addresses}
*/
export declare class DataGoogleComputeAddresses extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_addresses";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_addresses google_compute_addresses} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeAddressesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeAddressesConfig);
    private _addresses;
    get addresses(): DataGoogleComputeAddressesAddressesList;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
