import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_region_ssl_certificate#id DataGoogleComputeRegionSslCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
  
  
  These are in the same namespace as the managed SSL certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_region_ssl_certificate#name DataGoogleComputeRegionSslCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_region_ssl_certificate#project DataGoogleComputeRegionSslCertificate#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created regional ssl certificate should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_region_ssl_certificate#region DataGoogleComputeRegionSslCertificate#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_region_ssl_certificate google_compute_region_ssl_certificate}
*/
export declare class DataGoogleComputeRegionSslCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_region_ssl_certificate";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_region_ssl_certificate google_compute_region_ssl_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRegionSslCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRegionSslCertificateConfig);
    get certificate(): string;
    get certificateId(): number;
    get creationTimestamp(): string;
    get description(): string;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get namePrefix(): string;
    get privateKey(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
