import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRouterNatConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat#id DataGoogleComputeRouterNat#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the NAT service. The name must be 1-63 characters long and
  comply with RFC1035.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat#name DataGoogleComputeRouterNat#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat#project DataGoogleComputeRouterNat#project}
    */
    readonly project?: string;
    /**
    * Region where the router and NAT reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat#region DataGoogleComputeRouterNat#region}
    */
    readonly region?: string;
    /**
    * The name of the Cloud Router in which this NAT will be configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat#router DataGoogleComputeRouterNat#router}
    */
    readonly router: string;
}
export interface DataGoogleComputeRouterNatLogConfig {
}
export declare function dataGoogleComputeRouterNatLogConfigToTerraform(struct?: DataGoogleComputeRouterNatLogConfig): any;
export declare class DataGoogleComputeRouterNatLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterNatLogConfig | undefined;
    set internalValue(value: DataGoogleComputeRouterNatLogConfig | undefined);
    get enable(): cdktf.IResolvable;
    get filter(): string;
}
export declare class DataGoogleComputeRouterNatLogConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterNatLogConfigOutputReference;
}
export interface DataGoogleComputeRouterNatRulesAction {
}
export declare function dataGoogleComputeRouterNatRulesActionToTerraform(struct?: DataGoogleComputeRouterNatRulesAction): any;
export declare class DataGoogleComputeRouterNatRulesActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterNatRulesAction | undefined;
    set internalValue(value: DataGoogleComputeRouterNatRulesAction | undefined);
    get sourceNatActiveIps(): string[];
    get sourceNatDrainIps(): string[];
}
export declare class DataGoogleComputeRouterNatRulesActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterNatRulesActionOutputReference;
}
export interface DataGoogleComputeRouterNatRules {
}
export declare function dataGoogleComputeRouterNatRulesToTerraform(struct?: DataGoogleComputeRouterNatRules): any;
export declare class DataGoogleComputeRouterNatRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterNatRules | undefined;
    set internalValue(value: DataGoogleComputeRouterNatRules | undefined);
    private _action;
    get action(): DataGoogleComputeRouterNatRulesActionList;
    get description(): string;
    get match(): string;
    get ruleNumber(): number;
}
export declare class DataGoogleComputeRouterNatRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterNatRulesOutputReference;
}
export interface DataGoogleComputeRouterNatSubnetwork {
}
export declare function dataGoogleComputeRouterNatSubnetworkToTerraform(struct?: DataGoogleComputeRouterNatSubnetwork): any;
export declare class DataGoogleComputeRouterNatSubnetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterNatSubnetwork | undefined;
    set internalValue(value: DataGoogleComputeRouterNatSubnetwork | undefined);
    get name(): string;
    get secondaryIpRangeNames(): string[];
    get sourceIpRangesToNat(): string[];
}
export declare class DataGoogleComputeRouterNatSubnetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterNatSubnetworkOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat google_compute_router_nat}
*/
export declare class DataGoogleComputeRouterNat extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_router_nat";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_nat google_compute_router_nat} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRouterNatConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRouterNatConfig);
    get drainNatIps(): string[];
    get enableDynamicPortAllocation(): cdktf.IResolvable;
    get enableEndpointIndependentMapping(): cdktf.IResolvable;
    get icmpIdleTimeoutSec(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logConfig;
    get logConfig(): DataGoogleComputeRouterNatLogConfigList;
    get maxPortsPerVm(): number;
    get minPortsPerVm(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get natIpAllocateOption(): string;
    get natIps(): string[];
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    private _rules;
    get rules(): DataGoogleComputeRouterNatRulesList;
    get sourceSubnetworkIpRangesToNat(): string;
    private _subnetwork;
    get subnetwork(): DataGoogleComputeRouterNatSubnetworkList;
    get tcpEstablishedIdleTimeoutSec(): number;
    get tcpTimeWaitTimeoutSec(): number;
    get tcpTransitoryIdleTimeoutSec(): number;
    get udpIdleTimeoutSec(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
