import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRouterStatusConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_status#id DataGoogleComputeRouterStatus#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the router to query.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_status#name DataGoogleComputeRouterStatus#name}
    */
    readonly name: string;
    /**
    * Project ID of the target router.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_status#project DataGoogleComputeRouterStatus#project}
    */
    readonly project?: string;
    /**
    * Region of the target router.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_status#region DataGoogleComputeRouterStatus#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeRouterStatusBestRoutes {
}
export declare function dataGoogleComputeRouterStatusBestRoutesToTerraform(struct?: DataGoogleComputeRouterStatusBestRoutes): any;
export declare class DataGoogleComputeRouterStatusBestRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterStatusBestRoutes | undefined;
    set internalValue(value: DataGoogleComputeRouterStatusBestRoutes | undefined);
    get description(): string;
    get destRange(): string;
    get name(): string;
    get network(): string;
    get nextHopGateway(): string;
    get nextHopIlb(): string;
    get nextHopInstance(): string;
    get nextHopInstanceZone(): string;
    get nextHopIp(): string;
    get nextHopNetwork(): string;
    get nextHopVpnTunnel(): string;
    get priority(): number;
    get project(): string;
    get selfLink(): string;
    get tags(): string[];
}
export declare class DataGoogleComputeRouterStatusBestRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterStatusBestRoutesOutputReference;
}
export interface DataGoogleComputeRouterStatusBestRoutesForRouter {
}
export declare function dataGoogleComputeRouterStatusBestRoutesForRouterToTerraform(struct?: DataGoogleComputeRouterStatusBestRoutesForRouter): any;
export declare class DataGoogleComputeRouterStatusBestRoutesForRouterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRouterStatusBestRoutesForRouter | undefined;
    set internalValue(value: DataGoogleComputeRouterStatusBestRoutesForRouter | undefined);
    get description(): string;
    get destRange(): string;
    get name(): string;
    get network(): string;
    get nextHopGateway(): string;
    get nextHopIlb(): string;
    get nextHopInstance(): string;
    get nextHopInstanceZone(): string;
    get nextHopIp(): string;
    get nextHopNetwork(): string;
    get nextHopVpnTunnel(): string;
    get priority(): number;
    get project(): string;
    get selfLink(): string;
    get tags(): string[];
}
export declare class DataGoogleComputeRouterStatusBestRoutesForRouterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRouterStatusBestRoutesForRouterOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_status google_compute_router_status}
*/
export declare class DataGoogleComputeRouterStatus extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_router_status";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_compute_router_status google_compute_router_status} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRouterStatusConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRouterStatusConfig);
    private _bestRoutes;
    get bestRoutes(): DataGoogleComputeRouterStatusBestRoutesList;
    private _bestRoutesForRouter;
    get bestRoutesForRouter(): DataGoogleComputeRouterStatusBestRoutesForRouterList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
