import { DataGoogleContainerClusterAddonsConfigList, DataGoogleContainerClusterAuthenticatorGroupsConfigList, DataGoogleContainerClusterBinaryAuthorizationList, DataGoogleContainerClusterClusterAutoscalingList, DataGoogleContainerClusterClusterTelemetryList, DataGoogleContainerClusterConfidentialNodesList, DataGoogleContainerClusterCostManagementConfigList, DataGoogleContainerClusterDatabaseEncryptionList, DataGoogleContainerClusterDefaultSnatStatusList, DataGoogleContainerClusterDnsConfigList, DataGoogleContainerClusterGatewayApiConfigList, DataGoogleContainerClusterIdentityServiceConfigList, DataGoogleContainerClusterIpAllocationPolicyList, DataGoogleContainerClusterLoggingConfigList, DataGoogleContainerClusterMaintenancePolicyList, DataGoogleContainerClusterMasterAuthList, DataGoogleContainerClusterMasterAuthorizedNetworksConfigList, DataGoogleContainerClusterMeshCertificatesList, DataGoogleContainerClusterMonitoringConfigList, DataGoogleContainerClusterNetworkPolicyList, DataGoogleContainerClusterNodeConfigList, DataGoogleContainerClusterNodePoolList, DataGoogleContainerClusterNodePoolAutoConfigList, DataGoogleContainerClusterNodePoolDefaultsList, DataGoogleContainerClusterNotificationConfigList, DataGoogleContainerClusterPodSecurityPolicyConfigList, DataGoogleContainerClusterPrivateClusterConfigList, DataGoogleContainerClusterProtectConfigList, DataGoogleContainerClusterReleaseChannelList, DataGoogleContainerClusterResourceUsageExportConfigList, DataGoogleContainerClusterServiceExternalIpsConfigList, DataGoogleContainerClusterTpuConfigList, DataGoogleContainerClusterVerticalPodAutoscalingList, DataGoogleContainerClusterWorkloadIdentityConfigList } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_container_cluster#id DataGoogleContainerCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location (region or zone) in which the cluster master will be created, as well as the default node location. If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_container_cluster#location DataGoogleContainerCluster#location}
    */
    readonly location?: string;
    /**
    * The name of the cluster, unique within the project and location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_container_cluster#name DataGoogleContainerCluster#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_container_cluster#project DataGoogleContainerCluster#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_container_cluster google_container_cluster}
*/
export declare class DataGoogleContainerCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_cluster";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_container_cluster google_container_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleContainerClusterConfig);
    private _addonsConfig;
    get addonsConfig(): DataGoogleContainerClusterAddonsConfigList;
    private _authenticatorGroupsConfig;
    get authenticatorGroupsConfig(): DataGoogleContainerClusterAuthenticatorGroupsConfigList;
    private _binaryAuthorization;
    get binaryAuthorization(): DataGoogleContainerClusterBinaryAuthorizationList;
    private _clusterAutoscaling;
    get clusterAutoscaling(): DataGoogleContainerClusterClusterAutoscalingList;
    get clusterIpv4Cidr(): string;
    private _clusterTelemetry;
    get clusterTelemetry(): DataGoogleContainerClusterClusterTelemetryList;
    private _confidentialNodes;
    get confidentialNodes(): DataGoogleContainerClusterConfidentialNodesList;
    private _costManagementConfig;
    get costManagementConfig(): DataGoogleContainerClusterCostManagementConfigList;
    private _databaseEncryption;
    get databaseEncryption(): DataGoogleContainerClusterDatabaseEncryptionList;
    get datapathProvider(): string;
    get defaultMaxPodsPerNode(): number;
    private _defaultSnatStatus;
    get defaultSnatStatus(): DataGoogleContainerClusterDefaultSnatStatusList;
    get description(): string;
    private _dnsConfig;
    get dnsConfig(): DataGoogleContainerClusterDnsConfigList;
    get enableAutopilot(): cdktf.IResolvable;
    get enableBinaryAuthorization(): cdktf.IResolvable;
    get enableIntranodeVisibility(): cdktf.IResolvable;
    get enableKubernetesAlpha(): cdktf.IResolvable;
    get enableL4IlbSubsetting(): cdktf.IResolvable;
    get enableLegacyAbac(): cdktf.IResolvable;
    get enableShieldedNodes(): cdktf.IResolvable;
    get enableTpu(): cdktf.IResolvable;
    get endpoint(): string;
    private _gatewayApiConfig;
    get gatewayApiConfig(): DataGoogleContainerClusterGatewayApiConfigList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identityServiceConfig;
    get identityServiceConfig(): DataGoogleContainerClusterIdentityServiceConfigList;
    get initialNodeCount(): number;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): DataGoogleContainerClusterIpAllocationPolicyList;
    get labelFingerprint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _loggingConfig;
    get loggingConfig(): DataGoogleContainerClusterLoggingConfigList;
    get loggingService(): string;
    private _maintenancePolicy;
    get maintenancePolicy(): DataGoogleContainerClusterMaintenancePolicyList;
    private _masterAuth;
    get masterAuth(): DataGoogleContainerClusterMasterAuthList;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): DataGoogleContainerClusterMasterAuthorizedNetworksConfigList;
    get masterVersion(): string;
    private _meshCertificates;
    get meshCertificates(): DataGoogleContainerClusterMeshCertificatesList;
    get minMasterVersion(): string;
    private _monitoringConfig;
    get monitoringConfig(): DataGoogleContainerClusterMonitoringConfigList;
    get monitoringService(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _networkPolicy;
    get networkPolicy(): DataGoogleContainerClusterNetworkPolicyList;
    get networkingMode(): string;
    private _nodeConfig;
    get nodeConfig(): DataGoogleContainerClusterNodeConfigList;
    get nodeLocations(): string[];
    private _nodePool;
    get nodePool(): DataGoogleContainerClusterNodePoolList;
    private _nodePoolAutoConfig;
    get nodePoolAutoConfig(): DataGoogleContainerClusterNodePoolAutoConfigList;
    private _nodePoolDefaults;
    get nodePoolDefaults(): DataGoogleContainerClusterNodePoolDefaultsList;
    get nodeVersion(): string;
    private _notificationConfig;
    get notificationConfig(): DataGoogleContainerClusterNotificationConfigList;
    get operation(): string;
    private _podSecurityPolicyConfig;
    get podSecurityPolicyConfig(): DataGoogleContainerClusterPodSecurityPolicyConfigList;
    private _privateClusterConfig;
    get privateClusterConfig(): DataGoogleContainerClusterPrivateClusterConfigList;
    get privateIpv6GoogleAccess(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protectConfig;
    get protectConfig(): DataGoogleContainerClusterProtectConfigList;
    private _releaseChannel;
    get releaseChannel(): DataGoogleContainerClusterReleaseChannelList;
    get removeDefaultNodePool(): cdktf.IResolvable;
    private _resourceLabels;
    get resourceLabels(): cdktf.StringMap;
    private _resourceUsageExportConfig;
    get resourceUsageExportConfig(): DataGoogleContainerClusterResourceUsageExportConfigList;
    get selfLink(): string;
    private _serviceExternalIpsConfig;
    get serviceExternalIpsConfig(): DataGoogleContainerClusterServiceExternalIpsConfigList;
    get servicesIpv4Cidr(): string;
    get subnetwork(): string;
    private _tpuConfig;
    get tpuConfig(): DataGoogleContainerClusterTpuConfigList;
    get tpuIpv4CidrBlock(): string;
    private _verticalPodAutoscaling;
    get verticalPodAutoscaling(): DataGoogleContainerClusterVerticalPodAutoscalingList;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): DataGoogleContainerClusterWorkloadIdentityConfigList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
