import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleDataprocMetastoreServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dataproc_metastore_service#id DataGoogleDataprocMetastoreService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location where the metastore service should reside.
  The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dataproc_metastore_service#location DataGoogleDataprocMetastoreService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dataproc_metastore_service#project DataGoogleDataprocMetastoreService#project}
    */
    readonly project?: string;
    /**
    * The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
  and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
  3 and 63 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dataproc_metastore_service#service_id DataGoogleDataprocMetastoreService#service_id}
    */
    readonly serviceId: string;
}
export interface DataGoogleDataprocMetastoreServiceEncryptionConfig {
}
export declare function dataGoogleDataprocMetastoreServiceEncryptionConfigToTerraform(struct?: DataGoogleDataprocMetastoreServiceEncryptionConfig): any;
export declare class DataGoogleDataprocMetastoreServiceEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceEncryptionConfig | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceEncryptionConfig | undefined);
    get kmsKey(): string;
}
export declare class DataGoogleDataprocMetastoreServiceEncryptionConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceEncryptionConfigOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions {
}
export declare function dataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsToTerraform(struct?: DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions): any;
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersions | undefined);
    private _configOverrides;
    get configOverrides(): cdktf.StringMap;
    get key(): string;
    get version(): string;
}
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab {
}
export declare function dataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabToTerraform(struct?: DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab): any;
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytab | undefined);
    get cloudSecret(): string;
}
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig {
}
export declare function dataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigToTerraform(struct?: DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig): any;
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfig | undefined);
    private _keytab;
    get keytab(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigKeytabList;
    get krb5ConfigGcsUri(): string;
    get principal(): string;
}
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceHiveMetastoreConfig {
}
export declare function dataGoogleDataprocMetastoreServiceHiveMetastoreConfigToTerraform(struct?: DataGoogleDataprocMetastoreServiceHiveMetastoreConfig): any;
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfig | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceHiveMetastoreConfig | undefined);
    private _auxiliaryVersions;
    get auxiliaryVersions(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigAuxiliaryVersionsList;
    private _configOverrides;
    get configOverrides(): cdktf.StringMap;
    get endpointProtocol(): string;
    private _kerberosConfig;
    get kerberosConfig(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigKerberosConfigList;
    get version(): string;
}
export declare class DataGoogleDataprocMetastoreServiceHiveMetastoreConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceMaintenanceWindow {
}
export declare function dataGoogleDataprocMetastoreServiceMaintenanceWindowToTerraform(struct?: DataGoogleDataprocMetastoreServiceMaintenanceWindow): any;
export declare class DataGoogleDataprocMetastoreServiceMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceMaintenanceWindow | undefined);
    get dayOfWeek(): string;
    get hourOfDay(): number;
}
export declare class DataGoogleDataprocMetastoreServiceMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceMaintenanceWindowOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig {
}
export declare function dataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigToTerraform(struct?: DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig): any;
export declare class DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfig | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceMetadataIntegration {
}
export declare function dataGoogleDataprocMetastoreServiceMetadataIntegrationToTerraform(struct?: DataGoogleDataprocMetastoreServiceMetadataIntegration): any;
export declare class DataGoogleDataprocMetastoreServiceMetadataIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceMetadataIntegration | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceMetadataIntegration | undefined);
    private _dataCatalogConfig;
    get dataCatalogConfig(): DataGoogleDataprocMetastoreServiceMetadataIntegrationDataCatalogConfigList;
}
export declare class DataGoogleDataprocMetastoreServiceMetadataIntegrationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceMetadataIntegrationOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceNetworkConfigConsumers {
}
export declare function dataGoogleDataprocMetastoreServiceNetworkConfigConsumersToTerraform(struct?: DataGoogleDataprocMetastoreServiceNetworkConfigConsumers): any;
export declare class DataGoogleDataprocMetastoreServiceNetworkConfigConsumersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceNetworkConfigConsumers | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceNetworkConfigConsumers | undefined);
    get endpointUri(): string;
    get subnetwork(): string;
}
export declare class DataGoogleDataprocMetastoreServiceNetworkConfigConsumersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceNetworkConfigConsumersOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceNetworkConfig {
}
export declare function dataGoogleDataprocMetastoreServiceNetworkConfigToTerraform(struct?: DataGoogleDataprocMetastoreServiceNetworkConfig): any;
export declare class DataGoogleDataprocMetastoreServiceNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceNetworkConfig | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceNetworkConfig | undefined);
    private _consumers;
    get consumers(): DataGoogleDataprocMetastoreServiceNetworkConfigConsumersList;
}
export declare class DataGoogleDataprocMetastoreServiceNetworkConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceNetworkConfigOutputReference;
}
export interface DataGoogleDataprocMetastoreServiceTelemetryConfig {
}
export declare function dataGoogleDataprocMetastoreServiceTelemetryConfigToTerraform(struct?: DataGoogleDataprocMetastoreServiceTelemetryConfig): any;
export declare class DataGoogleDataprocMetastoreServiceTelemetryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDataprocMetastoreServiceTelemetryConfig | undefined;
    set internalValue(value: DataGoogleDataprocMetastoreServiceTelemetryConfig | undefined);
    get logFormat(): string;
}
export declare class DataGoogleDataprocMetastoreServiceTelemetryConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDataprocMetastoreServiceTelemetryConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dataproc_metastore_service google_dataproc_metastore_service}
*/
export declare class DataGoogleDataprocMetastoreService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_dataproc_metastore_service";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dataproc_metastore_service google_dataproc_metastore_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleDataprocMetastoreServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleDataprocMetastoreServiceConfig);
    get artifactGcsUri(): string;
    get databaseType(): string;
    private _encryptionConfig;
    get encryptionConfig(): DataGoogleDataprocMetastoreServiceEncryptionConfigList;
    get endpointUri(): string;
    private _hiveMetastoreConfig;
    get hiveMetastoreConfig(): DataGoogleDataprocMetastoreServiceHiveMetastoreConfigList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): DataGoogleDataprocMetastoreServiceMaintenanceWindowList;
    private _metadataIntegration;
    get metadataIntegration(): DataGoogleDataprocMetastoreServiceMetadataIntegrationList;
    get name(): string;
    get network(): string;
    private _networkConfig;
    get networkConfig(): DataGoogleDataprocMetastoreServiceNetworkConfigList;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get releaseChannel(): string;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    get state(): string;
    get stateMessage(): string;
    private _telemetryConfig;
    get telemetryConfig(): DataGoogleDataprocMetastoreServiceTelemetryConfigList;
    get tier(): string;
    get uid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
