import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleDnsRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Name of the zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dns_record_set#managed_zone DataGoogleDnsRecordSet#managed_zone}
    */
    readonly managedZone: string;
    /**
    * The DNS name for the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dns_record_set#name DataGoogleDnsRecordSet#name}
    */
    readonly name: string;
    /**
    * The ID of the project for the Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dns_record_set#project DataGoogleDnsRecordSet#project}
    */
    readonly project?: string;
    /**
    * The identifier of a supported record type. See the list of Supported DNS record types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dns_record_set#type DataGoogleDnsRecordSet#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dns_record_set google_dns_record_set}
*/
export declare class DataGoogleDnsRecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_dns_record_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_dns_record_set google_dns_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleDnsRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleDnsRecordSetConfig);
    get id(): string;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get rrdatas(): string[];
    get ttl(): number;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
