import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFirebaseAndroidAppConfigAConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of the Firebase Android App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_android_app_config#app_id DataGoogleFirebaseAndroidAppConfigA#app_id}
    */
    readonly appId: string;
    /**
    * The project id of the Firebase Android App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_android_app_config#project DataGoogleFirebaseAndroidAppConfigA#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_android_app_config google_firebase_android_app_config}
*/
export declare class DataGoogleFirebaseAndroidAppConfigA extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_firebase_android_app_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_android_app_config google_firebase_android_app_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFirebaseAndroidAppConfigAConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFirebaseAndroidAppConfigAConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get configFileContents(): string;
    get configFilename(): string;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
