import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFirebaseAppleAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * The globally unique, Firebase-assigned identifier of the App.
  This identifier should be treated as an opaque token, as the data format is not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_apple_app#app_id DataGoogleFirebaseAppleApp#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_apple_app#id DataGoogleFirebaseAppleApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_apple_app#project DataGoogleFirebaseAppleApp#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_apple_app google_firebase_apple_app}
*/
export declare class DataGoogleFirebaseAppleApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_firebase_apple_app";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_apple_app google_firebase_apple_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFirebaseAppleAppConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFirebaseAppleAppConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get appStoreId(): string;
    get bundleId(): string;
    get deletionPolicy(): string;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get teamId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
