import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFirebaseHostingChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. Immutable. A unique ID within the site that identifies the channel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_hosting_channel#channel_id DataGoogleFirebaseHostingChannel#channel_id}
    */
    readonly channelId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_hosting_channel#id DataGoogleFirebaseHostingChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Required. The ID of the site in which to create this channel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_hosting_channel#site_id DataGoogleFirebaseHostingChannel#site_id}
    */
    readonly siteId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_hosting_channel google_firebase_hosting_channel}
*/
export declare class DataGoogleFirebaseHostingChannel extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_firebase_hosting_channel";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_firebase_hosting_channel google_firebase_hosting_channel} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFirebaseHostingChannelConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFirebaseHostingChannelConfig);
    private _channelId?;
    get channelId(): string;
    set channelId(value: string);
    get channelIdInput(): string | undefined;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get retainedReleaseCount(): number;
    private _siteId?;
    get siteId(): string;
    set siteId(value: string);
    get siteIdInput(): string | undefined;
    get ttl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
