import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_folder_organization_policy#constraint DataGoogleFolderOrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_folder_organization_policy#folder DataGoogleFolderOrganizationPolicy#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_folder_organization_policy#id DataGoogleFolderOrganizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataGoogleFolderOrganizationPolicyBooleanPolicy {
}
export declare function dataGoogleFolderOrganizationPolicyBooleanPolicyToTerraform(struct?: DataGoogleFolderOrganizationPolicyBooleanPolicy): any;
export declare class DataGoogleFolderOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleFolderOrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: DataGoogleFolderOrganizationPolicyBooleanPolicy | undefined);
    get enforced(): cdktf.IResolvable;
}
export declare class DataGoogleFolderOrganizationPolicyBooleanPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleFolderOrganizationPolicyBooleanPolicyOutputReference;
}
export interface DataGoogleFolderOrganizationPolicyListPolicyAllow {
}
export declare function dataGoogleFolderOrganizationPolicyListPolicyAllowToTerraform(struct?: DataGoogleFolderOrganizationPolicyListPolicyAllow): any;
export declare class DataGoogleFolderOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleFolderOrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: DataGoogleFolderOrganizationPolicyListPolicyAllow | undefined);
    get all(): cdktf.IResolvable;
    get values(): string[];
}
export declare class DataGoogleFolderOrganizationPolicyListPolicyAllowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleFolderOrganizationPolicyListPolicyAllowOutputReference;
}
export interface DataGoogleFolderOrganizationPolicyListPolicyDeny {
}
export declare function dataGoogleFolderOrganizationPolicyListPolicyDenyToTerraform(struct?: DataGoogleFolderOrganizationPolicyListPolicyDeny): any;
export declare class DataGoogleFolderOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleFolderOrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: DataGoogleFolderOrganizationPolicyListPolicyDeny | undefined);
    get all(): cdktf.IResolvable;
    get values(): string[];
}
export declare class DataGoogleFolderOrganizationPolicyListPolicyDenyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleFolderOrganizationPolicyListPolicyDenyOutputReference;
}
export interface DataGoogleFolderOrganizationPolicyListPolicy {
}
export declare function dataGoogleFolderOrganizationPolicyListPolicyToTerraform(struct?: DataGoogleFolderOrganizationPolicyListPolicy): any;
export declare class DataGoogleFolderOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleFolderOrganizationPolicyListPolicy | undefined;
    set internalValue(value: DataGoogleFolderOrganizationPolicyListPolicy | undefined);
    private _allow;
    get allow(): DataGoogleFolderOrganizationPolicyListPolicyAllowList;
    private _deny;
    get deny(): DataGoogleFolderOrganizationPolicyListPolicyDenyList;
    get inheritFromParent(): cdktf.IResolvable;
    get suggestedValue(): string;
}
export declare class DataGoogleFolderOrganizationPolicyListPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleFolderOrganizationPolicyListPolicyOutputReference;
}
export interface DataGoogleFolderOrganizationPolicyRestorePolicy {
}
export declare function dataGoogleFolderOrganizationPolicyRestorePolicyToTerraform(struct?: DataGoogleFolderOrganizationPolicyRestorePolicy): any;
export declare class DataGoogleFolderOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleFolderOrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: DataGoogleFolderOrganizationPolicyRestorePolicy | undefined);
    get default(): cdktf.IResolvable;
}
export declare class DataGoogleFolderOrganizationPolicyRestorePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleFolderOrganizationPolicyRestorePolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_folder_organization_policy google_folder_organization_policy}
*/
export declare class DataGoogleFolderOrganizationPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_folder_organization_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_folder_organization_policy google_folder_organization_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFolderOrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFolderOrganizationPolicyConfig);
    private _booleanPolicy;
    get booleanPolicy(): DataGoogleFolderOrganizationPolicyBooleanPolicyList;
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listPolicy;
    get listPolicy(): DataGoogleFolderOrganizationPolicyListPolicyList;
    private _restorePolicy;
    get restorePolicy(): DataGoogleFolderOrganizationPolicyRestorePolicyList;
    get updateTime(): string;
    get version(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
