import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#id DataGoogleIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * audit_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#audit_config DataGoogleIamPolicy#audit_config}
    */
    readonly auditConfig?: DataGoogleIamPolicyAuditConfig[] | cdktf.IResolvable;
    /**
    * binding block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#binding DataGoogleIamPolicy#binding}
    */
    readonly binding?: DataGoogleIamPolicyBinding[] | cdktf.IResolvable;
}
export interface DataGoogleIamPolicyAuditConfigAuditLogConfigs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#exempted_members DataGoogleIamPolicy#exempted_members}
    */
    readonly exemptedMembers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#log_type DataGoogleIamPolicy#log_type}
    */
    readonly logType: string;
}
export declare function dataGoogleIamPolicyAuditConfigAuditLogConfigsToTerraform(struct?: DataGoogleIamPolicyAuditConfigAuditLogConfigs | cdktf.IResolvable): any;
export declare class DataGoogleIamPolicyAuditConfigAuditLogConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamPolicyAuditConfigAuditLogConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleIamPolicyAuditConfigAuditLogConfigs | cdktf.IResolvable | undefined);
    private _exemptedMembers?;
    get exemptedMembers(): string[];
    set exemptedMembers(value: string[]);
    resetExemptedMembers(): void;
    get exemptedMembersInput(): string[] | undefined;
    private _logType?;
    get logType(): string;
    set logType(value: string);
    get logTypeInput(): string | undefined;
}
export declare class DataGoogleIamPolicyAuditConfigAuditLogConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleIamPolicyAuditConfigAuditLogConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamPolicyAuditConfigAuditLogConfigsOutputReference;
}
export interface DataGoogleIamPolicyAuditConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#service DataGoogleIamPolicy#service}
    */
    readonly service: string;
    /**
    * audit_log_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#audit_log_configs DataGoogleIamPolicy#audit_log_configs}
    */
    readonly auditLogConfigs: DataGoogleIamPolicyAuditConfigAuditLogConfigs[] | cdktf.IResolvable;
}
export declare function dataGoogleIamPolicyAuditConfigToTerraform(struct?: DataGoogleIamPolicyAuditConfig | cdktf.IResolvable): any;
export declare class DataGoogleIamPolicyAuditConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamPolicyAuditConfig | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleIamPolicyAuditConfig | cdktf.IResolvable | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _auditLogConfigs;
    get auditLogConfigs(): DataGoogleIamPolicyAuditConfigAuditLogConfigsList;
    putAuditLogConfigs(value: DataGoogleIamPolicyAuditConfigAuditLogConfigs[] | cdktf.IResolvable): void;
    get auditLogConfigsInput(): cdktf.IResolvable | DataGoogleIamPolicyAuditConfigAuditLogConfigs[] | undefined;
}
export declare class DataGoogleIamPolicyAuditConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleIamPolicyAuditConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamPolicyAuditConfigOutputReference;
}
export interface DataGoogleIamPolicyBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#description DataGoogleIamPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#expression DataGoogleIamPolicy#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#title DataGoogleIamPolicy#title}
    */
    readonly title: string;
}
export declare function dataGoogleIamPolicyBindingConditionToTerraform(struct?: DataGoogleIamPolicyBindingConditionOutputReference | DataGoogleIamPolicyBindingCondition): any;
export declare class DataGoogleIamPolicyBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataGoogleIamPolicyBindingCondition | undefined;
    set internalValue(value: DataGoogleIamPolicyBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export interface DataGoogleIamPolicyBinding {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#members DataGoogleIamPolicy#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#role DataGoogleIamPolicy#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy#condition DataGoogleIamPolicy#condition}
    */
    readonly condition?: DataGoogleIamPolicyBindingCondition;
}
export declare function dataGoogleIamPolicyBindingToTerraform(struct?: DataGoogleIamPolicyBinding | cdktf.IResolvable): any;
export declare class DataGoogleIamPolicyBindingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleIamPolicyBinding | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleIamPolicyBinding | cdktf.IResolvable | undefined);
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DataGoogleIamPolicyBindingConditionOutputReference;
    putCondition(value: DataGoogleIamPolicyBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): DataGoogleIamPolicyBindingCondition | undefined;
}
export declare class DataGoogleIamPolicyBindingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleIamPolicyBinding[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleIamPolicyBindingOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy google_iam_policy}
*/
export declare class DataGoogleIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_iam_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_iam_policy google_iam_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleIamPolicyConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleIamPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get policyData(): string;
    private _auditConfig;
    get auditConfig(): DataGoogleIamPolicyAuditConfigList;
    putAuditConfig(value: DataGoogleIamPolicyAuditConfig[] | cdktf.IResolvable): void;
    resetAuditConfig(): void;
    get auditConfigInput(): cdktf.IResolvable | DataGoogleIamPolicyAuditConfig[] | undefined;
    private _binding;
    get binding(): DataGoogleIamPolicyBindingList;
    putBinding(value: DataGoogleIamPolicyBinding[] | cdktf.IResolvable): void;
    resetBinding(): void;
    get bindingInput(): cdktf.IResolvable | DataGoogleIamPolicyBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
