import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsCryptoKeyVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_crypto_key_version#crypto_key DataGoogleKmsCryptoKeyVersion#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_crypto_key_version#id DataGoogleKmsCryptoKeyVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_crypto_key_version#version DataGoogleKmsCryptoKeyVersion#version}
    */
    readonly version?: number;
}
export interface DataGoogleKmsCryptoKeyVersionPublicKey {
}
export declare function dataGoogleKmsCryptoKeyVersionPublicKeyToTerraform(struct?: DataGoogleKmsCryptoKeyVersionPublicKey): any;
export declare class DataGoogleKmsCryptoKeyVersionPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleKmsCryptoKeyVersionPublicKey | undefined;
    set internalValue(value: DataGoogleKmsCryptoKeyVersionPublicKey | undefined);
    get algorithm(): string;
    get pem(): string;
}
export declare class DataGoogleKmsCryptoKeyVersionPublicKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleKmsCryptoKeyVersionPublicKeyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_crypto_key_version google_kms_crypto_key_version}
*/
export declare class DataGoogleKmsCryptoKeyVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_crypto_key_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_crypto_key_version google_kms_crypto_key_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsCryptoKeyVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsCryptoKeyVersionConfig);
    get algorithm(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get protectionLevel(): string;
    private _publicKey;
    get publicKey(): DataGoogleKmsCryptoKeyVersionPublicKeyList;
    get state(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
