import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsSecretAsymmetricConfig extends cdktf.TerraformMetaArguments {
    /**
    * The public key encrypted ciphertext in base64 encoding
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_secret_asymmetric#ciphertext DataGoogleKmsSecretAsymmetric#ciphertext}
    */
    readonly ciphertext: string;
    /**
    * The crc32 checksum of the ciphertext, hexadecimal encoding. If not specified, it will be computed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_secret_asymmetric#crc32 DataGoogleKmsSecretAsymmetric#crc32}
    */
    readonly crc32?: string;
    /**
    * The fully qualified KMS crypto key version name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_secret_asymmetric#crypto_key_version DataGoogleKmsSecretAsymmetric#crypto_key_version}
    */
    readonly cryptoKeyVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_secret_asymmetric#id DataGoogleKmsSecretAsymmetric#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_secret_asymmetric google_kms_secret_asymmetric}
*/
export declare class DataGoogleKmsSecretAsymmetric extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_secret_asymmetric";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_kms_secret_asymmetric google_kms_secret_asymmetric} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsSecretAsymmetricConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretAsymmetricConfig);
    private _ciphertext?;
    get ciphertext(): string;
    set ciphertext(value: string);
    get ciphertextInput(): string | undefined;
    private _crc32?;
    get crc32(): string;
    set crc32(value: string);
    resetCrc32(): void;
    get crc32Input(): string | undefined;
    private _cryptoKeyVersion?;
    get cryptoKeyVersion(): string;
    set cryptoKeyVersion(value: string);
    get cryptoKeyVersionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get plaintext(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
