import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringMeshIstioServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service#id DataGoogleMonitoringMeshIstioService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the mesh in which this Istio service is defined.
                          Corresponds to the meshUid metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service#mesh_uid DataGoogleMonitoringMeshIstioService#mesh_uid}
    */
    readonly meshUid: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service#project DataGoogleMonitoringMeshIstioService#project}
    */
    readonly project?: string;
    /**
    * The name of the Istio service underlying this service.
                          Corresponds to the destination_service_name metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service#service_name DataGoogleMonitoringMeshIstioService#service_name}
    */
    readonly serviceName: string;
    /**
    * The namespace of the Istio service underlying this service.
                          Corresponds to the destination_service_namespace metric label in Istio metrics.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service#service_namespace DataGoogleMonitoringMeshIstioService#service_namespace}
    */
    readonly serviceNamespace: string;
}
export interface DataGoogleMonitoringMeshIstioServiceTelemetry {
}
export declare function dataGoogleMonitoringMeshIstioServiceTelemetryToTerraform(struct?: DataGoogleMonitoringMeshIstioServiceTelemetry): any;
export declare class DataGoogleMonitoringMeshIstioServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleMonitoringMeshIstioServiceTelemetry | undefined;
    set internalValue(value: DataGoogleMonitoringMeshIstioServiceTelemetry | undefined);
    get resourceName(): string;
}
export declare class DataGoogleMonitoringMeshIstioServiceTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleMonitoringMeshIstioServiceTelemetryOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service google_monitoring_mesh_istio_service}
*/
export declare class DataGoogleMonitoringMeshIstioService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_monitoring_mesh_istio_service";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_monitoring_mesh_istio_service google_monitoring_mesh_istio_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleMonitoringMeshIstioServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringMeshIstioServiceConfig);
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meshUid?;
    get meshUid(): string;
    set meshUid(value: string);
    get meshUidInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceId(): string;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _serviceNamespace?;
    get serviceNamespace(): string;
    set serviceNamespace(value: string);
    get serviceNamespaceInput(): string | undefined;
    private _telemetry;
    get telemetry(): DataGoogleMonitoringMeshIstioServiceTelemetryList;
    private _userLabels;
    get userLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
