import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleNetblockIpRangesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_netblock_ip_ranges#id DataGoogleNetblockIpRanges#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_netblock_ip_ranges#range_type DataGoogleNetblockIpRanges#range_type}
    */
    readonly rangeType?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_netblock_ip_ranges google_netblock_ip_ranges}
*/
export declare class DataGoogleNetblockIpRanges extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_netblock_ip_ranges";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_netblock_ip_ranges google_netblock_ip_ranges} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleNetblockIpRangesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleNetblockIpRangesConfig);
    get cidrBlocks(): string[];
    get cidrBlocksIpv4(): string[];
    get cidrBlocksIpv6(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _rangeType?;
    get rangeType(): string;
    set rangeType(value: string);
    resetRangeType(): void;
    get rangeTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
