import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleRuntimeconfigConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_runtimeconfig_config#id DataGoogleRuntimeconfigConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the runtime config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_runtimeconfig_config#name DataGoogleRuntimeconfigConfig#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_runtimeconfig_config#project DataGoogleRuntimeconfigConfig#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_runtimeconfig_config google_runtimeconfig_config}
*/
export declare class DataGoogleRuntimeconfigConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_runtimeconfig_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_runtimeconfig_config google_runtimeconfig_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleRuntimeconfigConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleRuntimeconfigConfigConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
