import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountJwtConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt#delegates DataGoogleServiceAccountJwt#delegates}
    */
    readonly delegates?: string[];
    /**
    * Number of seconds until the JWT expires. If set and non-zero an `exp` claim will be added to the payload derived from the current timestamp plus expires_in seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt#expires_in DataGoogleServiceAccountJwt#expires_in}
    */
    readonly expiresIn?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt#id DataGoogleServiceAccountJwt#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A JSON-encoded JWT claims set that will be included in the signed JWT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt#payload DataGoogleServiceAccountJwt#payload}
    */
    readonly payload: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt#target_service_account DataGoogleServiceAccountJwt#target_service_account}
    */
    readonly targetServiceAccount: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt google_service_account_jwt}
*/
export declare class DataGoogleServiceAccountJwt extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_service_account_jwt";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/data-sources/google_service_account_jwt google_service_account_jwt} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleServiceAccountJwtConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountJwtConfig);
    private _delegates?;
    get delegates(): string[];
    set delegates(value: string[]);
    resetDelegates(): void;
    get delegatesInput(): string[] | undefined;
    private _expiresIn?;
    get expiresIn(): number;
    set expiresIn(value: number);
    resetExpiresIn(): void;
    get expiresInInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get jwt(): string;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    get payloadInput(): string | undefined;
    private _targetServiceAccount?;
    get targetServiceAccount(): string;
    set targetServiceAccount(value: string);
    get targetServiceAccountInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
