import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleActiveDirectoryPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#authorized_network GoogleActiveDirectoryPeering#authorized_network}
    */
    readonly authorizedNetwork: string;
    /**
    * Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#domain_resource GoogleActiveDirectoryPeering#domain_resource}
    */
    readonly domainResource: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#id GoogleActiveDirectoryPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels that can contain user-provided metadata
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#labels GoogleActiveDirectoryPeering#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#peering_id GoogleActiveDirectoryPeering#peering_id}
    */
    readonly peeringId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#project GoogleActiveDirectoryPeering#project}
    */
    readonly project?: string;
    /**
    * The current state of this Peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#status GoogleActiveDirectoryPeering#status}
    */
    readonly status?: string;
    /**
    * Additional information about the current status of this peering, if available.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#status_message GoogleActiveDirectoryPeering#status_message}
    */
    readonly statusMessage?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#timeouts GoogleActiveDirectoryPeering#timeouts}
    */
    readonly timeouts?: GoogleActiveDirectoryPeeringTimeouts;
}
export interface GoogleActiveDirectoryPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#create GoogleActiveDirectoryPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#delete GoogleActiveDirectoryPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering#update GoogleActiveDirectoryPeering#update}
    */
    readonly update?: string;
}
export declare function googleActiveDirectoryPeeringTimeoutsToTerraform(struct?: GoogleActiveDirectoryPeeringTimeouts | cdktf.IResolvable): any;
export declare class GoogleActiveDirectoryPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleActiveDirectoryPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleActiveDirectoryPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering google_active_directory_peering}
*/
export declare class GoogleActiveDirectoryPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_active_directory_peering";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_active_directory_peering google_active_directory_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleActiveDirectoryPeeringConfig
    */
    constructor(scope: Construct, id: string, config: GoogleActiveDirectoryPeeringConfig);
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    get authorizedNetworkInput(): string | undefined;
    private _domainResource?;
    get domainResource(): string;
    set domainResource(value: string);
    get domainResourceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _peeringId?;
    get peeringId(): string;
    set peeringId(value: string);
    get peeringIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _statusMessage?;
    get statusMessage(): string;
    set statusMessage(value: string);
    resetStatusMessage(): void;
    get statusMessageInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleActiveDirectoryPeeringTimeoutsOutputReference;
    putTimeouts(value: GoogleActiveDirectoryPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleActiveDirectoryPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
