import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbBackupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the alloydb backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#backup_id GoogleAlloydbBackup#backup_id}
    */
    readonly backupId: string;
    /**
    * The full resource name of the backup source cluster (e.g., projects/{project}/locations/{location}/clusters/{clusterId}).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#cluster_name GoogleAlloydbBackup#cluster_name}
    */
    readonly clusterName: string;
    /**
    * User-provided description of the backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#description GoogleAlloydbBackup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#id GoogleAlloydbBackup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the alloydb backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#labels GoogleAlloydbBackup#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the alloydb backup should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#location GoogleAlloydbBackup#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#project GoogleAlloydbBackup#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#timeouts GoogleAlloydbBackup#timeouts}
    */
    readonly timeouts?: GoogleAlloydbBackupTimeouts;
}
export interface GoogleAlloydbBackupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#create GoogleAlloydbBackup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#delete GoogleAlloydbBackup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup#update GoogleAlloydbBackup#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbBackupTimeoutsToTerraform(struct?: GoogleAlloydbBackupTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbBackupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbBackupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbBackupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup google_alloydb_backup}
*/
export declare class GoogleAlloydbBackup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_backup";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_backup google_alloydb_backup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbBackupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbBackupConfig);
    private _backupId?;
    get backupId(): string;
    set backupId(value: string);
    get backupIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleAlloydbBackupTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbBackupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbBackupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
