import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the alloydb cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#cluster_id GoogleAlloydbCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * User-settable and human-readable display name for the Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#display_name GoogleAlloydbCluster#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#id GoogleAlloydbCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the alloydb cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#labels GoogleAlloydbCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the alloydb cluster should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#location GoogleAlloydbCluster#location}
    */
    readonly location?: string;
    /**
    * The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
  
  "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#network GoogleAlloydbCluster#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#project GoogleAlloydbCluster#project}
    */
    readonly project?: string;
    /**
    * automated_backup_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#automated_backup_policy GoogleAlloydbCluster#automated_backup_policy}
    */
    readonly automatedBackupPolicy?: GoogleAlloydbClusterAutomatedBackupPolicy;
    /**
    * initial_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#initial_user GoogleAlloydbCluster#initial_user}
    */
    readonly initialUser?: GoogleAlloydbClusterInitialUser;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#timeouts GoogleAlloydbCluster#timeouts}
    */
    readonly timeouts?: GoogleAlloydbClusterTimeouts;
}
export interface GoogleAlloydbClusterBackupSource {
}
export declare function googleAlloydbClusterBackupSourceToTerraform(struct?: GoogleAlloydbClusterBackupSource): any;
export declare class GoogleAlloydbClusterBackupSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterBackupSource | undefined;
    set internalValue(value: GoogleAlloydbClusterBackupSource | undefined);
    get backupName(): string;
}
export declare class GoogleAlloydbClusterBackupSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterBackupSourceOutputReference;
}
export interface GoogleAlloydbClusterMigrationSource {
}
export declare function googleAlloydbClusterMigrationSourceToTerraform(struct?: GoogleAlloydbClusterMigrationSource): any;
export declare class GoogleAlloydbClusterMigrationSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterMigrationSource | undefined;
    set internalValue(value: GoogleAlloydbClusterMigrationSource | undefined);
    get hostPort(): string;
    get referenceId(): string;
    get sourceType(): string;
}
export declare class GoogleAlloydbClusterMigrationSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterMigrationSourceOutputReference;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention {
    /**
    * The number of backups to retain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#count GoogleAlloydbCluster#count}
    */
    readonly count?: number;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention {
    /**
    * The retention period.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#retention_period GoogleAlloydbCluster#retention_period}
    */
    readonly retentionPeriod?: string;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined);
    private _retentionPeriod?;
    get retentionPeriod(): string;
    set retentionPeriod(value: string);
    resetRetentionPeriod(): void;
    get retentionPeriodInput(): string | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#hours GoogleAlloydbCluster#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#minutes GoogleAlloydbCluster#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#nanos GoogleAlloydbCluster#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#seconds GoogleAlloydbCluster#seconds}
    */
    readonly seconds?: number;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export declare class GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesOutputReference;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule {
    /**
    * The days of the week to perform a backup. At least one day of the week must be provided. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#days_of_week GoogleAlloydbCluster#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * start_times block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#start_times GoogleAlloydbCluster#start_times}
    */
    readonly startTimes: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference | GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _startTimes;
    get startTimes(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesList;
    putStartTimes(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable): void;
    get startTimesInput(): cdktf.IResolvable | GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | undefined;
}
export interface GoogleAlloydbClusterAutomatedBackupPolicy {
    /**
    * The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
  
  The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#backup_window GoogleAlloydbCluster#backup_window}
    */
    readonly backupWindow?: string;
    /**
    * Whether automated backups are enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#enabled GoogleAlloydbCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Labels to apply to backups created using this configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#labels GoogleAlloydbCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#location GoogleAlloydbCluster#location}
    */
    readonly location?: string;
    /**
    * quantity_based_retention block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#quantity_based_retention GoogleAlloydbCluster#quantity_based_retention}
    */
    readonly quantityBasedRetention?: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention;
    /**
    * time_based_retention block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#time_based_retention GoogleAlloydbCluster#time_based_retention}
    */
    readonly timeBasedRetention?: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#weekly_schedule GoogleAlloydbCluster#weekly_schedule}
    */
    readonly weeklySchedule?: GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule;
}
export declare function googleAlloydbClusterAutomatedBackupPolicyToTerraform(struct?: GoogleAlloydbClusterAutomatedBackupPolicyOutputReference | GoogleAlloydbClusterAutomatedBackupPolicy): any;
export declare class GoogleAlloydbClusterAutomatedBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterAutomatedBackupPolicy | undefined;
    set internalValue(value: GoogleAlloydbClusterAutomatedBackupPolicy | undefined);
    private _backupWindow?;
    get backupWindow(): string;
    set backupWindow(value: string);
    resetBackupWindow(): void;
    get backupWindowInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _quantityBasedRetention;
    get quantityBasedRetention(): GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference;
    putQuantityBasedRetention(value: GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): void;
    resetQuantityBasedRetention(): void;
    get quantityBasedRetentionInput(): GoogleAlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined;
    private _timeBasedRetention;
    get timeBasedRetention(): GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference;
    putTimeBasedRetention(value: GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention): void;
    resetTimeBasedRetention(): void;
    get timeBasedRetentionInput(): GoogleAlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined;
    private _weeklySchedule;
    get weeklySchedule(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference;
    putWeeklySchedule(value: GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): GoogleAlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined;
}
export interface GoogleAlloydbClusterInitialUser {
    /**
    * The initial password for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#password GoogleAlloydbCluster#password}
    */
    readonly password: string;
    /**
    * The database username.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#user GoogleAlloydbCluster#user}
    */
    readonly user?: string;
}
export declare function googleAlloydbClusterInitialUserToTerraform(struct?: GoogleAlloydbClusterInitialUserOutputReference | GoogleAlloydbClusterInitialUser): any;
export declare class GoogleAlloydbClusterInitialUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterInitialUser | undefined;
    set internalValue(value: GoogleAlloydbClusterInitialUser | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface GoogleAlloydbClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#create GoogleAlloydbCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#delete GoogleAlloydbCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster#update GoogleAlloydbCluster#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbClusterTimeoutsToTerraform(struct?: GoogleAlloydbClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster google_alloydb_cluster}
*/
export declare class GoogleAlloydbCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_cluster";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_cluster google_alloydb_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbClusterConfig);
    private _backupSource;
    get backupSource(): GoogleAlloydbClusterBackupSourceList;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get databaseVersion(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _migrationSource;
    get migrationSource(): GoogleAlloydbClusterMigrationSourceList;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    private _automatedBackupPolicy;
    get automatedBackupPolicy(): GoogleAlloydbClusterAutomatedBackupPolicyOutputReference;
    putAutomatedBackupPolicy(value: GoogleAlloydbClusterAutomatedBackupPolicy): void;
    resetAutomatedBackupPolicy(): void;
    get automatedBackupPolicyInput(): GoogleAlloydbClusterAutomatedBackupPolicy | undefined;
    private _initialUser;
    get initialUser(): GoogleAlloydbClusterInitialUserOutputReference;
    putInitialUser(value: GoogleAlloydbClusterInitialUser): void;
    resetInitialUser(): void;
    get initialUserInput(): GoogleAlloydbClusterInitialUser | undefined;
    private _timeouts;
    get timeouts(): GoogleAlloydbClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
