import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAlloydbInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#annotations GoogleAlloydbInstance#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types. Possible values: ["AVAILABILITY_TYPE_UNSPECIFIED", "ZONAL", "REGIONAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#availability_type GoogleAlloydbInstance#availability_type}
    */
    readonly availabilityType?: string;
    /**
    * Identifies the alloydb cluster. Must be in the format
  'projects/{project}/locations/{location}/clusters/{cluster_id}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#cluster GoogleAlloydbInstance#cluster}
    */
    readonly cluster: string;
    /**
    * Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#database_flags GoogleAlloydbInstance#database_flags}
    */
    readonly databaseFlags?: {
        [key: string]: string;
    };
    /**
    * User-settable and human-readable display name for the Instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#display_name GoogleAlloydbInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#gce_zone GoogleAlloydbInstance#gce_zone}
    */
    readonly gceZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#id GoogleAlloydbInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the alloydb instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#instance_id GoogleAlloydbInstance#instance_id}
    */
    readonly instanceId: string;
    /**
    * The type of the instance. Possible values: ["PRIMARY", "READ_POOL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#instance_type GoogleAlloydbInstance#instance_type}
    */
    readonly instanceType: string;
    /**
    * User-defined labels for the alloydb instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#labels GoogleAlloydbInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * machine_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#machine_config GoogleAlloydbInstance#machine_config}
    */
    readonly machineConfig?: GoogleAlloydbInstanceMachineConfig;
    /**
    * read_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#read_pool_config GoogleAlloydbInstance#read_pool_config}
    */
    readonly readPoolConfig?: GoogleAlloydbInstanceReadPoolConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#timeouts GoogleAlloydbInstance#timeouts}
    */
    readonly timeouts?: GoogleAlloydbInstanceTimeouts;
}
export interface GoogleAlloydbInstanceMachineConfig {
    /**
    * The number of CPU's in the VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#cpu_count GoogleAlloydbInstance#cpu_count}
    */
    readonly cpuCount?: number;
}
export declare function googleAlloydbInstanceMachineConfigToTerraform(struct?: GoogleAlloydbInstanceMachineConfigOutputReference | GoogleAlloydbInstanceMachineConfig): any;
export declare class GoogleAlloydbInstanceMachineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceMachineConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceMachineConfig | undefined);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    resetCpuCount(): void;
    get cpuCountInput(): number | undefined;
}
export interface GoogleAlloydbInstanceReadPoolConfig {
    /**
    * Read capacity, i.e. number of nodes in a read pool instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#node_count GoogleAlloydbInstance#node_count}
    */
    readonly nodeCount?: number;
}
export declare function googleAlloydbInstanceReadPoolConfigToTerraform(struct?: GoogleAlloydbInstanceReadPoolConfigOutputReference | GoogleAlloydbInstanceReadPoolConfig): any;
export declare class GoogleAlloydbInstanceReadPoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceReadPoolConfig | undefined;
    set internalValue(value: GoogleAlloydbInstanceReadPoolConfig | undefined);
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
}
export interface GoogleAlloydbInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#create GoogleAlloydbInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#delete GoogleAlloydbInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance#update GoogleAlloydbInstance#update}
    */
    readonly update?: string;
}
export declare function googleAlloydbInstanceTimeoutsToTerraform(struct?: GoogleAlloydbInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleAlloydbInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAlloydbInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAlloydbInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance google_alloydb_instance}
*/
export declare class GoogleAlloydbInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_instance";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_alloydb_instance google_alloydb_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAlloydbInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAlloydbInstanceConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _availabilityType?;
    get availabilityType(): string;
    set availabilityType(value: string);
    resetAvailabilityType(): void;
    get availabilityTypeInput(): string | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    private _databaseFlags?;
    get databaseFlags(): {
        [key: string]: string;
    };
    set databaseFlags(value: {
        [key: string]: string;
    });
    resetDatabaseFlags(): void;
    get databaseFlagsInput(): {
        [key: string]: string;
    } | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _gceZone?;
    get gceZone(): string;
    set gceZone(value: string);
    resetGceZone(): void;
    get gceZoneInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    get instanceTypeInput(): string | undefined;
    get ipAddress(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _machineConfig;
    get machineConfig(): GoogleAlloydbInstanceMachineConfigOutputReference;
    putMachineConfig(value: GoogleAlloydbInstanceMachineConfig): void;
    resetMachineConfig(): void;
    get machineConfigInput(): GoogleAlloydbInstanceMachineConfig | undefined;
    private _readPoolConfig;
    get readPoolConfig(): GoogleAlloydbInstanceReadPoolConfigOutputReference;
    putReadPoolConfig(value: GoogleAlloydbInstanceReadPoolConfig): void;
    resetReadPoolConfig(): void;
    get readPoolConfigInput(): GoogleAlloydbInstanceReadPoolConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleAlloydbInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleAlloydbInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAlloydbInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
