import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApiGatewayApiConfigAConfig extends cdktf.TerraformMetaArguments {
    /**
    * The API to attach the config to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#api GoogleApiGatewayApiConfigA#api}
    */
    readonly api: string;
    /**
    * Identifier to assign to the API Config. Must be unique within scope of the parent resource(api).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#api_config_id GoogleApiGatewayApiConfigA#api_config_id}
    */
    readonly apiConfigId?: string;
    /**
    * Creates a unique name beginning with the specified prefix. If this and api_config_id are unspecified, a random value is chosen for the name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#api_config_id_prefix GoogleApiGatewayApiConfigA#api_config_id_prefix}
    */
    readonly apiConfigIdPrefix?: string;
    /**
    * A user-visible name for the API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#display_name GoogleApiGatewayApiConfigA#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#id GoogleApiGatewayApiConfigA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#labels GoogleApiGatewayApiConfigA#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#project GoogleApiGatewayApiConfigA#project}
    */
    readonly project?: string;
    /**
    * gateway_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#gateway_config GoogleApiGatewayApiConfigA#gateway_config}
    */
    readonly gatewayConfig?: GoogleApiGatewayApiConfigGatewayConfig;
    /**
    * grpc_services block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#grpc_services GoogleApiGatewayApiConfigA#grpc_services}
    */
    readonly grpcServices?: GoogleApiGatewayApiConfigGrpcServices[] | cdktf.IResolvable;
    /**
    * managed_service_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#managed_service_configs GoogleApiGatewayApiConfigA#managed_service_configs}
    */
    readonly managedServiceConfigs?: GoogleApiGatewayApiConfigManagedServiceConfigs[] | cdktf.IResolvable;
    /**
    * openapi_documents block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#openapi_documents GoogleApiGatewayApiConfigA#openapi_documents}
    */
    readonly openapiDocuments?: GoogleApiGatewayApiConfigOpenapiDocuments[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#timeouts GoogleApiGatewayApiConfigA#timeouts}
    */
    readonly timeouts?: GoogleApiGatewayApiConfigTimeouts;
}
export interface GoogleApiGatewayApiConfigGatewayConfigBackendConfig {
    /**
    * Google Cloud IAM service account used to sign OIDC tokens for backends that have authentication configured
  (https://cloud.google.com/service-infrastructure/docs/service-management/reference/rest/v1/services.configs#backend).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#google_service_account GoogleApiGatewayApiConfigA#google_service_account}
    */
    readonly googleServiceAccount: string;
}
export declare function googleApiGatewayApiConfigGatewayConfigBackendConfigToTerraform(struct?: GoogleApiGatewayApiConfigGatewayConfigBackendConfigOutputReference | GoogleApiGatewayApiConfigGatewayConfigBackendConfig): any;
export declare class GoogleApiGatewayApiConfigGatewayConfigBackendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiConfigGatewayConfigBackendConfig | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigGatewayConfigBackendConfig | undefined);
    private _googleServiceAccount?;
    get googleServiceAccount(): string;
    set googleServiceAccount(value: string);
    get googleServiceAccountInput(): string | undefined;
}
export interface GoogleApiGatewayApiConfigGatewayConfig {
    /**
    * backend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#backend_config GoogleApiGatewayApiConfigA#backend_config}
    */
    readonly backendConfig: GoogleApiGatewayApiConfigGatewayConfigBackendConfig;
}
export declare function googleApiGatewayApiConfigGatewayConfigToTerraform(struct?: GoogleApiGatewayApiConfigGatewayConfigOutputReference | GoogleApiGatewayApiConfigGatewayConfig): any;
export declare class GoogleApiGatewayApiConfigGatewayConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiConfigGatewayConfig | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigGatewayConfig | undefined);
    private _backendConfig;
    get backendConfig(): GoogleApiGatewayApiConfigGatewayConfigBackendConfigOutputReference;
    putBackendConfig(value: GoogleApiGatewayApiConfigGatewayConfigBackendConfig): void;
    get backendConfigInput(): GoogleApiGatewayApiConfigGatewayConfigBackendConfig | undefined;
}
export interface GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet {
    /**
    * Base64 encoded content of the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#contents GoogleApiGatewayApiConfigA#contents}
    */
    readonly contents: string;
    /**
    * The file path (full or relative path). This is typically the path of the file when it is uploaded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#path GoogleApiGatewayApiConfigA#path}
    */
    readonly path: string;
}
export declare function googleApiGatewayApiConfigGrpcServicesFileDescriptorSetToTerraform(struct?: GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSetOutputReference | GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet): any;
export declare class GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet | undefined);
    private _contents?;
    get contents(): string;
    set contents(value: string);
    get contentsInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface GoogleApiGatewayApiConfigGrpcServicesSource {
    /**
    * Base64 encoded content of the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#contents GoogleApiGatewayApiConfigA#contents}
    */
    readonly contents: string;
    /**
    * The file path (full or relative path). This is typically the path of the file when it is uploaded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#path GoogleApiGatewayApiConfigA#path}
    */
    readonly path: string;
}
export declare function googleApiGatewayApiConfigGrpcServicesSourceToTerraform(struct?: GoogleApiGatewayApiConfigGrpcServicesSource | cdktf.IResolvable): any;
export declare class GoogleApiGatewayApiConfigGrpcServicesSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApiGatewayApiConfigGrpcServicesSource | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigGrpcServicesSource | cdktf.IResolvable | undefined);
    private _contents?;
    get contents(): string;
    set contents(value: string);
    get contentsInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class GoogleApiGatewayApiConfigGrpcServicesSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApiGatewayApiConfigGrpcServicesSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApiGatewayApiConfigGrpcServicesSourceOutputReference;
}
export interface GoogleApiGatewayApiConfigGrpcServices {
    /**
    * file_descriptor_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#file_descriptor_set GoogleApiGatewayApiConfigA#file_descriptor_set}
    */
    readonly fileDescriptorSet: GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#source GoogleApiGatewayApiConfigA#source}
    */
    readonly source?: GoogleApiGatewayApiConfigGrpcServicesSource[] | cdktf.IResolvable;
}
export declare function googleApiGatewayApiConfigGrpcServicesToTerraform(struct?: GoogleApiGatewayApiConfigGrpcServices | cdktf.IResolvable): any;
export declare class GoogleApiGatewayApiConfigGrpcServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApiGatewayApiConfigGrpcServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigGrpcServices | cdktf.IResolvable | undefined);
    private _fileDescriptorSet;
    get fileDescriptorSet(): GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSetOutputReference;
    putFileDescriptorSet(value: GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet): void;
    get fileDescriptorSetInput(): GoogleApiGatewayApiConfigGrpcServicesFileDescriptorSet | undefined;
    private _source;
    get source(): GoogleApiGatewayApiConfigGrpcServicesSourceList;
    putSource(value: GoogleApiGatewayApiConfigGrpcServicesSource[] | cdktf.IResolvable): void;
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | GoogleApiGatewayApiConfigGrpcServicesSource[] | undefined;
}
export declare class GoogleApiGatewayApiConfigGrpcServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApiGatewayApiConfigGrpcServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApiGatewayApiConfigGrpcServicesOutputReference;
}
export interface GoogleApiGatewayApiConfigManagedServiceConfigs {
    /**
    * Base64 encoded content of the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#contents GoogleApiGatewayApiConfigA#contents}
    */
    readonly contents: string;
    /**
    * The file path (full or relative path). This is typically the path of the file when it is uploaded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#path GoogleApiGatewayApiConfigA#path}
    */
    readonly path: string;
}
export declare function googleApiGatewayApiConfigManagedServiceConfigsToTerraform(struct?: GoogleApiGatewayApiConfigManagedServiceConfigs | cdktf.IResolvable): any;
export declare class GoogleApiGatewayApiConfigManagedServiceConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApiGatewayApiConfigManagedServiceConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigManagedServiceConfigs | cdktf.IResolvable | undefined);
    private _contents?;
    get contents(): string;
    set contents(value: string);
    get contentsInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class GoogleApiGatewayApiConfigManagedServiceConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApiGatewayApiConfigManagedServiceConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApiGatewayApiConfigManagedServiceConfigsOutputReference;
}
export interface GoogleApiGatewayApiConfigOpenapiDocumentsDocument {
    /**
    * Base64 encoded content of the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#contents GoogleApiGatewayApiConfigA#contents}
    */
    readonly contents: string;
    /**
    * The file path (full or relative path). This is typically the path of the file when it is uploaded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#path GoogleApiGatewayApiConfigA#path}
    */
    readonly path: string;
}
export declare function googleApiGatewayApiConfigOpenapiDocumentsDocumentToTerraform(struct?: GoogleApiGatewayApiConfigOpenapiDocumentsDocumentOutputReference | GoogleApiGatewayApiConfigOpenapiDocumentsDocument): any;
export declare class GoogleApiGatewayApiConfigOpenapiDocumentsDocumentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiConfigOpenapiDocumentsDocument | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigOpenapiDocumentsDocument | undefined);
    private _contents?;
    get contents(): string;
    set contents(value: string);
    get contentsInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface GoogleApiGatewayApiConfigOpenapiDocuments {
    /**
    * document block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#document GoogleApiGatewayApiConfigA#document}
    */
    readonly document: GoogleApiGatewayApiConfigOpenapiDocumentsDocument;
}
export declare function googleApiGatewayApiConfigOpenapiDocumentsToTerraform(struct?: GoogleApiGatewayApiConfigOpenapiDocuments | cdktf.IResolvable): any;
export declare class GoogleApiGatewayApiConfigOpenapiDocumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApiGatewayApiConfigOpenapiDocuments | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigOpenapiDocuments | cdktf.IResolvable | undefined);
    private _document;
    get document(): GoogleApiGatewayApiConfigOpenapiDocumentsDocumentOutputReference;
    putDocument(value: GoogleApiGatewayApiConfigOpenapiDocumentsDocument): void;
    get documentInput(): GoogleApiGatewayApiConfigOpenapiDocumentsDocument | undefined;
}
export declare class GoogleApiGatewayApiConfigOpenapiDocumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApiGatewayApiConfigOpenapiDocuments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApiGatewayApiConfigOpenapiDocumentsOutputReference;
}
export interface GoogleApiGatewayApiConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#create GoogleApiGatewayApiConfigA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#delete GoogleApiGatewayApiConfigA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config#update GoogleApiGatewayApiConfigA#update}
    */
    readonly update?: string;
}
export declare function googleApiGatewayApiConfigTimeoutsToTerraform(struct?: GoogleApiGatewayApiConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleApiGatewayApiConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config google_api_gateway_api_config}
*/
export declare class GoogleApiGatewayApiConfigA extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_api_gateway_api_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_api_gateway_api_config google_api_gateway_api_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApiGatewayApiConfigAConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApiGatewayApiConfigAConfig);
    private _api?;
    get api(): string;
    set api(value: string);
    get apiInput(): string | undefined;
    private _apiConfigId?;
    get apiConfigId(): string;
    set apiConfigId(value: string);
    resetApiConfigId(): void;
    get apiConfigIdInput(): string | undefined;
    private _apiConfigIdPrefix?;
    get apiConfigIdPrefix(): string;
    set apiConfigIdPrefix(value: string);
    resetApiConfigIdPrefix(): void;
    get apiConfigIdPrefixInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceConfigId(): string;
    private _gatewayConfig;
    get gatewayConfig(): GoogleApiGatewayApiConfigGatewayConfigOutputReference;
    putGatewayConfig(value: GoogleApiGatewayApiConfigGatewayConfig): void;
    resetGatewayConfig(): void;
    get gatewayConfigInput(): GoogleApiGatewayApiConfigGatewayConfig | undefined;
    private _grpcServices;
    get grpcServices(): GoogleApiGatewayApiConfigGrpcServicesList;
    putGrpcServices(value: GoogleApiGatewayApiConfigGrpcServices[] | cdktf.IResolvable): void;
    resetGrpcServices(): void;
    get grpcServicesInput(): cdktf.IResolvable | GoogleApiGatewayApiConfigGrpcServices[] | undefined;
    private _managedServiceConfigs;
    get managedServiceConfigs(): GoogleApiGatewayApiConfigManagedServiceConfigsList;
    putManagedServiceConfigs(value: GoogleApiGatewayApiConfigManagedServiceConfigs[] | cdktf.IResolvable): void;
    resetManagedServiceConfigs(): void;
    get managedServiceConfigsInput(): cdktf.IResolvable | GoogleApiGatewayApiConfigManagedServiceConfigs[] | undefined;
    private _openapiDocuments;
    get openapiDocuments(): GoogleApiGatewayApiConfigOpenapiDocumentsList;
    putOpenapiDocuments(value: GoogleApiGatewayApiConfigOpenapiDocuments[] | cdktf.IResolvable): void;
    resetOpenapiDocuments(): void;
    get openapiDocumentsInput(): cdktf.IResolvable | GoogleApiGatewayApiConfigOpenapiDocuments[] | undefined;
    private _timeouts;
    get timeouts(): GoogleApiGatewayApiConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleApiGatewayApiConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApiGatewayApiConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
