import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeEnvgroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Hostnames of the environment group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#hostnames GoogleApigeeEnvgroup#hostnames}
    */
    readonly hostnames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#id GoogleApigeeEnvgroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource ID of the environment group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#name GoogleApigeeEnvgroup#name}
    */
    readonly name: string;
    /**
    * The Apigee Organization associated with the Apigee environment group,
  in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#org_id GoogleApigeeEnvgroup#org_id}
    */
    readonly orgId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#timeouts GoogleApigeeEnvgroup#timeouts}
    */
    readonly timeouts?: GoogleApigeeEnvgroupTimeouts;
}
export interface GoogleApigeeEnvgroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#create GoogleApigeeEnvgroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#delete GoogleApigeeEnvgroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup#update GoogleApigeeEnvgroup#update}
    */
    readonly update?: string;
}
export declare function googleApigeeEnvgroupTimeoutsToTerraform(struct?: GoogleApigeeEnvgroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeEnvgroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEnvgroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeEnvgroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup google_apigee_envgroup}
*/
export declare class GoogleApigeeEnvgroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_envgroup";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_envgroup google_apigee_envgroup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeEnvgroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeEnvgroupConfig);
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    resetHostnames(): void;
    get hostnamesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeEnvgroupTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeEnvgroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeEnvgroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
