import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeKeystoresAliasesSelfSignedCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Alias for the key/certificate pair. Values must match the regular expression [\w\s-.]{1,255}.
  This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
  this parameter or the JSON body.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#alias GoogleApigeeKeystoresAliasesSelfSignedCert#alias}
    */
    readonly alias: string;
    /**
    * Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#cert_validity_in_days GoogleApigeeKeystoresAliasesSelfSignedCert#cert_validity_in_days}
    */
    readonly certValidityInDays?: number;
    /**
    * The Apigee environment name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#environment GoogleApigeeKeystoresAliasesSelfSignedCert#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#id GoogleApigeeKeystoresAliasesSelfSignedCert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key size. Default and maximum value is 2048 bits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#key_size GoogleApigeeKeystoresAliasesSelfSignedCert#key_size}
    */
    readonly keySize?: string;
    /**
    * The Apigee keystore name associated in an Apigee environment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#keystore GoogleApigeeKeystoresAliasesSelfSignedCert#keystore}
    */
    readonly keystore: string;
    /**
    * The Apigee Organization name associated with the Apigee environment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#org_id GoogleApigeeKeystoresAliasesSelfSignedCert#org_id}
    */
    readonly orgId: string;
    /**
    * Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#sig_alg GoogleApigeeKeystoresAliasesSelfSignedCert#sig_alg}
    */
    readonly sigAlg: string;
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#subject GoogleApigeeKeystoresAliasesSelfSignedCert#subject}
    */
    readonly subject: GoogleApigeeKeystoresAliasesSelfSignedCertSubject;
    /**
    * subject_alternative_dns_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#subject_alternative_dns_names GoogleApigeeKeystoresAliasesSelfSignedCert#subject_alternative_dns_names}
    */
    readonly subjectAlternativeDnsNames?: GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#timeouts GoogleApigeeKeystoresAliasesSelfSignedCert#timeouts}
    */
    readonly timeouts?: GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts;
}
export interface GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo {
}
export declare function googleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoToTerraform(struct?: GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo): any;
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo | undefined);
    get basicConstraints(): string;
    get expiryDate(): string;
    get isValid(): string;
    get issuer(): string;
    get publicKey(): string;
    get serialNumber(): string;
    get sigAlgName(): string;
    get subject(): string;
    get subjectAlternativeNames(): string[];
    get validFrom(): string;
    get version(): number;
}
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoOutputReference;
}
export interface GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfo {
}
export declare function googleApigeeKeystoresAliasesSelfSignedCertCertsInfoToTerraform(struct?: GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfo): any;
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfo | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfo | undefined);
    private _certInfo;
    get certInfo(): GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoList;
}
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoOutputReference;
}
export interface GoogleApigeeKeystoresAliasesSelfSignedCertSubject {
    /**
    * Common name of the organization. Maximum length is 64 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#common_name GoogleApigeeKeystoresAliasesSelfSignedCert#common_name}
    */
    readonly commonName?: string;
    /**
    * Two-letter country code. Example, IN for India, US for United States of America.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#country_code GoogleApigeeKeystoresAliasesSelfSignedCert#country_code}
    */
    readonly countryCode?: string;
    /**
    * Email address. Max 255 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#email GoogleApigeeKeystoresAliasesSelfSignedCert#email}
    */
    readonly email?: string;
    /**
    * City or town name. Maximum length is 128 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#locality GoogleApigeeKeystoresAliasesSelfSignedCert#locality}
    */
    readonly locality?: string;
    /**
    * Organization name. Maximum length is 64 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#org GoogleApigeeKeystoresAliasesSelfSignedCert#org}
    */
    readonly org?: string;
    /**
    * Organization team name. Maximum length is 64 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#org_unit GoogleApigeeKeystoresAliasesSelfSignedCert#org_unit}
    */
    readonly orgUnit?: string;
    /**
    * State or district name. Maximum length is 128 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#state GoogleApigeeKeystoresAliasesSelfSignedCert#state}
    */
    readonly state?: string;
}
export declare function googleApigeeKeystoresAliasesSelfSignedCertSubjectToTerraform(struct?: GoogleApigeeKeystoresAliasesSelfSignedCertSubjectOutputReference | GoogleApigeeKeystoresAliasesSelfSignedCertSubject): any;
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeKeystoresAliasesSelfSignedCertSubject | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesSelfSignedCertSubject | undefined);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    resetCommonName(): void;
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _org?;
    get org(): string;
    set org(value: string);
    resetOrg(): void;
    get orgInput(): string | undefined;
    private _orgUnit?;
    get orgUnit(): string;
    set orgUnit(value: string);
    resetOrgUnit(): void;
    get orgUnitInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
}
export interface GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames {
    /**
    * Subject Alternative Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#subject_alternative_name GoogleApigeeKeystoresAliasesSelfSignedCert#subject_alternative_name}
    */
    readonly subjectAlternativeName?: string;
}
export declare function googleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesToTerraform(struct?: GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesOutputReference | GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames): any;
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames | undefined);
    private _subjectAlternativeName?;
    get subjectAlternativeName(): string;
    set subjectAlternativeName(value: string);
    resetSubjectAlternativeName(): void;
    get subjectAlternativeNameInput(): string | undefined;
}
export interface GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#create GoogleApigeeKeystoresAliasesSelfSignedCert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert#delete GoogleApigeeKeystoresAliasesSelfSignedCert#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeKeystoresAliasesSelfSignedCertTimeoutsToTerraform(struct?: GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeKeystoresAliasesSelfSignedCertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert google_apigee_keystores_aliases_self_signed_cert}
*/
export declare class GoogleApigeeKeystoresAliasesSelfSignedCert extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_keystores_aliases_self_signed_cert";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_keystores_aliases_self_signed_cert google_apigee_keystores_aliases_self_signed_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeKeystoresAliasesSelfSignedCertConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeKeystoresAliasesSelfSignedCertConfig);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    get aliasInput(): string | undefined;
    private _certValidityInDays?;
    get certValidityInDays(): number;
    set certValidityInDays(value: number);
    resetCertValidityInDays(): void;
    get certValidityInDaysInput(): number | undefined;
    private _certsInfo;
    get certsInfo(): GoogleApigeeKeystoresAliasesSelfSignedCertCertsInfoList;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keySize?;
    get keySize(): string;
    set keySize(value: string);
    resetKeySize(): void;
    get keySizeInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    get keystoreInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _sigAlg?;
    get sigAlg(): string;
    set sigAlg(value: string);
    get sigAlgInput(): string | undefined;
    get type(): string;
    private _subject;
    get subject(): GoogleApigeeKeystoresAliasesSelfSignedCertSubjectOutputReference;
    putSubject(value: GoogleApigeeKeystoresAliasesSelfSignedCertSubject): void;
    get subjectInput(): GoogleApigeeKeystoresAliasesSelfSignedCertSubject | undefined;
    private _subjectAlternativeDnsNames;
    get subjectAlternativeDnsNames(): GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesOutputReference;
    putSubjectAlternativeDnsNames(value: GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames): void;
    resetSubjectAlternativeDnsNames(): void;
    get subjectAlternativeDnsNamesInput(): GoogleApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeKeystoresAliasesSelfSignedCertTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeKeystoresAliasesSelfSignedCertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
