import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeSharedflowConfig extends cdktf.TerraformMetaArguments {
    /**
    * A path to the config bundle zip you want to upload. Must be defined if content is not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#config_bundle GoogleApigeeSharedflow#config_bundle}
    */
    readonly configBundle: string;
    /**
    * A hash of local config bundle in string, user needs to use a Terraform Hash function of their choice. A change in hash will trigger an update.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#detect_md5hash GoogleApigeeSharedflow#detect_md5hash}
    */
    readonly detectMd5Hash?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#id GoogleApigeeSharedflow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the shared flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#name GoogleApigeeSharedflow#name}
    */
    readonly name: string;
    /**
    * The Apigee Organization name associated with the Apigee instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#org_id GoogleApigeeSharedflow#org_id}
    */
    readonly orgId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#timeouts GoogleApigeeSharedflow#timeouts}
    */
    readonly timeouts?: GoogleApigeeSharedflowTimeouts;
}
export interface GoogleApigeeSharedflowMetaData {
}
export declare function googleApigeeSharedflowMetaDataToTerraform(struct?: GoogleApigeeSharedflowMetaData): any;
export declare class GoogleApigeeSharedflowMetaDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApigeeSharedflowMetaData | undefined;
    set internalValue(value: GoogleApigeeSharedflowMetaData | undefined);
    get createdAt(): string;
    get lastModifiedAt(): string;
    get subType(): string;
}
export declare class GoogleApigeeSharedflowMetaDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApigeeSharedflowMetaDataOutputReference;
}
export interface GoogleApigeeSharedflowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#create GoogleApigeeSharedflow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#delete GoogleApigeeSharedflow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow#update GoogleApigeeSharedflow#update}
    */
    readonly update?: string;
}
export declare function googleApigeeSharedflowTimeoutsToTerraform(struct?: GoogleApigeeSharedflowTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeSharedflowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeSharedflowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeSharedflowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow google_apigee_sharedflow}
*/
export declare class GoogleApigeeSharedflow extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_sharedflow";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sharedflow google_apigee_sharedflow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeSharedflowConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeSharedflowConfig);
    private _configBundle?;
    get configBundle(): string;
    set configBundle(value: string);
    get configBundleInput(): string | undefined;
    private _detectMd5Hash?;
    get detectMd5Hash(): string;
    set detectMd5Hash(value: string);
    resetDetectMd5Hash(): void;
    get detectMd5HashInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get latestRevisionId(): string;
    get md5Hash(): string;
    private _metaData;
    get metaData(): GoogleApigeeSharedflowMetaDataList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get revision(): string[];
    private _timeouts;
    get timeouts(): GoogleApigeeSharedflowTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeSharedflowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeSharedflowTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
