import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeSyncAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#id GoogleApigeeSyncAuthorization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Array of service accounts to grant access to control plane resources, each specified using the following format: 'serviceAccount:service-account-name'.
  
  The 'service-account-name' is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
  
  You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
  
  The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#identities GoogleApigeeSyncAuthorization#identities}
    */
    readonly identities: string[];
    /**
    * Name of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#name GoogleApigeeSyncAuthorization#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#timeouts GoogleApigeeSyncAuthorization#timeouts}
    */
    readonly timeouts?: GoogleApigeeSyncAuthorizationTimeouts;
}
export interface GoogleApigeeSyncAuthorizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#create GoogleApigeeSyncAuthorization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#delete GoogleApigeeSyncAuthorization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization#update GoogleApigeeSyncAuthorization#update}
    */
    readonly update?: string;
}
export declare function googleApigeeSyncAuthorizationTimeoutsToTerraform(struct?: GoogleApigeeSyncAuthorizationTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeSyncAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeSyncAuthorizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeSyncAuthorizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization google_apigee_sync_authorization}
*/
export declare class GoogleApigeeSyncAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_sync_authorization";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_apigee_sync_authorization google_apigee_sync_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeSyncAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeSyncAuthorizationConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    get identitiesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeSyncAuthorizationTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeSyncAuthorizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeSyncAuthorizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
