import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The domain to authenticate users with when using App Engine's User API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#auth_domain GoogleAppEngineApplication#auth_domain}
    */
    readonly authDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#database_type GoogleAppEngineApplication#database_type}
    */
    readonly databaseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#id GoogleAppEngineApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location to serve the app from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#location_id GoogleAppEngineApplication#location_id}
    */
    readonly locationId: string;
    /**
    * The project ID to create the application under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#project GoogleAppEngineApplication#project}
    */
    readonly project?: string;
    /**
    * The serving status of the app.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#serving_status GoogleAppEngineApplication#serving_status}
    */
    readonly servingStatus?: string;
    /**
    * feature_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#feature_settings GoogleAppEngineApplication#feature_settings}
    */
    readonly featureSettings?: GoogleAppEngineApplicationFeatureSettings;
    /**
    * iap block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#iap GoogleAppEngineApplication#iap}
    */
    readonly iap?: GoogleAppEngineApplicationIap;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#timeouts GoogleAppEngineApplication#timeouts}
    */
    readonly timeouts?: GoogleAppEngineApplicationTimeouts;
}
export interface GoogleAppEngineApplicationUrlDispatchRule {
}
export declare function googleAppEngineApplicationUrlDispatchRuleToTerraform(struct?: GoogleAppEngineApplicationUrlDispatchRule): any;
export declare class GoogleAppEngineApplicationUrlDispatchRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineApplicationUrlDispatchRule | undefined;
    set internalValue(value: GoogleAppEngineApplicationUrlDispatchRule | undefined);
    get domain(): string;
    get path(): string;
    get service(): string;
}
export declare class GoogleAppEngineApplicationUrlDispatchRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineApplicationUrlDispatchRuleOutputReference;
}
export interface GoogleAppEngineApplicationFeatureSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#split_health_checks GoogleAppEngineApplication#split_health_checks}
    */
    readonly splitHealthChecks: boolean | cdktf.IResolvable;
}
export declare function googleAppEngineApplicationFeatureSettingsToTerraform(struct?: GoogleAppEngineApplicationFeatureSettingsOutputReference | GoogleAppEngineApplicationFeatureSettings): any;
export declare class GoogleAppEngineApplicationFeatureSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineApplicationFeatureSettings | undefined;
    set internalValue(value: GoogleAppEngineApplicationFeatureSettings | undefined);
    private _splitHealthChecks?;
    get splitHealthChecks(): boolean | cdktf.IResolvable;
    set splitHealthChecks(value: boolean | cdktf.IResolvable);
    get splitHealthChecksInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleAppEngineApplicationIap {
    /**
    * Adapted for use with the app
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#enabled GoogleAppEngineApplication#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * OAuth2 client ID to use for the authentication flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#oauth2_client_id GoogleAppEngineApplication#oauth2_client_id}
    */
    readonly oauth2ClientId: string;
    /**
    * OAuth2 client secret to use for the authentication flow. The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#oauth2_client_secret GoogleAppEngineApplication#oauth2_client_secret}
    */
    readonly oauth2ClientSecret: string;
}
export declare function googleAppEngineApplicationIapToTerraform(struct?: GoogleAppEngineApplicationIapOutputReference | GoogleAppEngineApplicationIap): any;
export declare class GoogleAppEngineApplicationIapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineApplicationIap | undefined;
    set internalValue(value: GoogleAppEngineApplicationIap | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _oauth2ClientId?;
    get oauth2ClientId(): string;
    set oauth2ClientId(value: string);
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    get oauth2ClientSecret(): string;
    set oauth2ClientSecret(value: string);
    get oauth2ClientSecretInput(): string | undefined;
    get oauth2ClientSecretSha256(): string;
}
export interface GoogleAppEngineApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#create GoogleAppEngineApplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application#update GoogleAppEngineApplication#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineApplicationTimeoutsToTerraform(struct?: GoogleAppEngineApplicationTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineApplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineApplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application google_app_engine_application}
*/
export declare class GoogleAppEngineApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_application";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_application google_app_engine_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineApplicationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineApplicationConfig);
    get appId(): string;
    private _authDomain?;
    get authDomain(): string;
    set authDomain(value: string);
    resetAuthDomain(): void;
    get authDomainInput(): string | undefined;
    get codeBucket(): string;
    private _databaseType?;
    get databaseType(): string;
    set databaseType(value: string);
    resetDatabaseType(): void;
    get databaseTypeInput(): string | undefined;
    get defaultBucket(): string;
    get defaultHostname(): string;
    get gcrDomain(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    get locationIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _servingStatus?;
    get servingStatus(): string;
    set servingStatus(value: string);
    resetServingStatus(): void;
    get servingStatusInput(): string | undefined;
    private _urlDispatchRule;
    get urlDispatchRule(): GoogleAppEngineApplicationUrlDispatchRuleList;
    private _featureSettings;
    get featureSettings(): GoogleAppEngineApplicationFeatureSettingsOutputReference;
    putFeatureSettings(value: GoogleAppEngineApplicationFeatureSettings): void;
    resetFeatureSettings(): void;
    get featureSettingsInput(): GoogleAppEngineApplicationFeatureSettings | undefined;
    private _iap;
    get iap(): GoogleAppEngineApplicationIapOutputReference;
    putIap(value: GoogleAppEngineApplicationIap): void;
    resetIap(): void;
    get iapInput(): GoogleAppEngineApplicationIap | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineApplicationTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
