import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineFlexibleAppVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Metadata settings that are supplied to this version to enable beta runtime features.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#beta_settings GoogleAppEngineFlexibleAppVersion#beta_settings}
    */
    readonly betaSettings?: {
        [key: string]: string;
    };
    /**
    * Duration that static files should be cached by web proxies and browsers.
  Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#default_expiration GoogleAppEngineFlexibleAppVersion#default_expiration}
    */
    readonly defaultExpiration?: string;
    /**
    * If set to 'true', the service will be deleted if it is the last version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#delete_service_on_destroy GoogleAppEngineFlexibleAppVersion#delete_service_on_destroy}
    */
    readonly deleteServiceOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Environment variables available to the application.  As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#env_variables GoogleAppEngineFlexibleAppVersion#env_variables}
    */
    readonly envVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#id GoogleAppEngineFlexibleAppVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#inbound_services GoogleAppEngineFlexibleAppVersion#inbound_services}
    */
    readonly inboundServices?: string[];
    /**
    * Instance class that is used to run this version. Valid values are
  AutomaticScaling: F1, F2, F4, F4_1G
  ManualScaling: B1, B2, B4, B8, B4_1G
  Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#instance_class GoogleAppEngineFlexibleAppVersion#instance_class}
    */
    readonly instanceClass?: string;
    /**
    * Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#nobuild_files_regex GoogleAppEngineFlexibleAppVersion#nobuild_files_regex}
    */
    readonly nobuildFilesRegex?: string;
    /**
    * If set to 'true', the application version will not be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#noop_on_destroy GoogleAppEngineFlexibleAppVersion#noop_on_destroy}
    */
    readonly noopOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#project GoogleAppEngineFlexibleAppVersion#project}
    */
    readonly project?: string;
    /**
    * Desired runtime. Example python27.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#runtime GoogleAppEngineFlexibleAppVersion#runtime}
    */
    readonly runtime: string;
    /**
    * The version of the API in the given runtime environment.
  Please see the app.yaml reference for valid values at 'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\
  Substitute '<language>' with 'python', 'java', 'php', 'ruby', 'go' or 'nodejs'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#runtime_api_version GoogleAppEngineFlexibleAppVersion#runtime_api_version}
    */
    readonly runtimeApiVersion?: string;
    /**
    * The channel of the runtime to use. Only available for some runtimes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#runtime_channel GoogleAppEngineFlexibleAppVersion#runtime_channel}
    */
    readonly runtimeChannel?: string;
    /**
    * The path or name of the app's main executable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#runtime_main_executable_path GoogleAppEngineFlexibleAppVersion#runtime_main_executable_path}
    */
    readonly runtimeMainExecutablePath?: string;
    /**
    * AppEngine service resource. Can contain numbers, letters, and hyphens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#service GoogleAppEngineFlexibleAppVersion#service}
    */
    readonly service: string;
    /**
    * The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
  default if this field is neither provided in app.yaml file nor through CLI flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#service_account GoogleAppEngineFlexibleAppVersion#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Current serving status of this version. Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#serving_status GoogleAppEngineFlexibleAppVersion#serving_status}
    */
    readonly servingStatus?: string;
    /**
    * Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens.
  Reserved names,"default", "latest", and any name with the prefix "ah-".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#version_id GoogleAppEngineFlexibleAppVersion#version_id}
    */
    readonly versionId?: string;
    /**
    * api_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#api_config GoogleAppEngineFlexibleAppVersion#api_config}
    */
    readonly apiConfig?: GoogleAppEngineFlexibleAppVersionApiConfig;
    /**
    * automatic_scaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#automatic_scaling GoogleAppEngineFlexibleAppVersion#automatic_scaling}
    */
    readonly automaticScaling?: GoogleAppEngineFlexibleAppVersionAutomaticScaling;
    /**
    * deployment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#deployment GoogleAppEngineFlexibleAppVersion#deployment}
    */
    readonly deployment?: GoogleAppEngineFlexibleAppVersionDeployment;
    /**
    * endpoints_api_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#endpoints_api_service GoogleAppEngineFlexibleAppVersion#endpoints_api_service}
    */
    readonly endpointsApiService?: GoogleAppEngineFlexibleAppVersionEndpointsApiService;
    /**
    * entrypoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#entrypoint GoogleAppEngineFlexibleAppVersion#entrypoint}
    */
    readonly entrypoint?: GoogleAppEngineFlexibleAppVersionEntrypoint;
    /**
    * handlers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#handlers GoogleAppEngineFlexibleAppVersion#handlers}
    */
    readonly handlers?: GoogleAppEngineFlexibleAppVersionHandlers[] | cdktf.IResolvable;
    /**
    * liveness_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#liveness_check GoogleAppEngineFlexibleAppVersion#liveness_check}
    */
    readonly livenessCheck: GoogleAppEngineFlexibleAppVersionLivenessCheck;
    /**
    * manual_scaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#manual_scaling GoogleAppEngineFlexibleAppVersion#manual_scaling}
    */
    readonly manualScaling?: GoogleAppEngineFlexibleAppVersionManualScaling;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#network GoogleAppEngineFlexibleAppVersion#network}
    */
    readonly network?: GoogleAppEngineFlexibleAppVersionNetwork;
    /**
    * readiness_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#readiness_check GoogleAppEngineFlexibleAppVersion#readiness_check}
    */
    readonly readinessCheck: GoogleAppEngineFlexibleAppVersionReadinessCheck;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#resources GoogleAppEngineFlexibleAppVersion#resources}
    */
    readonly resources?: GoogleAppEngineFlexibleAppVersionResources;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#timeouts GoogleAppEngineFlexibleAppVersion#timeouts}
    */
    readonly timeouts?: GoogleAppEngineFlexibleAppVersionTimeouts;
    /**
    * vpc_access_connector block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#vpc_access_connector GoogleAppEngineFlexibleAppVersion#vpc_access_connector}
    */
    readonly vpcAccessConnector?: GoogleAppEngineFlexibleAppVersionVpcAccessConnector;
}
export interface GoogleAppEngineFlexibleAppVersionApiConfig {
    /**
    * Action to take when users access resources that require authentication. Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#auth_fail_action GoogleAppEngineFlexibleAppVersion#auth_fail_action}
    */
    readonly authFailAction?: string;
    /**
    * Level of login required to access this resource. Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#login GoogleAppEngineFlexibleAppVersion#login}
    */
    readonly login?: string;
    /**
    * Path to the script from the application root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#script GoogleAppEngineFlexibleAppVersion#script}
    */
    readonly script: string;
    /**
    * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#security_level GoogleAppEngineFlexibleAppVersion#security_level}
    */
    readonly securityLevel?: string;
    /**
    * URL to serve the endpoint at.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#url GoogleAppEngineFlexibleAppVersion#url}
    */
    readonly url?: string;
}
export declare function googleAppEngineFlexibleAppVersionApiConfigToTerraform(struct?: GoogleAppEngineFlexibleAppVersionApiConfigOutputReference | GoogleAppEngineFlexibleAppVersionApiConfig): any;
export declare class GoogleAppEngineFlexibleAppVersionApiConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionApiConfig | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionApiConfig | undefined);
    private _authFailAction?;
    get authFailAction(): string;
    set authFailAction(value: string);
    resetAuthFailAction(): void;
    get authFailActionInput(): string | undefined;
    private _login?;
    get login(): string;
    set login(value: string);
    resetLogin(): void;
    get loginInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
    private _securityLevel?;
    get securityLevel(): string;
    set securityLevel(value: string);
    resetSecurityLevel(): void;
    get securityLevelInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization {
    /**
    * Period of time over which CPU utilization is calculated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#aggregation_window_length GoogleAppEngineFlexibleAppVersion#aggregation_window_length}
    */
    readonly aggregationWindowLength?: string;
    /**
    * Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_utilization GoogleAppEngineFlexibleAppVersion#target_utilization}
    */
    readonly targetUtilization: number;
}
export declare function googleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationToTerraform(struct?: GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference | GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization): any;
export declare class GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined);
    private _aggregationWindowLength?;
    get aggregationWindowLength(): string;
    set aggregationWindowLength(value: string);
    resetAggregationWindowLength(): void;
    get aggregationWindowLengthInput(): string | undefined;
    private _targetUtilization?;
    get targetUtilization(): number;
    set targetUtilization(value: number);
    get targetUtilizationInput(): number | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization {
    /**
    * Target bytes read per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_read_bytes_per_second GoogleAppEngineFlexibleAppVersion#target_read_bytes_per_second}
    */
    readonly targetReadBytesPerSecond?: number;
    /**
    * Target ops read per seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_read_ops_per_second GoogleAppEngineFlexibleAppVersion#target_read_ops_per_second}
    */
    readonly targetReadOpsPerSecond?: number;
    /**
    * Target bytes written per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_write_bytes_per_second GoogleAppEngineFlexibleAppVersion#target_write_bytes_per_second}
    */
    readonly targetWriteBytesPerSecond?: number;
    /**
    * Target ops written per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_write_ops_per_second GoogleAppEngineFlexibleAppVersion#target_write_ops_per_second}
    */
    readonly targetWriteOpsPerSecond?: number;
}
export declare function googleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationToTerraform(struct?: GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference | GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization): any;
export declare class GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined);
    private _targetReadBytesPerSecond?;
    get targetReadBytesPerSecond(): number;
    set targetReadBytesPerSecond(value: number);
    resetTargetReadBytesPerSecond(): void;
    get targetReadBytesPerSecondInput(): number | undefined;
    private _targetReadOpsPerSecond?;
    get targetReadOpsPerSecond(): number;
    set targetReadOpsPerSecond(value: number);
    resetTargetReadOpsPerSecond(): void;
    get targetReadOpsPerSecondInput(): number | undefined;
    private _targetWriteBytesPerSecond?;
    get targetWriteBytesPerSecond(): number;
    set targetWriteBytesPerSecond(value: number);
    resetTargetWriteBytesPerSecond(): void;
    get targetWriteBytesPerSecondInput(): number | undefined;
    private _targetWriteOpsPerSecond?;
    get targetWriteOpsPerSecond(): number;
    set targetWriteOpsPerSecond(value: number);
    resetTargetWriteOpsPerSecond(): void;
    get targetWriteOpsPerSecondInput(): number | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization {
    /**
    * Target bytes received per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_received_bytes_per_second GoogleAppEngineFlexibleAppVersion#target_received_bytes_per_second}
    */
    readonly targetReceivedBytesPerSecond?: number;
    /**
    * Target packets received per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_received_packets_per_second GoogleAppEngineFlexibleAppVersion#target_received_packets_per_second}
    */
    readonly targetReceivedPacketsPerSecond?: number;
    /**
    * Target bytes sent per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_sent_bytes_per_second GoogleAppEngineFlexibleAppVersion#target_sent_bytes_per_second}
    */
    readonly targetSentBytesPerSecond?: number;
    /**
    * Target packets sent per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_sent_packets_per_second GoogleAppEngineFlexibleAppVersion#target_sent_packets_per_second}
    */
    readonly targetSentPacketsPerSecond?: number;
}
export declare function googleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationToTerraform(struct?: GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference | GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization): any;
export declare class GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined);
    private _targetReceivedBytesPerSecond?;
    get targetReceivedBytesPerSecond(): number;
    set targetReceivedBytesPerSecond(value: number);
    resetTargetReceivedBytesPerSecond(): void;
    get targetReceivedBytesPerSecondInput(): number | undefined;
    private _targetReceivedPacketsPerSecond?;
    get targetReceivedPacketsPerSecond(): number;
    set targetReceivedPacketsPerSecond(value: number);
    resetTargetReceivedPacketsPerSecond(): void;
    get targetReceivedPacketsPerSecondInput(): number | undefined;
    private _targetSentBytesPerSecond?;
    get targetSentBytesPerSecond(): number;
    set targetSentBytesPerSecond(value: number);
    resetTargetSentBytesPerSecond(): void;
    get targetSentBytesPerSecondInput(): number | undefined;
    private _targetSentPacketsPerSecond?;
    get targetSentPacketsPerSecond(): number;
    set targetSentPacketsPerSecond(value: number);
    resetTargetSentPacketsPerSecond(): void;
    get targetSentPacketsPerSecondInput(): number | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization {
    /**
    * Target number of concurrent requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_concurrent_requests GoogleAppEngineFlexibleAppVersion#target_concurrent_requests}
    */
    readonly targetConcurrentRequests?: number;
    /**
    * Target requests per second.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#target_request_count_per_second GoogleAppEngineFlexibleAppVersion#target_request_count_per_second}
    */
    readonly targetRequestCountPerSecond?: string;
}
export declare function googleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationToTerraform(struct?: GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference | GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization): any;
export declare class GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined);
    private _targetConcurrentRequests?;
    get targetConcurrentRequests(): number;
    set targetConcurrentRequests(value: number);
    resetTargetConcurrentRequests(): void;
    get targetConcurrentRequestsInput(): number | undefined;
    private _targetRequestCountPerSecond?;
    get targetRequestCountPerSecond(): string;
    set targetRequestCountPerSecond(value: string);
    resetTargetRequestCountPerSecond(): void;
    get targetRequestCountPerSecondInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionAutomaticScaling {
    /**
    * The time period that the Autoscaler should wait before it starts collecting information from a new instance.
  This prevents the autoscaler from collecting information when the instance is initializing,
  during which the collected usage would not be reliable. Default: 120s
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#cool_down_period GoogleAppEngineFlexibleAppVersion#cool_down_period}
    */
    readonly coolDownPeriod?: string;
    /**
    * Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
  
  Defaults to a runtime-specific value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#max_concurrent_requests GoogleAppEngineFlexibleAppVersion#max_concurrent_requests}
    */
    readonly maxConcurrentRequests?: number;
    /**
    * Maximum number of idle instances that should be maintained for this version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#max_idle_instances GoogleAppEngineFlexibleAppVersion#max_idle_instances}
    */
    readonly maxIdleInstances?: number;
    /**
    * Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#max_pending_latency GoogleAppEngineFlexibleAppVersion#max_pending_latency}
    */
    readonly maxPendingLatency?: string;
    /**
    * Maximum number of instances that should be started to handle requests for this version. Default: 20
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#max_total_instances GoogleAppEngineFlexibleAppVersion#max_total_instances}
    */
    readonly maxTotalInstances?: number;
    /**
    * Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#min_idle_instances GoogleAppEngineFlexibleAppVersion#min_idle_instances}
    */
    readonly minIdleInstances?: number;
    /**
    * Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#min_pending_latency GoogleAppEngineFlexibleAppVersion#min_pending_latency}
    */
    readonly minPendingLatency?: string;
    /**
    * Minimum number of running instances that should be maintained for this version. Default: 2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#min_total_instances GoogleAppEngineFlexibleAppVersion#min_total_instances}
    */
    readonly minTotalInstances?: number;
    /**
    * cpu_utilization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#cpu_utilization GoogleAppEngineFlexibleAppVersion#cpu_utilization}
    */
    readonly cpuUtilization: GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization;
    /**
    * disk_utilization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#disk_utilization GoogleAppEngineFlexibleAppVersion#disk_utilization}
    */
    readonly diskUtilization?: GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization;
    /**
    * network_utilization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#network_utilization GoogleAppEngineFlexibleAppVersion#network_utilization}
    */
    readonly networkUtilization?: GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization;
    /**
    * request_utilization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#request_utilization GoogleAppEngineFlexibleAppVersion#request_utilization}
    */
    readonly requestUtilization?: GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization;
}
export declare function googleAppEngineFlexibleAppVersionAutomaticScalingToTerraform(struct?: GoogleAppEngineFlexibleAppVersionAutomaticScalingOutputReference | GoogleAppEngineFlexibleAppVersionAutomaticScaling): any;
export declare class GoogleAppEngineFlexibleAppVersionAutomaticScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionAutomaticScaling | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionAutomaticScaling | undefined);
    private _coolDownPeriod?;
    get coolDownPeriod(): string;
    set coolDownPeriod(value: string);
    resetCoolDownPeriod(): void;
    get coolDownPeriodInput(): string | undefined;
    private _maxConcurrentRequests?;
    get maxConcurrentRequests(): number;
    set maxConcurrentRequests(value: number);
    resetMaxConcurrentRequests(): void;
    get maxConcurrentRequestsInput(): number | undefined;
    private _maxIdleInstances?;
    get maxIdleInstances(): number;
    set maxIdleInstances(value: number);
    resetMaxIdleInstances(): void;
    get maxIdleInstancesInput(): number | undefined;
    private _maxPendingLatency?;
    get maxPendingLatency(): string;
    set maxPendingLatency(value: string);
    resetMaxPendingLatency(): void;
    get maxPendingLatencyInput(): string | undefined;
    private _maxTotalInstances?;
    get maxTotalInstances(): number;
    set maxTotalInstances(value: number);
    resetMaxTotalInstances(): void;
    get maxTotalInstancesInput(): number | undefined;
    private _minIdleInstances?;
    get minIdleInstances(): number;
    set minIdleInstances(value: number);
    resetMinIdleInstances(): void;
    get minIdleInstancesInput(): number | undefined;
    private _minPendingLatency?;
    get minPendingLatency(): string;
    set minPendingLatency(value: string);
    resetMinPendingLatency(): void;
    get minPendingLatencyInput(): string | undefined;
    private _minTotalInstances?;
    get minTotalInstances(): number;
    set minTotalInstances(value: number);
    resetMinTotalInstances(): void;
    get minTotalInstancesInput(): number | undefined;
    private _cpuUtilization;
    get cpuUtilization(): GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference;
    putCpuUtilization(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization): void;
    get cpuUtilizationInput(): GoogleAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined;
    private _diskUtilization;
    get diskUtilization(): GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference;
    putDiskUtilization(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization): void;
    resetDiskUtilization(): void;
    get diskUtilizationInput(): GoogleAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined;
    private _networkUtilization;
    get networkUtilization(): GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference;
    putNetworkUtilization(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization): void;
    resetNetworkUtilization(): void;
    get networkUtilizationInput(): GoogleAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined;
    private _requestUtilization;
    get requestUtilization(): GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference;
    putRequestUtilization(value: GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization): void;
    resetRequestUtilization(): void;
    get requestUtilizationInput(): GoogleAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions {
    /**
    * Path to the yaml file used in deployment, used to determine runtime configuration details.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#app_yaml_path GoogleAppEngineFlexibleAppVersion#app_yaml_path}
    */
    readonly appYamlPath: string;
    /**
    * The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#cloud_build_timeout GoogleAppEngineFlexibleAppVersion#cloud_build_timeout}
    */
    readonly cloudBuildTimeout?: string;
}
export declare function googleAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsToTerraform(struct?: GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference | GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions): any;
export declare class GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined);
    private _appYamlPath?;
    get appYamlPath(): string;
    set appYamlPath(value: string);
    get appYamlPathInput(): string | undefined;
    private _cloudBuildTimeout?;
    get cloudBuildTimeout(): string;
    set cloudBuildTimeout(value: string);
    resetCloudBuildTimeout(): void;
    get cloudBuildTimeoutInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionDeploymentContainer {
    /**
    * URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest.
  Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#image GoogleAppEngineFlexibleAppVersion#image}
    */
    readonly image: string;
}
export declare function googleAppEngineFlexibleAppVersionDeploymentContainerToTerraform(struct?: GoogleAppEngineFlexibleAppVersionDeploymentContainerOutputReference | GoogleAppEngineFlexibleAppVersionDeploymentContainer): any;
export declare class GoogleAppEngineFlexibleAppVersionDeploymentContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionDeploymentContainer | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionDeploymentContainer | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionDeploymentFiles {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#name GoogleAppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * SHA1 checksum of the file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#sha1_sum GoogleAppEngineFlexibleAppVersion#sha1_sum}
    */
    readonly sha1Sum?: string;
    /**
    * Source URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#source_url GoogleAppEngineFlexibleAppVersion#source_url}
    */
    readonly sourceUrl: string;
}
export declare function googleAppEngineFlexibleAppVersionDeploymentFilesToTerraform(struct?: GoogleAppEngineFlexibleAppVersionDeploymentFiles | cdktf.IResolvable): any;
export declare class GoogleAppEngineFlexibleAppVersionDeploymentFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineFlexibleAppVersionDeploymentFiles | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionDeploymentFiles | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sha1Sum?;
    get sha1Sum(): string;
    set sha1Sum(value: string);
    resetSha1Sum(): void;
    get sha1SumInput(): string | undefined;
    private _sourceUrl?;
    get sourceUrl(): string;
    set sourceUrl(value: string);
    get sourceUrlInput(): string | undefined;
}
export declare class GoogleAppEngineFlexibleAppVersionDeploymentFilesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineFlexibleAppVersionDeploymentFiles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineFlexibleAppVersionDeploymentFilesOutputReference;
}
export interface GoogleAppEngineFlexibleAppVersionDeploymentZip {
    /**
    * files count
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#files_count GoogleAppEngineFlexibleAppVersion#files_count}
    */
    readonly filesCount?: number;
    /**
    * Source URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#source_url GoogleAppEngineFlexibleAppVersion#source_url}
    */
    readonly sourceUrl: string;
}
export declare function googleAppEngineFlexibleAppVersionDeploymentZipToTerraform(struct?: GoogleAppEngineFlexibleAppVersionDeploymentZipOutputReference | GoogleAppEngineFlexibleAppVersionDeploymentZip): any;
export declare class GoogleAppEngineFlexibleAppVersionDeploymentZipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionDeploymentZip | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionDeploymentZip | undefined);
    private _filesCount?;
    get filesCount(): number;
    set filesCount(value: number);
    resetFilesCount(): void;
    get filesCountInput(): number | undefined;
    private _sourceUrl?;
    get sourceUrl(): string;
    set sourceUrl(value: string);
    get sourceUrlInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionDeployment {
    /**
    * cloud_build_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#cloud_build_options GoogleAppEngineFlexibleAppVersion#cloud_build_options}
    */
    readonly cloudBuildOptions?: GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#container GoogleAppEngineFlexibleAppVersion#container}
    */
    readonly container?: GoogleAppEngineFlexibleAppVersionDeploymentContainer;
    /**
    * files block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#files GoogleAppEngineFlexibleAppVersion#files}
    */
    readonly files?: GoogleAppEngineFlexibleAppVersionDeploymentFiles[] | cdktf.IResolvable;
    /**
    * zip block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#zip GoogleAppEngineFlexibleAppVersion#zip}
    */
    readonly zip?: GoogleAppEngineFlexibleAppVersionDeploymentZip;
}
export declare function googleAppEngineFlexibleAppVersionDeploymentToTerraform(struct?: GoogleAppEngineFlexibleAppVersionDeploymentOutputReference | GoogleAppEngineFlexibleAppVersionDeployment): any;
export declare class GoogleAppEngineFlexibleAppVersionDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionDeployment | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionDeployment | undefined);
    private _cloudBuildOptions;
    get cloudBuildOptions(): GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference;
    putCloudBuildOptions(value: GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions): void;
    resetCloudBuildOptions(): void;
    get cloudBuildOptionsInput(): GoogleAppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined;
    private _container;
    get container(): GoogleAppEngineFlexibleAppVersionDeploymentContainerOutputReference;
    putContainer(value: GoogleAppEngineFlexibleAppVersionDeploymentContainer): void;
    resetContainer(): void;
    get containerInput(): GoogleAppEngineFlexibleAppVersionDeploymentContainer | undefined;
    private _files;
    get files(): GoogleAppEngineFlexibleAppVersionDeploymentFilesList;
    putFiles(value: GoogleAppEngineFlexibleAppVersionDeploymentFiles[] | cdktf.IResolvable): void;
    resetFiles(): void;
    get filesInput(): cdktf.IResolvable | GoogleAppEngineFlexibleAppVersionDeploymentFiles[] | undefined;
    private _zip;
    get zip(): GoogleAppEngineFlexibleAppVersionDeploymentZipOutputReference;
    putZip(value: GoogleAppEngineFlexibleAppVersionDeploymentZip): void;
    resetZip(): void;
    get zipInput(): GoogleAppEngineFlexibleAppVersionDeploymentZip | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionEndpointsApiService {
    /**
    * Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".
  
  By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
  When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
  and is required in this case.
  
  Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
  the configuration ID. In this case, configId must be omitted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#config_id GoogleAppEngineFlexibleAppVersion#config_id}
    */
    readonly configId?: string;
    /**
    * Enable or disable trace sampling. By default, this is set to false for enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#disable_trace_sampling GoogleAppEngineFlexibleAppVersion#disable_trace_sampling}
    */
    readonly disableTraceSampling?: boolean | cdktf.IResolvable;
    /**
    * Endpoints service name which is the name of the "service" resource in the Service Management API.
  For example "myapi.endpoints.myproject.cloud.goog"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#name GoogleAppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * Endpoints rollout strategy. If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#rollout_strategy GoogleAppEngineFlexibleAppVersion#rollout_strategy}
    */
    readonly rolloutStrategy?: string;
}
export declare function googleAppEngineFlexibleAppVersionEndpointsApiServiceToTerraform(struct?: GoogleAppEngineFlexibleAppVersionEndpointsApiServiceOutputReference | GoogleAppEngineFlexibleAppVersionEndpointsApiService): any;
export declare class GoogleAppEngineFlexibleAppVersionEndpointsApiServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionEndpointsApiService | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionEndpointsApiService | undefined);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    resetConfigId(): void;
    get configIdInput(): string | undefined;
    private _disableTraceSampling?;
    get disableTraceSampling(): boolean | cdktf.IResolvable;
    set disableTraceSampling(value: boolean | cdktf.IResolvable);
    resetDisableTraceSampling(): void;
    get disableTraceSamplingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rolloutStrategy?;
    get rolloutStrategy(): string;
    set rolloutStrategy(value: string);
    resetRolloutStrategy(): void;
    get rolloutStrategyInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionEntrypoint {
    /**
    * The format should be a shell command that can be fed to bash -c.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#shell GoogleAppEngineFlexibleAppVersion#shell}
    */
    readonly shell: string;
}
export declare function googleAppEngineFlexibleAppVersionEntrypointToTerraform(struct?: GoogleAppEngineFlexibleAppVersionEntrypointOutputReference | GoogleAppEngineFlexibleAppVersionEntrypoint): any;
export declare class GoogleAppEngineFlexibleAppVersionEntrypointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionEntrypoint | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionEntrypoint | undefined);
    private _shell?;
    get shell(): string;
    set shell(value: string);
    get shellInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionHandlersScript {
    /**
    * Path to the script from the application root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#script_path GoogleAppEngineFlexibleAppVersion#script_path}
    */
    readonly scriptPath: string;
}
export declare function googleAppEngineFlexibleAppVersionHandlersScriptToTerraform(struct?: GoogleAppEngineFlexibleAppVersionHandlersScriptOutputReference | GoogleAppEngineFlexibleAppVersionHandlersScript): any;
export declare class GoogleAppEngineFlexibleAppVersionHandlersScriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionHandlersScript | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionHandlersScript | undefined);
    private _scriptPath?;
    get scriptPath(): string;
    set scriptPath(value: string);
    get scriptPathInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionHandlersStaticFiles {
    /**
    * Whether files should also be uploaded as code data. By default, files declared in static file handlers are
  uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
  uploads are charged against both your code and static data storage resource quotas.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#application_readable GoogleAppEngineFlexibleAppVersion#application_readable}
    */
    readonly applicationReadable?: boolean | cdktf.IResolvable;
    /**
    * Time a static file served by this handler should be cached by web proxies and browsers.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
  Default is '0s'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#expiration GoogleAppEngineFlexibleAppVersion#expiration}
    */
    readonly expiration?: string;
    /**
    * HTTP headers to use for all responses from these URLs.
  An object containing a list of "key:value" value pairs.".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#http_headers GoogleAppEngineFlexibleAppVersion#http_headers}
    */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
    * MIME type used to serve all files served by this handler.
  Defaults to file-specific MIME types, which are derived from each file's filename extension.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#mime_type GoogleAppEngineFlexibleAppVersion#mime_type}
    */
    readonly mimeType?: string;
    /**
    * Path to the static files matched by the URL pattern, from the application root directory.
  The path can refer to text matched in groupings in the URL pattern.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#path GoogleAppEngineFlexibleAppVersion#path}
    */
    readonly path?: string;
    /**
    * Whether this handler should match the request if the file referenced by the handler does not exist.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#require_matching_file GoogleAppEngineFlexibleAppVersion#require_matching_file}
    */
    readonly requireMatchingFile?: boolean | cdktf.IResolvable;
    /**
    * Regular expression that matches the file paths for all files that should be referenced by this handler.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#upload_path_regex GoogleAppEngineFlexibleAppVersion#upload_path_regex}
    */
    readonly uploadPathRegex?: string;
}
export declare function googleAppEngineFlexibleAppVersionHandlersStaticFilesToTerraform(struct?: GoogleAppEngineFlexibleAppVersionHandlersStaticFilesOutputReference | GoogleAppEngineFlexibleAppVersionHandlersStaticFiles): any;
export declare class GoogleAppEngineFlexibleAppVersionHandlersStaticFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionHandlersStaticFiles | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionHandlersStaticFiles | undefined);
    private _applicationReadable?;
    get applicationReadable(): boolean | cdktf.IResolvable;
    set applicationReadable(value: boolean | cdktf.IResolvable);
    resetApplicationReadable(): void;
    get applicationReadableInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    get expiration(): string;
    set expiration(value: string);
    resetExpiration(): void;
    get expirationInput(): string | undefined;
    private _httpHeaders?;
    get httpHeaders(): {
        [key: string]: string;
    };
    set httpHeaders(value: {
        [key: string]: string;
    });
    resetHttpHeaders(): void;
    get httpHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _mimeType?;
    get mimeType(): string;
    set mimeType(value: string);
    resetMimeType(): void;
    get mimeTypeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _requireMatchingFile?;
    get requireMatchingFile(): boolean | cdktf.IResolvable;
    set requireMatchingFile(value: boolean | cdktf.IResolvable);
    resetRequireMatchingFile(): void;
    get requireMatchingFileInput(): boolean | cdktf.IResolvable | undefined;
    private _uploadPathRegex?;
    get uploadPathRegex(): string;
    set uploadPathRegex(value: string);
    resetUploadPathRegex(): void;
    get uploadPathRegexInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionHandlers {
    /**
    * Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#auth_fail_action GoogleAppEngineFlexibleAppVersion#auth_fail_action}
    */
    readonly authFailAction?: string;
    /**
    * Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#login GoogleAppEngineFlexibleAppVersion#login}
    */
    readonly login?: string;
    /**
    * 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#redirect_http_response_code GoogleAppEngineFlexibleAppVersion#redirect_http_response_code}
    */
    readonly redirectHttpResponseCode?: string;
    /**
    * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#security_level GoogleAppEngineFlexibleAppVersion#security_level}
    */
    readonly securityLevel?: string;
    /**
    * URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
  All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#url_regex GoogleAppEngineFlexibleAppVersion#url_regex}
    */
    readonly urlRegex?: string;
    /**
    * script block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#script GoogleAppEngineFlexibleAppVersion#script}
    */
    readonly script?: GoogleAppEngineFlexibleAppVersionHandlersScript;
    /**
    * static_files block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#static_files GoogleAppEngineFlexibleAppVersion#static_files}
    */
    readonly staticFiles?: GoogleAppEngineFlexibleAppVersionHandlersStaticFiles;
}
export declare function googleAppEngineFlexibleAppVersionHandlersToTerraform(struct?: GoogleAppEngineFlexibleAppVersionHandlers | cdktf.IResolvable): any;
export declare class GoogleAppEngineFlexibleAppVersionHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineFlexibleAppVersionHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionHandlers | cdktf.IResolvable | undefined);
    private _authFailAction?;
    get authFailAction(): string;
    set authFailAction(value: string);
    resetAuthFailAction(): void;
    get authFailActionInput(): string | undefined;
    private _login?;
    get login(): string;
    set login(value: string);
    resetLogin(): void;
    get loginInput(): string | undefined;
    private _redirectHttpResponseCode?;
    get redirectHttpResponseCode(): string;
    set redirectHttpResponseCode(value: string);
    resetRedirectHttpResponseCode(): void;
    get redirectHttpResponseCodeInput(): string | undefined;
    private _securityLevel?;
    get securityLevel(): string;
    set securityLevel(value: string);
    resetSecurityLevel(): void;
    get securityLevelInput(): string | undefined;
    private _urlRegex?;
    get urlRegex(): string;
    set urlRegex(value: string);
    resetUrlRegex(): void;
    get urlRegexInput(): string | undefined;
    private _script;
    get script(): GoogleAppEngineFlexibleAppVersionHandlersScriptOutputReference;
    putScript(value: GoogleAppEngineFlexibleAppVersionHandlersScript): void;
    resetScript(): void;
    get scriptInput(): GoogleAppEngineFlexibleAppVersionHandlersScript | undefined;
    private _staticFiles;
    get staticFiles(): GoogleAppEngineFlexibleAppVersionHandlersStaticFilesOutputReference;
    putStaticFiles(value: GoogleAppEngineFlexibleAppVersionHandlersStaticFiles): void;
    resetStaticFiles(): void;
    get staticFilesInput(): GoogleAppEngineFlexibleAppVersionHandlersStaticFiles | undefined;
}
export declare class GoogleAppEngineFlexibleAppVersionHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineFlexibleAppVersionHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineFlexibleAppVersionHandlersOutputReference;
}
export interface GoogleAppEngineFlexibleAppVersionLivenessCheck {
    /**
    * Interval between health checks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#check_interval GoogleAppEngineFlexibleAppVersion#check_interval}
    */
    readonly checkInterval?: string;
    /**
    * Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#failure_threshold GoogleAppEngineFlexibleAppVersion#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#host GoogleAppEngineFlexibleAppVersion#host}
    */
    readonly host?: string;
    /**
    * The initial delay before starting to execute the checks. Default: "300s"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#initial_delay GoogleAppEngineFlexibleAppVersion#initial_delay}
    */
    readonly initialDelay?: string;
    /**
    * The request path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#path GoogleAppEngineFlexibleAppVersion#path}
    */
    readonly path: string;
    /**
    * Number of consecutive successful checks required before considering the VM healthy. Default: 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#success_threshold GoogleAppEngineFlexibleAppVersion#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Time before the check is considered failed. Default: "4s"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#timeout GoogleAppEngineFlexibleAppVersion#timeout}
    */
    readonly timeout?: string;
}
export declare function googleAppEngineFlexibleAppVersionLivenessCheckToTerraform(struct?: GoogleAppEngineFlexibleAppVersionLivenessCheckOutputReference | GoogleAppEngineFlexibleAppVersionLivenessCheck): any;
export declare class GoogleAppEngineFlexibleAppVersionLivenessCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionLivenessCheck | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionLivenessCheck | undefined);
    private _checkInterval?;
    get checkInterval(): string;
    set checkInterval(value: string);
    resetCheckInterval(): void;
    get checkIntervalInput(): string | undefined;
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _initialDelay?;
    get initialDelay(): string;
    set initialDelay(value: string);
    resetInitialDelay(): void;
    get initialDelayInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionManualScaling {
    /**
    * Number of instances to assign to the service at the start.
  
  **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
  Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#instances GoogleAppEngineFlexibleAppVersion#instances}
    */
    readonly instances: number;
}
export declare function googleAppEngineFlexibleAppVersionManualScalingToTerraform(struct?: GoogleAppEngineFlexibleAppVersionManualScalingOutputReference | GoogleAppEngineFlexibleAppVersionManualScaling): any;
export declare class GoogleAppEngineFlexibleAppVersionManualScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionManualScaling | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionManualScaling | undefined);
    private _instances?;
    get instances(): number;
    set instances(value: number);
    get instancesInput(): number | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionNetwork {
    /**
    * List of ports, or port pairs, to forward from the virtual machine to the application container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#forwarded_ports GoogleAppEngineFlexibleAppVersion#forwarded_ports}
    */
    readonly forwardedPorts?: string[];
    /**
    * Tag to apply to the instance during creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#instance_tag GoogleAppEngineFlexibleAppVersion#instance_tag}
    */
    readonly instanceTag?: string;
    /**
    * Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#name GoogleAppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * Enable session affinity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#session_affinity GoogleAppEngineFlexibleAppVersion#session_affinity}
    */
    readonly sessionAffinity?: boolean | cdktf.IResolvable;
    /**
    * Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.
  
  If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
  If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
  If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
  If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#subnetwork GoogleAppEngineFlexibleAppVersion#subnetwork}
    */
    readonly subnetwork?: string;
}
export declare function googleAppEngineFlexibleAppVersionNetworkToTerraform(struct?: GoogleAppEngineFlexibleAppVersionNetworkOutputReference | GoogleAppEngineFlexibleAppVersionNetwork): any;
export declare class GoogleAppEngineFlexibleAppVersionNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionNetwork | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionNetwork | undefined);
    private _forwardedPorts?;
    get forwardedPorts(): string[];
    set forwardedPorts(value: string[]);
    resetForwardedPorts(): void;
    get forwardedPortsInput(): string[] | undefined;
    private _instanceTag?;
    get instanceTag(): string;
    set instanceTag(value: string);
    resetInstanceTag(): void;
    get instanceTagInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sessionAffinity?;
    get sessionAffinity(): boolean | cdktf.IResolvable;
    set sessionAffinity(value: boolean | cdktf.IResolvable);
    resetSessionAffinity(): void;
    get sessionAffinityInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionReadinessCheck {
    /**
    * A maximum time limit on application initialization, measured from moment the application successfully
  replies to a healthcheck until it is ready to serve traffic. Default: "300s"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#app_start_timeout GoogleAppEngineFlexibleAppVersion#app_start_timeout}
    */
    readonly appStartTimeout?: string;
    /**
    * Interval between health checks.  Default: "5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#check_interval GoogleAppEngineFlexibleAppVersion#check_interval}
    */
    readonly checkInterval?: string;
    /**
    * Number of consecutive failed checks required before removing traffic. Default: 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#failure_threshold GoogleAppEngineFlexibleAppVersion#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#host GoogleAppEngineFlexibleAppVersion#host}
    */
    readonly host?: string;
    /**
    * The request path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#path GoogleAppEngineFlexibleAppVersion#path}
    */
    readonly path: string;
    /**
    * Number of consecutive successful checks required before receiving traffic. Default: 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#success_threshold GoogleAppEngineFlexibleAppVersion#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Time before the check is considered failed. Default: "4s"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#timeout GoogleAppEngineFlexibleAppVersion#timeout}
    */
    readonly timeout?: string;
}
export declare function googleAppEngineFlexibleAppVersionReadinessCheckToTerraform(struct?: GoogleAppEngineFlexibleAppVersionReadinessCheckOutputReference | GoogleAppEngineFlexibleAppVersionReadinessCheck): any;
export declare class GoogleAppEngineFlexibleAppVersionReadinessCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionReadinessCheck | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionReadinessCheck | undefined);
    private _appStartTimeout?;
    get appStartTimeout(): string;
    set appStartTimeout(value: string);
    resetAppStartTimeout(): void;
    get appStartTimeoutInput(): string | undefined;
    private _checkInterval?;
    get checkInterval(): string;
    set checkInterval(value: string);
    resetCheckInterval(): void;
    get checkIntervalInput(): string | undefined;
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionResourcesVolumes {
    /**
    * Unique name for the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#name GoogleAppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * Volume size in gigabytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#size_gb GoogleAppEngineFlexibleAppVersion#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Underlying volume type, e.g. 'tmpfs'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#volume_type GoogleAppEngineFlexibleAppVersion#volume_type}
    */
    readonly volumeType: string;
}
export declare function googleAppEngineFlexibleAppVersionResourcesVolumesToTerraform(struct?: GoogleAppEngineFlexibleAppVersionResourcesVolumes | cdktf.IResolvable): any;
export declare class GoogleAppEngineFlexibleAppVersionResourcesVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineFlexibleAppVersionResourcesVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionResourcesVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    get sizeGbInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    get volumeTypeInput(): string | undefined;
}
export declare class GoogleAppEngineFlexibleAppVersionResourcesVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineFlexibleAppVersionResourcesVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineFlexibleAppVersionResourcesVolumesOutputReference;
}
export interface GoogleAppEngineFlexibleAppVersionResources {
    /**
    * Number of CPU cores needed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#cpu GoogleAppEngineFlexibleAppVersion#cpu}
    */
    readonly cpu?: number;
    /**
    * Disk size (GB) needed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#disk_gb GoogleAppEngineFlexibleAppVersion#disk_gb}
    */
    readonly diskGb?: number;
    /**
    * Memory (GB) needed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#memory_gb GoogleAppEngineFlexibleAppVersion#memory_gb}
    */
    readonly memoryGb?: number;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#volumes GoogleAppEngineFlexibleAppVersion#volumes}
    */
    readonly volumes?: GoogleAppEngineFlexibleAppVersionResourcesVolumes[] | cdktf.IResolvable;
}
export declare function googleAppEngineFlexibleAppVersionResourcesToTerraform(struct?: GoogleAppEngineFlexibleAppVersionResourcesOutputReference | GoogleAppEngineFlexibleAppVersionResources): any;
export declare class GoogleAppEngineFlexibleAppVersionResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionResources | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionResources | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _diskGb?;
    get diskGb(): number;
    set diskGb(value: number);
    resetDiskGb(): void;
    get diskGbInput(): number | undefined;
    private _memoryGb?;
    get memoryGb(): number;
    set memoryGb(value: number);
    resetMemoryGb(): void;
    get memoryGbInput(): number | undefined;
    private _volumes;
    get volumes(): GoogleAppEngineFlexibleAppVersionResourcesVolumesList;
    putVolumes(value: GoogleAppEngineFlexibleAppVersionResourcesVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | GoogleAppEngineFlexibleAppVersionResourcesVolumes[] | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#create GoogleAppEngineFlexibleAppVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#delete GoogleAppEngineFlexibleAppVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#update GoogleAppEngineFlexibleAppVersion#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineFlexibleAppVersionTimeoutsToTerraform(struct?: GoogleAppEngineFlexibleAppVersionTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineFlexibleAppVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleAppEngineFlexibleAppVersionVpcAccessConnector {
    /**
    * Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version#name GoogleAppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
}
export declare function googleAppEngineFlexibleAppVersionVpcAccessConnectorToTerraform(struct?: GoogleAppEngineFlexibleAppVersionVpcAccessConnectorOutputReference | GoogleAppEngineFlexibleAppVersionVpcAccessConnector): any;
export declare class GoogleAppEngineFlexibleAppVersionVpcAccessConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineFlexibleAppVersionVpcAccessConnector | undefined;
    set internalValue(value: GoogleAppEngineFlexibleAppVersionVpcAccessConnector | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version google_app_engine_flexible_app_version}
*/
export declare class GoogleAppEngineFlexibleAppVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_flexible_app_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_flexible_app_version google_app_engine_flexible_app_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineFlexibleAppVersionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineFlexibleAppVersionConfig);
    private _betaSettings?;
    get betaSettings(): {
        [key: string]: string;
    };
    set betaSettings(value: {
        [key: string]: string;
    });
    resetBetaSettings(): void;
    get betaSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultExpiration?;
    get defaultExpiration(): string;
    set defaultExpiration(value: string);
    resetDefaultExpiration(): void;
    get defaultExpirationInput(): string | undefined;
    private _deleteServiceOnDestroy?;
    get deleteServiceOnDestroy(): boolean | cdktf.IResolvable;
    set deleteServiceOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeleteServiceOnDestroy(): void;
    get deleteServiceOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _envVariables?;
    get envVariables(): {
        [key: string]: string;
    };
    set envVariables(value: {
        [key: string]: string;
    });
    resetEnvVariables(): void;
    get envVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundServices?;
    get inboundServices(): string[];
    set inboundServices(value: string[]);
    resetInboundServices(): void;
    get inboundServicesInput(): string[] | undefined;
    private _instanceClass?;
    get instanceClass(): string;
    set instanceClass(value: string);
    resetInstanceClass(): void;
    get instanceClassInput(): string | undefined;
    get name(): string;
    private _nobuildFilesRegex?;
    get nobuildFilesRegex(): string;
    set nobuildFilesRegex(value: string);
    resetNobuildFilesRegex(): void;
    get nobuildFilesRegexInput(): string | undefined;
    private _noopOnDestroy?;
    get noopOnDestroy(): boolean | cdktf.IResolvable;
    set noopOnDestroy(value: boolean | cdktf.IResolvable);
    resetNoopOnDestroy(): void;
    get noopOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    get runtimeInput(): string | undefined;
    private _runtimeApiVersion?;
    get runtimeApiVersion(): string;
    set runtimeApiVersion(value: string);
    resetRuntimeApiVersion(): void;
    get runtimeApiVersionInput(): string | undefined;
    private _runtimeChannel?;
    get runtimeChannel(): string;
    set runtimeChannel(value: string);
    resetRuntimeChannel(): void;
    get runtimeChannelInput(): string | undefined;
    private _runtimeMainExecutablePath?;
    get runtimeMainExecutablePath(): string;
    set runtimeMainExecutablePath(value: string);
    resetRuntimeMainExecutablePath(): void;
    get runtimeMainExecutablePathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _servingStatus?;
    get servingStatus(): string;
    set servingStatus(value: string);
    resetServingStatus(): void;
    get servingStatusInput(): string | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    resetVersionId(): void;
    get versionIdInput(): string | undefined;
    private _apiConfig;
    get apiConfig(): GoogleAppEngineFlexibleAppVersionApiConfigOutputReference;
    putApiConfig(value: GoogleAppEngineFlexibleAppVersionApiConfig): void;
    resetApiConfig(): void;
    get apiConfigInput(): GoogleAppEngineFlexibleAppVersionApiConfig | undefined;
    private _automaticScaling;
    get automaticScaling(): GoogleAppEngineFlexibleAppVersionAutomaticScalingOutputReference;
    putAutomaticScaling(value: GoogleAppEngineFlexibleAppVersionAutomaticScaling): void;
    resetAutomaticScaling(): void;
    get automaticScalingInput(): GoogleAppEngineFlexibleAppVersionAutomaticScaling | undefined;
    private _deployment;
    get deployment(): GoogleAppEngineFlexibleAppVersionDeploymentOutputReference;
    putDeployment(value: GoogleAppEngineFlexibleAppVersionDeployment): void;
    resetDeployment(): void;
    get deploymentInput(): GoogleAppEngineFlexibleAppVersionDeployment | undefined;
    private _endpointsApiService;
    get endpointsApiService(): GoogleAppEngineFlexibleAppVersionEndpointsApiServiceOutputReference;
    putEndpointsApiService(value: GoogleAppEngineFlexibleAppVersionEndpointsApiService): void;
    resetEndpointsApiService(): void;
    get endpointsApiServiceInput(): GoogleAppEngineFlexibleAppVersionEndpointsApiService | undefined;
    private _entrypoint;
    get entrypoint(): GoogleAppEngineFlexibleAppVersionEntrypointOutputReference;
    putEntrypoint(value: GoogleAppEngineFlexibleAppVersionEntrypoint): void;
    resetEntrypoint(): void;
    get entrypointInput(): GoogleAppEngineFlexibleAppVersionEntrypoint | undefined;
    private _handlers;
    get handlers(): GoogleAppEngineFlexibleAppVersionHandlersList;
    putHandlers(value: GoogleAppEngineFlexibleAppVersionHandlers[] | cdktf.IResolvable): void;
    resetHandlers(): void;
    get handlersInput(): cdktf.IResolvable | GoogleAppEngineFlexibleAppVersionHandlers[] | undefined;
    private _livenessCheck;
    get livenessCheck(): GoogleAppEngineFlexibleAppVersionLivenessCheckOutputReference;
    putLivenessCheck(value: GoogleAppEngineFlexibleAppVersionLivenessCheck): void;
    get livenessCheckInput(): GoogleAppEngineFlexibleAppVersionLivenessCheck | undefined;
    private _manualScaling;
    get manualScaling(): GoogleAppEngineFlexibleAppVersionManualScalingOutputReference;
    putManualScaling(value: GoogleAppEngineFlexibleAppVersionManualScaling): void;
    resetManualScaling(): void;
    get manualScalingInput(): GoogleAppEngineFlexibleAppVersionManualScaling | undefined;
    private _network;
    get network(): GoogleAppEngineFlexibleAppVersionNetworkOutputReference;
    putNetwork(value: GoogleAppEngineFlexibleAppVersionNetwork): void;
    resetNetwork(): void;
    get networkInput(): GoogleAppEngineFlexibleAppVersionNetwork | undefined;
    private _readinessCheck;
    get readinessCheck(): GoogleAppEngineFlexibleAppVersionReadinessCheckOutputReference;
    putReadinessCheck(value: GoogleAppEngineFlexibleAppVersionReadinessCheck): void;
    get readinessCheckInput(): GoogleAppEngineFlexibleAppVersionReadinessCheck | undefined;
    private _resources;
    get resources(): GoogleAppEngineFlexibleAppVersionResourcesOutputReference;
    putResources(value: GoogleAppEngineFlexibleAppVersionResources): void;
    resetResources(): void;
    get resourcesInput(): GoogleAppEngineFlexibleAppVersionResources | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineFlexibleAppVersionTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineFlexibleAppVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineFlexibleAppVersionTimeouts | undefined;
    private _vpcAccessConnector;
    get vpcAccessConnector(): GoogleAppEngineFlexibleAppVersionVpcAccessConnectorOutputReference;
    putVpcAccessConnector(value: GoogleAppEngineFlexibleAppVersionVpcAccessConnector): void;
    resetVpcAccessConnector(): void;
    get vpcAccessConnectorInput(): GoogleAppEngineFlexibleAppVersionVpcAccessConnector | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
