import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineServiceSplitTrafficConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#id GoogleAppEngineServiceSplitTraffic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If set to true traffic will be migrated to this version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#migrate_traffic GoogleAppEngineServiceSplitTraffic#migrate_traffic}
    */
    readonly migrateTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#project GoogleAppEngineServiceSplitTraffic#project}
    */
    readonly project?: string;
    /**
    * The name of the service these settings apply to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#service GoogleAppEngineServiceSplitTraffic#service}
    */
    readonly service: string;
    /**
    * split block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#split GoogleAppEngineServiceSplitTraffic#split}
    */
    readonly split: GoogleAppEngineServiceSplitTrafficSplit;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#timeouts GoogleAppEngineServiceSplitTraffic#timeouts}
    */
    readonly timeouts?: GoogleAppEngineServiceSplitTrafficTimeouts;
}
export interface GoogleAppEngineServiceSplitTrafficSplit {
    /**
    * Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#allocations GoogleAppEngineServiceSplitTraffic#allocations}
    */
    readonly allocations: {
        [key: string]: string;
    };
    /**
    * Mechanism used to determine which version a request is sent to. The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#shard_by GoogleAppEngineServiceSplitTraffic#shard_by}
    */
    readonly shardBy?: string;
}
export declare function googleAppEngineServiceSplitTrafficSplitToTerraform(struct?: GoogleAppEngineServiceSplitTrafficSplitOutputReference | GoogleAppEngineServiceSplitTrafficSplit): any;
export declare class GoogleAppEngineServiceSplitTrafficSplitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineServiceSplitTrafficSplit | undefined;
    set internalValue(value: GoogleAppEngineServiceSplitTrafficSplit | undefined);
    private _allocations?;
    get allocations(): {
        [key: string]: string;
    };
    set allocations(value: {
        [key: string]: string;
    });
    get allocationsInput(): {
        [key: string]: string;
    } | undefined;
    private _shardBy?;
    get shardBy(): string;
    set shardBy(value: string);
    resetShardBy(): void;
    get shardByInput(): string | undefined;
}
export interface GoogleAppEngineServiceSplitTrafficTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#create GoogleAppEngineServiceSplitTraffic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#delete GoogleAppEngineServiceSplitTraffic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic#update GoogleAppEngineServiceSplitTraffic#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineServiceSplitTrafficTimeoutsToTerraform(struct?: GoogleAppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineServiceSplitTrafficTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic google_app_engine_service_split_traffic}
*/
export declare class GoogleAppEngineServiceSplitTraffic extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_service_split_traffic";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_app_engine_service_split_traffic google_app_engine_service_split_traffic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineServiceSplitTrafficConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineServiceSplitTrafficConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _migrateTraffic?;
    get migrateTraffic(): boolean | cdktf.IResolvable;
    set migrateTraffic(value: boolean | cdktf.IResolvable);
    resetMigrateTraffic(): void;
    get migrateTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _split;
    get split(): GoogleAppEngineServiceSplitTrafficSplitOutputReference;
    putSplit(value: GoogleAppEngineServiceSplitTrafficSplit): void;
    get splitInput(): GoogleAppEngineServiceSplitTrafficSplit | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineServiceSplitTrafficTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineServiceSplitTrafficTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineServiceSplitTrafficTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
