import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleArtifactRegistryRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-provided description of the repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#description GoogleArtifactRegistryRepository#description}
    */
    readonly description?: string;
    /**
    * The format of packages that are stored in the repository. Supported formats
  can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
  You can only create alpha formats if you are a member of the
  [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#format GoogleArtifactRegistryRepository#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#id GoogleArtifactRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Cloud KMS resource name of the customer managed encryption key that’s
  used to encrypt the contents of the Repository. Has the form:
  'projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key'.
  This value may not be changed after the Repository has been created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#kms_key_name GoogleArtifactRegistryRepository#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Labels with user-defined metadata.
  This field may contain up to 64 entries. Label keys and values may be no
  longer than 63 characters. Label keys must begin with a lowercase letter
  and may only contain lowercase letters, numeric characters, underscores,
  and dashes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#labels GoogleArtifactRegistryRepository#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this repository is located in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#location GoogleArtifactRegistryRepository#location}
    */
    readonly location?: string;
    /**
    * The mode configures the repository to serve artifacts from different sources. Default value: "STANDARD_REPOSITORY" Possible values: ["STANDARD_REPOSITORY", "VIRTUAL_REPOSITORY", "REMOTE_REPOSITORY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#mode GoogleArtifactRegistryRepository#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#project GoogleArtifactRegistryRepository#project}
    */
    readonly project?: string;
    /**
    * The last part of the repository name, for example:
  "repo1"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#repository_id GoogleArtifactRegistryRepository#repository_id}
    */
    readonly repositoryId: string;
    /**
    * docker_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#docker_config GoogleArtifactRegistryRepository#docker_config}
    */
    readonly dockerConfig?: GoogleArtifactRegistryRepositoryDockerConfig;
    /**
    * maven_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#maven_config GoogleArtifactRegistryRepository#maven_config}
    */
    readonly mavenConfig?: GoogleArtifactRegistryRepositoryMavenConfig;
    /**
    * remote_repository_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#remote_repository_config GoogleArtifactRegistryRepository#remote_repository_config}
    */
    readonly remoteRepositoryConfig?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#timeouts GoogleArtifactRegistryRepository#timeouts}
    */
    readonly timeouts?: GoogleArtifactRegistryRepositoryTimeouts;
    /**
    * virtual_repository_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#virtual_repository_config GoogleArtifactRegistryRepository#virtual_repository_config}
    */
    readonly virtualRepositoryConfig?: GoogleArtifactRegistryRepositoryVirtualRepositoryConfig;
}
export interface GoogleArtifactRegistryRepositoryDockerConfig {
    /**
    * The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#immutable_tags GoogleArtifactRegistryRepository#immutable_tags}
    */
    readonly immutableTags?: boolean | cdktf.IResolvable;
}
export declare function googleArtifactRegistryRepositoryDockerConfigToTerraform(struct?: GoogleArtifactRegistryRepositoryDockerConfigOutputReference | GoogleArtifactRegistryRepositoryDockerConfig): any;
export declare class GoogleArtifactRegistryRepositoryDockerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryDockerConfig | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryDockerConfig | undefined);
    private _immutableTags?;
    get immutableTags(): boolean | cdktf.IResolvable;
    set immutableTags(value: boolean | cdktf.IResolvable);
    resetImmutableTags(): void;
    get immutableTagsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleArtifactRegistryRepositoryMavenConfig {
    /**
    * The repository with this flag will allow publishing the same
  snapshot versions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#allow_snapshot_overwrites GoogleArtifactRegistryRepository#allow_snapshot_overwrites}
    */
    readonly allowSnapshotOverwrites?: boolean | cdktf.IResolvable;
    /**
    * Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#version_policy GoogleArtifactRegistryRepository#version_policy}
    */
    readonly versionPolicy?: string;
}
export declare function googleArtifactRegistryRepositoryMavenConfigToTerraform(struct?: GoogleArtifactRegistryRepositoryMavenConfigOutputReference | GoogleArtifactRegistryRepositoryMavenConfig): any;
export declare class GoogleArtifactRegistryRepositoryMavenConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryMavenConfig | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryMavenConfig | undefined);
    private _allowSnapshotOverwrites?;
    get allowSnapshotOverwrites(): boolean | cdktf.IResolvable;
    set allowSnapshotOverwrites(value: boolean | cdktf.IResolvable);
    resetAllowSnapshotOverwrites(): void;
    get allowSnapshotOverwritesInput(): boolean | cdktf.IResolvable | undefined;
    private _versionPolicy?;
    get versionPolicy(): string;
    set versionPolicy(value: string);
    resetVersionPolicy(): void;
    get versionPolicyInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository {
    /**
    * Address of the remote repository. Default value: "DOCKER_HUB" Possible values: ["DOCKER_HUB"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#public_repository GoogleArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function googleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryToTerraform(struct?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryOutputReference | GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository): any;
export declare class GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository {
    /**
    * Address of the remote repository. Default value: "MAVEN_CENTRAL" Possible values: ["MAVEN_CENTRAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#public_repository GoogleArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function googleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryToTerraform(struct?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryOutputReference | GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository): any;
export declare class GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository {
    /**
    * Address of the remote repository. Default value: "NPMJS" Possible values: ["NPMJS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#public_repository GoogleArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function googleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryToTerraform(struct?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryOutputReference | GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository): any;
export declare class GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository {
    /**
    * Address of the remote repository. Default value: "PYPI" Possible values: ["PYPI"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#public_repository GoogleArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function googleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryToTerraform(struct?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryOutputReference | GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository): any;
export declare class GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryRemoteRepositoryConfig {
    /**
    * The description of the remote source.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#description GoogleArtifactRegistryRepository#description}
    */
    readonly description?: string;
    /**
    * docker_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#docker_repository GoogleArtifactRegistryRepository#docker_repository}
    */
    readonly dockerRepository?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository;
    /**
    * maven_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#maven_repository GoogleArtifactRegistryRepository#maven_repository}
    */
    readonly mavenRepository?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository;
    /**
    * npm_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#npm_repository GoogleArtifactRegistryRepository#npm_repository}
    */
    readonly npmRepository?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository;
    /**
    * python_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#python_repository GoogleArtifactRegistryRepository#python_repository}
    */
    readonly pythonRepository?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository;
}
export declare function googleArtifactRegistryRepositoryRemoteRepositoryConfigToTerraform(struct?: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigOutputReference | GoogleArtifactRegistryRepositoryRemoteRepositoryConfig): any;
export declare class GoogleArtifactRegistryRepositoryRemoteRepositoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfig | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfig | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dockerRepository;
    get dockerRepository(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryOutputReference;
    putDockerRepository(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository): void;
    resetDockerRepository(): void;
    get dockerRepositoryInput(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository | undefined;
    private _mavenRepository;
    get mavenRepository(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryOutputReference;
    putMavenRepository(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository): void;
    resetMavenRepository(): void;
    get mavenRepositoryInput(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository | undefined;
    private _npmRepository;
    get npmRepository(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryOutputReference;
    putNpmRepository(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository): void;
    resetNpmRepository(): void;
    get npmRepositoryInput(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository | undefined;
    private _pythonRepository;
    get pythonRepository(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryOutputReference;
    putPythonRepository(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository): void;
    resetPythonRepository(): void;
    get pythonRepositoryInput(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository | undefined;
}
export interface GoogleArtifactRegistryRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#create GoogleArtifactRegistryRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#delete GoogleArtifactRegistryRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#update GoogleArtifactRegistryRepository#update}
    */
    readonly update?: string;
}
export declare function googleArtifactRegistryRepositoryTimeoutsToTerraform(struct?: GoogleArtifactRegistryRepositoryTimeouts | cdktf.IResolvable): any;
export declare class GoogleArtifactRegistryRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies {
    /**
    * The user-provided ID of the upstream policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#id GoogleArtifactRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Entries with a greater priority value take precedence in the pull order.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#priority GoogleArtifactRegistryRepository#priority}
    */
    readonly priority?: number;
    /**
    * A reference to the repository resource, for example:
  "projects/p1/locations/us-central1/repository/repo1".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#repository GoogleArtifactRegistryRepository#repository}
    */
    readonly repository?: string;
}
export declare function googleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesToTerraform(struct?: GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies | cdktf.IResolvable): any;
export declare class GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
}
export declare class GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesOutputReference;
}
export interface GoogleArtifactRegistryRepositoryVirtualRepositoryConfig {
    /**
    * upstream_policies block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository#upstream_policies GoogleArtifactRegistryRepository#upstream_policies}
    */
    readonly upstreamPolicies?: GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | cdktf.IResolvable;
}
export declare function googleArtifactRegistryRepositoryVirtualRepositoryConfigToTerraform(struct?: GoogleArtifactRegistryRepositoryVirtualRepositoryConfigOutputReference | GoogleArtifactRegistryRepositoryVirtualRepositoryConfig): any;
export declare class GoogleArtifactRegistryRepositoryVirtualRepositoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryVirtualRepositoryConfig | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryVirtualRepositoryConfig | undefined);
    private _upstreamPolicies;
    get upstreamPolicies(): GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesList;
    putUpstreamPolicies(value: GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | cdktf.IResolvable): void;
    resetUpstreamPolicies(): void;
    get upstreamPoliciesInput(): cdktf.IResolvable | GoogleArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository google_artifact_registry_repository}
*/
export declare class GoogleArtifactRegistryRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_artifact_registry_repository";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_artifact_registry_repository google_artifact_registry_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleArtifactRegistryRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleArtifactRegistryRepositoryConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repositoryId?;
    get repositoryId(): string;
    set repositoryId(value: string);
    get repositoryIdInput(): string | undefined;
    get updateTime(): string;
    private _dockerConfig;
    get dockerConfig(): GoogleArtifactRegistryRepositoryDockerConfigOutputReference;
    putDockerConfig(value: GoogleArtifactRegistryRepositoryDockerConfig): void;
    resetDockerConfig(): void;
    get dockerConfigInput(): GoogleArtifactRegistryRepositoryDockerConfig | undefined;
    private _mavenConfig;
    get mavenConfig(): GoogleArtifactRegistryRepositoryMavenConfigOutputReference;
    putMavenConfig(value: GoogleArtifactRegistryRepositoryMavenConfig): void;
    resetMavenConfig(): void;
    get mavenConfigInput(): GoogleArtifactRegistryRepositoryMavenConfig | undefined;
    private _remoteRepositoryConfig;
    get remoteRepositoryConfig(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfigOutputReference;
    putRemoteRepositoryConfig(value: GoogleArtifactRegistryRepositoryRemoteRepositoryConfig): void;
    resetRemoteRepositoryConfig(): void;
    get remoteRepositoryConfigInput(): GoogleArtifactRegistryRepositoryRemoteRepositoryConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleArtifactRegistryRepositoryTimeoutsOutputReference;
    putTimeouts(value: GoogleArtifactRegistryRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleArtifactRegistryRepositoryTimeouts | undefined;
    private _virtualRepositoryConfig;
    get virtualRepositoryConfig(): GoogleArtifactRegistryRepositoryVirtualRepositoryConfigOutputReference;
    putVirtualRepositoryConfig(value: GoogleArtifactRegistryRepositoryVirtualRepositoryConfig): void;
    resetVirtualRepositoryConfig(): void;
    get virtualRepositoryConfigInput(): GoogleArtifactRegistryRepositoryVirtualRepositoryConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
