import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBeyondcorpAppGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * An arbitrary user-provided name for the AppGateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#display_name GoogleBeyondcorpAppGateway#display_name}
    */
    readonly displayName?: string;
    /**
    * The type of hosting used by the AppGateway. Default value: "HOST_TYPE_UNSPECIFIED" Possible values: ["HOST_TYPE_UNSPECIFIED", "GCP_REGIONAL_MIG"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#host_type GoogleBeyondcorpAppGateway#host_type}
    */
    readonly hostType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#id GoogleBeyondcorpAppGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#labels GoogleBeyondcorpAppGateway#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * ID of the AppGateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#name GoogleBeyondcorpAppGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#project GoogleBeyondcorpAppGateway#project}
    */
    readonly project?: string;
    /**
    * The region of the AppGateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#region GoogleBeyondcorpAppGateway#region}
    */
    readonly region?: string;
    /**
    * The type of network connectivity used by the AppGateway. Default value: "TYPE_UNSPECIFIED" Possible values: ["TYPE_UNSPECIFIED", "TCP_PROXY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#type GoogleBeyondcorpAppGateway#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#timeouts GoogleBeyondcorpAppGateway#timeouts}
    */
    readonly timeouts?: GoogleBeyondcorpAppGatewayTimeouts;
}
export interface GoogleBeyondcorpAppGatewayAllocatedConnections {
}
export declare function googleBeyondcorpAppGatewayAllocatedConnectionsToTerraform(struct?: GoogleBeyondcorpAppGatewayAllocatedConnections): any;
export declare class GoogleBeyondcorpAppGatewayAllocatedConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBeyondcorpAppGatewayAllocatedConnections | undefined;
    set internalValue(value: GoogleBeyondcorpAppGatewayAllocatedConnections | undefined);
    get ingressPort(): number;
    get pscUri(): string;
}
export declare class GoogleBeyondcorpAppGatewayAllocatedConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBeyondcorpAppGatewayAllocatedConnectionsOutputReference;
}
export interface GoogleBeyondcorpAppGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#create GoogleBeyondcorpAppGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway#delete GoogleBeyondcorpAppGateway#delete}
    */
    readonly delete?: string;
}
export declare function googleBeyondcorpAppGatewayTimeoutsToTerraform(struct?: GoogleBeyondcorpAppGatewayTimeouts | cdktf.IResolvable): any;
export declare class GoogleBeyondcorpAppGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBeyondcorpAppGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBeyondcorpAppGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway google_beyondcorp_app_gateway}
*/
export declare class GoogleBeyondcorpAppGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_beyondcorp_app_gateway";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_beyondcorp_app_gateway google_beyondcorp_app_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBeyondcorpAppGatewayConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBeyondcorpAppGatewayConfig);
    private _allocatedConnections;
    get allocatedConnections(): GoogleBeyondcorpAppGatewayAllocatedConnectionsList;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _hostType?;
    get hostType(): string;
    set hostType(value: string);
    resetHostType(): void;
    get hostTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get uri(): string;
    private _timeouts;
    get timeouts(): GoogleBeyondcorpAppGatewayTimeoutsOutputReference;
    putTimeouts(value: GoogleBeyondcorpAppGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBeyondcorpAppGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
