import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryCapacityCommitmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The optional capacity commitment ID. Capacity commitment name will be generated automatically if this field is
  empty. This field must only contain lower case alphanumeric characters or dashes. The first and last character
  cannot be a dash. Max length is 64 characters. NOTE: this ID won't be kept if the capacity commitment is split
  or merged.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#capacity_commitment_id GoogleBigqueryCapacityCommitment#capacity_commitment_id}
    */
    readonly capacityCommitmentId?: string;
    /**
    * The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#edition GoogleBigqueryCapacityCommitment#edition}
    */
    readonly edition?: string;
    /**
    * If true, fail the request if another project in the organization has a capacity commitment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#enforce_single_admin_project_per_org GoogleBigqueryCapacityCommitment#enforce_single_admin_project_per_org}
    */
    readonly enforceSingleAdminProjectPerOrg?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#id GoogleBigqueryCapacityCommitment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The geographic location where the transfer config should reside.
  Examples: US, EU, asia-northeast1. The default value is US.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#location GoogleBigqueryCapacityCommitment#location}
    */
    readonly location?: string;
    /**
    * Capacity commitment plan. Valid values are at https://cloud.google.com/bigquery/docs/reference/reservations/rpc/google.cloud.bigquery.reservation.v1#commitmentplan
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#plan GoogleBigqueryCapacityCommitment#plan}
    */
    readonly plan: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#project GoogleBigqueryCapacityCommitment#project}
    */
    readonly project?: string;
    /**
    * The plan this capacity commitment is converted to after commitmentEndTime passes. Once the plan is changed, committed period is extended according to commitment plan. Only applicable some commitment plans.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#renewal_plan GoogleBigqueryCapacityCommitment#renewal_plan}
    */
    readonly renewalPlan?: string;
    /**
    * Number of slots in this commitment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#slot_count GoogleBigqueryCapacityCommitment#slot_count}
    */
    readonly slotCount: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#timeouts GoogleBigqueryCapacityCommitment#timeouts}
    */
    readonly timeouts?: GoogleBigqueryCapacityCommitmentTimeouts;
}
export interface GoogleBigqueryCapacityCommitmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#create GoogleBigqueryCapacityCommitment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#delete GoogleBigqueryCapacityCommitment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment#update GoogleBigqueryCapacityCommitment#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryCapacityCommitmentTimeoutsToTerraform(struct?: GoogleBigqueryCapacityCommitmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryCapacityCommitmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryCapacityCommitmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryCapacityCommitmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment google_bigquery_capacity_commitment}
*/
export declare class GoogleBigqueryCapacityCommitment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_capacity_commitment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_capacity_commitment google_bigquery_capacity_commitment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryCapacityCommitmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryCapacityCommitmentConfig);
    private _capacityCommitmentId?;
    get capacityCommitmentId(): string;
    set capacityCommitmentId(value: string);
    resetCapacityCommitmentId(): void;
    get capacityCommitmentIdInput(): string | undefined;
    get commitmentEndTime(): string;
    get commitmentStartTime(): string;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    resetEdition(): void;
    get editionInput(): string | undefined;
    private _enforceSingleAdminProjectPerOrg?;
    get enforceSingleAdminProjectPerOrg(): string;
    set enforceSingleAdminProjectPerOrg(value: string);
    resetEnforceSingleAdminProjectPerOrg(): void;
    get enforceSingleAdminProjectPerOrgInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _renewalPlan?;
    get renewalPlan(): string;
    set renewalPlan(value: string);
    resetRenewalPlan(): void;
    get renewalPlanInput(): string | undefined;
    private _slotCount?;
    get slotCount(): number;
    set slotCount(value: number);
    get slotCountInput(): number | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): GoogleBigqueryCapacityCommitmentTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryCapacityCommitmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryCapacityCommitmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
