import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryDataTransferConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of days to look back to automatically refresh the data.
  For example, if dataRefreshWindowDays = 10, then every day BigQuery
  reingests data for [today-10, today-1], rather than ingesting data for
  just [today-1]. Only valid if the data source supports the feature.
  Set the value to 0 to use the default value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#data_refresh_window_days GoogleBigqueryDataTransferConfig#data_refresh_window_days}
    */
    readonly dataRefreshWindowDays?: number;
    /**
    * The data source id. Cannot be changed once the transfer config is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#data_source_id GoogleBigqueryDataTransferConfig#data_source_id}
    */
    readonly dataSourceId: string;
    /**
    * The BigQuery target dataset id.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#destination_dataset_id GoogleBigqueryDataTransferConfig#destination_dataset_id}
    */
    readonly destinationDatasetId?: string;
    /**
    * When set to true, no runs are scheduled for a given transfer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#disabled GoogleBigqueryDataTransferConfig#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The user specified display name for the transfer config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#display_name GoogleBigqueryDataTransferConfig#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#id GoogleBigqueryDataTransferConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The geographic location where the transfer config should reside.
  Examples: US, EU, asia-northeast1. The default value is US.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#location GoogleBigqueryDataTransferConfig#location}
    */
    readonly location?: string;
    /**
    * Pub/Sub topic where notifications will be sent after transfer runs
  associated with this transfer config finish.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#notification_pubsub_topic GoogleBigqueryDataTransferConfig#notification_pubsub_topic}
    */
    readonly notificationPubsubTopic?: string;
    /**
    * Parameters specific to each data source. For more information see the bq tab in the 'Setting up a data transfer'
  section for each data source. For example the parameters for Cloud Storage transfers are listed here:
  https://cloud.google.com/bigquery-transfer/docs/cloud-storage-transfer#bq
  
  **NOTE** : If you are attempting to update a parameter that cannot be updated (due to api limitations) [please force recreation of the resource](https://www.terraform.io/cli/state/taint#forcing-re-creation-of-resources).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#params GoogleBigqueryDataTransferConfig#params}
    */
    readonly params: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#project GoogleBigqueryDataTransferConfig#project}
    */
    readonly project?: string;
    /**
    * Data transfer schedule. If the data source does not support a custom
  schedule, this should be empty. If it is empty, the default value for
  the data source will be used. The specified times are in UTC. Examples
  of valid format: 1st,3rd monday of month 15:30, every wed,fri of jan,
  jun 13:15, and first sunday of quarter 00:00. See more explanation
  about the format here:
  https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
  NOTE: the granularity should be at least 8 hours, or less frequent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#schedule GoogleBigqueryDataTransferConfig#schedule}
    */
    readonly schedule?: string;
    /**
    * Service account email. If this field is set, transfer config will
  be created with this service account credentials. It requires that
  requesting user calling this API has permissions to act as this service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#service_account_name GoogleBigqueryDataTransferConfig#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * email_preferences block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#email_preferences GoogleBigqueryDataTransferConfig#email_preferences}
    */
    readonly emailPreferences?: GoogleBigqueryDataTransferConfigEmailPreferences;
    /**
    * schedule_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#schedule_options GoogleBigqueryDataTransferConfig#schedule_options}
    */
    readonly scheduleOptions?: GoogleBigqueryDataTransferConfigScheduleOptions;
    /**
    * sensitive_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#sensitive_params GoogleBigqueryDataTransferConfig#sensitive_params}
    */
    readonly sensitiveParams?: GoogleBigqueryDataTransferConfigSensitiveParams;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#timeouts GoogleBigqueryDataTransferConfig#timeouts}
    */
    readonly timeouts?: GoogleBigqueryDataTransferConfigTimeouts;
}
export interface GoogleBigqueryDataTransferConfigEmailPreferences {
    /**
    * If true, email notifications will be sent on transfer run failures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#enable_failure_email GoogleBigqueryDataTransferConfig#enable_failure_email}
    */
    readonly enableFailureEmail: boolean | cdktf.IResolvable;
}
export declare function googleBigqueryDataTransferConfigEmailPreferencesToTerraform(struct?: GoogleBigqueryDataTransferConfigEmailPreferencesOutputReference | GoogleBigqueryDataTransferConfigEmailPreferences): any;
export declare class GoogleBigqueryDataTransferConfigEmailPreferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDataTransferConfigEmailPreferences | undefined;
    set internalValue(value: GoogleBigqueryDataTransferConfigEmailPreferences | undefined);
    private _enableFailureEmail?;
    get enableFailureEmail(): boolean | cdktf.IResolvable;
    set enableFailureEmail(value: boolean | cdktf.IResolvable);
    get enableFailureEmailInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleBigqueryDataTransferConfigScheduleOptions {
    /**
    * If true, automatic scheduling of data transfer runs for this
  configuration will be disabled. The runs can be started on ad-hoc
  basis using transferConfigs.startManualRuns API. When automatic
  scheduling is disabled, the TransferConfig.schedule field will
  be ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#disable_auto_scheduling GoogleBigqueryDataTransferConfig#disable_auto_scheduling}
    */
    readonly disableAutoScheduling?: boolean | cdktf.IResolvable;
    /**
    * Defines time to stop scheduling transfer runs. A transfer run cannot be
  scheduled at or after the end time. The end time can be changed at any
  moment. The time when a data transfer can be triggered manually is not
  limited by this option.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#end_time GoogleBigqueryDataTransferConfig#end_time}
    */
    readonly endTime?: string;
    /**
    * Specifies time to start scheduling transfer runs. The first run will be
  scheduled at or after the start time according to a recurrence pattern
  defined in the schedule string. The start time can be changed at any
  moment. The time when a data transfer can be triggered manually is not
  limited by this option.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#start_time GoogleBigqueryDataTransferConfig#start_time}
    */
    readonly startTime?: string;
}
export declare function googleBigqueryDataTransferConfigScheduleOptionsToTerraform(struct?: GoogleBigqueryDataTransferConfigScheduleOptionsOutputReference | GoogleBigqueryDataTransferConfigScheduleOptions): any;
export declare class GoogleBigqueryDataTransferConfigScheduleOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDataTransferConfigScheduleOptions | undefined;
    set internalValue(value: GoogleBigqueryDataTransferConfigScheduleOptions | undefined);
    private _disableAutoScheduling?;
    get disableAutoScheduling(): boolean | cdktf.IResolvable;
    set disableAutoScheduling(value: boolean | cdktf.IResolvable);
    resetDisableAutoScheduling(): void;
    get disableAutoSchedulingInput(): boolean | cdktf.IResolvable | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface GoogleBigqueryDataTransferConfigSensitiveParams {
    /**
    * The Secret Access Key of the AWS account transferring data from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#secret_access_key GoogleBigqueryDataTransferConfig#secret_access_key}
    */
    readonly secretAccessKey: string;
}
export declare function googleBigqueryDataTransferConfigSensitiveParamsToTerraform(struct?: GoogleBigqueryDataTransferConfigSensitiveParamsOutputReference | GoogleBigqueryDataTransferConfigSensitiveParams): any;
export declare class GoogleBigqueryDataTransferConfigSensitiveParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDataTransferConfigSensitiveParams | undefined;
    set internalValue(value: GoogleBigqueryDataTransferConfigSensitiveParams | undefined);
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    get secretAccessKeyInput(): string | undefined;
}
export interface GoogleBigqueryDataTransferConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#create GoogleBigqueryDataTransferConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#delete GoogleBigqueryDataTransferConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config#update GoogleBigqueryDataTransferConfig#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryDataTransferConfigTimeoutsToTerraform(struct?: GoogleBigqueryDataTransferConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryDataTransferConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDataTransferConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryDataTransferConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config google_bigquery_data_transfer_config}
*/
export declare class GoogleBigqueryDataTransferConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_data_transfer_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_data_transfer_config google_bigquery_data_transfer_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryDataTransferConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryDataTransferConfigConfig);
    private _dataRefreshWindowDays?;
    get dataRefreshWindowDays(): number;
    set dataRefreshWindowDays(value: number);
    resetDataRefreshWindowDays(): void;
    get dataRefreshWindowDaysInput(): number | undefined;
    private _dataSourceId?;
    get dataSourceId(): string;
    set dataSourceId(value: string);
    get dataSourceIdInput(): string | undefined;
    private _destinationDatasetId?;
    get destinationDatasetId(): string;
    set destinationDatasetId(value: string);
    resetDestinationDatasetId(): void;
    get destinationDatasetIdInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _notificationPubsubTopic?;
    get notificationPubsubTopic(): string;
    set notificationPubsubTopic(value: string);
    resetNotificationPubsubTopic(): void;
    get notificationPubsubTopicInput(): string | undefined;
    private _params?;
    get params(): {
        [key: string]: string;
    };
    set params(value: {
        [key: string]: string;
    });
    get paramsInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _emailPreferences;
    get emailPreferences(): GoogleBigqueryDataTransferConfigEmailPreferencesOutputReference;
    putEmailPreferences(value: GoogleBigqueryDataTransferConfigEmailPreferences): void;
    resetEmailPreferences(): void;
    get emailPreferencesInput(): GoogleBigqueryDataTransferConfigEmailPreferences | undefined;
    private _scheduleOptions;
    get scheduleOptions(): GoogleBigqueryDataTransferConfigScheduleOptionsOutputReference;
    putScheduleOptions(value: GoogleBigqueryDataTransferConfigScheduleOptions): void;
    resetScheduleOptions(): void;
    get scheduleOptionsInput(): GoogleBigqueryDataTransferConfigScheduleOptions | undefined;
    private _sensitiveParams;
    get sensitiveParams(): GoogleBigqueryDataTransferConfigSensitiveParamsOutputReference;
    putSensitiveParams(value: GoogleBigqueryDataTransferConfigSensitiveParams): void;
    resetSensitiveParams(): void;
    get sensitiveParamsInput(): GoogleBigqueryDataTransferConfigSensitiveParams | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryDataTransferConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryDataTransferConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryDataTransferConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
