import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique ID for this dataset, without the project name. The ID
  must contain only letters (a-z, A-Z), numbers (0-9), or
  underscores (_). The maximum length is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#dataset_id GoogleBigqueryDataset#dataset_id}
    */
    readonly datasetId: string;
    /**
    * Defines the default collation specification of future tables created
  in the dataset. If a table is created in this dataset without table-level
  default collation, then the table inherits the dataset default collation,
  which is applied to the string fields that do not have explicit collation
  specified. A change to this field affects only tables created afterwards,
  and does not alter the existing tables.
  
  The following values are supported:
  - 'und:ci': undetermined locale, case insensitive.
  - '': empty string. Default to case-sensitive behavior.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#default_collation GoogleBigqueryDataset#default_collation}
    */
    readonly defaultCollation?: string;
    /**
    * The default partition expiration for all partitioned tables in
  the dataset, in milliseconds.
  
  
  Once this property is set, all newly-created partitioned tables in
  the dataset will have an 'expirationMs' property in the 'timePartitioning'
  settings set to this value, and changing the value will only
  affect new tables, not existing ones. The storage in a partition will
  have an expiration time of its partition time plus this value.
  Setting this property overrides the use of 'defaultTableExpirationMs'
  for partitioned tables: only one of 'defaultTableExpirationMs' and
  'defaultPartitionExpirationMs' will be used for any new partitioned
  table. If you provide an explicit 'timePartitioning.expirationMs' when
  creating or updating a partitioned table, that value takes precedence
  over the default partition expiration time indicated by this property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#default_partition_expiration_ms GoogleBigqueryDataset#default_partition_expiration_ms}
    */
    readonly defaultPartitionExpirationMs?: number;
    /**
    * The default lifetime of all tables in the dataset, in milliseconds.
  The minimum value is 3600000 milliseconds (one hour).
  
  
  Once this property is set, all newly-created tables in the dataset
  will have an 'expirationTime' property set to the creation time plus
  the value in this property, and changing the value will only affect
  new tables, not existing ones. When the 'expirationTime' for a given
  table is reached, that table will be deleted automatically.
  If a table's 'expirationTime' is modified or removed before the
  table expires, or if you provide an explicit 'expirationTime' when
  creating a table, that value takes precedence over the default
  expiration time indicated by this property.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#default_table_expiration_ms GoogleBigqueryDataset#default_table_expiration_ms}
    */
    readonly defaultTableExpirationMs?: number;
    /**
    * If set to 'true', delete all the tables in the
  dataset when destroying the resource; otherwise,
  destroying the resource will fail if tables are present.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#delete_contents_on_destroy GoogleBigqueryDataset#delete_contents_on_destroy}
    */
    readonly deleteContentsOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * A user-friendly description of the dataset
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#description GoogleBigqueryDataset#description}
    */
    readonly description?: string;
    /**
    * A descriptive name for the dataset
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#friendly_name GoogleBigqueryDataset#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#id GoogleBigqueryDataset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * TRUE if the dataset and its table names are case-insensitive, otherwise FALSE.
  By default, this is FALSE, which means the dataset and its table names are
  case-sensitive. This field does not affect routine references.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#is_case_insensitive GoogleBigqueryDataset#is_case_insensitive}
    */
    readonly isCaseInsensitive?: boolean | cdktf.IResolvable;
    /**
    * The labels associated with this dataset. You can use these to
  organize and group your datasets
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#labels GoogleBigqueryDataset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The geographic location where the dataset should reside.
  See [official docs](https://cloud.google.com/bigquery/docs/dataset-locations).
  
  
  There are two types of locations, regional or multi-regional. A regional
  location is a specific geographic place, such as Tokyo, and a multi-regional
  location is a large geographic area, such as the United States, that
  contains at least two geographic places.
  
  
  The default value is multi-regional location 'US'.
  Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#location GoogleBigqueryDataset#location}
    */
    readonly location?: string;
    /**
    * Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to 7 days).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#max_time_travel_hours GoogleBigqueryDataset#max_time_travel_hours}
    */
    readonly maxTimeTravelHours?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#project GoogleBigqueryDataset#project}
    */
    readonly project?: string;
    /**
    * access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#access GoogleBigqueryDataset#access}
    */
    readonly access?: GoogleBigqueryDatasetAccess[] | cdktf.IResolvable;
    /**
    * default_encryption_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#default_encryption_configuration GoogleBigqueryDataset#default_encryption_configuration}
    */
    readonly defaultEncryptionConfiguration?: GoogleBigqueryDatasetDefaultEncryptionConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#timeouts GoogleBigqueryDataset#timeouts}
    */
    readonly timeouts?: GoogleBigqueryDatasetTimeouts;
}
export interface GoogleBigqueryDatasetAccessDatasetDataset {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#dataset_id GoogleBigqueryDataset#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#project_id GoogleBigqueryDataset#project_id}
    */
    readonly projectId: string;
}
export declare function googleBigqueryDatasetAccessDatasetDatasetToTerraform(struct?: GoogleBigqueryDatasetAccessDatasetDatasetOutputReference | GoogleBigqueryDatasetAccessDatasetDataset): any;
export declare class GoogleBigqueryDatasetAccessDatasetDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessDatasetDataset | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessDatasetDataset | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface GoogleBigqueryDatasetAccessDataset {
    /**
    * Which resources in the dataset this entry applies to. Currently, only views are supported,
  but additional target types may be added in the future. Possible values: VIEWS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#target_types GoogleBigqueryDataset#target_types}
    */
    readonly targetTypes: string[];
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#dataset GoogleBigqueryDataset#dataset}
    */
    readonly dataset: GoogleBigqueryDatasetAccessDatasetDataset;
}
export declare function googleBigqueryDatasetAccessDatasetToTerraform(struct?: GoogleBigqueryDatasetAccessDatasetOutputReference | GoogleBigqueryDatasetAccessDataset): any;
export declare class GoogleBigqueryDatasetAccessDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessDataset | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessDataset | undefined);
    private _targetTypes?;
    get targetTypes(): string[];
    set targetTypes(value: string[]);
    get targetTypesInput(): string[] | undefined;
    private _dataset;
    get dataset(): GoogleBigqueryDatasetAccessDatasetDatasetOutputReference;
    putDataset(value: GoogleBigqueryDatasetAccessDatasetDataset): void;
    get datasetInput(): GoogleBigqueryDatasetAccessDatasetDataset | undefined;
}
export interface GoogleBigqueryDatasetAccessRoutine {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#dataset_id GoogleBigqueryDataset#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#project_id GoogleBigqueryDataset#project_id}
    */
    readonly projectId: string;
    /**
    * The ID of the routine. The ID must contain only letters (a-z,
  A-Z), numbers (0-9), or underscores (_). The maximum length
  is 256 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#routine_id GoogleBigqueryDataset#routine_id}
    */
    readonly routineId: string;
}
export declare function googleBigqueryDatasetAccessRoutineToTerraform(struct?: GoogleBigqueryDatasetAccessRoutineOutputReference | GoogleBigqueryDatasetAccessRoutine): any;
export declare class GoogleBigqueryDatasetAccessRoutineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessRoutine | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessRoutine | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _routineId?;
    get routineId(): string;
    set routineId(value: string);
    get routineIdInput(): string | undefined;
}
export interface GoogleBigqueryDatasetAccessView {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#dataset_id GoogleBigqueryDataset#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#project_id GoogleBigqueryDataset#project_id}
    */
    readonly projectId: string;
    /**
    * The ID of the table. The ID must contain only letters (a-z,
  A-Z), numbers (0-9), or underscores (_). The maximum length
  is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#table_id GoogleBigqueryDataset#table_id}
    */
    readonly tableId: string;
}
export declare function googleBigqueryDatasetAccessViewToTerraform(struct?: GoogleBigqueryDatasetAccessViewOutputReference | GoogleBigqueryDatasetAccessView): any;
export declare class GoogleBigqueryDatasetAccessViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessView | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessView | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface GoogleBigqueryDatasetAccess {
    /**
    * A domain to grant access to. Any users signed in with the
  domain specified will be granted the specified access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#domain GoogleBigqueryDataset#domain}
    */
    readonly domain?: string;
    /**
    * An email address of a Google Group to grant access to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#group_by_email GoogleBigqueryDataset#group_by_email}
    */
    readonly groupByEmail?: string;
    /**
    * Describes the rights granted to the user specified by the other
  member of the access object. Basic, predefined, and custom roles
  are supported. Predefined roles that have equivalent basic roles
  are swapped by the API to their basic counterparts. See
  [official docs](https://cloud.google.com/bigquery/docs/access-control).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#role GoogleBigqueryDataset#role}
    */
    readonly role?: string;
    /**
    * A special group to grant access to. Possible values include:
  
  
  * 'projectOwners': Owners of the enclosing project.
  
  
  * 'projectReaders': Readers of the enclosing project.
  
  
  * 'projectWriters': Writers of the enclosing project.
  
  
  * 'allAuthenticatedUsers': All authenticated BigQuery users.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#special_group GoogleBigqueryDataset#special_group}
    */
    readonly specialGroup?: string;
    /**
    * An email address of a user to grant access to. For example:
  fred@example.com
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#user_by_email GoogleBigqueryDataset#user_by_email}
    */
    readonly userByEmail?: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#dataset GoogleBigqueryDataset#dataset}
    */
    readonly dataset?: GoogleBigqueryDatasetAccessDataset;
    /**
    * routine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#routine GoogleBigqueryDataset#routine}
    */
    readonly routine?: GoogleBigqueryDatasetAccessRoutine;
    /**
    * view block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#view GoogleBigqueryDataset#view}
    */
    readonly view?: GoogleBigqueryDatasetAccessView;
}
export declare function googleBigqueryDatasetAccessToTerraform(struct?: GoogleBigqueryDatasetAccess | cdktf.IResolvable): any;
export declare class GoogleBigqueryDatasetAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigqueryDatasetAccess | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccess | cdktf.IResolvable | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _groupByEmail?;
    get groupByEmail(): string;
    set groupByEmail(value: string);
    resetGroupByEmail(): void;
    get groupByEmailInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _specialGroup?;
    get specialGroup(): string;
    set specialGroup(value: string);
    resetSpecialGroup(): void;
    get specialGroupInput(): string | undefined;
    private _userByEmail?;
    get userByEmail(): string;
    set userByEmail(value: string);
    resetUserByEmail(): void;
    get userByEmailInput(): string | undefined;
    private _dataset;
    get dataset(): GoogleBigqueryDatasetAccessDatasetOutputReference;
    putDataset(value: GoogleBigqueryDatasetAccessDataset): void;
    resetDataset(): void;
    get datasetInput(): GoogleBigqueryDatasetAccessDataset | undefined;
    private _routine;
    get routine(): GoogleBigqueryDatasetAccessRoutineOutputReference;
    putRoutine(value: GoogleBigqueryDatasetAccessRoutine): void;
    resetRoutine(): void;
    get routineInput(): GoogleBigqueryDatasetAccessRoutine | undefined;
    private _view;
    get view(): GoogleBigqueryDatasetAccessViewOutputReference;
    putView(value: GoogleBigqueryDatasetAccessView): void;
    resetView(): void;
    get viewInput(): GoogleBigqueryDatasetAccessView | undefined;
}
export declare class GoogleBigqueryDatasetAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigqueryDatasetAccess[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigqueryDatasetAccessOutputReference;
}
export interface GoogleBigqueryDatasetDefaultEncryptionConfiguration {
    /**
    * Describes the Cloud KMS encryption key that will be used to protect destination
  BigQuery table. The BigQuery Service Account associated with your project requires
  access to this encryption key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#kms_key_name GoogleBigqueryDataset#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleBigqueryDatasetDefaultEncryptionConfigurationToTerraform(struct?: GoogleBigqueryDatasetDefaultEncryptionConfigurationOutputReference | GoogleBigqueryDatasetDefaultEncryptionConfiguration): any;
export declare class GoogleBigqueryDatasetDefaultEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetDefaultEncryptionConfiguration | undefined;
    set internalValue(value: GoogleBigqueryDatasetDefaultEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleBigqueryDatasetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#create GoogleBigqueryDataset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#delete GoogleBigqueryDataset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset#update GoogleBigqueryDataset#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryDatasetTimeoutsToTerraform(struct?: GoogleBigqueryDatasetTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryDatasetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset google_bigquery_dataset}
*/
export declare class GoogleBigqueryDataset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_dataset";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigquery_dataset google_bigquery_dataset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryDatasetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryDatasetConfig);
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _defaultCollation?;
    get defaultCollation(): string;
    set defaultCollation(value: string);
    resetDefaultCollation(): void;
    get defaultCollationInput(): string | undefined;
    private _defaultPartitionExpirationMs?;
    get defaultPartitionExpirationMs(): number;
    set defaultPartitionExpirationMs(value: number);
    resetDefaultPartitionExpirationMs(): void;
    get defaultPartitionExpirationMsInput(): number | undefined;
    private _defaultTableExpirationMs?;
    get defaultTableExpirationMs(): number;
    set defaultTableExpirationMs(value: number);
    resetDefaultTableExpirationMs(): void;
    get defaultTableExpirationMsInput(): number | undefined;
    private _deleteContentsOnDestroy?;
    get deleteContentsOnDestroy(): boolean | cdktf.IResolvable;
    set deleteContentsOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeleteContentsOnDestroy(): void;
    get deleteContentsOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isCaseInsensitive?;
    get isCaseInsensitive(): boolean | cdktf.IResolvable;
    set isCaseInsensitive(value: boolean | cdktf.IResolvable);
    resetIsCaseInsensitive(): void;
    get isCaseInsensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastModifiedTime(): number;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _maxTimeTravelHours?;
    get maxTimeTravelHours(): string;
    set maxTimeTravelHours(value: string);
    resetMaxTimeTravelHours(): void;
    get maxTimeTravelHoursInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _access;
    get access(): GoogleBigqueryDatasetAccessList;
    putAccess(value: GoogleBigqueryDatasetAccess[] | cdktf.IResolvable): void;
    resetAccess(): void;
    get accessInput(): cdktf.IResolvable | GoogleBigqueryDatasetAccess[] | undefined;
    private _defaultEncryptionConfiguration;
    get defaultEncryptionConfiguration(): GoogleBigqueryDatasetDefaultEncryptionConfigurationOutputReference;
    putDefaultEncryptionConfiguration(value: GoogleBigqueryDatasetDefaultEncryptionConfiguration): void;
    resetDefaultEncryptionConfiguration(): void;
    get defaultEncryptionConfigurationInput(): GoogleBigqueryDatasetDefaultEncryptionConfiguration | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryDatasetTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryDatasetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
