import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigtableTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, currently deletion protection will be set to UNPROTECTED as it is the API default value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#deletion_protection GoogleBigtableTable#deletion_protection}
    */
    readonly deletionProtection?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#id GoogleBigtableTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Bigtable instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#instance_name GoogleBigtableTable#instance_name}
    */
    readonly instanceName: string;
    /**
    * The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#name GoogleBigtableTable#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#project GoogleBigtableTable#project}
    */
    readonly project?: string;
    /**
    * A list of predefined keys to split the table on. !> Warning: Modifying the split_keys of an existing table will cause Terraform to delete/recreate the entire google_bigtable_table resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#split_keys GoogleBigtableTable#split_keys}
    */
    readonly splitKeys?: string[];
    /**
    * column_family block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#column_family GoogleBigtableTable#column_family}
    */
    readonly columnFamily?: GoogleBigtableTableColumnFamily[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#timeouts GoogleBigtableTable#timeouts}
    */
    readonly timeouts?: GoogleBigtableTableTimeouts;
}
export interface GoogleBigtableTableColumnFamily {
    /**
    * The name of the column family.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#family GoogleBigtableTable#family}
    */
    readonly family: string;
}
export declare function googleBigtableTableColumnFamilyToTerraform(struct?: GoogleBigtableTableColumnFamily | cdktf.IResolvable): any;
export declare class GoogleBigtableTableColumnFamilyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigtableTableColumnFamily | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigtableTableColumnFamily | cdktf.IResolvable | undefined);
    private _family?;
    get family(): string;
    set family(value: string);
    get familyInput(): string | undefined;
}
export declare class GoogleBigtableTableColumnFamilyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigtableTableColumnFamily[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigtableTableColumnFamilyOutputReference;
}
export interface GoogleBigtableTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table#create GoogleBigtableTable#create}
    */
    readonly create?: string;
}
export declare function googleBigtableTableTimeoutsToTerraform(struct?: GoogleBigtableTableTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigtableTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigtableTableTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table google_bigtable_table}
*/
export declare class GoogleBigtableTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_table";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_bigtable_table google_bigtable_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigtableTableConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigtableTableConfig);
    private _deletionProtection?;
    get deletionProtection(): string;
    set deletionProtection(value: string);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _splitKeys?;
    get splitKeys(): string[];
    set splitKeys(value: string[]);
    resetSplitKeys(): void;
    get splitKeysInput(): string[] | undefined;
    private _columnFamily;
    get columnFamily(): GoogleBigtableTableColumnFamilyList;
    putColumnFamily(value: GoogleBigtableTableColumnFamily[] | cdktf.IResolvable): void;
    resetColumnFamily(): void;
    get columnFamilyInput(): cdktf.IResolvable | GoogleBigtableTableColumnFamily[] | undefined;
    private _timeouts;
    get timeouts(): GoogleBigtableTableTimeoutsOutputReference;
    putTimeouts(value: GoogleBigtableTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigtableTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
