import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBinaryAuthorizationAttestorConfig extends cdktf.TerraformMetaArguments {
    /**
    * A descriptive comment. This field may be updated. The field may be
  displayed in chooser dialogs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#description GoogleBinaryAuthorizationAttestor#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#id GoogleBinaryAuthorizationAttestor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#name GoogleBinaryAuthorizationAttestor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#project GoogleBinaryAuthorizationAttestor#project}
    */
    readonly project?: string;
    /**
    * attestation_authority_note block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#attestation_authority_note GoogleBinaryAuthorizationAttestor#attestation_authority_note}
    */
    readonly attestationAuthorityNote: GoogleBinaryAuthorizationAttestorAttestationAuthorityNote;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#timeouts GoogleBinaryAuthorizationAttestor#timeouts}
    */
    readonly timeouts?: GoogleBinaryAuthorizationAttestorTimeouts;
}
export interface GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey {
    /**
    * A PEM-encoded public key, as described in
  'https://tools.ietf.org/html/rfc7468#section-13'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#public_key_pem GoogleBinaryAuthorizationAttestor#public_key_pem}
    */
    readonly publicKeyPem?: string;
    /**
    * The signature algorithm used to verify a message against
  a signature using this key. These signature algorithm must
  match the structure and any object identifiers encoded in
  publicKeyPem (i.e. this algorithm must match that of the
  public key).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#signature_algorithm GoogleBinaryAuthorizationAttestor#signature_algorithm}
    */
    readonly signatureAlgorithm?: string;
}
export declare function googleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyToTerraform(struct?: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference | GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey): any;
export declare class GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined;
    set internalValue(value: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined);
    private _publicKeyPem?;
    get publicKeyPem(): string;
    set publicKeyPem(value: string);
    resetPublicKeyPem(): void;
    get publicKeyPemInput(): string | undefined;
    private _signatureAlgorithm?;
    get signatureAlgorithm(): string;
    set signatureAlgorithm(value: string);
    resetSignatureAlgorithm(): void;
    get signatureAlgorithmInput(): string | undefined;
}
export interface GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys {
    /**
    * ASCII-armored representation of a PGP public key, as the
  entire output by the command
  'gpg --export --armor foo@example.com' (either LF or CRLF
  line endings). When using this field, id should be left
  blank. The BinAuthz API handlers will calculate the ID
  and fill it in automatically. BinAuthz computes this ID
  as the OpenPGP RFC4880 V4 fingerprint, represented as
  upper-case hex. If id is provided by the caller, it will
  be overwritten by the API-calculated ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#ascii_armored_pgp_public_key GoogleBinaryAuthorizationAttestor#ascii_armored_pgp_public_key}
    */
    readonly asciiArmoredPgpPublicKey?: string;
    /**
    * A descriptive comment. This field may be updated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#comment GoogleBinaryAuthorizationAttestor#comment}
    */
    readonly comment?: string;
    /**
    * The ID of this public key. Signatures verified by BinAuthz
  must include the ID of the public key that can be used to
  verify them, and that ID must match the contents of this
  field exactly. Additional restrictions on this field can
  be imposed based on which public key type is encapsulated.
  See the documentation on publicKey cases below for details.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#id GoogleBinaryAuthorizationAttestor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * pkix_public_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#pkix_public_key GoogleBinaryAuthorizationAttestor#pkix_public_key}
    */
    readonly pkixPublicKey?: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey;
}
export declare function googleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysToTerraform(struct?: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys | cdktf.IResolvable): any;
export declare class GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys | cdktf.IResolvable | undefined);
    private _asciiArmoredPgpPublicKey?;
    get asciiArmoredPgpPublicKey(): string;
    set asciiArmoredPgpPublicKey(value: string);
    resetAsciiArmoredPgpPublicKey(): void;
    get asciiArmoredPgpPublicKeyInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _pkixPublicKey;
    get pkixPublicKey(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference;
    putPkixPublicKey(value: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey): void;
    resetPkixPublicKey(): void;
    get pkixPublicKeyInput(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined;
}
export declare class GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysOutputReference;
}
export interface GoogleBinaryAuthorizationAttestorAttestationAuthorityNote {
    /**
    * The resource name of a ATTESTATION_AUTHORITY Note, created by the
  user. If the Note is in a different project from the Attestor, it
  should be specified in the format 'projects/*\/notes/*' (or the legacy
  'providers/*\/notes/*'). This field may not be updated.
  An attestation by this attestor is stored as a Container Analysis
  ATTESTATION_AUTHORITY Occurrence that names a container image
  and that links to this Note.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#note_reference GoogleBinaryAuthorizationAttestor#note_reference}
    */
    readonly noteReference: string;
    /**
    * public_keys block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#public_keys GoogleBinaryAuthorizationAttestor#public_keys}
    */
    readonly publicKeys?: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable;
}
export declare function googleBinaryAuthorizationAttestorAttestationAuthorityNoteToTerraform(struct?: GoogleBinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference | GoogleBinaryAuthorizationAttestorAttestationAuthorityNote): any;
export declare class GoogleBinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNote | undefined;
    set internalValue(value: GoogleBinaryAuthorizationAttestorAttestationAuthorityNote | undefined);
    get delegationServiceAccountEmail(): string;
    private _noteReference?;
    get noteReference(): string;
    set noteReference(value: string);
    get noteReferenceInput(): string | undefined;
    private _publicKeys;
    get publicKeys(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysList;
    putPublicKeys(value: GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable): void;
    resetPublicKeys(): void;
    get publicKeysInput(): cdktf.IResolvable | GoogleBinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | undefined;
}
export interface GoogleBinaryAuthorizationAttestorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#create GoogleBinaryAuthorizationAttestor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#delete GoogleBinaryAuthorizationAttestor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor#update GoogleBinaryAuthorizationAttestor#update}
    */
    readonly update?: string;
}
export declare function googleBinaryAuthorizationAttestorTimeoutsToTerraform(struct?: GoogleBinaryAuthorizationAttestorTimeouts | cdktf.IResolvable): any;
export declare class GoogleBinaryAuthorizationAttestorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBinaryAuthorizationAttestorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBinaryAuthorizationAttestorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor google_binary_authorization_attestor}
*/
export declare class GoogleBinaryAuthorizationAttestor extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_binary_authorization_attestor";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_attestor google_binary_authorization_attestor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBinaryAuthorizationAttestorConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBinaryAuthorizationAttestorConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _attestationAuthorityNote;
    get attestationAuthorityNote(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference;
    putAttestationAuthorityNote(value: GoogleBinaryAuthorizationAttestorAttestationAuthorityNote): void;
    get attestationAuthorityNoteInput(): GoogleBinaryAuthorizationAttestorAttestationAuthorityNote | undefined;
    private _timeouts;
    get timeouts(): GoogleBinaryAuthorizationAttestorTimeoutsOutputReference;
    putTimeouts(value: GoogleBinaryAuthorizationAttestorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBinaryAuthorizationAttestorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
