import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBinaryAuthorizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A descriptive comment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#description GoogleBinaryAuthorizationPolicy#description}
    */
    readonly description?: string;
    /**
    * Controls the evaluation of a Google-maintained global admission policy
  for common system-level images. Images not covered by the global
  policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#global_policy_evaluation_mode GoogleBinaryAuthorizationPolicy#global_policy_evaluation_mode}
    */
    readonly globalPolicyEvaluationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#id GoogleBinaryAuthorizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#project GoogleBinaryAuthorizationPolicy#project}
    */
    readonly project?: string;
    /**
    * admission_whitelist_patterns block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#admission_whitelist_patterns GoogleBinaryAuthorizationPolicy#admission_whitelist_patterns}
    */
    readonly admissionWhitelistPatterns?: GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | cdktf.IResolvable;
    /**
    * cluster_admission_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#cluster_admission_rules GoogleBinaryAuthorizationPolicy#cluster_admission_rules}
    */
    readonly clusterAdmissionRules?: GoogleBinaryAuthorizationPolicyClusterAdmissionRules[] | cdktf.IResolvable;
    /**
    * default_admission_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#default_admission_rule GoogleBinaryAuthorizationPolicy#default_admission_rule}
    */
    readonly defaultAdmissionRule: GoogleBinaryAuthorizationPolicyDefaultAdmissionRule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#timeouts GoogleBinaryAuthorizationPolicy#timeouts}
    */
    readonly timeouts?: GoogleBinaryAuthorizationPolicyTimeouts;
}
export interface GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns {
    /**
    * An image name pattern to whitelist, in the form
  'registry/path/to/image'. This supports a trailing * as a
  wildcard, but this is allowed only in text after the registry/
  part.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#name_pattern GoogleBinaryAuthorizationPolicy#name_pattern}
    */
    readonly namePattern: string;
}
export declare function googleBinaryAuthorizationPolicyAdmissionWhitelistPatternsToTerraform(struct?: GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns | cdktf.IResolvable): any;
export declare class GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatternsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns | cdktf.IResolvable | undefined);
    private _namePattern?;
    get namePattern(): string;
    set namePattern(value: string);
    get namePatternInput(): string | undefined;
}
export declare class GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatternsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatternsOutputReference;
}
export interface GoogleBinaryAuthorizationPolicyClusterAdmissionRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#cluster GoogleBinaryAuthorizationPolicy#cluster}
    */
    readonly cluster: string;
    /**
    * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#enforcement_mode GoogleBinaryAuthorizationPolicy#enforcement_mode}
    */
    readonly enforcementMode: string;
    /**
    * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#evaluation_mode GoogleBinaryAuthorizationPolicy#evaluation_mode}
    */
    readonly evaluationMode: string;
    /**
    * The resource names of the attestors that must attest to a
  container image. If the attestor is in a different project from the
  policy, it should be specified in the format 'projects/*\/attestors/*'.
  Each attestor must exist before a policy can reference it. To add an
  attestor to a policy the principal issuing the policy change
  request must be able to read the attestor resource.
  
  Note: this field must be non-empty when the evaluation_mode field
  specifies REQUIRE_ATTESTATION, otherwise it must be empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#require_attestations_by GoogleBinaryAuthorizationPolicy#require_attestations_by}
    */
    readonly requireAttestationsBy?: string[];
}
export declare function googleBinaryAuthorizationPolicyClusterAdmissionRulesToTerraform(struct?: GoogleBinaryAuthorizationPolicyClusterAdmissionRules | cdktf.IResolvable): any;
export declare class GoogleBinaryAuthorizationPolicyClusterAdmissionRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBinaryAuthorizationPolicyClusterAdmissionRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBinaryAuthorizationPolicyClusterAdmissionRules | cdktf.IResolvable | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _enforcementMode?;
    get enforcementMode(): string;
    set enforcementMode(value: string);
    get enforcementModeInput(): string | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    get evaluationModeInput(): string | undefined;
    private _requireAttestationsBy?;
    get requireAttestationsBy(): string[];
    set requireAttestationsBy(value: string[]);
    resetRequireAttestationsBy(): void;
    get requireAttestationsByInput(): string[] | undefined;
}
export declare class GoogleBinaryAuthorizationPolicyClusterAdmissionRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBinaryAuthorizationPolicyClusterAdmissionRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBinaryAuthorizationPolicyClusterAdmissionRulesOutputReference;
}
export interface GoogleBinaryAuthorizationPolicyDefaultAdmissionRule {
    /**
    * The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#enforcement_mode GoogleBinaryAuthorizationPolicy#enforcement_mode}
    */
    readonly enforcementMode: string;
    /**
    * How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#evaluation_mode GoogleBinaryAuthorizationPolicy#evaluation_mode}
    */
    readonly evaluationMode: string;
    /**
    * The resource names of the attestors that must attest to a
  container image. If the attestor is in a different project from the
  policy, it should be specified in the format 'projects/*\/attestors/*'.
  Each attestor must exist before a policy can reference it. To add an
  attestor to a policy the principal issuing the policy change
  request must be able to read the attestor resource.
  
  Note: this field must be non-empty when the evaluation_mode field
  specifies REQUIRE_ATTESTATION, otherwise it must be empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#require_attestations_by GoogleBinaryAuthorizationPolicy#require_attestations_by}
    */
    readonly requireAttestationsBy?: string[];
}
export declare function googleBinaryAuthorizationPolicyDefaultAdmissionRuleToTerraform(struct?: GoogleBinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference | GoogleBinaryAuthorizationPolicyDefaultAdmissionRule): any;
export declare class GoogleBinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBinaryAuthorizationPolicyDefaultAdmissionRule | undefined;
    set internalValue(value: GoogleBinaryAuthorizationPolicyDefaultAdmissionRule | undefined);
    private _enforcementMode?;
    get enforcementMode(): string;
    set enforcementMode(value: string);
    get enforcementModeInput(): string | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    get evaluationModeInput(): string | undefined;
    private _requireAttestationsBy?;
    get requireAttestationsBy(): string[];
    set requireAttestationsBy(value: string[]);
    resetRequireAttestationsBy(): void;
    get requireAttestationsByInput(): string[] | undefined;
}
export interface GoogleBinaryAuthorizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#create GoogleBinaryAuthorizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#delete GoogleBinaryAuthorizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy#update GoogleBinaryAuthorizationPolicy#update}
    */
    readonly update?: string;
}
export declare function googleBinaryAuthorizationPolicyTimeoutsToTerraform(struct?: GoogleBinaryAuthorizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleBinaryAuthorizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBinaryAuthorizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBinaryAuthorizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy google_binary_authorization_policy}
*/
export declare class GoogleBinaryAuthorizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_binary_authorization_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_binary_authorization_policy google_binary_authorization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBinaryAuthorizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBinaryAuthorizationPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _globalPolicyEvaluationMode?;
    get globalPolicyEvaluationMode(): string;
    set globalPolicyEvaluationMode(value: string);
    resetGlobalPolicyEvaluationMode(): void;
    get globalPolicyEvaluationModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _admissionWhitelistPatterns;
    get admissionWhitelistPatterns(): GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatternsList;
    putAdmissionWhitelistPatterns(value: GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | cdktf.IResolvable): void;
    resetAdmissionWhitelistPatterns(): void;
    get admissionWhitelistPatternsInput(): cdktf.IResolvable | GoogleBinaryAuthorizationPolicyAdmissionWhitelistPatterns[] | undefined;
    private _clusterAdmissionRules;
    get clusterAdmissionRules(): GoogleBinaryAuthorizationPolicyClusterAdmissionRulesList;
    putClusterAdmissionRules(value: GoogleBinaryAuthorizationPolicyClusterAdmissionRules[] | cdktf.IResolvable): void;
    resetClusterAdmissionRules(): void;
    get clusterAdmissionRulesInput(): cdktf.IResolvable | GoogleBinaryAuthorizationPolicyClusterAdmissionRules[] | undefined;
    private _defaultAdmissionRule;
    get defaultAdmissionRule(): GoogleBinaryAuthorizationPolicyDefaultAdmissionRuleOutputReference;
    putDefaultAdmissionRule(value: GoogleBinaryAuthorizationPolicyDefaultAdmissionRule): void;
    get defaultAdmissionRuleInput(): GoogleBinaryAuthorizationPolicyDefaultAdmissionRule | undefined;
    private _timeouts;
    get timeouts(): GoogleBinaryAuthorizationPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleBinaryAuthorizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBinaryAuthorizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
