import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudAssetFolderFeedConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of the full names of the assets to receive updates. You must specify either or both of
  assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
  exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
  See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#asset_names GoogleCloudAssetFolderFeed#asset_names}
    */
    readonly assetNames?: string[];
    /**
    * A list of types of the assets to receive updates. You must specify either or both of assetNames
  and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
  the feed. For example: "compute.googleapis.com/Disk"
  See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
  supported asset types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#asset_types GoogleCloudAssetFolderFeed#asset_types}
    */
    readonly assetTypes?: string[];
    /**
    * The project whose identity will be used when sending messages to the
  destination pubsub topic. It also specifies the project for API
  enablement check, quota, and billing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#billing_project GoogleCloudAssetFolderFeed#billing_project}
    */
    readonly billingProject: string;
    /**
    * Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "OS_INVENTORY", "ACCESS_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#content_type GoogleCloudAssetFolderFeed#content_type}
    */
    readonly contentType?: string;
    /**
    * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#feed_id GoogleCloudAssetFolderFeed#feed_id}
    */
    readonly feedId: string;
    /**
    * The folder this feed should be created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#folder GoogleCloudAssetFolderFeed#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#id GoogleCloudAssetFolderFeed#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#condition GoogleCloudAssetFolderFeed#condition}
    */
    readonly condition?: GoogleCloudAssetFolderFeedCondition;
    /**
    * feed_output_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#feed_output_config GoogleCloudAssetFolderFeed#feed_output_config}
    */
    readonly feedOutputConfig: GoogleCloudAssetFolderFeedFeedOutputConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#timeouts GoogleCloudAssetFolderFeed#timeouts}
    */
    readonly timeouts?: GoogleCloudAssetFolderFeedTimeouts;
}
export interface GoogleCloudAssetFolderFeedCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#description GoogleCloudAssetFolderFeed#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#expression GoogleCloudAssetFolderFeed#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file
  name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#location GoogleCloudAssetFolderFeed#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#title GoogleCloudAssetFolderFeed#title}
    */
    readonly title?: string;
}
export declare function googleCloudAssetFolderFeedConditionToTerraform(struct?: GoogleCloudAssetFolderFeedConditionOutputReference | GoogleCloudAssetFolderFeedCondition): any;
export declare class GoogleCloudAssetFolderFeedConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetFolderFeedCondition | undefined;
    set internalValue(value: GoogleCloudAssetFolderFeedCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination {
    /**
    * Destination on Cloud Pubsub topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#topic GoogleCloudAssetFolderFeed#topic}
    */
    readonly topic: string;
}
export declare function googleCloudAssetFolderFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference | GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination): any;
export declare class GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
    set internalValue(value: GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface GoogleCloudAssetFolderFeedFeedOutputConfig {
    /**
    * pubsub_destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#pubsub_destination GoogleCloudAssetFolderFeed#pubsub_destination}
    */
    readonly pubsubDestination: GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination;
}
export declare function googleCloudAssetFolderFeedFeedOutputConfigToTerraform(struct?: GoogleCloudAssetFolderFeedFeedOutputConfigOutputReference | GoogleCloudAssetFolderFeedFeedOutputConfig): any;
export declare class GoogleCloudAssetFolderFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetFolderFeedFeedOutputConfig | undefined;
    set internalValue(value: GoogleCloudAssetFolderFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    get pubsubDestination(): GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestinationOutputReference;
    putPubsubDestination(value: GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination): void;
    get pubsubDestinationInput(): GoogleCloudAssetFolderFeedFeedOutputConfigPubsubDestination | undefined;
}
export interface GoogleCloudAssetFolderFeedTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#create GoogleCloudAssetFolderFeed#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#delete GoogleCloudAssetFolderFeed#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed#update GoogleCloudAssetFolderFeed#update}
    */
    readonly update?: string;
}
export declare function googleCloudAssetFolderFeedTimeoutsToTerraform(struct?: GoogleCloudAssetFolderFeedTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudAssetFolderFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetFolderFeedTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudAssetFolderFeedTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed google_cloud_asset_folder_feed}
*/
export declare class GoogleCloudAssetFolderFeed extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_asset_folder_feed";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_asset_folder_feed google_cloud_asset_folder_feed} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudAssetFolderFeedConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudAssetFolderFeedConfig);
    private _assetNames?;
    get assetNames(): string[];
    set assetNames(value: string[]);
    resetAssetNames(): void;
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    get assetTypes(): string[];
    set assetTypes(value: string[]);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    get billingProject(): string;
    set billingProject(value: string);
    get billingProjectInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _feedId?;
    get feedId(): string;
    set feedId(value: string);
    get feedIdInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get folderId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _condition;
    get condition(): GoogleCloudAssetFolderFeedConditionOutputReference;
    putCondition(value: GoogleCloudAssetFolderFeedCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleCloudAssetFolderFeedCondition | undefined;
    private _feedOutputConfig;
    get feedOutputConfig(): GoogleCloudAssetFolderFeedFeedOutputConfigOutputReference;
    putFeedOutputConfig(value: GoogleCloudAssetFolderFeedFeedOutputConfig): void;
    get feedOutputConfigInput(): GoogleCloudAssetFolderFeedFeedOutputConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudAssetFolderFeedTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudAssetFolderFeedTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudAssetFolderFeedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
